/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.common;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.container.Tab;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.TreeEntryGrid;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.login.utils.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.formplugin.resources.CreditmFormResourceEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public abstract class AbstracCreditmEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String KEY_CHANGECREDITTYPE = "KEY_CHANGECREDITtYPE";
    private static final String KEY_CHANGEISGROUP = "KEY_CHANGEISGROUP";
    private static final String KEY_ORGTREEENTRY = "KEY_ORGTREEENTRY";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"o_orgtext", "t_credittypetext"});
        this.addItemClickListeners(new String[]{"advcontoolbarap"});
        BasedataEdit bankF7 = (BasedataEdit)this.getControl("bank");
        bankF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit orgF7 = (BasedataEdit)this.getControl("m_org");
        orgF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit typeF7 = (BasedataEdit)this.getControl("m_credittype");
        typeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        DynamicObject baseCurrency;
        DynamicObject comp = (DynamicObject)this.getModel().getValue("org");
        if (comp != null && (baseCurrency = TmcBusinessBaseHelper.getBaseCurrency((long)((Long)comp.getPkValue()))) != null) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"currency", (Object)baseCurrency.getPkValue());
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"guaranteeorg", null);
        this.setDefaultEndDate();
        this.setDetaultOrgEntry();
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        switch (key) {
            case "bank": {
                this.bankF7(evt);
                break;
            }
            case "m_org": {
                this.mOrgF7(evt);
                break;
            }
            case "m_credittype": {
                Set baseTypeIds = CreditLimitHelper.getBaseIds((IDataModel)this.getModel(), (String)"entry_type", (String)"t_credittype");
                if (baseTypeIds.size() <= 0) break;
                formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)baseTypeIds));
            }
        }
    }

    public void afterCopyData(EventObject e) {
        this.setDefaultEndDate();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean dataChanged = this.getModel().getDataChanged();
        this.setColumnText("entry_org", "o_orgtext", "o_org");
        this.setColumnText("entry_type", "t_credittypetext", "t_credittype");
        this.refeshOrderNum("entry_org", "ordernumorg");
        this.refeshOrderNum("entry_type", "ordernumtype");
        this.setDefaultCon();
        String orgTree = this.getPageCache().get(KEY_ORGTREEENTRY);
        if (EmptyUtil.isNoEmpty((String)orgTree)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"o_singleamt"});
        }
        this.getModel().setDataChanged(dataChanged);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String key = control.getKey();
        if ("o_orgtext".equals(key)) {
            HashMap<String, String> param = new HashMap<String, String>(1);
            param.put("orgFuncId", "08");
            int idx = this.getModel().getEntryCurrentRowIndex("entry_org");
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entry_org", idx);
            QFilter noFilter = this.getNoFilter("entry_org", "o_org");
            DynamicObject framWork = (DynamicObject)this.getModel().getValue("framework");
            if (EmptyUtil.isNoEmpty((DynamicObject)framWork)) {
                DynamicObject org = (DynamicObject)this.getModel().getValue("org");
                List subOrgIds = CreditFrameworkHelper.getAllSubOrgs(Collections.singletonList(org.getLong("id")));
                QFilter orgFilter = new QFilter("id", "in", (Object)subOrgIds);
                noFilter = noFilter != null ? noFilter.and(orgFilter) : orgFilter;
            }
            this.showF7Form("bos_org", EmptyUtil.isEmpty((Object)rowEntity.get("pid")), noFilter, param, key, this.getCurrBaseIds(rowEntity, "o_org"));
        } else if ("t_credittypetext".equals(key)) {
            Object creditType = this.getModel().getValue("credittype");
            if (EmptyUtil.isEmpty((Object)creditType)) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u6388\u4fe1\u7c7b\u522b\uff01", (String)"CreditLimitDetailEdit_0", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), new Object[0]));
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            DynamicObject framWork = (DynamicObject)this.getModel().getValue("framework");
            QFilter filter = CreditFrameworkHelper.getFrameTypeFilter((DynamicObject)framWork, (DynamicObject)org);
            QFilter noFilter = this.getNoFilter("entry_type", "t_credittype");
            if (noFilter != null) {
                filter.and(noFilter);
            }
            int idx = this.getModel().getEntryCurrentRowIndex("entry_type");
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("entry_type", idx);
            this.showF7Form("cfm_credittype", EmptyUtil.isEmpty((Object)rowEntity.get("pid")), filter, null, key, this.getCurrBaseIds(rowEntity, "t_credittype"));
        }
    }

    private QFilter getNoFilter(String entry, String field) {
        QFilter filter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue());
        Set typeIds = CreditLimitHelper.getBaseIds((IDataModel)this.getModel(), (String)entry, (String)field);
        int currIdx = this.getModel().getEntryCurrentRowIndex(entry);
        Object entryCreditType = this.getModel().getValue(field, currIdx);
        if (entryCreditType != null) {
            Set ids = CreditLimitHelper.getCollIds((DynamicObjectCollection)((DynamicObjectCollection)entryCreditType));
            typeIds.removeAll(ids);
        }
        if (EmptyUtil.isNoEmpty((Object)typeIds)) {
            return filter.and(new QFilter("id", "not in", (Object)typeIds));
        }
        return filter;
    }

    private Object[] getCurrBaseIds(DynamicObject rowEntity, String baseField) {
        DynamicObjectCollection bases = rowEntity.getDynamicObjectCollection(baseField);
        return bases.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).toArray();
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("newrow".equals(itemKey) || "insertrow".equals(itemKey) || "delrow".equals(itemKey)) {
            boolean idDownShare;
            Object creditType = this.getModel().getValue("credittype");
            Object isGroup = this.getModel().getValue("isgrouplimit");
            if ("tabentry_org".equals(this.getTabName()) && !((Boolean)isGroup).booleanValue()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u975e\u96c6\u56e2\u6388\u4fe1\u4e0d\u80fd\u64cd\u4f5c\u7ec4\u7ec7\u5171\u4eab\u5206\u5f55\uff01", (String)"CreditLimitDetailEdit_1", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if ("tabentry_type".equals(this.getTabName()) && creditType != null && !((DynamicObject)creditType).getBoolean("iscomprehensive")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e13\u9879\u6388\u4fe1\u4e0d\u80fd\u64cd\u4f5c\u7c7b\u522b\u5171\u4eab\u5206\u5f55\uff01", (String)"CreditLimitDetailEdit_2", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
            if ((idDownShare = OrgShareTypeEnum.DOWNSHARE.getValue().equals(this.getModel().getValue("orgsharetype"))) && "tabentry_org".equals(this.getTabName()) && "insertrow".equals(itemKey)) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5171\u4eab\u65b9\u5f0f\u4e3a\u5411\u4e0b\u5171\u4eab\uff0c\u4e0d\u80fd\u63d2\u5165\u660e\u7ec6\uff01", (String)"CreditLimitDetailEdit_8", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            }
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entry = e.getEntryProp().getName();
        if ("entry_org".equals(entry) || "entry_type".equals(entry)) {
            Set<Integer> pRowIndex = this.getRowIndex(entry, e.getRowIndexs());
            boolean isOrg = "entry_org".equals(entry);
            if (isOrg && OrgShareTypeEnum.DOWNSHARE.getValue().equals(this.getModel().getValue("orgsharetype"))) {
                this.refeshOrderNum(entry, "ordernumorg");
                return;
            }
            if (this.getPageCache().get("del") != null) {
                this.createMultParent(entry, isOrg ? "o_org" : "t_credittype", isOrg ? "o_orgtext" : "t_credittypetext", pRowIndex);
                this.getPageCache().remove("del");
                this.refeshOrderNum(entry, "entry_org".equals(entry) ? "ordernumorg" : "ordernumtype");
            }
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "newrow": {
                this.rowBtnClick("new_");
                break;
            }
            case "insertrow": {
                this.rowBtnClick("insert_");
                break;
            }
            case "delrow": {
                this.getPageCache().put("del", "1");
                this.rowBtnClick("delete_");
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        Object oldValue = changeData[0].getOldValue();
        switch (prop) {
            case "credittype": {
                this.changeTypeEntry(oldValue);
                break;
            }
            case "isgrouplimit": {
                this.changeOrgEntry(oldValue);
                break;
            }
            case "orgsharetype": {
                this.changeOrgShareType();
                break;
            }
            case "totalamt": {
                BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("totalamt");
                this.setEntryAmt("entry_org", "o_totalamt", "o_singleamt", totalAmt);
                this.setEntryAmt("entry_type", "t_totalamt", "t_singleamt", totalAmt);
                this.setEntryAmt("entry_mult", "m_totalamt", null, totalAmt);
                break;
            }
            case "o_totalamt": {
                this.checkDetailSingleAmt("entry_org", "o_totalamt", "o_singleamt");
                break;
            }
            case "t_totalamt": {
                this.checkDetailSingleAmt("entry_type", "t_totalamt", "t_singleamt");
                break;
            }
            case "o_singleamt": {
                this.checkSingelAmt("entry_org", "o_totalamt", "o_singleamt", "o_useamt", "o_preamt", "o_avaramt");
                break;
            }
            case "t_singleamt": {
                this.checkSingelAmt("entry_type", "t_totalamt", "t_singleamt", "t_useamt", "t_preamt", "t_avaramt");
                break;
            }
            case "m_totalamt": {
                this.checkMultAmt();
                break;
            }
            case "o_orgtext": {
                this.changeTextField("entry_org", "o_org", "o_orgtext", oldValue);
                break;
            }
            case "o_org": {
                this.setCreditMult("entry_org", "o_orgtext", "o_org", changeData[0].getRowIndex());
                break;
            }
            case "t_credittypetext": {
                this.changeTextField("entry_type", "t_credittype", "t_credittypetext", oldValue);
                break;
            }
            case "t_credittype": {
                this.setCreditMult("entry_type", "t_credittypetext", "t_credittype", changeData[0].getRowIndex());
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String operateKey;
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (operateKey = op.getOperateKey()) {
            case "insert_entry_org": {
                this.createDetail("entry_org", args);
                break;
            }
            case "insert_entry_type": {
                this.createDetail("entry_type", args);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (KEY_CHANGEISGROUP.equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.setDetaultOrgEntry();
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"isgrouplimit", (Object)this.getPageCache().get("isgrouplimit"));
            }
            boolean isGroup = (Boolean)this.getModel().getValue("isgrouplimit");
            this.getView().setEnable(Boolean.valueOf(isGroup), new String[]{"entry_org"});
            this.getView().setVisible(Boolean.valueOf(isGroup), new String[]{"o_singleamt", "orgsharetype"});
        } else if (KEY_CHANGECREDITTYPE.equals(messageBoxClosedEvent.getCallBackId())) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.setDefaultTypeEntry();
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"credittype", (Object)this.getPageCache().get("credittype"));
            }
            DynamicObject creditType = (DynamicObject)this.getModel().getValue("credittype");
            if (creditType != null) {
                this.getView().setEnable(Boolean.valueOf(creditType.getBoolean("iscomprehensive")), new String[]{"entry_type"});
                this.getView().setVisible(Boolean.valueOf(creditType.getBoolean("iscomprehensive")), new String[]{"t_singleamt"});
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        if (EmptyUtil.isNoEmpty((Object)evt.getReturnData()) && ("o_orgtext".equals(evt.getActionId()) || "t_credittypetext".equals(evt.getActionId()))) {
            Map<Long, Pair<BigDecimal, BigDecimal>> detailAmtMap;
            String entry = "o_orgtext".equals(evt.getActionId()) ? "entry_org" : "entry_type";
            int rowIndex = this.getSelectedRowIndex(entry);
            ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)evt.getReturnData();
            if (EmptyUtil.isEmpty((Collection)returnDatas)) {
                return;
            }
            Set collectIds = returnDatas.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
            if ("o_orgtext".equals(evt.getActionId())) {
                Long orgId;
                detailAmtMap = new HashMap<Long, Pair<BigDecimal, BigDecimal>>();
                if (this.isCreditLimtBill() && EmptyUtil.isNoEmpty((Long)(orgId = CreditLimitHelper.checkExist(collectIds, (detailAmtMap = this.getHasUseDetails("entry_org", "o_org", "o_useamt", "o_preamt")).keySet())))) {
                    DynamicObject org = TmcOrgDataHelper.getOrgById((long)orgId);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8d44\u91d1\u7ec4\u7ec7[%S]\u5df2\u88ab\u5360\u7528\uff0c\u5fc5\u987b\u9009\u62e9\uff01", (String)"CreditLimitDetailEdit_5", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), org != null ? org.getString("name") : ""));
                    return;
                }
                this.setEntryVal(evt.getActionId(), returnDatas, detailAmtMap, rowIndex);
            }
            if ("t_credittypetext".equals(evt.getActionId())) {
                Long typeId;
                detailAmtMap = new HashMap();
                if (this.isCreditLimtBill() && EmptyUtil.isNoEmpty((Long)(typeId = CreditLimitHelper.checkExist(collectIds, (detailAmtMap = this.getHasUseDetails("entry_type", "t_credittype", "t_useamt", "t_preamt")).keySet())))) {
                    DynamicObject creditType = CreditLimitHelper.getCreditTypeById((long)typeId);
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b[%S]\u5df2\u88ab\u5360\u7528\uff0c\u5fc5\u987b\u9009\u62e9\uff01", (String)"CreditLimitDetailEdit_6", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), creditType != null ? creditType.getString("name") : ""));
                    return;
                }
                this.setEntryVal(evt.getActionId(), returnDatas, detailAmtMap, rowIndex);
            }
        }
    }

    private void setEntryVal(String field, ListSelectedRowCollection returnDatas, Map<Long, Pair<BigDecimal, BigDecimal>> detailAmtMap, int rowIndex) {
        int i;
        boolean isOrg = "o_orgtext".equals(field);
        String entry = isOrg ? "entry_org" : "entry_type";
        String idField = isOrg ? "o_org" : "t_credittype";
        String preField = isOrg ? "o_preamt" : "t_preamt";
        String useField = isOrg ? "o_useamt" : "t_useamt";
        IDataModel model = this.getModel();
        String orgTree = this.getPageCache().get(KEY_ORGTREEENTRY);
        if (EmptyUtil.isNoEmpty((String)orgTree)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"o_singleamt"});
        }
        Object shareType = model.getValue("orgsharetype");
        if (isOrg && (OrgShareTypeEnum.DOWNSHARE.getValue().equals(shareType) || EmptyUtil.isNoEmpty((String)orgTree))) {
            int i2 = 0;
            for (ListSelectedRow returnData : returnDatas) {
                if (i2 > 0) {
                    rowIndex = model.createNewEntryRow(entry);
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)field, (Object)returnData.getName(), (int)rowIndex);
                model.setValue("o_totalamt", this.getModel().getValue("totalamt"), rowIndex);
                model.setValue("o_org", (Object)new Object[]{returnData.getPrimaryKeyValue()}, rowIndex);
                Pair<BigDecimal, BigDecimal> amtPair = detailAmtMap.get(returnData.getPrimaryKeyValue());
                if (amtPair != null) {
                    model.setValue(preField, amtPair.getLeft());
                    model.setValue(useField, amtPair.getRight());
                }
                ++i2;
            }
            return;
        }
        Set collectNames = returnDatas.stream().map(ListSelectedRow::getName).collect(Collectors.toSet());
        Set<Object> collectIds = returnDatas.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toSet());
        model.setValue(field, (Object)String.join((CharSequence)",", collectNames), rowIndex);
        model.setValue(idField, (Object)collectIds.toArray(new Object[0]), rowIndex);
        if (!this.isCreditLimtBill()) {
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount(entry);
        for (i = 0; i < entryRowCount; ++i) {
            model.setValue(preField, (Object)BigDecimal.ZERO, i);
            model.setValue(useField, (Object)BigDecimal.ZERO, i);
        }
        for (i = 0; i < entryRowCount; ++i) {
            DynamicObject rowEntity = model.getEntryRowEntity(entry, i);
            Set collIds = CreditLimitHelper.getCollIds((DynamicObjectCollection)rowEntity.getDynamicObjectCollection(idField));
            Pair sumAmt = CreditLimitHelper.getSumAmt(detailAmtMap, (Set)collIds);
            model.setValue(preField, sumAmt.getLeft(), i);
            model.setValue(useField, sumAmt.getRight(), i);
            this.getView().setEnable(Boolean.valueOf(((BigDecimal)sumAmt.getLeft()).add((BigDecimal)sumAmt.getRight()).compareTo(BigDecimal.ZERO) == 0), i, new String[]{field});
        }
    }

    private Map<Long, Pair<BigDecimal, BigDecimal>> getHasUseDetails(String entry, String baseField, String useField, String preField) {
        int currIdx = this.getModel().getEntryCurrentRowIndex(entry);
        HashMap<Long, Pair<BigDecimal, BigDecimal>> companyIdAmtMap = new HashMap<Long, Pair<BigDecimal, BigDecimal>>();
        DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entry, currIdx);
        if (EmptyUtil.isEmpty((Long)entryRowEntity.getLong("pid"))) {
            int entryRowCount = this.getModel().getEntryRowCount(entry);
            for (int i = currIdx + 1; i < entryRowCount; ++i) {
                DynamicObject rowEntity;
                DynamicObjectCollection colls;
                BigDecimal preAmt;
                BigDecimal useAmt = (BigDecimal)this.getModel().getValue(useField, i);
                if (useAmt.add(preAmt = (BigDecimal)this.getModel().getValue(preField, i)).compareTo(BigDecimal.ZERO) > 0 && EmptyUtil.isNoEmpty((DynamicObjectCollection)(colls = (DynamicObjectCollection)this.getModel().getValue(baseField, i)))) {
                    companyIdAmtMap.put(((DynamicObject)colls.get(0)).getDynamicObject("fbasedataid").getLong("id"), (Pair<BigDecimal, BigDecimal>)Pair.of((Object)preAmt, (Object)useAmt));
                }
                if (EmptyUtil.isEmpty((Long)(rowEntity = this.getModel().getEntryRowEntity(entry, i)).getLong("pid"))) break;
            }
        }
        return companyIdAmtMap;
    }

    protected void setSingleAmt(String entry, int index, String totalField, String singleField) {
        DynamicObject row = this.getModel().getEntryRowEntity(entry, index);
        if (!EmptyUtil.isEmpty((Long)row.getLong("pid"))) {
            int parentRowIndex = this.getSelectMainRowIndex(entry);
            this.getModel().setValue(singleField, this.getModel().getValue(totalField, parentRowIndex), index);
        }
        this.refeshOrderNum(entry, "entry_org".equals(entry) ? "ordernumorg" : "ordernumtype");
    }

    protected void createDetail(String entry, BeforeDoOperationEventArgs args) {
        EntryGrid entryGrid = (EntryGrid)this.getControl(entry);
        int[] select = entryGrid.getSelectRows();
        if (EmptyUtil.isNoEmpty((Object)select) && select.length == 1) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entry, select[0]);
            if (entryRowEntity != null && EmptyUtil.isNoEmpty((Long)entryRowEntity.getLong("pid"))) {
                args.setCancel(true);
                this.getModel().insertEntryRow(entry, this.getSelectMainRowIndex(entry));
            } else {
                Object baseId = this.getModel().getValue("entry_org".equals(entry) ? "o_org" : "t_credittype", select[0]);
                if (EmptyUtil.isEmpty((Object)baseId)) {
                    args.setCancel(true);
                    this.getView().showTipNotification("entry_org".equals(entry) ? CreditmFormResourceEnum.AbstracCreditmEdit_3.loadKDString(select[0] + 1) : CreditmFormResourceEnum.AbstracCreditmEdit_4.loadKDString(select[0] + 1));
                }
            }
        }
    }

    private void setCreditMult(String entry, String text, String baseField, int currentRowIdx) {
        DynamicObjectCollection mults = (DynamicObjectCollection)this.getModel().getValue(baseField, currentRowIdx);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)mults)) {
            boolean isChange;
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entry, currentRowIdx);
            Object pid = entryRowEntity.get("pid");
            if (EmptyUtil.isNoEmpty((Object)pid)) {
                this.getModel().setValue(text, (Object)CreditLimitHelper.getMultCollectIdOrName((DynamicObjectCollection)mults, (boolean)false));
                Set<Integer> rowIndex = this.getRowIndex(entry, new int[]{currentRowIdx});
                boolean isOrg = "entry_org".equals(entry);
                this.createMultParent(entry, isOrg ? "o_org" : "t_credittype", isOrg ? "o_orgtext" : "t_credittypetext", rowIndex);
            }
            if (this.isCreditLimtBill() && (isChange = ((Boolean)this.getModel().getValue("ischanging")).booleanValue()) && mults.size() == 1) {
                this.setCreditUseAmt(entry, mults, pid, currentRowIdx, isChange);
                return;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)text, (Object)CreditLimitHelper.getMultCollectName((DynamicObjectCollection)mults), (int)currentRowIdx);
            this.createDetailEntry(CreditLimitHelper.getMultFromDyn((DynamicObjectCollection)mults), entry, baseField, text, currentRowIdx);
        } else {
            this.getModel().setValue(text, (Object)"");
        }
        this.refeshOrderNum(entry, "entry_org".equals(entry) ? "ordernumorg" : "ordernumtype");
    }

    private void createDetailEntry(Map<Long, String> multMap, String entry, String baseField, String textField, int currRowIndex) {
        String entryAmt = "entry_org".equals(entry) ? "o_totalamt" : "t_totalamt";
        Object amt = this.getModel().getValue(entryAmt, currRowIndex);
        BigDecimal entryTotalAmt = BigDecimal.ZERO;
        if (amt != null) {
            entryTotalAmt = (BigDecimal)amt;
        }
        if (entryTotalAmt.compareTo(BigDecimal.ZERO) == 0) {
            BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("totalamt");
            this.getModel().setValue(entryAmt, (Object)totalAmt, currRowIndex);
            entryTotalAmt = totalAmt;
        }
        IDataModel model = this.getModel();
        int entryRowCount = this.getModel().getEntryRowCount(entry);
        Object shareType = model.getValue("orgsharetype");
        if ("entry_org".equals(entry) && OrgShareTypeEnum.DOWNSHARE.getValue().equals(shareType)) {
            return;
        }
        if (multMap.size() == 1) {
            this.deleteDetail(entry, currRowIndex, entryRowCount);
            return;
        }
        if (entryRowCount > currRowIndex + 1) {
            this.deleteOtherEntry(multMap, entry, currRowIndex, entryRowCount, baseField);
        }
        int parentIdx = currRowIndex;
        if (multMap.size() > 0) {
            this.getModel().batchInsertEntryRow(entry, parentIdx, multMap.size());
            for (Map.Entry<Long, String> mult : multMap.entrySet()) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)baseField, (Object)new Object[]{mult.getKey()}, (int)(++currRowIndex));
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)textField, (Object)mult.getValue(), (int)currRowIndex);
                model.setValue("entry_org".equals(entry) ? "o_singleamt" : "t_singleamt", (Object)entryTotalAmt, currRowIndex);
                if (!this.isCreditLimtBill()) continue;
                this.setEntryAvaAmt(entry, currRowIndex);
            }
            TreeEntryGrid treeEntry = (TreeEntryGrid)this.getView().getControl(entry);
            treeEntry.expand(parentIdx);
        }
        if ("entry_type".equals(entry) && this.isCreditLimtBill()) {
            this.creditTypeMerge();
        }
    }

    private void deleteOtherEntry(Map<Long, String> multMap, String entry, int currRowIndex, int entryRowCount, String baseField) {
        DynamicObject entryRowEntity;
        HashSet<Integer> delRow = new HashSet<Integer>();
        for (int i = currRowIndex + 1; !(i >= entryRowCount || (entryRowEntity = this.getModel().getEntryRowEntity(entry, i)) != null && EmptyUtil.isEmpty((Object)entryRowEntity.get("pid"))); ++i) {
            String id;
            DynamicObjectCollection colls = (DynamicObjectCollection)this.getModel().getValue(baseField, i);
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)colls) && EmptyUtil.isNoEmpty((String)(id = CreditLimitHelper.getMultCollectIdOrName((DynamicObjectCollection)colls, (boolean)true))) && multMap != null && multMap.containsKey(Long.parseLong(id))) {
                multMap.remove(Long.parseLong(id));
                ++currRowIndex;
                continue;
            }
            delRow.add(i);
        }
        boolean dataChanged = this.getModel().getDataChanged();
        this.getModel().beginInit();
        this.getModel().deleteEntryRows(entry, delRow.stream().mapToInt(Integer::intValue).toArray());
        this.getModel().endInit();
        this.getView().updateView(entry);
        this.getModel().setDataChanged(dataChanged);
    }

    private void deleteDetail(String entry, int currRowIndex, int entryRowCount) {
        DynamicObject rowEntity;
        Object pid;
        HashSet<Integer> delRow = new HashSet<Integer>();
        DynamicObject currEntry = this.getModel().getEntryRowEntity(entry, currRowIndex);
        for (int i = currRowIndex + 1; i < entryRowCount && EmptyUtil.isNoEmpty((Object)(pid = (rowEntity = this.getModel().getEntryRowEntity(entry, i)).get("pid"))) && currEntry.getPkValue().equals(pid); ++i) {
            delRow.add(i);
        }
        if (delRow.size() > 0) {
            this.getModel().deleteEntryRows(entry, delRow.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    public void creditTypeMerge() {
        boolean isChange = (Boolean)this.getModel().getValue("ischanging");
        if (!isChange) {
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount("entry_type");
        HashSet<Long> typeIds = new HashSet<Long>();
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObjectCollection types;
            String typeId;
            DynamicObject rowEntity;
            boolean typeorgin = (Boolean)this.getModel().getValue("typeorgin", i);
            BigDecimal useAmt = (BigDecimal)this.getModel().getValue("t_useamt", i);
            BigDecimal preAmt = (BigDecimal)this.getModel().getValue("t_preamt", i);
            if (typeorgin || useAmt.compareTo(BigDecimal.ZERO) > 0 || preAmt.compareTo(BigDecimal.ZERO) > 0 || EmptyUtil.isEmpty((Long)(rowEntity = this.getModel().getEntryRowEntity("entry_type", i)).getLong("pid")) || EmptyUtil.isEmpty((String)(typeId = CreditLimitHelper.getMultCollectIdOrName((DynamicObjectCollection)(types = (DynamicObjectCollection)this.getModel().getValue("t_credittype", i)), (boolean)true)))) continue;
            typeIds.add(Long.parseLong(typeId));
        }
        if (typeIds.size() > 0) {
            Set creditIds = null;
            final Object id = this.getModel().getDataEntity().getPkValue();
            if (EmptyUtil.isNoEmpty((Object)id)) {
                creditIds = new HashSet<Long>(){
                    {
                        this.add(Long.parseLong(String.valueOf(id)));
                    }
                };
            }
            if (creditIds != null && creditIds.size() > 0) {
                Map creditTypeAmtMap = CreditLimitHelper.getCreditTypeAmt((Long)((Long)creditIds.iterator().next()), typeIds, (String)"credittype");
                this.setCreditTypeAmt(creditTypeAmtMap);
            }
        }
    }

    public void setCreditTypeAmt(Map<Long, Pair<BigDecimal, BigDecimal>> creditTypeAmtMap) {
        HashSet<Long> pids = new HashSet<Long>();
        int entryRowCount = this.getModel().getEntryRowCount("entry_type");
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObjectCollection types;
            String typeId;
            DynamicObject rowEntity;
            boolean typeorgin = (Boolean)this.getModel().getValue("typeorgin", i);
            BigDecimal useAmt = (BigDecimal)this.getModel().getValue("t_useamt", i);
            BigDecimal preAmt = (BigDecimal)this.getModel().getValue("t_preamt", i);
            if (typeorgin || useAmt.compareTo(BigDecimal.ZERO) > 0 || preAmt.compareTo(BigDecimal.ZERO) > 0 || EmptyUtil.isEmpty((Long)(rowEntity = this.getModel().getEntryRowEntity("entry_type", i)).getLong("pid")) || !creditTypeAmtMap.containsKey(Long.parseLong(typeId = CreditLimitHelper.getMultCollectIdOrName((DynamicObjectCollection)(types = (DynamicObjectCollection)this.getModel().getValue("t_credittype", i)), (boolean)true)))) continue;
            Pair<BigDecimal, BigDecimal> pairMap = creditTypeAmtMap.get(Long.parseLong(typeId));
            this.getModel().setValue("t_useamt", pairMap.getLeft(), i);
            this.getModel().setValue("t_preamt", pairMap.getRight(), i);
            this.getModel().setValue("t_avaramt", (Object)((BigDecimal)this.getModel().getValue("t_singleamt", i)).subtract((BigDecimal)pairMap.getRight()).subtract((BigDecimal)pairMap.getLeft()), i);
            pids.add(rowEntity.getLong("pid"));
        }
        CreditLimitHelper.setCreditTypeParentAmt((IDataModel)this.getModel(), (IFormView)this.getView(), pids);
    }

    private void setEntryAvaAmt(String entry, int rowIdx) {
        String avaField = "entry_org".equals(entry) ? "o_avaramt" : "t_avaramt";
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("entry_org".equals(entry) ? "o_totalamt" : "t_totalamt", rowIdx);
        BigDecimal singleAmt = (BigDecimal)this.getModel().getValue("entry_org".equals(entry) ? "o_singleamt" : "t_singleamt", rowIdx);
        BigDecimal useAmt = (BigDecimal)this.getModel().getValue("entry_org".equals(entry) ? "o_useamt" : "t_useamt", rowIdx);
        BigDecimal preAmt = (BigDecimal)this.getModel().getValue("entry_org".equals(entry) ? "o_preamt" : "t_preamt", rowIdx);
        BigDecimal avaAmount = totalAmt.add(singleAmt).subtract(useAmt).subtract(preAmt);
        this.getModel().setValue(avaField, (Object)(BigDecimal.ZERO.compareTo(avaAmount) > 0 ? BigDecimal.ZERO : avaAmount), rowIdx);
    }

    private void changeTextField(String entry, String baseField, String textField, Object oldValue) {
        if (EmptyUtil.isEmpty((Object)oldValue)) {
            return;
        }
        int entryCurrentRowIndex = this.getModel().getEntryCurrentRowIndex(entry);
        Object textVal = this.getModel().getValue(textField, entryCurrentRowIndex);
        if (EmptyUtil.isEmpty((Object)textVal)) {
            DynamicObject rowEntity = this.getModel().getEntryRowEntity(entry, entryCurrentRowIndex);
            Set<Integer> detailIds = this.getDetailRowIdxs(entry, baseField, entryCurrentRowIndex);
            boolean isPid = EmptyUtil.isEmpty((Long)rowEntity.getLong("pid"));
            if (isPid && EmptyUtil.isNoEmpty(detailIds)) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)textField, (Object)oldValue, (int)entryCurrentRowIndex);
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5220\u9664\u5b50\u884c\uff0c\u518d\u5220\u9664\u7236\u884c\u3002", (String)"CreditLimitDetailEdit_3", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                return;
            }
            this.getModel().setValue(baseField, null, entryCurrentRowIndex);
            if (isPid) {
                return;
            }
            HashSet<Integer> rowIdxs = new HashSet<Integer>();
            rowIdxs.add(this.getParentIndex(entry, entryCurrentRowIndex));
            this.createMultParent(entry, baseField, textField, rowIdxs);
        }
        this.refeshOrderNum(entry, "entry_org".equals(entry) ? "ordernumorg" : "ordernumtype");
    }

    protected void checkSingelAmt(String entry, String totalField, String singleField, String useField, String preField, String avaField) {
        int parentIdx = this.getSelectMainRowIndex(entry);
        int currIdx = this.getSelectedRowIndex(entry);
        BigDecimal totalParenAmt = (BigDecimal)this.getModel().getValue(totalField, parentIdx);
        BigDecimal singleAmt = (BigDecimal)this.getModel().getValue(singleField, currIdx);
        if (singleAmt != null && totalParenAmt != null && singleAmt.compareTo(totalParenAmt) > 0) {
            BigDecimal useAmt = (BigDecimal)this.getModel().getValue(useField, currIdx);
            BigDecimal preAmt = (BigDecimal)this.getModel().getValue(preField, currIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)singleField, (Object)totalParenAmt, (int)currIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)avaField, (Object)totalParenAmt.subtract(useAmt).subtract(preAmt), (int)currIdx);
        }
    }

    private void checkMultAmt() {
        int currIdx = this.getModel().getEntryCurrentRowIndex("entry_mult");
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("totalamt");
        BigDecimal mAmt = (BigDecimal)this.getModel().getValue("m_totalamt");
        if (mAmt != null && totalAmt != null && mAmt.compareTo(totalAmt) > 0) {
            if ("creditm_apply".equals(this.getModel().getDataEntityType().getName())) {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"m_totalamt", (Object)totalAmt, (int)currIdx);
                return;
            }
            BigDecimal useAmt = (BigDecimal)this.getModel().getValue("m_useamt", currIdx);
            BigDecimal preAmt = (BigDecimal)this.getModel().getValue("m_preamt", currIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"m_totalamt", (Object)totalAmt, (int)currIdx);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"m_avaramt", (Object)totalAmt.subtract(useAmt).subtract(preAmt), (int)currIdx);
        }
    }

    protected int getSelectMainRowIndex(String entry) {
        DynamicObject entryRowEntity;
        int index = this.getSelectedRowIndex(entry);
        while (!((entryRowEntity = this.getModel().getEntryRowEntity(entry, index)) != null && EmptyUtil.isEmpty((Long)entryRowEntity.getLong("pid")) || index-- < 0)) {
        }
        return index;
    }

    protected int getSelectedRowIndex(String entry) {
        EntryGrid detail = (EntryGrid)this.getControl(entry);
        int[] select = detail.getSelectRows();
        if (select.length > 0) {
            return select[0];
        }
        return -1;
    }

    protected void checkDetailSingleAmt(String entry, String totalField, String singleField) {
        DynamicObject rowEntry;
        BigDecimal headTotalAmt;
        String applyType;
        if ("entry_mult".equals(entry)) {
            return;
        }
        if (!this.isCreditLimtBill() && !CreditmApplyTypeEnum.isAddChange((String)(applyType = (String)this.getModel().getValue("applytype")))) {
            return;
        }
        int rowIndex = this.getModel().getEntryCurrentRowIndex(entry);
        DynamicObject rowEntity = this.getModel().getEntryRowEntity(entry, rowIndex);
        if (EmptyUtil.isNoEmpty((Object)rowEntity.get("pid"))) {
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount(entry);
        BigDecimal totalAmt = rowEntity.getBigDecimal(totalField);
        if (totalAmt.compareTo(headTotalAmt = (BigDecimal)this.getModel().getValue("totalamt")) > 0) {
            this.getModel().setValue(totalField, (Object)headTotalAmt, rowIndex);
            totalAmt = headTotalAmt;
        }
        for (int i = rowIndex + 1; i < entryRowCount && (rowEntry = this.getModel().getEntryRowEntity(entry, i)) != null && !EmptyUtil.isEmpty((Long)rowEntry.getLong("pid")); ++i) {
            BigDecimal singleAmt = (BigDecimal)this.getModel().getValue(singleField, i);
            if (singleAmt.compareTo(BigDecimal.ZERO) != 0 && singleAmt.compareTo(totalAmt) <= 0) continue;
            this.getModel().setValue(singleField, (Object)totalAmt, i);
        }
    }

    private void changeOrgShareType() {
        if (this.isChangeVersion()) {
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount("entry_org");
        if (entryRowCount > 0) {
            this.getModel().deleteEntryData("entry_org");
        }
        this.setDetaultOrgEntry();
    }

    protected void setEntryAmt(String entry, String totalField, String singleField, BigDecimal totalAmt) {
        if (totalAmt != null && totalAmt.compareTo(BigDecimal.ZERO) < 0) {
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount(entry);
        for (int i = 0; i < entryRowCount; ++i) {
            BigDecimal entryTotalAmt;
            if ("entry_mult".equals(entry)) {
                String applyType;
                entryTotalAmt = (BigDecimal)this.getModel().getValue(totalField, i);
                if (!this.isCreditLimtBill() && !CreditmApplyTypeEnum.isAddChange((String)(applyType = (String)this.getModel().getValue("applytype")))) {
                    return;
                }
                if (entryTotalAmt.compareTo(totalAmt) <= 0 && entryTotalAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                this.getModel().setValue(totalField, (Object)totalAmt, i);
                continue;
            }
            entryTotalAmt = (BigDecimal)this.getModel().getValue(totalField, i);
            long pid = this.getModel().getEntryRowEntity(entry, i).getLong("pid");
            BigDecimal entrySingleAmt = (BigDecimal)this.getModel().getValue(singleField, i);
            if ("entry_org".equals(entry) && (!((Boolean)this.getModel().getValue("isgrouplimit")).booleanValue() || OrgShareTypeEnum.DOWNSHARE.getValue().equals(this.getModel().getValue("orgsharetype")) && entryTotalAmt.compareTo(totalAmt) > 0)) {
                this.getModel().setValue(totalField, (Object)totalAmt, i);
                continue;
            }
            DynamicObject type = (DynamicObject)this.getModel().getValue("credittype");
            if ("entry_type".equals(entry) && type != null && !type.getBoolean("iscomprehensive")) {
                this.getModel().setValue(totalField, (Object)totalAmt, i);
                continue;
            }
            if (EmptyUtil.isNoEmpty((Long)pid)) {
                if (entrySingleAmt.compareTo(totalAmt) <= 0 && entrySingleAmt.compareTo(BigDecimal.ZERO) != 0) continue;
                this.getModel().setValue(singleField, (Object)totalAmt, i);
                continue;
            }
            if (entryTotalAmt.compareTo(totalAmt) <= 0 && entryTotalAmt.compareTo(BigDecimal.ZERO) != 0) continue;
            this.getModel().setValue(totalField, (Object)totalAmt, i);
        }
    }

    protected void changeOrgEntry(Object oldValue) {
        if (this.isChangeVersion()) {
            return;
        }
        if (oldValue != null && !((Boolean)oldValue).booleanValue()) {
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount("entry_org");
        if (entryRowCount > 1 && EmptyUtil.isNoEmpty((Object)this.getModel().getValue("o_org"))) {
            this.getPageCache().put("isgrouplimit", String.valueOf(oldValue == null ? Boolean.valueOf(false) : oldValue));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362[\u662f\u5426\u96c6\u56e2\u6388\u4fe1]\u5c06\u4e22\u5931\u7ec4\u7ec7\u5171\u4eab\u5206\u5f55\u6570\u636e, \u786e\u5b9a\u64cd\u4f5c\u5417?", (String)"AbstracCreditmEdit_3", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_CHANGEISGROUP, (IFormPlugin)this));
        } else {
            this.setDetaultOrgEntry();
        }
        if (!this.isCreditLimtBill() && oldValue != null) {
            this.getModel().setValue("isframework", (Object)"0");
        }
    }

    private void changeTypeEntry(Object oldValue) {
        if (this.isChangeVersion()) {
            return;
        }
        int entryRowCount = this.getModel().getEntryRowCount("entry_type");
        Object creditType = this.getModel().getValue("credittype");
        if (entryRowCount > 0 && EmptyUtil.isNoEmpty((Object)this.getModel().getValue("t_credittype", 0)) && (creditType == null || !((DynamicObject)creditType).getBoolean("iscomprehensive"))) {
            this.getPageCache().put("credittype", String.valueOf(((DynamicObject)oldValue).getPkValue()));
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5207\u6362[\u6388\u4fe1\u7c7b\u522b]\u5c06\u4e22\u5931\u7c7b\u522b\u5171\u4eab\u5206\u5f55\u6570\u636e, \u786e\u5b9a\u64cd\u4f5c\u5417?", (String)"CreditLimitDetailEdit_4", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), MessageBoxOptions.YesNo, new ConfirmCallBackListener(KEY_CHANGECREDITTYPE, (IFormPlugin)this));
        } else {
            this.setDefaultTypeEntry();
        }
    }

    private boolean isChangeVersion() {
        return this.getView().getFormShowParameter().getCustomParams().containsKey("openHistoryId");
    }

    private void rowBtnClick(String opKey) {
        this.getView().invokeOperation(this.getTabName().replace("tab", opKey));
    }

    protected void createMultParent(String entry, String baseField, String textField, Set<Integer> pRowIndex) {
        if (pRowIndex.size() == 0) {
            return;
        }
        HashSet<Integer> rows = new HashSet<Integer>(pRowIndex.size());
        for (Integer index : pRowIndex) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entry, index.intValue());
            DynamicObject pEntry = this.getModel().getEntryRowEntity(entry, index.intValue());
            DynamicObjectCollection parentBases = pEntry.getDynamicObjectCollection(baseField);
            if (EmptyUtil.isNoEmpty((Long)entryRowEntity.getLong("pid")) || parentBases.size() == 0) continue;
            Set<Integer> detailRowIdxs = this.getDetailRowIdxs(entry, baseField, index);
            Set<Long> detailIds = this.getDetailIds(entry, baseField, index);
            if (detailRowIdxs.size() == 1) {
                if (parentBases.size() == 1 && detailIds.size() == 1 && !((DynamicObject)parentBases.get(0)).getDynamicObject("fbasedataid").getPkValue().equals(detailIds.iterator().next())) {
                    int idx = this.getModel().insertEntryRow(entry, index.intValue());
                    DynamicObject newEntry = ((DynamicObject)parentBases.get(0)).getDynamicObject("fbasedataid");
                    this.getModel().setValue(textField, (Object)newEntry.getString("name"), idx);
                    this.getModel().setValue(baseField, (Object)new Object[]{newEntry.getPkValue()}, idx);
                } else {
                    rows.addAll(detailRowIdxs);
                }
            }
            detailIds = this.getDetailIds(entry, baseField, index);
            if (parentBases.size() == 1 && detailIds.size() == 0) continue;
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)baseField, (Object)detailIds.toArray(new Object[0]), (int)index);
            DynamicObjectCollection colls = (DynamicObjectCollection)this.getModel().getValue(baseField, index.intValue());
            if (EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
                int entryRowCount = this.getModel().getEntryRowCount(entry);
                if (entryRowCount == 1) {
                    this.getModel().deleteEntryData(entry);
                    this.getModel().createNewEntryRow(entry);
                    continue;
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)textField, (Object)CreditLimitHelper.getMultCollectName((DynamicObjectCollection)colls), (int)index);
                continue;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)textField, (Object)CreditLimitHelper.getMultCollectName((DynamicObjectCollection)colls), (int)index);
        }
        if (rows.size() > 0) {
            this.getPageCache().remove("del");
            this.getModel().deleteEntryRows(entry, rows.stream().mapToInt(Integer::intValue).toArray());
        }
    }

    private Set<Integer> getDetailRowIdxs(String entry, String baseField, int idx) {
        DynamicObject entryRowEntity;
        int entryRowCount = this.getModel().getEntryRowCount(entry);
        HashSet<Integer> ids = new HashSet<Integer>(entryRowCount);
        for (int i = idx + 1; i < entryRowCount && !EmptyUtil.isEmpty((Long)(entryRowEntity = this.getModel().getEntryRowEntity(entry, i)).getLong("pid")); ++i) {
            if (EmptyUtil.isEmpty((DynamicObjectCollection)entryRowEntity.getDynamicObjectCollection(baseField))) continue;
            ids.add(i);
        }
        return ids;
    }

    private Set<Long> getDetailIds(String entry, String baseField, int idx) {
        DynamicObject entryRowEntity;
        int entryRowCount = this.getModel().getEntryRowCount(entry);
        HashSet<Long> ids = new HashSet<Long>(entryRowCount);
        for (int i = idx + 1; i < entryRowCount && !EmptyUtil.isEmpty((Long)(entryRowEntity = this.getModel().getEntryRowEntity(entry, i)).getLong("pid")); ++i) {
            DynamicObjectCollection colls = (DynamicObjectCollection)this.getModel().getValue(baseField, i);
            Set collIds = CreditLimitHelper.getCollIds((DynamicObjectCollection)colls);
            ids.addAll(collIds);
        }
        return ids;
    }

    protected void refeshOrderNum(String entry, String orderNum) {
        int size = this.getModel().getEntryRowCount(entry);
        int group = 0;
        int groupDetail = 1;
        for (int index = 0; index < size; ++index) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entry, index);
            Long pid = entryRowEntity.getLong("pid");
            boolean isPid = EmptyUtil.isNoEmpty((Long)pid);
            if (isPid) {
                this.getModel().setValue(orderNum, (Object)(group + "." + groupDetail), index);
                this.getModel().setValue("entry_org".equals(entry) ? "o_totalamt" : "t_totalamt", (Object)0, index);
                ++groupDetail;
            } else {
                this.getModel().setValue("entry_org".equals(entry) ? "o_singleamt" : "t_singleamt", (Object)0, index);
                this.getModel().setValue(orderNum, (Object)(++group), index);
                groupDetail = 1;
            }
            this.getView().updateView(orderNum, index);
            this.getView().setEnable(Boolean.valueOf(!isPid), index, new String[]{"entry_org".equals(entry) ? "o_totalamt" : "t_totalamt"});
            this.getView().setEnable(Boolean.valueOf(isPid), index, new String[]{"entry_org".equals(entry) ? "o_singleamt" : "t_singleamt"});
        }
    }

    protected Set<Integer> getRowIndex(String entry, int[] indexs) {
        HashSet<Integer> rowIndexs = new HashSet<Integer>(indexs.length);
        int entryRowCount = this.getModel().getEntryRowCount(entry);
        if (entryRowCount == 0) {
            return rowIndexs;
        }
        for (int currIdx : indexs) {
            int parentIndex = this.getParentIndex(entry, currIdx);
            if (parentIndex < 0) continue;
            rowIndexs.add(parentIndex);
        }
        return rowIndexs;
    }

    protected int getParentIndex(String entry, int currIdx) {
        for (int i = currIdx - 1; i >= 0 && this.getModel().getEntryRowCount(entry) != 0; --i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity(entry, i);
            if (entryRowEntity == null || !EmptyUtil.isEmpty((Long)entryRowEntity.getLong("pid"))) continue;
            return i;
        }
        return -1;
    }

    protected String getTabName() {
        Tab tab = (Tab)this.getView().getControl("tabap");
        return tab.getCurrentTab();
    }

    protected void showF7Form(String formId, boolean isMultiSelect, QFilter filter, Map param, String callBackKey, Object[] selectRows) {
        ListShowParameter parameter = ShowFormHelper.createShowListForm((String)formId, (boolean)isMultiSelect, (int)0, (boolean)true);
        if (EmptyUtil.isNoEmpty((Object)param)) {
            parameter.getCustomParams().putAll(param);
        }
        if (EmptyUtil.isNoEmpty((String)callBackKey)) {
            CloseCallBack callBack = new CloseCallBack((IFormPlugin)this, callBackKey);
            parameter.setCloseCallBack(callBack);
        }
        if (EmptyUtil.isNoEmpty((Object)filter)) {
            parameter.getListFilterParameter().setFilter(filter);
        }
        parameter.setSelectedRows(selectRows);
        this.getView().showForm((FormShowParameter)parameter);
    }

    private void setDefaultCon() {
        DynamicObject creditType = (DynamicObject)this.getModel().getValue("credittype");
        if (creditType != null) {
            this.getView().setEnable(Boolean.valueOf(creditType.getBoolean("iscomprehensive")), new String[]{"entry_type"});
            this.getView().setVisible(Boolean.valueOf(creditType.getBoolean("iscomprehensive")), new String[]{"t_singleamt"});
        }
        boolean isGroup = (Boolean)this.getModel().getValue("isgrouplimit");
        this.getView().setEnable(Boolean.valueOf(isGroup), new String[]{"entry_org"});
        this.getView().setVisible(Boolean.valueOf(isGroup), new String[]{"o_singleamt", "orgsharetype"});
    }

    private void setColumnText(String entryName, String text, String baseField) {
        DynamicObjectCollection entrys = (DynamicObjectCollection)this.getModel().getValue(entryName);
        entrys.forEach(o -> o.set(text, (Object)CreditLimitHelper.getMultCollectName((DynamicObjectCollection)o.getDynamicObjectCollection(baseField))));
        this.getView().updateView(entryName);
    }

    private void setDefaultEndDate() {
        Date startDate = (Date)this.getModel().getValue("startdate");
        if (startDate != null) {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"enddate", (Object)DateUtils.addYears((Date)startDate, (int)1));
        }
    }

    private void mOrgF7(BeforeF7SelectEvent evt) {
        ListShowParameter formShowParameter = (ListShowParameter)evt.getFormShowParameter();
        Object orgShereType = this.getModel().getValue("orgsharetype");
        Set baseOrgIds = CreditLimitHelper.getBaseIds((IDataModel)this.getModel(), (String)"entry_org", (String)"o_org");
        if (!OrgShareTypeEnum.DOWNSHARE.getValue().equals(orgShereType)) {
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)baseOrgIds));
        } else {
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"08", new ArrayList(baseOrgIds), (boolean)true);
            formShowParameter.getListFilterParameter().getQFilters().add(new QFilter("id", "in", (Object)subOrgIds));
        }
    }

    private void bankF7(BeforeF7SelectEvent evt) {
        String bankType = (String)this.getModel().getValue("banktype");
        if (EmptyUtil.isEmpty((String)bankType)) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter filter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()).and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (CreditFinTypeEnum.ORG.getValue().equals(bankType)) {
            showParameter.setCustomParam("orgFuncId", (Object)"08");
        }
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    protected void setDetaultOrgEntry() {
        this.getModel().deleteEntryData("entry_org");
        int newEntryRow = this.getModel().createNewEntryRow("entry_org");
        boolean isGroup = (Boolean)this.getModel().getValue("isgrouplimit");
        if (!isGroup) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"orgsharetype", (Object)OrgShareTypeEnum.APPOINTSHARE.getValue());
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                return;
            }
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"o_org", (Object)new Object[]{org.getPkValue()}, (int)newEntryRow);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"o_orgtext", (Object)org.getString("name"), (int)newEntryRow);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"o_totalamt", (Object)this.getModel().getValue("totalamt"), (int)newEntryRow);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"ordernumorg", (Object)1, (int)newEntryRow);
        }
        this.getView().setEnable(Boolean.valueOf(isGroup), new String[]{"entry_org"});
        this.getView().setVisible(Boolean.valueOf(isGroup), new String[]{"o_singleamt", "orgsharetype"});
    }

    protected void setDefaultTypeEntry() {
        this.getModel().deleteEntryData("entry_type");
        DynamicObject creditType = (DynamicObject)this.getModel().getValue("credittype");
        if (creditType != null) {
            boolean isCom = creditType.getBoolean("iscomprehensive");
            if (!isCom) {
                int newEntryRow = this.getModel().createNewEntryRow("entry_type");
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"t_credittype", (Object)new Object[]{creditType.getPkValue()}, (int)newEntryRow);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"t_credittypetext", (Object)creditType.getString("name"), (int)newEntryRow);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"t_totalamt", (Object)this.getModel().getValue("totalamt"), (int)newEntryRow);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"ordernumtype", (Object)1, (int)newEntryRow);
            }
            this.getView().setEnable(Boolean.valueOf(isCom), new String[]{"entry_type"});
            this.getView().setVisible(Boolean.valueOf(isCom), new String[]{"t_singleamt"});
        }
    }

    private void setCreditUseAmt(String entry, DynamicObjectCollection mults, Object pid, int currentRowIdx, boolean isChange) {
        Long sourcebillId = 0L;
        if (isChange) {
            sourcebillId = this.getModel().getDataEntity().getLong("id");
        } else {
            DynamicObjectCollection sourceBillIds = (DynamicObjectCollection)this.getModel().getValue("sourcebillids");
            Set creditIds = CreditLimitHelper.getCollIds((DynamicObjectCollection)sourceBillIds);
            if (creditIds.isEmpty()) {
                return;
            }
            sourcebillId = (Long)creditIds.iterator().next();
        }
        if (EmptyUtil.isEmpty((Long)sourcebillId) || EmptyUtil.isEmpty((DynamicObjectCollection)mults)) {
            return;
        }
        boolean isOrg = "entry_org".equals(entry);
        String selField = isOrg ? "org" : "credittype";
        Set allIds = CreditLimitHelper.getCollIds((DynamicObjectCollection)mults);
        boolean isDownShare = OrgShareTypeEnum.DOWNSHARE.getValue().equals(this.getModel().getValue("orgsharetype"));
        if (isOrg) {
            allIds = CreditLimitHelper.getAllOrgIds((DynamicObjectCollection)mults, (boolean)isDownShare);
        }
        Map creditTypeAmtMap = CreditLimitHelper.getCreditTypeAmt((Long)sourcebillId, (Set)allIds, (String)selField);
        Pair amtPair = (Pair)creditTypeAmtMap.get(((DynamicObject)mults.get(0)).getDynamicObject("fbasedataid").getLong("id"));
        if (isDownShare) {
            BigDecimal useAmt = creditTypeAmtMap.values().stream().map(o -> (BigDecimal)o.getLeft()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal preAmt = creditTypeAmtMap.values().stream().map(o -> (BigDecimal)o.getRight()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            amtPair = Pair.of((Object)useAmt, (Object)preAmt);
        }
        if (amtPair == null) {
            return;
        }
        this.getModel().setValue(isOrg ? "o_useamt" : "t_useamt", amtPair.getLeft(), currentRowIdx);
        this.getModel().setValue(isOrg ? "o_preamt" : "t_preamt", amtPair.getRight(), currentRowIdx);
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue(isOrg ? "o_totalamt" : "t_totalamt", currentRowIdx);
        BigDecimal singleAmt = (BigDecimal)this.getModel().getValue(isOrg ? "o_singleamt" : "t_singleamt", currentRowIdx);
        this.getModel().setValue(isOrg ? "o_avaramt" : "t_avaramt", (Object)totalAmt.add(singleAmt).subtract((BigDecimal)amtPair.getLeft()).subtract((BigDecimal)amtPair.getRight()), currentRowIdx);
        if (!isOrg && ((BigDecimal)amtPair.getLeft()).add((BigDecimal)amtPair.getRight()).compareTo(BigDecimal.ZERO) > 0) {
            HashSet<Long> pidSet = new HashSet<Long>();
            pidSet.add((Long)pid);
            CreditLimitHelper.setCreditTypeParentAmt((IDataModel)this.getModel(), (IFormView)this.getView(), pidSet);
        }
    }

    protected boolean isCreditLimtBill() {
        return true;
    }
}

