/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.common;

import java.math.BigDecimal;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class CreditLimitFrameWorkEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit creditF7 = (BasedataEdit)this.getControl("framework");
        creditF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name;
        switch (name = evt.getProperty().getName()) {
            case "framework": {
                this.frameWorkF7(evt);
            }
        }
    }

    private void frameWorkF7(BeforeF7SelectEvent evt) {
        boolean isCheck = TmcViewInputHelper.checkMustInput((IFormView)this.getView(), (IDataModel)this.getModel(), (boolean)false, (String[])new String[]{"org", "banktype", "bank", "credittype", "currency", "totalamt"});
        if (!isCheck) {
            evt.setCancel(true);
            return;
        }
        DynamicObject creditType = (DynamicObject)this.getModel().getValue("credittype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String bankType = (String)this.getModel().getValue("banktype");
        DynamicObject bank = (DynamicObject)this.getModel().getValue("bank");
        DynamicObject currency = (DynamicObject)this.getModel().getValue("currency");
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("totalamt");
        QFilter frameFilter = CreditFrameworkHelper.getFrameLimitFilter((long)org.getLong("id"), (DynamicObject)bank, (String)bankType, (DynamicObject)creditType, (long)currency.getLong("id"), (BigDecimal)totalAmt);
        ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
        parameter.getListFilterParameter().getQFilters().add(frameFilter);
        parameter.getCustomParams().put("totalamt", totalAmt);
        parameter.getCustomParams().put("org", org.getLong("id"));
        parameter.getCustomParams().put("credittype", creditType.getLong("id"));
    }
}

