/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditframe;

import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.base.BaseShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.CreditFrameworkRerunHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditFrameWorkAllocationEdit
extends AbstractFormPlugin
implements HyperLinkClickListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        BillList list = (BillList)this.getControl("billlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        String filter = this.getPageCache().get("filter");
        if (EmptyUtil.isNoEmpty((String)filter)) {
            this.setFilter(Arrays.stream(filter.split(",")).map(Long::new).collect(Collectors.toSet()));
        }
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initfaultVal();
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey;
        super.itemClick(evt);
        switch (itemKey = evt.getItemKey()) {
            case "tb_fresh": {
                this.initfaultVal();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        if ("isdirect".equals(name)) {
            this.initfaultVal();
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent event) {
        String fieldName = event.getFieldName();
        if ("number".equals(fieldName)) {
            BillList billSel = (BillList)this.getControl("billlistap");
            Object limitId = billSel.getFocusRowPkId();
            DynamicObject limit = QueryServiceHelper.queryOne((String)"cfm_creditlimit", (String)"id,isframework", (QFilter[])new QFilter[]{new QFilter("id", "=", limitId)});
            BaseShowParameter parameter = new BaseShowParameter();
            parameter.setFormId(limit.getBoolean("isframework") ? "creditm_limit_framework" : "cfm_creditlimit");
            parameter.setPkId((Object)limit.getLong("id"));
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private void initfaultVal() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object frameWorkId = customParams.get("id");
        if (EmptyUtil.isEmpty(frameWorkId)) {
            return;
        }
        DynamicObjectCollection frameWorks = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"id,number,banktype,bank,currency,totalamt,sourcebillids.fbasedataid sourcebillids", (QFilter[])new QFilter[]{new QFilter("id", "=", frameWorkId)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)frameWorks)) {
            return;
        }
        DynamicObject frameWork = (DynamicObject)frameWorks.get(0);
        this.getModel().setValue("billno", (Object)frameWork.getString("number"));
        this.getModel().setValue("banktype", (Object)frameWork.getString("banktype"));
        this.getModel().setValue("bank", frameWork.get("bank"));
        this.getModel().setValue("currency", frameWork.get("currency"));
        this.getModel().setValue("totalamt", frameWork.get("totalamt"));
        Set srcBillIds = frameWorks.stream().map(o -> o.getLong("sourcebillids")).collect(Collectors.toSet());
        Set allLimitIds = CreditFrameworkRerunHelper.getMergeSrcbillIds(Collections.singletonList(frameWork.getLong("id")).stream().collect(Collectors.toSet()), srcBillIds);
        Set creditLimitIds = CreditFrameworkHelper.getFrameWorkUse((Set)allLimitIds, new HashSet(), ((Boolean)this.getModel().getValue("isdirect") == false ? 1 : 0) != 0);
        this.getPageCache().put("filter", creditLimitIds.stream().map(String::valueOf).collect(Collectors.joining(",")));
        this.setFilter(creditLimitIds);
        BillList useList = (BillList)this.getControl("billlistap");
        useList.refreshData();
    }

    private void setFilter(Set<Long> creditLimitIds) {
        BillList useList = (BillList)this.getControl("billlistap");
        useList.setFilter(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("id", "in", creditLimitIds)));
    }
}

