/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditframe;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.CreditFrameworkRerunHelper;
import kd.tmc.creditm.common.helper.CreditLimitAmtHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.formplugin.resources.CreditmFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;
import org.apache.commons.lang3.tuple.Pair;

public class CreditFrameWorkEdit
extends AbstractTmcBillEdit {
    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.autoCountEntryUseamt();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("save".equals(key) || "submit".equals(key)) {
            op.getOption().setVariableValue("op_from_list_form", "1");
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        super.propertyChanged(e);
        switch (name = e.getProperty().getName()) {
            case "totalamt": {
                this.propChgTotalAmt(e);
                break;
            }
            case "o_singleamt": {
                this.propChgSingleAmt(e, "o_notallocationamt", "o_singleamt");
                break;
            }
            case "o_totalamt": {
                this.propChgSingleAmt(e, "o_notallocationamt", "o_totalamt");
                break;
            }
            case "t_singleamt": {
                this.propChgSingleAmt(e, "t_notallocationamt", "t_singleamt");
                break;
            }
            case "t_totalamt": {
                this.propChgSingleAmt(e, "t_notallocationamt", "t_totalamt");
                break;
            }
            case "m_totalamt": {
                this.propChgSingleAmt(e, "m_notallocationamt", "m_totalamt");
                break;
            }
            case "framework": {
                this.getModel().deleteEntryData("entry_org");
                this.getModel().createNewEntryRow("entry_org");
            }
        }
    }

    private void propChgTotalAmt(PropertyChangedArgs e) {
        boolean isMergeNew = (Boolean)this.getModel().getValue("ismergenew");
        if (!isMergeNew) {
            return;
        }
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("totalamt");
        BigDecimal notCalAmt = (BigDecimal)this.getModel().getValue("notallocationamt");
        ChangeData[] changeData = e.getChangeSet();
        BigDecimal oldAmt = (BigDecimal)changeData[0].getOldValue();
        BigDecimal calAmt = oldAmt.subtract(notCalAmt);
        if (calAmt.compareTo(totalAmt) > 0) {
            this.getView().showTipNotification(CreditmFormResourceEnum.AbstracCreditmEdit_2.loadKDString(calAmt));
            this.getModel().setValue("totalamt", (Object)oldAmt);
            return;
        }
        this.getModel().setValue("notallocationamt", (Object)totalAmt.subtract(calAmt));
    }

    private void propChgSingleAmt(PropertyChangedArgs e, String notField, String amtField) {
        if (this.getPageCache().get("ismergenew") != null) {
            this.getPageCache().remove("ismergenew");
            return;
        }
        String status = (String)this.getModel().getValue("status");
        boolean ismergeNew = (Boolean)this.getModel().getValue("ismergenew");
        if (BillStatusEnum.SAVE.getValue().equals(status) && !ismergeNew) {
            return;
        }
        ChangeData[] changeData = e.getChangeSet();
        BigDecimal oldAmt = (BigDecimal)changeData[0].getOldValue();
        int idx = e.getChangeSet()[0].getRowIndex();
        BigDecimal notCal = (BigDecimal)this.getModel().getValue(notField, idx);
        BigDecimal singleAmt = (BigDecimal)this.getModel().getValue(amtField, idx);
        BigDecimal calAmt = oldAmt.subtract(notCal);
        if (calAmt.compareTo(singleAmt) > 0) {
            String msg = CreditmFormResourceEnum.AbstracCreditmEdit_0.loadKDString(calAmt);
            if ("o_totalamt".equals(amtField) || "t_totalamt".equals(amtField) || "m_totalamt".equals(amtField)) {
                msg = CreditmFormResourceEnum.AbstracCreditmEdit_1.loadKDString(calAmt);
            }
            this.getView().showTipNotification(msg);
            this.getPageCache().put("ismergenew", "1");
            this.getModel().setValue(amtField, (Object)oldAmt, idx);
            return;
        }
        this.getModel().setValue(notField, (Object)singleAmt.subtract(calAmt), idx);
    }

    private void autoCountEntryUseamt() {
        Set allLimitIds;
        Set creditLimitIds;
        String status = (String)this.getModel().getValue("status");
        boolean isDownShare = OrgShareTypeEnum.DOWNSHARE.getValue().equals(this.getModel().getValue("orgsharetype"));
        boolean isMergeNew = (Boolean)this.getModel().getValue("ismergenew");
        if (!BillStatusEnum.isAudit((String)status) && !isMergeNew) {
            return;
        }
        long frameWorkId = this.getModel().getDataEntity().getLong("id");
        DynamicObjectCollection sourceBillIds = (DynamicObjectCollection)this.getModel().getValue("sourcebillids");
        HashSet<Long> srcBillIds = new HashSet<Long>();
        if (isMergeNew && EmptyUtil.isNoEmpty((DynamicObjectCollection)sourceBillIds)) {
            srcBillIds.add(((DynamicObject)sourceBillIds.get(0)).getDynamicObject("fbasedataid").getLong("id"));
        }
        if (EmptyUtil.isEmpty((Collection)(creditLimitIds = CreditFrameworkHelper.getFrameWorkUse((Set)(allLimitIds = CreditFrameworkRerunHelper.getMergeSrcbillIds(Collections.singletonList(frameWorkId).stream().collect(Collectors.toSet()), srcBillIds)), new HashSet(), (boolean)true)))) {
            this.setEntryAmt(new HashMap<Long, Pair<BigDecimal, BigDecimal>>(), "entry_org", isDownShare);
            this.setEntryAmt(new HashMap<Long, Pair<BigDecimal, BigDecimal>>(), "entry_type", isDownShare);
            this.setMultEntryAmt(new HashMap<String, Pair<BigDecimal, BigDecimal>>());
            this.getModel().setDataChanged(false);
            return;
        }
        DataSet creditLimitOrgtypeDs = CreditFrameworkHelper.getCreditLimitOrgtypeDs((Set)creditLimitIds);
        DataSet frameToLimitDs = this.getParentLimitDs(creditLimitOrgtypeDs.copy(), creditLimitOrgtypeDs.copy().filter("framework!=0"));
        DataSet creditUseDs = CreditLimitAmtHelper.getCreditUseDs((Set)creditLimitIds, null, null);
        creditUseDs = creditUseDs.leftJoin(frameToLimitDs).on("creditlimit", "id").select(new String[]{"creditlimit", "preamount", "amount"}, new String[]{"horg org", "htype credittype"}).finish();
        Map entryOrgAmtMap = CreditFrameworkHelper.getEntryAmtMap((DataSet)creditUseDs.copy(), (String)"org");
        Map entryTypeAmtMap = CreditFrameworkHelper.getEntryAmtMap((DataSet)creditUseDs.copy(), (String)"credittype");
        Map entryMultAmtMap = CreditFrameworkHelper.getEntryMultAmtMap((DataSet)creditUseDs);
        this.setEntryAmt(entryOrgAmtMap, "entry_org", isDownShare);
        this.setEntryAmt(entryTypeAmtMap, "entry_type", isDownShare);
        this.setMultEntryAmt(entryMultAmtMap);
        this.getModel().setDataChanged(false);
    }

    private void setMultEntryAmt(Map<String, Pair<BigDecimal, BigDecimal>> entryMultAmtMap) {
        int multCount = this.getModel().getEntryRowCount("entry_mult");
        if (multCount == 0) {
            return;
        }
        for (int i = 0; i < multCount; ++i) {
            this.getModel().setValue("m_useamt", (Object)BigDecimal.ZERO, i);
            this.getModel().setValue("m_preamt", (Object)BigDecimal.ZERO, i);
            this.getModel().setValue("m_avaramt", this.getModel().getValue("m_totalamt", i), i);
        }
        for (Map.Entry<String, Pair<BigDecimal, BigDecimal>> entry : entryMultAmtMap.entrySet()) {
            Object[] split = entry.getKey().split("#");
            if (EmptyUtil.isEmpty((Object[])split) && split.length != 2) continue;
            long orgId = Long.parseLong((String)split[0]);
            long typeId = Long.parseLong((String)split[1]);
            for (int i = 0; i < multCount; ++i) {
                DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entry_mult", i);
                Set orgIds = CreditLimitHelper.getCollIds((DynamicObjectCollection)entryRowEntity.getDynamicObjectCollection("m_org"));
                Set typeIds = CreditLimitHelper.getCollIds((DynamicObjectCollection)entryRowEntity.getDynamicObjectCollection("m_credittype"));
                if (!orgIds.contains(orgId) || !typeIds.contains(typeId)) continue;
                BigDecimal useAmt = entryRowEntity.getBigDecimal("m_useamt");
                BigDecimal preAmt = entryRowEntity.getBigDecimal("m_preamt");
                BigDecimal avaAmt = entryRowEntity.getBigDecimal("m_avaramt");
                this.getModel().setValue("m_useamt", (Object)useAmt.add((BigDecimal)entry.getValue().getLeft()), i);
                this.getModel().setValue("m_preamt", (Object)preAmt.add((BigDecimal)entry.getValue().getRight()), i);
                avaAmt = avaAmt.subtract((BigDecimal)entry.getValue().getLeft()).subtract((BigDecimal)entry.getValue().getRight());
                this.getModel().setValue("m_avaramt", (Object)(avaAmt.compareTo(BigDecimal.ZERO) > 0 ? avaAmt : BigDecimal.ZERO), i);
            }
        }
    }

    private DataSet getParentLimitDs(DataSet creditLimitOrgtypeDs, DataSet frameDs) {
        long frameWorkId = this.getModel().getDataEntity().getLong("id");
        DataSet frameWorkDs = frameDs.copy().filter(String.format("isframework=(%s) and framework!=0", true));
        if ((frameWorkDs = this.getFrameWorkDs(frameWorkDs, Collections.singletonList(frameWorkId))).isEmpty()) {
            return creditLimitOrgtypeDs;
        }
        List<Long> frameIds = this.getRowDsIds(frameWorkDs);
        frameIds.add(frameWorkId);
        DataSet limitDs = creditLimitOrgtypeDs.copy().filter(String.format("isframework=(%s) and framework in (%s)", false, frameIds.stream().map(String::valueOf).collect(Collectors.joining(","))));
        frameWorkDs = frameWorkDs.addField("horg", "org").addField("htype", "type").removeFields(new String[]{"horg", "htype"});
        limitDs = limitDs.leftJoin(frameWorkDs).on("framework", "id").select(new String[]{"id", "org", "type", "isframework", "framework"}).finish();
        creditLimitOrgtypeDs = creditLimitOrgtypeDs.leftJoin(limitDs).on("id", "id").select(new String[]{"id", "case when org!=null then org else horg end horg", "case when type!=null then type else htype end htype", "isframework", "framework"}).finish();
        return creditLimitOrgtypeDs;
    }

    private DataSet getFrameWorkDs(DataSet frameWorkDs, List<Long> frameWorkIds) {
        DataSet twoFrameDs = frameWorkDs.copy().filter(String.format("framework in (%s)", frameWorkIds.stream().map(String::valueOf).collect(Collectors.joining(","))));
        if (twoFrameDs.isEmpty()) {
            return frameWorkDs;
        }
        List<Long> rowDsIds = this.getRowDsIds(twoFrameDs);
        DataSet threeFrameDs = frameWorkDs.copy().filter(String.format("framework in (%s)", rowDsIds.stream().map(String::valueOf).collect(Collectors.joining(","))));
        if (threeFrameDs.isEmpty()) {
            return frameWorkDs;
        }
        rowDsIds.addAll(frameWorkIds);
        DataSet fourFrameDs = frameWorkDs.copy().filter(String.format("framework not in (%s)", rowDsIds.stream().map(String::valueOf).collect(Collectors.joining(","))));
        threeFrameDs = threeFrameDs.leftJoin(twoFrameDs).on("framework", "id").select(new String[]{"id", "isframework", "framework"}, new String[]{"horg org", "htype type"}).finish();
        frameWorkDs = frameWorkDs.leftJoin(threeFrameDs.copy()).on("id", "id").select(new String[]{"id", "case when org!=null then org else horg end horg", "case when type!=null then type else htype end htype", "isframework", "framework"}).finish();
        if (fourFrameDs.isEmpty()) {
            return frameWorkDs;
        }
        rowDsIds = this.getRowDsIds(threeFrameDs);
        return this.getFrameWorkDs(frameWorkDs, rowDsIds);
    }

    private List<Long> getRowDsIds(DataSet frameWorkDs) {
        ArrayList<Long> frameIds = new ArrayList<Long>();
        for (Row frameWork : frameWorkDs.copy()) {
            frameIds.add(frameWork.getLong("id"));
        }
        return frameIds;
    }

    private void setEntryAmt(Map<Long, Pair<BigDecimal, BigDecimal>> entryAmtMap, String entry, boolean isDownShare) {
        int i;
        String field = "entry_org".equals(entry) ? "o_org" : "t_credittype";
        String totalField = "entry_org".equals(entry) ? "o_totalamt" : "t_totalamt";
        String singleField = "entry_org".equals(entry) ? "o_singleamt" : "t_singleamt";
        String useField = "entry_org".equals(entry) ? "o_useamt" : "t_useamt";
        String preField = "entry_org".equals(entry) ? "o_preamt" : "t_preamt";
        String avaField = "entry_org".equals(entry) ? "o_avaramt" : "t_avaramt";
        int entryRowCount = this.getModel().getEntryRowCount(entry);
        for (i = 0; i < entryRowCount; ++i) {
            this.getModel().setValue(useField, (Object)BigDecimal.ZERO, i);
            this.getModel().setValue(preField, (Object)BigDecimal.ZERO, i);
        }
        for (i = 0; i < entryRowCount; ++i) {
            DynamicObjectCollection vals = (DynamicObjectCollection)this.getModel().getValue(field, i);
            Pair<BigDecimal, BigDecimal> entryAmount = this.getEntryAmount(vals, entryAmtMap, entry, isDownShare);
            this.getModel().setValue(useField, (Object)((BigDecimal)this.getModel().getValue(useField, i)).add((BigDecimal)entryAmount.getLeft()), i);
            this.getModel().setValue(preField, (Object)((BigDecimal)this.getModel().getValue(preField, i)).add((BigDecimal)entryAmount.getRight()), i);
            BigDecimal totalAmt = (BigDecimal)this.getModel().getValue(totalField, i);
            BigDecimal singleAmt = (BigDecimal)this.getModel().getValue(singleField, i);
            BigDecimal avaAmt = totalAmt.add(singleAmt).subtract((BigDecimal)entryAmount.getLeft()).subtract((BigDecimal)entryAmount.getRight());
            this.getModel().setValue(avaField, (Object)(avaAmt.compareTo(BigDecimal.ZERO) > 0 ? avaAmt : BigDecimal.ZERO), i);
        }
        if ("entry_org".equals(entry)) {
            BigDecimal useAmt = entryAmtMap.values().stream().map(o -> (BigDecimal)o.getLeft()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            BigDecimal preAmt = entryAmtMap.values().stream().map(o -> (BigDecimal)o.getRight()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            this.getModel().setValue("useamt", (Object)useAmt);
            this.getModel().setValue("preuseamt", (Object)preAmt);
            BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("totalamt");
            BigDecimal avaAmt = totalAmt.subtract(useAmt).subtract(preAmt);
            this.getModel().setValue("avaramt", (Object)(avaAmt.compareTo(BigDecimal.ZERO) > 0 ? avaAmt : BigDecimal.ZERO));
        }
    }

    private Pair<BigDecimal, BigDecimal> getEntryAmount(DynamicObjectCollection vals, Map<Long, Pair<BigDecimal, BigDecimal>> map, String entry, boolean isDownShare) {
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal preAmount = BigDecimal.ZERO;
        for (DynamicObject val : vals) {
            Pair<BigDecimal, BigDecimal> amtPair = this.getAmountPair(map, val.getDynamicObject("fbasedataid").getLong("id"), "entry_org".equals(entry) && isDownShare);
            if (amtPair == null) continue;
            amount = amount.add((BigDecimal)amtPair.getLeft());
            preAmount = preAmount.add((BigDecimal)amtPair.getRight());
        }
        return Pair.of((Object)amount, (Object)preAmount);
    }

    private Pair<BigDecimal, BigDecimal> getAmountPair(Map<Long, Pair<BigDecimal, BigDecimal>> map, long orgId, boolean isDownShare) {
        Pair resAmount = Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO);
        if (isDownShare) {
            for (Map.Entry<Long, Pair<BigDecimal, BigDecimal>> amtEntry : map.entrySet()) {
                if (!OrgUnitServiceHelper.isParentOrg((String)"08", (long)orgId, (long)amtEntry.getKey())) continue;
                Pair<BigDecimal, BigDecimal> amtPair = amtEntry.getValue();
                resAmount = Pair.of((Object)((BigDecimal)resAmount.getLeft()).add((BigDecimal)amtPair.getLeft()), (Object)((BigDecimal)resAmount.getRight()).add((BigDecimal)amtPair.getRight()));
            }
            return resAmount;
        }
        return map.get(orgId);
    }
}

