/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditframe;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.mvc.list.ListDataProvider;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.CreditLimitAmtHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.formplugin.resources.CreditmFormResourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcDataBaseList;

public class CreditFrameWorkList
extends AbstractTmcDataBaseList {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BillList billList = (BillList)this.getControl("billlistap");
        billList.addListRowClickListener(new ListRowClickListener(){

            public void listRowClick(ListRowClickEvent evt) {
                CreditFrameWorkList.this.rowClick(evt);
            }
        });
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        OperationResult operationResult = args.getOperationResult();
        if (operationResult == null || !operationResult.isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "trackallocation": {
                this.showAllocationView();
                break;
            }
            case "framecheckuse": {
                this.checkUse();
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int start, int limit) {
                DynamicObjectCollection dataList = super.getData(start, limit);
                if (dataList.isEmpty()) {
                    return dataList;
                }
                if (!((DynamicObject)dataList.get(0)).getDataEntityType().getProperties().containsKey((Object)"useamt")) {
                    return dataList;
                }
                for (DynamicObject data : dataList) {
                    Set creditLimitIds = CreditFrameworkHelper.getCreditLimitIds((long)data.getLong("id"));
                    DataSet creditUseDs = CreditLimitAmtHelper.getCreditUseDs((Set)creditLimitIds, null, null);
                    DataSet resultDs = creditUseDs.groupBy().sum("amount").sum("preamount").finish();
                    if (resultDs.isEmpty()) continue;
                    Row row = (Row)resultDs.iterator().next();
                    data.set("useamt", (Object)row.getBigDecimal("amount"));
                    data.set("preuseamt", (Object)row.getBigDecimal("preamount"));
                }
                return dataList;
            }
        });
    }

    private void rowClick(ListRowClickEvent evt) {
        ListShowParameter sp = (ListShowParameter)this.getView().getFormShowParameter();
        if (!sp.isLookUp() || EmptyUtil.isEmpty((Object)evt.getCurrentListSelectedRow())) {
            return;
        }
        Object pkId = evt.getCurrentListSelectedRow().getPrimaryKeyValue();
        DynamicObject frameWork = TmcDataServiceHelper.loadSingle((Object)pkId, (String)"creditm_limit_framework");
        Map customParams = sp.getCustomParams();
        BigDecimal totalAmt = (BigDecimal)customParams.get("totalamt");
        Long orgId = Long.valueOf(String.valueOf(customParams.get("org")));
        Long creditType = Long.valueOf(String.valueOf(customParams.get("credittype")));
        BigDecimal orgTypeAmount = CreditFrameworkHelper.getOrgTypeAmount((DynamicObject)frameWork, (long)orgId, (long)creditType);
        if (totalAmt.compareTo(orgTypeAmount) > 0) {
            evt.setCancel(true);
            BillList useList = (BillList)this.getControl("billlistap");
            useList.clearSelection();
            IDataModel model = this.getView().getParentView().getModel();
            DynamicObject org = (DynamicObject)model.getValue("org");
            DynamicObject type = (DynamicObject)model.getValue("credittype");
            DynamicObject currency = (DynamicObject)model.getValue("currency");
            int amtPrecision = CreditLimitHelper.getAmtPrecision((DynamicObject)currency);
            this.getView().showTipNotification(CreditmFormResourceEnum.CreditFrameWorkList_0.loadKDString(org.getString("name"), type.getString("name"), orgTypeAmount.setScale(amtPrecision), totalAmt.setScale(amtPrecision)));
        }
    }

    private void showAllocationView() {
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isEmpty((Long)selectedId)) {
            return;
        }
        FormShowParameter form = new FormShowParameter();
        form.setFormId("creditm_allocation");
        form.setCustomParam("id", (Object)selectedId);
        form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(form);
    }

    private void checkUse() {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            return;
        }
        FormShowParameter sp = new FormShowParameter();
        sp.setFormId("cfm_creditusedetail");
        sp.setCustomParam("id", (Object)selectedId);
        sp.setCustomParam("isframework", (Object)true);
        sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(sp);
    }
}

