/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.devportal.AppMenuElement;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.list.BillList;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.devportal.AppMetadata;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.operation.Operation;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.AppMetaServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcBillBaseList;

public class CheckBillLogList
extends AbstractTmcBillBaseList {
    private static final Set<String> ignoreOpers = new HashSet<String>();

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if ("checkbtn".equals(itemKey)) {
            this.getOperates();
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refreshData();
        }
    }

    private void getOperates() {
        String path;
        EntityMetadata metadata = this.getEntityMetadata("bill_operation");
        ComboField applist = (ComboField)metadata.getFieldByKey("applist");
        Set<String> apps = applist.getItems().stream().filter(o -> o.isItemVisible()).map(o -> o.getValue()).collect(Collectors.toSet());
        if (apps == null || apps.size() == 0) {
            return;
        }
        Set<String> appIds = this.getAppids(apps);
        HashMap<String, String> menus = new HashMap<String, String>();
        HashMap<String, String> menuForms = new HashMap<String, String>();
        for (String appId : appIds) {
            AppMetadata appMetadata = AppMetaServiceHelper.loadAppMetadataById((String)appId, (boolean)false);
            List appMenus = appMetadata.getAppMenus();
            menus.putAll(appMenus.stream().filter(o -> EmptyUtil.isEmpty((String)o.getFormId())).collect(Collectors.toMap(o -> o.getId(), o -> o.getName().getLocaleValue())));
            for (AppMenuElement appMenu : appMenus) {
                path = "";
                String menuName = (String)menus.get(appMenu.getParentId());
                if (EmptyUtil.isNoEmpty((String)menuName)) {
                    path = menuName + ">";
                }
                if (!EmptyUtil.isNoEmpty((String)appMenu.getFormId())) continue;
                menuForms.put(appMenu.getFormId(), path + appMenu.getName().getLocaleValue());
            }
        }
        DynamicObjectCollection billEntitys = this.getBillEntitys(apps);
        Set billEntitySet = billEntitys.stream().map(o -> o.get("id")).collect(Collectors.toSet());
        DeleteServiceHelper.delete((String)"bill_operation", (QFilter[])new QFilter[]{new QFilter("entity", "in", billEntitySet)});
        ArrayList<DynamicObject> operations = new ArrayList<DynamicObject>();
        DynamicObject bill = null;
        for (DynamicObject billEntity : billEntitys) {
            path = (String)menuForms.get(billEntity.getString("dentityid"));
            List<Operation> operates = this.getOperateList(billEntity.getString("number"));
            for (Operation operate : operates) {
                if (ignoreOpers.contains(operate.getKey())) continue;
                bill = TmcDataServiceHelper.newDynamicObject((String)"bill_operation");
                bill.set("app", billEntity.get("bizappid"));
                bill.set("entity", billEntity.get("id"));
                bill.set("bizcloud", billEntity.get("bizcloud"));
                bill.set("type", billEntity.get("modeltype"));
                bill.set("menupath", (Object)path);
                bill.set("operatename", (Object)operate.getName().getLocaleValue());
                bill.set("operate", (Object)operate.getKey());
                bill.set("islog", (Object)operate.isLogEnable());
                bill.set("isauth", (Object)EmptyUtil.isNoEmpty((String)operate.getPermissionItemId()));
                bill.set("checklogtime", (Object)new Date());
                bill.set("user", (Object)RequestContext.get().getCurrUserId());
                operations.add(bill);
                if (operations.size() != 1000) continue;
                SaveServiceHelper.save((DynamicObject[])operations.toArray(new DynamicObject[0]));
                operations.clear();
            }
        }
        if (operations.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])operations.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObjectCollection getBillEntitys(Set<String> apps) {
        Set<String> appIds = this.getAppids(apps);
        DynamicObjectCollection billEntitys = QueryServiceHelper.query((String)"bos_entityobject", (String)"id,name,number,bizappid,bizappid.bizcloud bizcloud,modeltype,dentityid", (QFilter[])new QFilter[]{new QFilter("bizappid", "in", appIds), new QFilter("istemplate", "=", (Object)"0"), new QFilter("modeltype", "in", (Object)new String[]{"BillFormModel", "BaseFormModel", "ReportFormModel"})});
        return billEntitys;
    }

    private Set<String> getAppids(Set<String> apps) {
        DynamicObjectCollection appColls = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "in", apps)});
        Set<String> appIds = appColls.parallelStream().map(o -> o.getString("id")).collect(Collectors.toSet());
        return appIds;
    }

    private List<Operation> getOperateList(String entity) {
        EntityMetadata metadata = this.getEntityMetadata(entity);
        List operations = metadata.getRootEntity().getOperations();
        return operations;
    }

    private EntityMetadata getEntityMetadata(String entity) {
        MetadataReader reader = new MetadataReader();
        String formId = reader.loadIdByNumber(entity, MetaCategory.Form);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Form);
        EntityMetadata metadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formMetadata.getEntityId(), (MetaCategory)MetaCategory.Entity);
        return metadata;
    }

    static {
        ignoreOpers.add("first");
        ignoreOpers.add("previous");
        ignoreOpers.add("next");
        ignoreOpers.add("last");
        ignoreOpers.add("returndata");
        ignoreOpers.add("mobtoolbarselect");
        ignoreOpers.add("mobtoolbarcancel");
        ignoreOpers.add("newentry");
        ignoreOpers.add("deleteentry");
        ignoreOpers.add("refresh");
        ignoreOpers.add("close");
        ignoreOpers.add("option");
    }
}

