/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit;

import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.control.Control;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitCloseDatePlugin
extends AbstractFormPlugin {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control c = (Control)evt.getSource();
        String key = c.getKey().toLowerCase();
        if ("btnok".equals(key)) {
            Date closeDate = (Date)this.getModel().getValue("closedate");
            if (EmptyUtil.isEmpty((Object)closeDate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u95ed\u65e5\u671f\u5fc5\u586b", (String)"CreditLimitCloseDatePlugin_1", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                return;
            }
            Object id = this.getView().getFormShowParameter().getCustomParams().get("selectedId");
            DynamicObject creditLimit = TmcDataServiceHelper.loadSingle(id, (String)"cfm_creditlimit");
            if (this.validate(creditLimit)) {
                creditLimit.set("closedate", (Object)closeDate);
                TmcOperateServiceHelper.execOperate((String)"closecredit", (String)"cfm_creditlimit", (DynamicObject[])new DynamicObject[]{creditLimit}, (OperateOption)OperateOption.create());
                this.getView().close();
            }
        }
    }

    protected boolean validate(DynamicObject creditLimit) {
        if (null != creditLimit) {
            Date startDate = creditLimit.getDate("startdate");
            Date closeDate = (Date)this.getModel().getValue("closedate");
            if (!closeDate.after(startDate)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5173\u95ed\u65e5\u671f\u9700\u8981\u665a\u4e8e\u751f\u6548\u65e5\u671f", (String)"CreditLimitCloseDatePlugin_2", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                return false;
            }
            boolean exist = TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", (Object)creditLimit.getLong("id")), new QFilter("createtime", ">", (Object)closeDate), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
            if (exist) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5b58\u5728\u665a\u4e8e\u5173\u95ed\u65e5\u671f\u7684\u6388\u4fe1\u989d\u5ea6\u4f7f\u7528\u5355", (String)"CreditLimitCloseDatePlugin_0", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }
}

