/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit;

import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitEdit
extends AbstractBasePlugIn
implements RowClickEventListener,
BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit creditF7 = (BasedataEdit)this.getControl("creditlimitagree");
        creditF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit creditTypeF7 = (BasedataEdit)this.getControl("credittype");
        creditTypeF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bankF7 = (BasedataEdit)this.getControl("bank");
        bankF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter sp = this.getView().getFormShowParameter();
        Object isChanging = sp.getCustomParam("ischanging");
        if (EmptyUtil.isNoEmpty((Object)isChanging)) {
            this.getModel().setValue("ischanging", (Object)"1");
        }
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"ischanging", (Object)(isChanging != null ? 1 : 0));
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String prop = event.getProperty().getName();
        ListShowParameter formShowParameter = (ListShowParameter)event.getFormShowParameter();
        switch (prop) {
            case "creditlimitagree": {
                Object org = this.getModel().getValue("org");
                if (org == null) {
                    event.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6388\u4fe1\u4e3b\u4f53\u3002", (String)"CreditLimitEdit_2", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                    break;
                }
                QFilter filter = new QFilter("entryentityorg.et_org", "=", ((DynamicObject)org).getPkValue()).and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("enddate", ">", (Object)new Date()));
                formShowParameter.getListFilterParameter().getQFilters().add(filter);
                break;
            }
            case "credittype": {
                Object creditObj = this.getModel().getValue("creditlimitagree");
                if (creditObj == null) break;
                DynamicObject creditAgree = (DynamicObject)creditObj;
                DynamicObjectCollection entryTypes = creditAgree.getDynamicObjectCollection("entryentity");
                Set creditTypes = CreditLimitHelper.getMultiPorpIds((DynamicObjectCollection)entryTypes, (String)"e_credittype");
                QFilter typeFilter = new QFilter("id", "in", (Object)creditTypes).or(new QFilter("iscomprehensive", "=", (Object)"1"));
                formShowParameter.getListFilterParameter().getQFilters().add(typeFilter);
                break;
            }
            case "bank": {
                DynamicObject bank;
                Object credit = this.getModel().getValue("creditlimitagree");
                if (credit == null || (bank = ((DynamicObject)credit).getDynamicObject("bank")) == null) break;
                DynamicObject finorgInfo = TmcDataServiceHelper.loadSingle((Object)bank.getPkValue(), (String)"bd_finorginfo", (String)"id,bank_cate");
                QFilter bankFilter = new QFilter("bank_cate", "=", finorgInfo.getDynamicObject("bank_cate").getPkValue());
                formShowParameter.getListFilterParameter().getQFilters().add(bankFilter);
            }
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isChanging = (Boolean)this.getModel().getValue("ischanging");
        this.getView().setVisible(Boolean.valueOf(isChanging), new String[]{"barchangesave"});
        if (isChanging) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"barunaudit", "barclosecredit", "barprint"});
            this.setOrgin("entry_org", "orgorgin");
            this.setOrgin("entry_type", "typeorgin");
            this.setOrgin("entry_mult", "multorgin");
        }
        boolean isMergeNew = (Boolean)this.getModel().getValue("ismergenew");
        String status = (String)this.getModel().getValue("status");
        DynamicObjectCollection srcLimits = (DynamicObjectCollection)this.getModel().getValue("sourcebillids");
        if (isMergeNew && EmptyUtil.isNoEmpty((DynamicObjectCollection)srcLimits) && BillStatusEnum.isSave((String)status)) {
            DynamicObject limit = (DynamicObject)srcLimits.get(0);
            DynamicObject creditLimit = QueryServiceHelper.queryOne((String)"cfm_creditlimit", (String)"isgrouplimit", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)limit.getDynamicObject("fbasedataid").getLong("id"))});
            this.getView().setEnable(Boolean.valueOf(EmptyUtil.isEmpty((DynamicObject)creditLimit) || !creditLimit.getBoolean("isgrouplimit")), new String[]{"isgrouplimit"});
        }
    }

    private void setOrgin(String entry, String orgin) {
        DynamicObjectCollection orgEntrys = this.getModel().getEntryEntity(entry);
        boolean isChanged = this.getModel().getDataChanged();
        for (DynamicObject detail : orgEntrys) {
            detail.set(orgin, (Object)true);
        }
        this.getModel().setDataChanged(isChanged);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        if ("delete".equals(op.getOperateKey())) {
            op.getOption().setVariableValue("ignorerefentityids", "cfm_credituse");
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult res = afterDoOperationEventArgs.getOperationResult();
        List<String> needRefreshOpList = Arrays.asList("audit", "unaudit", "submit", "unsubmit");
        if (needRefreshOpList.contains(opKey) && res.isSuccess()) {
            this.getView().updateView("detail");
            this.getModel().setDataChanged(false);
            this.getView().invokeOperation("refresh");
        } else if (StringUtils.equals((CharSequence)"save", (CharSequence)opKey) && res.isSuccess()) {
            boolean isMergeNew = (Boolean)this.getModel().getValue("ismergenew");
            if (isMergeNew) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"bar_submit"});
            }
        } else if (StringUtils.equals((CharSequence)"closecreditbtn", (CharSequence)opKey) && res.isSuccess()) {
            this.showCloseDate();
        }
    }

    private void showCloseDate() {
        Long id = (Long)this.getModel().getValue("id");
        if (id == null) {
            return;
        }
        FormShowParameter sp = new FormShowParameter();
        sp.setCustomParam("selectedId", (Object)id);
        sp.setFormId("creditm_closedate");
        sp.getOpenStyle().setShowType(ShowType.Modal);
        sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closedate"));
        this.getView().showForm(sp);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("closedate".equals(actionId)) {
            this.getView().invokeOperation("refresh");
        }
    }
}

