/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.ListRowClickEvent;
import kd.bos.list.events.ListRowClickListener;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.tmc.creditm.common.action.FormActionExecutor;
import kd.tmc.creditm.common.action.FormActionResult;
import kd.tmc.creditm.common.action.IFormAction;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.common.helper.RateHelper;
import kd.tmc.creditm.formplugin.creditlimit.action.f7.ConfirmCreditAction;
import kd.tmc.creditm.formplugin.creditlimit.action.f7.CreditChooseAction;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitF7List
extends AbstractListPlugin {
    public static final String KEY_IS_FULL_USE = "KEY_IS_FULL_USE";
    public static final String KEY_REAL_BIZ_AMT = "KEY_REAL_BIZ_AMT";
    private CreditLimitUseBean useBean;
    private FormActionExecutor executor;

    public void initialize() {
        super.initialize();
        if (this.isLookUp()) {
            this.executor = new FormActionExecutor((AbstractFormPlugin)this, this.getModel());
            ListShowParameter sp = (ListShowParameter)this.getView().getFormShowParameter();
            Object param = sp.getCustomParam("KEY_F7PARAM");
            if (param != null) {
                this.useBean = (CreditLimitUseBean)SerializationUtils.fromJsonString((String)param.toString(), CreditLimitUseBean.class);
                sp.setMultiSelect(false);
            }
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        String parentFormId = e.getFormShowParameter().getParentFormId();
        Map customParams = e.getFormShowParameter().getCustomParams();
        if ("bos_list".equals(parentFormId) || customParams.containsKey("selectF7")) {
            e.getFormShowParameter().setFormId("bos_listf7");
        }
    }

    public void setFilter(SetFilterEvent e) {
        String parentFormId = this.getView().getFormShowParameter().getParentFormId();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if ("bos_list".equals(parentFormId) || customParams.containsKey("selectF7")) {
            return;
        }
        if (this.useBean == null) {
            this.getView().getParentView().showTipNotification(ResManager.loadKDString((String)"\u4f20\u9012\u53c2\u6570\u4e0d\u6ee1\u8db3\u8981\u6c42\uff0c\u6253\u5f00\u9875\u9762\u5931\u8d25\u3002", (String)"CreditLimitF7List_7", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            this.getView().close();
            return;
        }
        Long finOrgId = this.useBean.getFinOrgId();
        if (EmptyUtil.isEmpty((Long)finOrgId)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u673a\u6784\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreditLimitF7List_5", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            e.getQFilters().add(QFilter.of((String)"1 = 2", (Object[])new Object[0]));
            return;
        }
        QFilter filter = CreditLimitHelper.getCreditLimitFilter((CreditLimitUseBean)this.useBean);
        e.getQFilters().removeIf(o -> "org".equals(o.getProperty()));
        e.getQFilters().add(filter);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.getParam() == null) {
            return;
        }
        if (EmptyUtil.isNoEmpty((String)this.getPageCache().get("switch"))) {
            return;
        }
        FieldEdit etUseAmt = (FieldEdit)this.getView().getControl("et_useamt");
        String title = ResManager.loadKDString((String)"\u5360\u7528\u989d\u5ea6", (String)"CreditLimitF7List_3", (String)"tmc-creditm-formplugin", (Object[])new Object[0]);
        if (this.useBean.getPreOccupy() != null && this.useBean.getPreOccupy().booleanValue()) {
            title = ResManager.loadKDString((String)"\u9884\u5360\u989d\u5ea6", (String)"CreditLimitF7List_4", (String)"tmc-creditm-formplugin", (Object[])new Object[0]);
        }
        etUseAmt.setCaption(new LocaleString(title));
        if ("cfm_use_credit".equals(this.useBean.getEntityName())) {
            FieldEdit creditratio = (FieldEdit)this.getView().getControl("creditratio");
            creditratio.setCaption(new LocaleString(ResManager.loadKDString((String)"\u6388\u4fe1\u5360\u6bd4(%)", (String)"CreditLimitF7List_2", (String)"tmc-creditm-formplugin", (Object[])new Object[0])));
        }
        BigDecimal creditRatio = this.useBean.getCreditRatio();
        BigDecimal bizCreditAmount = this.useBean.getMaxAmt();
        if (EmptyUtil.isEmpty((BigDecimal)creditRatio)) {
            creditRatio = EmptyUtil.isEmpty((BigDecimal)this.useBean.getMaxAmt()) ? Constants.ONE_HUNDRED : this.useBean.getBizAmt().multiply(Constants.ONE_HUNDRED).divide(this.useBean.getMaxAmt(), 6, RoundingMode.DOWN);
            bizCreditAmount = this.useBean.getMaxAmt().multiply(creditRatio.divide(Constants.ONE_HUNDRED));
        } else {
            bizCreditAmount = bizCreditAmount.multiply(creditRatio).divide(Constants.ONE_HUNDRED);
        }
        this.getModel().setValue("curencybiz", (Object)this.useBean.getCurrencyId());
        this.getModel().setValue("creditratio", (Object)creditRatio);
        this.getModel().setValue("amount", (Object)bizCreditAmount);
        Long prevCreditLimitId = this.useBean.getCreditLimitId();
        if (prevCreditLimitId != null) {
            DynamicObject prevCreditLimit = TmcDataServiceHelper.loadSingle((Object)prevCreditLimitId, (String)"cfm_creditlimit");
            List prevUseRecList = CreditLimitHelper.getPrevCreditUseRec((String)this.useBean.getEntityName(), (Object)this.useBean.getPkId(), (Object)prevCreditLimitId);
            if (!CollectionUtils.isEmpty((Collection)prevUseRecList)) {
                this.getPageCache().put("isPre", "true");
                this.getModel().deleteEntryData("entryentity");
                BigDecimal amt = BigDecimal.ZERO;
                BigDecimal bizAmt = BigDecimal.ZERO;
                BigDecimal avaAmt = CreditLimitHelper.getCreditLimitAvarAmt((DynamicObject)prevCreditLimit, (Long)this.useBean.getCreditTypeId(), (Long)this.useBean.getOrgId(), null);
                for (int i = 0; i < prevUseRecList.size(); ++i) {
                    DynamicObject useRec = (DynamicObject)prevUseRecList.get(i);
                    this.getModel().insertEntryRow("entryentity", i);
                    DynamicObject creditType = useRec.getDynamicObject("credittype");
                    this.getModel().setValue("et_credittype", creditType != null ? creditType.getPkValue() : Long.valueOf(0L), i);
                    this.getModel().setValue("et_ctrltype", useRec.get("ctrltype"), i);
                    BigDecimal preAmount = useRec.getBigDecimal("preamount");
                    BigDecimal amount = useRec.getBigDecimal("amount");
                    this.getModel().setValue("et_useamt", (Object)preAmount.add(amount), i);
                    String billStatus = useRec.getString("billstatus");
                    this.getModel().setValue("et_avaamt", (Object)(this.useBean.getPreOccupy() != false && BillStatusEnum.AUDIT.getValue().equals(billStatus) ? avaAmt.add(preAmount) : avaAmt), i);
                    amt = amt.add(preAmount.add(amount));
                    bizAmt = bizAmt.add(useRec.getBigDecimal("bizcreditamount"));
                }
                BigDecimal ratio = ((DynamicObject)prevUseRecList.get(0)).getBigDecimal("creditratio");
                this.useBean.setCreditRatio(ratio);
                this.getModel().setValue("prev_creditratio", (Object)ratio);
                this.getModel().setValue("prev_curencybiz", (Object)this.useBean.getCurrencyId());
                this.getModel().setValue("prev_targetcurrency", prevCreditLimit.get("currency"));
                this.getModel().setValue("targetcurrency", prevCreditLimit.get("currency"));
                this.getModel().setValue("prev_amount", (Object)bizAmt);
                this.getModel().setValue("prev_exchangerate", ((DynamicObject)prevUseRecList.get(0)).get("creditrate"));
                this.getModel().setValue("prev_examt", (Object)amt);
                this.getModel().setValue("prev_creditlimit", (Object)prevCreditLimitId);
            }
        }
    }

    public void afterBindData(EventObject e) {
        Map customParams;
        super.afterBindData(e);
        if (this.isLookUp()) {
            Boolean isPreList = Boolean.FALSE;
            if (EmptyUtil.isNoEmpty((String)this.getPageCache().get("isPre"))) {
                isPreList = Boolean.TRUE;
            }
            if (EmptyUtil.isEmpty((String)this.getPageCache().get("switch"))) {
                this.switchShowingStatus(isPreList);
            }
            this.getPageCache().put("switch", "true");
        }
        if ((customParams = this.getView().getFormShowParameter().getCustomParams()).containsKey("islock")) {
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"creditratio", "amount"});
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        if (this.isLookUp()) {
            args.setCancel(true);
        }
    }

    private Object getParam() {
        ListShowParameter sp = (ListShowParameter)this.getView().getFormShowParameter();
        Object param = sp.getCustomParam("KEY_F7PARAM");
        return param;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        if (this.isLookUp() && this.getParam() != null) {
            Button okBtn = (Button)this.getControl("btnok");
            okBtn.addClickListener(new ClickListener(){

                public void click(EventObject evt) {
                    CreditLimitF7List.this.executor.execute(new IFormAction[]{new ConfirmCreditAction(CreditLimitF7List.this.useBean)});
                }
            });
            Button modifyBtn = (Button)this.getControl("btmodify");
            modifyBtn.addClickListener(new ClickListener(){

                public void click(EventObject evt) {
                    CreditLimitF7List.this.getModel().deleteEntryData("entryentity");
                    CreditLimitF7List.this.switchShowingStatus(false);
                }
            });
            BillList billList = (BillList)this.getControl("billlistap");
            billList.addListRowClickListener(new ListRowClickListener(){

                public void listRowClick(ListRowClickEvent evt) {
                    CreditLimitF7List.this.rowClick(evt);
                }
            });
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "creditratio": {
                BigDecimal creditRatio;
                Object newVal = e.getChangeSet()[0].getNewValue();
                BigDecimal bigDecimal = creditRatio = newVal == null ? BigDecimal.ZERO : (BigDecimal)newVal;
                if (Constants.ONE_HUNDRED.compareTo(creditRatio) < 0) {
                    this.getModel().setValue("creditratio", (Object)Constants.ONE_HUNDRED);
                    return;
                }
                BigDecimal amount = this.useBean.getMaxAmt().multiply(creditRatio).divide(Constants.ONE_HUNDRED, RoundingMode.DOWN);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"amount", (Object)amount);
                this.chooseCreditLimit();
                break;
            }
            case "exchangerate": {
                this.getModel().setValue("ismanualrate", (Object)true);
                this.chooseCreditLimit();
                break;
            }
            case "amount": {
                BigDecimal oldValue = (BigDecimal)e.getChangeSet()[0].getOldValue();
                BigDecimal newValue = (BigDecimal)e.getChangeSet()[0].getNewValue();
                if (newValue.compareTo(this.useBean.getMaxAmt()) > 0) {
                    this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e%s\u3002", (String)"CreditLimitF7List_1", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), this.useBean.getMaxAmt().setScale(RateHelper.getCurrency((Long)this.useBean.getCurrencyId()).getInt("amtprecision"), RoundingMode.HALF_UP)));
                    ParamMap paramMap = new ParamMap().put("amount", (Object)oldValue);
                    paramMap.put("creditratio", (Object)oldValue.multiply(Constants.ONE_HUNDRED).divide(this.useBean.getMaxAmt(), RoundingMode.DOWN));
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (Map)paramMap.getParams());
                    return;
                }
                BigDecimal ratio = newValue.multiply(Constants.ONE_HUNDRED).divide(this.useBean.getMaxAmt(), 8, 1);
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"creditratio", (Object)ratio);
                this.getPageCache().put(KEY_REAL_BIZ_AMT, newValue.toString());
                this.chooseCreditLimit();
            }
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        if (!this.isLookUp()) {
            return;
        }
        args.setListDataProvider((IListDataProvider)new ListDataProvider(){

            public DynamicObjectCollection getData(int arg0, int arg1) {
                DynamicObjectCollection dataList = super.getData(arg0, arg1);
                if (dataList.isEmpty()) {
                    return dataList;
                }
                if (!((DynamicObject)dataList.get(0)).getDataEntityType().getProperties().containsKey((Object)"curravaamt")) {
                    return dataList;
                }
                CreditLimitHelper.fillCanUseCreditLimitAmt((CreditLimitUseBean)CreditLimitF7List.this.useBean, (List)dataList);
                return dataList;
            }
        });
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        this.executor.confirmCallBack((IFormAction)new CreditChooseAction(this.useBean, this.getBizAmt()), messageBoxClosedEvent);
    }

    private boolean chooseCreditLimit() {
        List resList = this.executor.execute(new IFormAction[]{new CreditChooseAction(this.useBean, this.getRealAmt())});
        FormActionResult res = (FormActionResult)resList.get(0);
        return res.isSuccess();
    }

    private boolean isLookUp() {
        ListShowParameter sp = (ListShowParameter)this.getView().getFormShowParameter();
        boolean isLookUp = sp.isLookUp();
        return isLookUp;
    }

    private BigDecimal getBizAmt() {
        String realBizAmt = this.getPageCache().get(KEY_REAL_BIZ_AMT);
        BigDecimal bizAmt = realBizAmt != null ? new BigDecimal(realBizAmt) : this.useBean.getBizAmt();
        return bizAmt;
    }

    private BigDecimal getRealAmt() {
        return (BigDecimal)this.getModel().getValue("amount");
    }

    private void switchShowingStatus(boolean isShowPrevRec) {
        if (this.getParam() == null) {
            return;
        }
        if (!isShowPrevRec) {
            this.getModel().deleteEntryData("entryentity");
        }
        this.getView().setVisible(Boolean.valueOf(!isShowPrevRec), new String[]{"listap", "inputap", "btnok"});
        this.getView().setVisible(Boolean.valueOf(isShowPrevRec), new String[]{"previnfoap", "btmodify"});
    }

    private void rowClick(ListRowClickEvent evt) {
        String isAutoSelect = this.getPageCache().get(KEY_IS_FULL_USE);
        if (isAutoSelect != null) {
            this.chooseCreditLimit();
            this.getPageCache().remove(KEY_IS_FULL_USE);
        } else {
            boolean isManualPrev = (Boolean)this.getModel().getValue("ismanualrate");
            this.getModel().setValue("ismanualrate", (Object)false);
            boolean needRollback = this.chooseCreditLimit();
            if (needRollback) {
                this.getModel().setValue("ismanualrate", (Object)isManualPrev);
            } else {
                this.getModel().setValue("ismanualrate", (Object)false);
            }
            evt.setCancel(needRollback);
        }
    }
}

