/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.fbp.common.enums.BasisEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TermHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.common.feedetail.AbstractBizBillFeeTabEdit;
import org.apache.commons.lang3.tuple.Pair;

public class CreditLimitFeeDetailEdit
extends AbstractBizBillFeeTabEdit {
    private static final String FEEORG = "feeorg";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit feeOrg = (BasedataEdit)this.getView().getControl(FEEORG);
        feeOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public Pair<String, String> getBizBillFeeAmtFieldProp() {
        return Pair.of((Object)"totalamt", (Object)ResManager.loadKDString((String)"\u603b\u6388\u4fe1\u989d\u5ea6", (String)"CreditLimitFeeDetailEdit_02", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
    }

    public Pair<String, String> getBizBillCurrencyFieldProp() {
        return Pair.of((Object)"currency", (Object)ResManager.loadKDString((String)"\u5e01\u79cd", (String)"CreditLimitFeeDetailEdit_01", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
    }

    public void addField(TableValueSetter vs) {
        super.addField(vs);
        vs.addField(FEEORG, new Object[0]);
    }

    public void addRow(TableValueSetter vs, DynamicObject feeBill) {
        super.addRow(vs, feeBill);
        vs.set(FEEORG, feeBill.get("org"), vs.getCount() - 1);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        super.beforeF7Select(evt);
        String propName = evt.getProperty().getName();
        if (FEEORG.equals(propName)) {
            ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "=", org.getPkValue()));
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String propertyName = e.getProperty().getName();
        int rowIndex = e.getChangeSet()[0].getRowIndex();
        Object newValue = e.getChangeSet()[0].getNewValue();
        if ("feenumber".equals(propertyName) && EmptyUtil.isNoEmpty((Object)newValue)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)FEEORG, null, (int)rowIndex);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        DynamicObject org;
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String opKey = op.getOperateKey();
        if ("newentryfee".equals(opKey) && EmptyUtil.isEmpty((DynamicObject)(org = (DynamicObject)this.getModel().getValue("org")))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u57fa\u672c\u4fe1\u606f\u4e2d\u7684\u6388\u4fe1\u4e3b\u4f53\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreditLimitFeeDetailEdit_03", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void setFeeValueAfterSelectFeeNumber(DynamicObject feeBill, int indexRow) {
        this.getModel().setValue(FEEORG, (Object)feeBill.getDynamicObject("org"), indexRow);
    }

    public QFilter getFeeNumberQFilter() {
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String number = (String)this.getModel().getValue("number");
        QFilter qFilter = new QFilter("org", "in", (Object)new Object[]{org.getPkValue()});
        qFilter.and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue());
        qFilter.and("enpayamt", "!=", (Object)BigDecimal.ZERO);
        qFilter.and(new QFilter("entry.srcbillno", "!=", (Object)number).or("entry", "is null", null));
        return qFilter;
    }

    private String getStartDateFieldProp() {
        return "startdate";
    }

    private String getEndDateFieldProp() {
        return "enddate";
    }

    public BigDecimal getTerm(boolean isShowErrorTip) {
        return BigDecimal.valueOf(DateUtils.getDiffDays((Date)((Date)this.getModel().getValue(this.getStartDateFieldProp())), (Date)((Date)this.getModel().getValue(this.getEndDateFieldProp()))) - 1);
    }

    public BigDecimal getYrBasis(boolean isShowErrorTip) {
        return BigDecimal.valueOf(TermHelper.getBasis_YearDay((Date)((Date)this.getModel().getValue(this.getStartDateFieldProp())), (Date)((Date)this.getModel().getValue(this.getEndDateFieldProp())), (BasisEnum)BasisEnum.getEnum((String)BasisEnum.Actual_365.getValue())));
    }
}

