/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.function.Consumer;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.field.events.BeforeF7ViewDetailEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.creditm.common.enums.GuaranteeWayEnum;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitGuauseEdit
extends AbstractBasePlugIn
implements BeforeF7SelectListener,
Consumer<BeforeF7ViewDetailEvent> {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit gContract = (BasedataEdit)this.getView().getControl("gcontract");
        gContract.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        gContract.addBeforeF7ViewDetailListener((Consumer)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)true, (String[])new String[]{"gcontract", "gamount", "gratio", "gexchrate"});
    }

    @Override
    public void accept(BeforeF7ViewDetailEvent evt) {
        String key = ((BasedataEdit)evt.getSource()).getKey();
        if ("gcontract".equals(key)) {
            evt.setCancel(true);
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId("gm_guaranteecontract");
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setPkId(evt.getPkId());
            parameter.setStatus(OperationStatus.VIEW);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        if ("gcontract".equals(key)) {
            String guarType = (String)this.getModel().getValue("guartype");
            if (EmptyUtil.isNoEmpty((String)guarType) && !this.checkGuaWay()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u4e3a\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u4e0d\u652f\u6301\u5173\u8054\u62c5\u4fdd\u5408\u540c\u3002", (String)"CreditLimitGuauseEdit_0", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                this.initGuaFilter(evt);
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        switch (operate.getOperateKey()) {
            case "guanewentry": {
                if (this.checkGuaWay()) break;
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u62c5\u4fdd\u65b9\u5f0f\u4e0d\u4e3a\u4fdd\u8bc1\u3001\u62b5\u62bc\u3001\u8d28\u62bc\u65f6\uff0c\u4e0d\u652f\u6301\u5173\u8054\u62c5\u4fdd\u5408\u540c\u3002", (String)"CreditLimitGuauseEdit_0", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                args.setCancel(true);
                break;
            }
        }
    }

    private boolean checkGuaWay() {
        String guaType = (String)this.getModel().getValue("guartype");
        if (EmptyUtil.isEmpty((String)guaType)) {
            return false;
        }
        List<String> guarTypes = Arrays.asList(guaType.split(","));
        return guarTypes.contains(GuaranteeWayEnum.ENSURE.getValue()) || guarTypes.contains(GuaranteeWayEnum.MORTGAGE.getValue()) || guarTypes.contains(GuaranteeWayEnum.PLEDGE.getValue());
    }

    private void initGuaFilter(BeforeF7SelectEvent evt) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(2);
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        filters.add(new QFilter("entry_guaranteedorg.b_guaranteedorg", "in", org.getPkValue()));
        showParameter.getListFilterParameter().getQFilters().addAll(filters);
    }
}

