/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListColumnsArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.IListColumn;
import kd.bos.list.ListShowParameter;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.formplugin.resources.CreditmFormResourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcDataBaseList;

public class CreditLimitList
extends AbstractTmcDataBaseList {
    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"bank.")) {
            args.getQFilters().addAll(Arrays.asList(this.getFinOrgFilter()));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            CommonFilterColumn commonFilter = (CommonFilterColumn)filterColumn;
            String fieldName = commonFilter.getFieldName();
            if (!"org.name".equals(fieldName)) continue;
            commonFilter.setDefaultValue("");
            break;
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        if (StringUtils.startsWith((CharSequence)fieldName, (CharSequence)"bank.")) {
            args.getQfilters().addAll(Arrays.asList(this.getFinOrgFilter()));
        }
    }

    public void beforeCreateListColumns(BeforeCreateListColumnsArgs args) {
        Object param;
        ListShowParameter sp = (ListShowParameter)this.getView().getFormShowParameter();
        List columns = args.getListColumns();
        HashSet<String> remFiels = new HashSet<String>(5);
        if (sp.isLookUp()) {
            remFiels.add("totalamt");
            remFiels.add("useamt");
            remFiels.add("preuseamt");
            remFiels.add("avaramt");
        }
        if ((param = sp.getCustomParam("KEY_F7PARAM")) == null) {
            remFiels.add("curravaamt");
        }
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            IListColumn column = (IListColumn)iterator.next();
            String fieldName = column.getListFieldKey();
            if (!remFiels.remove(fieldName)) continue;
            iterator.remove();
            if (remFiels.size() != 0) continue;
            break;
        }
        args.setListColumns(columns);
    }

    public void setFilter(SetFilterEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (!customParams.containsKey("isframework")) {
            return;
        }
        List qFilters = e.getQFilters();
        QFilter frameFilter = qFilters.stream().filter(o -> "isframework".equals(o.getProperty())).findFirst().orElse(null);
        e.getQFilters().remove(frameFilter);
    }

    protected boolean disableDoubleClick() {
        ListShowParameter sp = (ListShowParameter)this.getView().getFormShowParameter();
        Object param = sp.getCustomParam("KEY_F7PARAM");
        if (EmptyUtil.isNoEmpty((Object)param)) {
            return true;
        }
        return super.disableDoubleClick();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        switch (op.getOperateKey()) {
            case "save": 
            case "submit": {
                op.getOption().setVariableValue("check", "1");
                break;
            }
            case "delete": {
                op.getOption().setVariableValue("ignorerefentityids", "cfm_credituse");
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (result == null || !result.isSuccess()) {
            return;
        }
        switch (opKey) {
            case "checkuse": {
                this.checkUse(false);
                break;
            }
            case "unclosecredit": {
                BillList billList = (BillList)this.getControl("billlistap");
                billList.refresh();
                break;
            }
            case "merge": {
                Long selectedId = this.getSelectedId();
                if (selectedId == null) {
                    return;
                }
                this.getView().invokeOperation("push");
                break;
            }
            case "change": {
                this.creditLimitChange();
                break;
            }
            case "releasecreditamt": {
                this.checkUse(true);
                break;
            }
            case "viewgua": {
                this.showViewGua();
                break;
            }
            case "closecreditbtn": {
                this.showCloseDate();
                break;
            }
        }
    }

    private void showViewGua() {
        List selectedIdList = this.getSelectedIdList();
        QFilter idFilter = new QFilter("gsrcbillid", "in", (Object)selectedIdList);
        DynamicObjectCollection gcontracts = QueryServiceHelper.query((String)"gm_guaranteeuse", (String)"gcontract", (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)gcontracts)) {
            Set gcontractIds = gcontracts.parallelStream().map(o -> o.getLong("gcontract")).collect(Collectors.toSet());
            if (gcontractIds.size() == 1) {
                BillShowParameter parameter = new BillShowParameter();
                parameter.setFormId("gm_guaranteecontract");
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                parameter.setPkId(gcontractIds.iterator().next());
                parameter.setStatus(OperationStatus.VIEW);
                this.getView().showForm((FormShowParameter)parameter);
            } else if (gcontractIds.size() > 1) {
                ListShowParameter listParam = new ListShowParameter();
                listParam.setBillFormId("gm_guaranteecontract");
                listParam.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                for (Long gcontractId : gcontractIds) {
                    listParam.addLinkQueryPkId((Object)gcontractId);
                }
                this.getView().showForm((FormShowParameter)listParam);
            }
        } else {
            this.getView().showTipNotification(CreditmFormResourceEnum.CreditLimitList_1.loadKDString());
        }
    }

    private void creditLimitChange() {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        DynamicObject limit = TmcDataServiceHelper.loadSingle((String)"cfm_creditlimit", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)selectedId)});
        boolean hasPermission = TmcOrgDataHelper.hasPermission((String)appId, (long)RequestContext.get().getCurrUserId(), (long)limit.getDynamicObject("org").getLong("id"), (String)"creditm_apply", (String)"47156aff000000ac");
        if (!hasPermission) {
            this.getView().showErrorNotification(CreditmFormResourceEnum.CreditLimitList_2.loadKDString(limit.getDynamicObject("org").getString("name")));
            return;
        }
        BillShowParameter sp = new BillShowParameter();
        sp.setFormId("creditm_apply");
        sp.setBillStatus(BillOperationStatus.EDIT);
        sp.setStatus(OperationStatus.ADDNEW);
        sp.setCustomParam("limitid", (Object)selectedId);
        sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)sp);
    }

    private void checkUse(boolean isRelease) {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            return;
        }
        DynamicObject creditLimit = TmcDataServiceHelper.loadSingle((Object)selectedId, (String)"cfm_creditlimit", (String)"isclose");
        boolean isClose = creditLimit.getBoolean("isclose");
        if (isRelease && isClose) {
            this.getView().showTipNotification(CreditmFormResourceEnum.CreditLimitList_0.loadKDString());
            return;
        }
        FormShowParameter sp = new FormShowParameter();
        sp.setFormId("cfm_creditusedetail");
        sp.setCustomParam("id", (Object)selectedId);
        sp.setCustomParam("isrelease", (Object)String.valueOf(isRelease));
        sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(sp);
    }

    private QFilter[] getFinOrgFilter() {
        DataSet dataSet = ORM.create().queryDataSet("cfm_creditlimit", "cfm_creditlimit", "bank.id", new QFilter[0], "bank.id", -1, (Distinctable)WithDistinctable.get());
        ArrayList<Object> idList = new ArrayList<Object>();
        for (Row row : dataSet) {
            idList.add(row.get(0));
        }
        return new QFilter[]{new QFilter("id", "in", idList)};
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        e.getParameter().setCustomParam("ismergerows", (Object)Boolean.TRUE);
    }

    private void showCloseDate() {
        Long selectedId = this.getSelectedId();
        if (selectedId == null) {
            return;
        }
        FormShowParameter sp = new FormShowParameter();
        sp.setCustomParam("selectedId", (Object)selectedId);
        sp.setFormId("creditm_closedate");
        sp.getOpenStyle().setShowType(ShowType.Modal);
        sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "closedate"));
        this.getView().showForm(sp);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String actionId = evt.getActionId();
        if ("closedate".equals(actionId)) {
            BillList billList = (BillList)this.getControl("billlistap");
            billList.refresh();
        }
    }
}

