/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Set;
import kd.bos.base.AbstractBasePlugIn;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterDeleteRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.container.Tab;
import kd.bos.form.control.events.TabSelectEvent;
import kd.bos.form.control.events.TabSelectListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CreditLimitMergeEdit
extends AbstractBasePlugIn
implements TabSelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        Tab tab = (Tab)this.getView().getControl("tabap");
        tab.addTabSelectListener((TabSelectListener)this);
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        this.controlRowEnableByMerge();
    }

    public void tabSelected(TabSelectEvent event) {
        if (this.getView().getFormShowParameter().getCustomParams().containsKey("openHistoryId")) {
            return;
        }
        String subTabKey = event.getTabKey();
        this.getView().setVisible(Boolean.TRUE, new String[]{"insertrow"});
        if ("tabentry_mult".equals(subTabKey)) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"insertrow"});
        }
    }

    public void afterDeleteRow(AfterDeleteRowEventArgs e) {
        String entry = e.getEntryProp().getName();
        if ("entry_type".equals(entry)) {
            boolean isMerge = (Boolean)this.getModel().getValue("ismergenew");
            boolean isChange = (Boolean)this.getModel().getValue("ischanging");
            if (!isMerge && !isChange) {
                return;
            }
            int[] rowIndexs = e.getRowIndexs();
            HashSet<Long> pids = new HashSet<Long>();
            for (int rowIndex : rowIndexs) {
                int parentIdx = this.getSelectMainRowIndex("entry_type", rowIndex);
                DynamicObject rowEntity = this.getModel().getEntryRowEntity("entry_type", parentIdx);
                if (rowEntity == null || !EmptyUtil.isEmpty((Long)rowEntity.getLong("pid"))) continue;
                pids.add(rowEntity.getLong("id"));
            }
            CreditLimitHelper.setCreditTypeParentAmt((IDataModel)this.getModel(), (IFormView)this.getView(), pids);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("changesave".equals(operateKey) || "save".equals(operateKey)) {
            Boolean change = (Boolean)this.getModel().getValue("ischanging");
            Boolean merge = (Boolean)this.getModel().getValue("ismergenew");
            if (change.booleanValue() || merge.booleanValue()) {
                this.getView().updateView("entry_type");
                this.getView().updateView("avaramt");
                this.getView().updateView("useamt");
                this.getView().updateView("preuseamt");
            }
        }
    }

    protected int getSelectMainRowIndex(String entry, int index) {
        DynamicObject entryRowEntity;
        while (!((entryRowEntity = this.getModel().getEntryRowEntity(entry, index)) != null && EmptyUtil.isEmpty((Long)entryRowEntity.getLong("pid")) || index-- < 0)) {
        }
        return index;
    }

    private void controlRowEnableByMerge() {
        boolean isChange = (Boolean)this.getModel().getValue("ischanging");
        if (!isChange) {
            return;
        }
        int orgRowCount = this.getModel().getEntryRowCount("entry_org");
        Object shareType = this.getModel().getValue("orgsharetype");
        for (int i = 0; i < orgRowCount; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entry_org", i);
            if (EmptyUtil.isEmpty((Long)entryRowEntity.getLong("pid")) && OrgShareTypeEnum.APPOINTSHARE.getValue().equals(shareType) || this.getUseAmt("o_useamt", "o_preamt", i).compareTo(BigDecimal.ZERO) <= 0) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"o_orgtext"});
        }
        int typeRowCount = this.getModel().getEntryRowCount("entry_type");
        for (int i = 0; i < typeRowCount; ++i) {
            DynamicObject entryRowEntity = this.getModel().getEntryRowEntity("entry_type", i);
            if (EmptyUtil.isEmpty((Long)entryRowEntity.getLong("pid")) || this.getUseAmt("t_useamt", "t_preamt", i).compareTo(BigDecimal.ZERO) <= 0) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"t_credittypetext"});
        }
        int multRowCount = this.getModel().getEntryRowCount("entry_mult");
        for (int i = 0; i < multRowCount; ++i) {
            if (this.getUseAmt("m_useamt", "m_preamt", i).compareTo(BigDecimal.ZERO) <= 0) continue;
            this.getView().setEnable(Boolean.valueOf(false), i, new String[]{"m_org", "m_credittype"});
        }
    }

    private BigDecimal getUseAmt(String useAmtField, String preAmtField, int rowIndex) {
        BigDecimal useAmt = (BigDecimal)this.getModel().getValue(useAmtField, rowIndex);
        BigDecimal preAmt = (BigDecimal)this.getModel().getValue(preAmtField, rowIndex);
        return useAmt.add(preAmt);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String prop;
        switch (prop = e.getProperty().getName()) {
            case "o_totalamt": 
            case "o_singleamt": {
                this.setAvaAmt("entry_org", "o_avaramt", "o_preamt", "o_useamt", "o_singleamt", "o_totalamt");
                break;
            }
            case "t_totalamt": 
            case "t_singleamt": {
                this.setAvaAmt("entry_type", "t_avaramt", "t_preamt", "t_useamt", "t_singleamt", "t_totalamt");
                break;
            }
            case "m_totalamt": {
                this.setAvaAmt("entry_mult", "m_avaramt", "m_preamt", "m_useamt", "m_singleamt", "m_totalamt");
                break;
            }
            case "totalamt": {
                this.setAvaAmt();
                break;
            }
            case "m_org": 
            case "m_credittype": {
                this.setAmtMergeOrChange();
            }
        }
    }

    private void setAmtMergeOrChange() {
        int multIdx = this.getModel().getEntryCurrentRowIndex("entry_mult");
        boolean isChange = (Boolean)this.getModel().getValue("ischanging");
        if (!isChange) {
            return;
        }
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("m_org", multIdx);
        DynamicObjectCollection types = (DynamicObjectCollection)this.getModel().getValue("m_credittype", multIdx);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs) && EmptyUtil.isNoEmpty((DynamicObjectCollection)types)) {
            Long creditLimitId = this.getModel().getDataEntity().getLong("id");
            Pair multAmt = CreditLimitHelper.getMultAmt((Long)creditLimitId, (Set)CreditLimitHelper.getCollIds((DynamicObjectCollection)orgs), (Set)CreditLimitHelper.getCollIds((DynamicObjectCollection)types));
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"m_useamt", (Object)multAmt.getLeft(), (int)multIdx);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"m_preamt", (Object)multAmt.getRight(), (int)multIdx);
        } else {
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"m_useamt", (Object)0, (int)multIdx);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"m_preamt", (Object)0, (int)multIdx);
        }
        BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("m_totalamt", multIdx);
        BigDecimal useAmt = (BigDecimal)this.getModel().getValue("m_useamt", multIdx);
        BigDecimal preAmt = (BigDecimal)this.getModel().getValue("m_preamt", multIdx);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"m_avaramt", (Object)totalAmt.subtract(useAmt).subtract(preAmt), (int)multIdx);
    }

    private void setAvaAmt() {
        boolean isChange = (Boolean)this.getModel().getValue("ischanging");
        boolean isMergeNew = (Boolean)this.getModel().getValue("ismergenew");
        if (isChange || isMergeNew) {
            BigDecimal totalAmt = (BigDecimal)this.getModel().getValue("totalamt");
            BigDecimal useAmt = (BigDecimal)this.getModel().getValue("useamt");
            BigDecimal preAmt = (BigDecimal)this.getModel().getValue("preuseamt");
            BigDecimal avaAmt = totalAmt.subtract(useAmt).subtract(preAmt);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"avaramt", (Object)(avaAmt.compareTo(BigDecimal.ZERO) > 0 ? avaAmt : BigDecimal.ZERO));
        }
    }

    public void setAvaAmt(String entry, String avaField, String preField, String useField, String singField, String totalField) {
        boolean isChange = (Boolean)this.getModel().getValue("ischanging");
        if (!isChange) {
            return;
        }
        int indexCount = this.getModel().getEntryRowCount(entry);
        for (int i = 0; i < indexCount; ++i) {
            BigDecimal totalAmt = (BigDecimal)this.getModel().getValue(totalField, i);
            BigDecimal singleAmt = "entry_mult".equals(entry) ? BigDecimal.ZERO : (BigDecimal)this.getModel().getValue(singField, i);
            BigDecimal useAmt = (BigDecimal)this.getModel().getValue(useField, i);
            BigDecimal preAmt = (BigDecimal)this.getModel().getValue(preField, i);
            BigDecimal avaAmt = totalAmt.add(singleAmt).subtract(useAmt).subtract(preAmt);
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)avaField, (Object)(avaAmt.compareTo(BigDecimal.ZERO) > 0 ? avaAmt : BigDecimal.ZERO), (int)i);
        }
    }
}

