/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.CreditFrameworkRerunHelper;
import kd.tmc.creditm.common.helper.UseCreditHelper;
import kd.tmc.creditm.formplugin.resources.CreditmFormResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.CreditLimitServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitUsePlugin
extends AbstractFormPlugin {
    private static final String CONFIRM_TBRELEASE = "CONFIRM_TBRELEASE";
    private static final String CONFIRM_TBREMOVE = "CONFIRM_TBREMOVE";

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.initfaultVal();
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"toolbarap"});
        this.setFilter();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        switch (evt.getItemKey()) {
            case "refresh": {
                this.initfaultVal();
                this.refreshBillList();
                break;
            }
            case "tbrelease": {
                this.clickRelease(CONFIRM_TBRELEASE);
                break;
            }
            case "tbremove": {
                this.clickRelease(CONFIRM_TBREMOVE);
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        super.confirmCallBack(evt);
        String callBackId = evt.getCallBackId();
        if (MessageBoxResult.Yes.equals((Object)evt.getResult())) {
            switch (callBackId) {
                case "CONFIRM_TBRELEASE": {
                    this.releaseCreditAmount(this.getSelectId(), false);
                    break;
                }
                case "CONFIRM_TBREMOVE": {
                    this.releaseCreditAmount(this.getSelectId(), true);
                }
            }
        }
    }

    private void clickRelease(String closeBackKey) {
        Object focusRowPkId = this.getSelectId();
        if (EmptyUtil.isEmpty((Object)focusRowPkId)) {
            return;
        }
        DynamicObject creditUse = TmcDataServiceHelper.loadSingle((Object)focusRowPkId, (String)"cfm_credituse", (String)"creditlimit,sourcetype,sourcebillentryid,realamt,billstatus,sourcename,sourcebillno");
        if (!BillStatusEnum.AUDIT.getValue().equals(creditUse.getString("billstatus"))) {
            this.getView().showTipNotification(CreditmFormResourceEnum.CreditLimitUsePlugin_0.loadKDString());
            return;
        }
        if (CreditPropEnum.FIX.getValue().equals(creditUse.getDynamicObject("creditlimit").getString("creditprop"))) {
            this.getView().showTipNotification(CreditmFormResourceEnum.CreditLimitUsePlugin_6.loadKDString());
            return;
        }
        if ("cfm_use_credit".equals(creditUse.getString("sourcetype"))) {
            this.getView().showTipNotification(CreditmFormResourceEnum.CreditLimitUsePlugin_7.loadKDString());
            return;
        }
        if (CONFIRM_TBRELEASE.equals(closeBackKey) && EmptyUtil.isEmpty((BigDecimal)creditUse.getBigDecimal("realamt"))) {
            this.getView().showTipNotification(CreditmFormResourceEnum.CreditLimitUsePlugin_1.loadKDString(creditUse.getString("sourcename"), creditUse.getString("sourcebillno")));
            return;
        }
        String billNo = creditUse.getString("sourcebillno");
        this.getView().showConfirm(CONFIRM_TBRELEASE.equals(closeBackKey) ? CreditmFormResourceEnum.CreditLimitUsePlugin_2.loadKDString(billNo) : CreditmFormResourceEnum.CreditLimitUsePlugin_8.loadKDString(billNo), MessageBoxOptions.YesNo, ConfirmTypes.Default, new ConfirmCallBackListener(closeBackKey, (IFormPlugin)this));
    }

    private void releaseCreditAmount(Object creditUsePkId, boolean isRemove) {
        Throwable throwable;
        TXHandle tx;
        String errorMsg;
        ReturnCreditLimitInfo returnInfo;
        ReturnCreditLimitInfo param;
        DynamicObject creditUse;
        block27: {
            block28: {
                block29: {
                    block24: {
                        block25: {
                            block26: {
                                String res;
                                if (EmptyUtil.isEmpty((Object)creditUsePkId)) {
                                    return;
                                }
                                creditUse = TmcDataServiceHelper.loadSingle((Object)creditUsePkId, (String)"cfm_credituse", (String)"creditlimit,sourcetype,sourcebillentryid,sourcebillid,amount,realamt,billstatus,sourcename,sourcebillno");
                                param = new ReturnCreditLimitInfo();
                                param.setId(Long.valueOf(creditUse.getLong("sourcebillid")));
                                param.setEntityName(creditUse.getString("sourcetype"));
                                param.setPreEntityName(creditUse.getDynamicObjectType().getName());
                                param.setReturnBillId(Long.valueOf(creditUse.getLong("id")));
                                param.setBizBillId(Long.valueOf(creditUse.getLong("id")));
                                param.setReturnTime(new Date());
                                param.setReturnAmt(creditUse.getBigDecimal("realamt"));
                                param.setPreOccupy(creditUse.getBigDecimal("amount").compareTo(BigDecimal.ZERO) == 0);
                                if (creditUse.getLong("sourcebillid") != creditUse.getLong("sourcebillentryid")) {
                                    HashMap<Long, BigDecimal> entryReturnAmtMap = new HashMap<Long, BigDecimal>(8);
                                    entryReturnAmtMap.put(creditUse.getLong("sourcebillentryid"), creditUse.getBigDecimal("realamt"));
                                    param.setEntryReturnAmtMap(entryReturnAmtMap);
                                }
                                param.setLast(true);
                                returnInfo = null;
                                errorMsg = CreditmFormResourceEnum.CreditLimitUsePlugin_5.loadKDString();
                                tx = TX.requiresNew();
                                throwable = null;
                                if (!isRemove || !EmptyUtil.isNoEmpty((String)(res = this.updateBizCreditProp(creditUse)))) break block24;
                                this.getView().showTipNotification(res);
                                if (tx == null) break block25;
                                if (throwable == null) break block26;
                                try {
                                    tx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block25;
                            }
                            tx.close();
                        }
                        return;
                    }
                    if (BigDecimal.ZERO.compareTo(creditUse.getBigDecimal("realamt")) != 0) break block27;
                    this.getView().showSuccessNotification(CreditmFormResourceEnum.CreditLimitUsePlugin_9.loadKDString());
                    if (tx == null) break block28;
                    if (throwable == null) break block29;
                    try {
                        tx.close();
                    }
                    catch (Throwable res) {
                        throwable.addSuppressed(res);
                    }
                    break block28;
                }
                tx.close();
            }
            return;
        }
        try {
            try {
                returnInfo = CreditLimitServiceHelper.returnCreditLimit((ReturnCreditLimitInfo)param);
            }
            catch (Exception e) {
                tx.markRollback();
                errorMsg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (tx != null) {
                if (throwable != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    tx.close();
                }
            }
        }
        if (returnInfo != null) {
            if (returnInfo.isSuccess()) {
                this.setFilter();
                BillList useList = (BillList)this.getControl("billlistap");
                useList.refresh();
                this.getView().showSuccessNotification(isRemove ? CreditmFormResourceEnum.CreditLimitUsePlugin_9.loadKDString() : CreditmFormResourceEnum.CreditLimitUsePlugin_4.loadKDString());
                this.fillCreditLimitData(creditUse.getDynamicObject("creditlimit").getLong("id"));
                return;
            }
            errorMsg = returnInfo.getMessage();
        }
        this.getView().showTipNotification(errorMsg);
    }

    private String updateBizCreditProp(DynamicObject creditUse) {
        Object[] bizBillArr;
        String entityName = creditUse.getString("sourcetype");
        Long billId = creditUse.getLong("sourcebillid");
        Long entryId = creditUse.getLong("sourcebillentryid");
        DynamicObject config = UseCreditHelper.getUseConfigFromType((String)entityName);
        if (EmptyUtil.isEmpty((DynamicObject)config)) {
            return CreditmFormResourceEnum.CreditLimitUsePlugin_10.loadKDString(creditUse.getString("sourcename"));
        }
        HashSet<String> selFields = new HashSet<String>();
        selFields.add(config.getString("creditprop"));
        if ("cfm_loancontractbill".equals(entityName)) {
            selFields.add("loantype");
            selFields.add("banksyndicate_entry.e_creditlimit");
        }
        if ("cfm_loanbill".equals(entityName)) {
            selFields.add("loantype");
            selFields.add("banksyndicate_entry.e_bankcreditlimit");
        }
        if (EmptyUtil.isEmpty((Object[])(bizBillArr = TmcDataServiceHelper.load((String)entityName, (String)selFields.stream().collect(Collectors.joining(",")), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)})))) {
            return null;
        }
        Object bizBill = bizBillArr[0];
        String entryField = "";
        String limitField = config.getString("creditprop");
        if (("cfm_loancontractbill".equals(entityName) || "cfm_loanbill".equals(entityName)) && "sl".equals(bizBill.getString("loantype"))) {
            entryField = "banksyndicate_entry";
            String string = limitField = "cfm_loancontractbill".equals(entityName) ? "e_creditlimit" : "e_bankcreditlimit";
        }
        if ("cfm_loanbill_bond".equals(entityName)) {
            entryField = config.getString("creditentry");
            limitField = limitField.replace(entryField, "").replace(".", "");
        }
        if (EmptyUtil.isNoEmpty((String)entryField)) {
            DynamicObjectCollection banksyndicateEntrys = bizBill.getDynamicObjectCollection(entryField);
            for (DynamicObject banksyndicateEntry : banksyndicateEntrys) {
                if (entryId.longValue() != banksyndicateEntry.getLong("id")) continue;
                if (EmptyUtil.isEmpty((Object)banksyndicateEntry.get(limitField))) {
                    return CreditmFormResourceEnum.CreditLimitUsePlugin_11.loadKDString(creditUse.getString("sourcebillno"));
                }
                banksyndicateEntry.set(limitField, null);
                break;
            }
        } else {
            if (EmptyUtil.isEmpty((Object)bizBill.get(limitField))) {
                return CreditmFormResourceEnum.CreditLimitUsePlugin_11.loadKDString(creditUse.getString("sourcebillno"));
            }
            bizBill.set(limitField, null);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bizBill});
        return null;
    }

    private void initfaultVal() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object creditLimitId = customParams.get("id");
        this.getView().setVisible(Boolean.valueOf(String.valueOf(customParams.get("isrelease"))), new String[]{"tbrelease"});
        this.fillCreditLimitData(creditLimitId);
        this.setFilter();
    }

    private void setFilter() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object creditLimitId = customParams.get("id");
        Object isFrameWork = customParams.get("isframework");
        HashSet<Long> creditLimitIds = new HashSet<Long>();
        creditLimitIds.add(Long.parseLong(String.valueOf(creditLimitId)));
        if (EmptyUtil.isNoEmpty(isFrameWork)) {
            Long frameWorkId = Long.valueOf(String.valueOf(creditLimitId));
            DynamicObjectCollection frameWorks = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"id,number,banktype,bank,currency,totalamt,sourcebillids.fbasedataid sourcebillids", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)frameWorkId)});
            Set srcBillIds = frameWorks.stream().map(o -> o.getLong("sourcebillids")).collect(Collectors.toSet());
            Set allLimitIds = CreditFrameworkRerunHelper.getMergeSrcbillIds(Collections.singletonList(frameWorkId).stream().collect(Collectors.toSet()), srcBillIds);
            creditLimitIds.addAll(CreditFrameworkHelper.getFrameWorkUse((Set)allLimitIds, new HashSet(), (boolean)true));
        }
        BillList useList = (BillList)this.getControl("billlistap");
        useList.setFilter(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("creditlimit", "in", creditLimitIds)));
    }

    private void fillCreditLimitData(Object creditLimitId) {
        DynamicObject creditLimit = TmcDataServiceHelper.loadSingle((Object)creditLimitId, (String)"cfm_creditlimit");
        boolean isFrameWork = creditLimit.getBoolean("isframework");
        this.getView().setVisible(Boolean.valueOf(!isFrameWork), new String[]{"useamt", "preamt", "avaramt"});
        this.getModel().setValue("billno", (Object)creditLimit.getString("number"));
        this.getModel().setValue("banktype", (Object)creditLimit.getString("banktype"));
        this.getModel().setValue("bank", creditLimit.getDynamicObject("bank").getPkValue());
        this.getModel().setValue("currency", creditLimit.getDynamicObject("currency").getPkValue());
        this.getModel().setValue("totalamt", (Object)creditLimit.getString("totalamt"));
        if (isFrameWork) {
            return;
        }
        this.getModel().setValue("useamt", (Object)creditLimit.getBigDecimal("useamt"));
        this.getModel().setValue("preamt", (Object)creditLimit.getBigDecimal("preuseamt"));
        this.getModel().setValue("avaramt", (Object)creditLimit.getString("avaramt"));
        DynamicObject forexQuote = creditLimit.getDynamicObject("forexquote");
        this.getModel().setValue("forexquote", forexQuote == null ? null : forexQuote.getPkValue());
    }

    private Object getSelectId() {
        BillList billSel = (BillList)this.getControl("billlistap");
        Object focusRowPkId = billSel.getFocusRowPkId();
        if (EmptyUtil.isEmpty((Object)focusRowPkId)) {
            this.getView().showTipNotification(CreditmFormResourceEnum.CreditLimitUsePlugin_3.loadKDString());
            return null;
        }
        return focusRowPkId;
    }

    private void refreshBillList() {
        BillList useList = (BillList)this.getControl("billlistap");
        useList.refreshData();
    }
}

