/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit.action.f7;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.list.BillList;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.tmc.creditm.business.service.creditlimit.CreditLimitService;
import kd.tmc.creditm.common.action.FormActionResult;
import kd.tmc.creditm.common.helper.RateHelper;
import kd.tmc.creditm.formplugin.creditlimit.action.f7.CreditF7Action;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class ConfirmCreditAction
extends CreditF7Action {
    private static final Log logger = LogFactory.getLog(ConfirmCreditAction.class);
    private CreditLimitUseBean useBean;
    private CreditLimitService service = new CreditLimitService();

    public ConfirmCreditAction(CreditLimitUseBean useBean) {
        this.useBean = useBean;
    }

    protected FormActionResult execute() {
        BigDecimal maxAmt;
        DynamicObjectCollection entryList = this.getModel().getEntryEntity("entryentity");
        BillList billList = (BillList)this.getView().getControl("billlistap");
        if (billList.getSelectedRows().size() == 0 || entryList.size() == 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u884c\u6570\u636e\u3002", (String)"ConfirmCreditAction_0", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            return FormActionResult.FAIL;
        }
        BigDecimal totalAmt = entryList.stream().map(o -> o.getBigDecimal("et_useamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        BigDecimal exAmt = (BigDecimal)this.getModel().getValue("examt");
        for (DynamicObject entry : entryList) {
            DynamicObject currCreditType = entry.getDynamicObject("et_credittype");
            BigDecimal avaAmt = entry.getBigDecimal("et_avaamt");
            BigDecimal useAmt = entry.getBigDecimal("et_useamt");
            if (useAmt.compareTo(avaAmt) <= 0) continue;
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b[%s]\u5360\u7528\u91d1\u989d\u5927\u4e8e\u53ef\u7528\u91d1\u989d, \u8bf7\u68c0\u67e5\u3002", (String)"ConfirmCreditAction_1", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), currCreditType.getString("name")));
            return FormActionResult.FAIL;
        }
        if (exAmt.compareTo(totalAmt) != 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5360\u7528\u91d1\u989d\u603b\u548c\u4e0e\u6298\u6388\u4fe1\u5e01\u79cd\u91d1\u989d\u4e0d\u7b49, \u8bf7\u68c0\u67e5\u3002", (String)"ConfirmCreditAction_3", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            return FormActionResult.FAIL;
        }
        BigDecimal amt = (BigDecimal)this.getModel().getValue("amount");
        if (amt.compareTo(maxAmt = this.useBean.getMaxAmt().setScale(RateHelper.getCurrency((Long)this.useBean.getCurrencyId()).getInt("amtprecision"), RoundingMode.HALF_UP)) > 0) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e%s", (String)"ConfirmCreditAction_4", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), maxAmt));
            return FormActionResult.FAIL;
        }
        if (BigDecimal.ZERO.compareTo(amt) >= 0) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u9009\u62e9\u6388\u4fe1\u754c\u9762\uff0c\u201c\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u201d\u4e0d\u80fd\u7b49\u4e8e0\u3002", (String)"ConfirmCreditAction_7", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            return FormActionResult.FAIL;
        }
        DynamicObject creditLimit = this.getCurrSelectCreditLimit();
        if (EmptyUtil.isEmpty((DynamicObject)creditLimit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6388\u4fe1\u989d\u5ea6\u5355\u3002", (String)"ConfirmCreditAction_6", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            return FormActionResult.FAIL;
        }
        this.createCreditUse(creditLimit);
        CreditLimitF7ResBean returnDataBean = new CreditLimitF7ResBean();
        returnDataBean.setCreditLimitId((Long)creditLimit.getPkValue());
        returnDataBean.setTransScale((BigDecimal)this.getModel().getValue("exchangerate"));
        returnDataBean.setRealBizAmt(amt);
        returnDataBean.setCreditRatio((BigDecimal)this.getModel().getValue("creditratio"));
        returnDataBean.setExchangeAmt((BigDecimal)this.getModel().getValue("examt"));
        DynamicObject tarCurrency = (DynamicObject)this.getModel().getValue("targetcurrency");
        Optional.ofNullable(tarCurrency).ifPresent(ccy -> returnDataBean.setTargetCurrencyId(Long.valueOf(ccy.getLong("id"))));
        this.getView().returnDataToParent((Object)SerializationUtils.toJsonString((Object)returnDataBean));
        this.getView().close();
        return FormActionResult.SUCCESS;
    }

    private void createCreditUse(DynamicObject creditLimit) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (customParams.containsKey("notCredituse")) {
            logger.info("notCredituse exist");
            return;
        }
        DynamicObjectCollection chooseEntry = this.getModel().getEntryEntity("entryentity");
        Object rate = this.getModel().getValue("exchangerate");
        Object creditRatio = this.getModel().getValue("creditratio");
        Object amount = this.getModel().getValue("amount");
        List useDetailList = chooseEntry.stream().filter(o -> o.getBigDecimal("et_useamt").compareTo(BigDecimal.ZERO) > 0).map(o -> {
            HashMap<String, Object> useDetail = new HashMap<String, Object>();
            DynamicObject creditType = o.getDynamicObject("et_credittype");
            useDetail.put("et_credittype", creditType != null ? creditType.getPkValue() : Long.valueOf(0L));
            useDetail.put("et_ctrltype", o.get("et_ctrltype"));
            useDetail.put("et_useamt", o.get("et_useamt"));
            useDetail.put("exchangerate", rate);
            useDetail.put("creditratio", creditRatio);
            useDetail.put("amount", amount);
            useDetail.put("bizamount", this.useBean.getMaxAmt());
            return useDetail;
        }).collect(Collectors.toList());
        this.service.useCreditLimit(this.useBean, creditLimit, useDetailList);
    }
}

