/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimit.action.f7;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.list.BillList;
import kd.tmc.creditm.common.action.FormActionResult;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.common.helper.RateHelper;
import kd.tmc.creditm.formplugin.creditlimit.action.f7.CreditF7Action;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.param.ParamMap;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditChooseAction
extends CreditF7Action {
    private CreditLimitUseBean useBean;
    private BigDecimal bizAmt;

    public CreditChooseAction(CreditLimitUseBean useBean, BigDecimal bizAmt) {
        this.useBean = useBean;
        this.bizAmt = bizAmt;
    }

    public FormActionResult execute() {
        DynamicObject creditLimit = this.getCurrSelectCreditLimit();
        if (creditLimit == null) {
            this.clearCreditLimitData();
            return FormActionResult.FAIL;
        }
        BillList billList = (BillList)this.getView().getControl("billlistap");
        BigDecimal creditRatio = (BigDecimal)this.getModel().getValue("creditratio");
        BigDecimal amount = (BigDecimal)this.getModel().getValue("amount");
        if (EmptyUtil.isEmpty((BigDecimal)creditRatio)) {
            billList.clearSelection();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6388\u4fe1\u5360\u6bd4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CreditChooseAction_9", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            return FormActionResult.FAIL;
        }
        if (EmptyUtil.isEmpty((BigDecimal)amount)) {
            billList.clearSelection();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5b9e\u9645\u5360\u7528\u6388\u4fe1\u91d1\u989d\u5fc5\u987b\u5927\u4e8e0\u3002", (String)"CreditChooseAction_10", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            return FormActionResult.FAIL;
        }
        Map preAmountMap = CreditLimitHelper.getPreAmountByCreditType((CreditLimitUseBean)this.useBean);
        BigDecimal totalAvaAmt = CreditLimitHelper.getCanUseCreditLimitAmt((CreditLimitUseBean)this.useBean, (DynamicObject)creditLimit, (Map)preAmountMap);
        if (totalAvaAmt.compareTo(BigDecimal.ZERO) <= 0) {
            billList.clearSelection();
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u6388\u4fe1\u989d\u5ea6\u5355\u53ef\u7528\u989d\u5ea6\u4e3a0, \u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CreditChooseAction_0", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), Integer.valueOf(6000));
            return FormActionResult.SUCCESS;
        }
        BigDecimal rate = this.getRate(creditLimit);
        if (rate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u83b7\u53d6\u5f02\u5e01\u79cd\u6c47\u7387\u5931\u8d25\uff0c\u8bf7\u524d\u5f80\u6c47\u7387\u8868\u4e2d\u7ef4\u62a4\u6c47\u7387\u3002", (String)"CreditChooseAction_2", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            return FormActionResult.SUCCESS;
        }
        DynamicObject creditCurr = creditLimit.getDynamicObject("currency");
        int currencyScale = CreditLimitHelper.getAmtPrecision((DynamicObject)creditCurr);
        BigDecimal bizAmtTrans = this.bizAmt.multiply(rate).setScale(currencyScale, RoundingMode.DOWN);
        if (totalAvaAmt.compareTo(bizAmtTrans) >= 0 || this.getPageCache().get("KEY_IS_FULL_USE") != null) {
            this.fill(creditLimit, rate);
            return FormActionResult.FAIL;
        }
        this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u6388\u4fe1\u989d\u5ea6\u5355\u53ef\u5360\u7528\u989d\u5ea6\u4e3a%s, \u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"CreditChooseAction_8", (String)"tmc-creditm-formplugin", (Object[])new Object[]{totalAvaAmt.setScale(currencyScale, RoundingMode.HALF_UP)}));
        this.getPageCache().remove("KEY_REAL_BIZ_AMT");
        billList.clearSelection();
        this.getModel().deleteEntryData("entryentity");
        return FormActionResult.SUCCESS;
    }

    private void fill(DynamicObject creditLimit, BigDecimal rate) {
        this.getModel().setValue("targetcurrency", creditLimit.getDynamicObject("currency").getPkValue());
        TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (Map)new ParamMap().put("exchangerate", (Object)rate).getParams());
        int amtPrecision = CreditLimitHelper.getAmtPrecision((DynamicObject)creditLimit.getDynamicObject("currency"));
        this.getModel().setValue("examt", (Object)this.bizAmt.multiply(rate).setScale(amtPrecision, RoundingMode.DOWN));
        boolean isCurrencyDiff = !creditLimit.getDynamicObject("currency").getPkValue().equals(this.useBean.getCurrencyId());
        this.getView().setEnable(Boolean.valueOf(isCurrencyDiff), new String[]{"exchangerate"});
        this.getModel().beginInit();
        this.getModel().deleteEntryData("entryentity");
        List dataList = CreditLimitHelper.autoFillCreditLimitType((DynamicObject)creditLimit, (CreditLimitUseBean)this.useBean, (BigDecimal)rate, (BigDecimal)this.bizAmt);
        for (int i = 0; i < dataList.size(); ++i) {
            Map o = (Map)dataList.get(i);
            this.getModel().insertEntryRow("entryentity", i);
            for (Map.Entry entry : o.entrySet()) {
                String key = (String)entry.getKey();
                if (key.equals("amount") || key.equals("creditratio") || key.equals("exchangerate")) continue;
                this.getModel().setValue((String)entry.getKey(), entry.getValue(), i);
            }
        }
        this.getModel().endInit();
        this.getView().updateView("entryentity");
    }

    private BigDecimal getRate(DynamicObject creditLimit) {
        boolean isManualRate = (Boolean)this.getModel().getValue("ismanualrate");
        BigDecimal rate = isManualRate ? (BigDecimal)this.getModel().getValue("exchangerate") : RateHelper.getMdTate((DynamicObject)creditLimit.getDynamicObject("forexquote"), (DynamicObject)((DynamicObject)this.getModel().getValue("curencybiz")), (DynamicObject)creditLimit.getDynamicObject("currency"), (Long)this.useBean.getOrgId(), (Date)new Date());
        return rate;
    }
}

