/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.creditlimitagree;

import java.util.ArrayList;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.list.BillList;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.formplugin.list.AbstractTmcDataBaseList;

public class CreditLimitAgreeList
extends AbstractTmcDataBaseList {
    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        String opKey = afterDoOperationEventArgs.getOperateKey();
        OperationResult result = afterDoOperationEventArgs.getOperationResult();
        if (StringUtils.equals((CharSequence)opKey, (CharSequence)"trackquery") && result.isSuccess()) {
            BillList billList = (BillList)this.getControl("billlistap");
            ListSelectedRowCollection selectRows = billList.getSelectedRows();
            int size = selectRows.size();
            if (size != 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4e00\u6761\u6570\u636e\u8fdb\u884c\u64cd\u4f5c", (String)"CreditLimitAgreeList_0", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
                return;
            }
            DynamicObjectCollection creditBills = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"id", (QFilter[])new QFilter[]{new QFilter("creditlimitagree", "=", selectRows.get(0).getPrimaryKeyValue()), new QFilter("status", "!=", (Object)BillStatusEnum.SAVE.getValue()), new QFilter("isclose", "=", (Object)"0")});
            if (creditBills.size() == 1) {
                BillShowParameter showParameter = new BillShowParameter();
                showParameter.setPkId(((DynamicObject)creditBills.get(0)).get("id"));
                showParameter.setFormId("cfm_creditlimit");
                showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                showParameter.setCustomParam("isshowtoolbarap", (Object)"no");
                this.getView().showForm((FormShowParameter)showParameter);
            } else {
                ListShowParameter sp = new ListShowParameter();
                sp.setIsolationOrg(false);
                sp.setBillFormId("cfm_creditlimit");
                ArrayList<QFilter> qFilters = new ArrayList<QFilter>();
                qFilters.add(new QFilter("id", "in", creditBills.stream().map(o -> o.get("id")).collect(Collectors.toSet())));
                sp.getListFilterParameter().setQFilters(qFilters);
                sp.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                sp.setStatus(OperationStatus.VIEW);
                sp.setCustomParam("isshowtoolbarap", (Object)"no");
                this.getView().showForm((FormShowParameter)sp);
            }
        }
    }
}

