/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.home;

import java.lang.constant.Constable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.chart.Axis;
import kd.bos.form.chart.AxisType;
import kd.bos.form.chart.BarSeries;
import kd.bos.form.chart.Chart;
import kd.bos.form.chart.Label;
import kd.bos.form.chart.Position;
import kd.bos.form.chart.XAlign;
import kd.bos.form.chart.YAlign;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.helper.RateHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CreditCardPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CreditCardPlugin.class);
    public static final String Q_COMPANY = "filter_company";
    public static final String Q_BANK = "filter_bank";
    public static final String Q_CREDITTYPE = "filter_credittype";
    public static final String Q_CURRENCY = "filter_currency";
    public static final String Q_CURRENCYUNIT = "filter_currencyunit";
    public static final String BTN_REFRESH = "refresh_btn";
    public static final String CREDIT_CHART = "creditchart";

    private Set<String> getSelectProps() {
        HashSet<String> props = new HashSet<String>(16);
        props.add("totalamt");
        props.add("useamt");
        props.add("currency");
        props.add("avaramt");
        props.add("entry_type");
        props.add("entry_mult");
        props.add("entry_type.t_credittype");
        props.add("entry_type.t_useamt");
        props.add("entry_type.t_preamt");
        props.add("entry_type.t_avaramt");
        props.add("entry_type.pid");
        props.add("entry_mult.m_avaramt");
        props.add("entry_mult.m_credittype");
        props.add("org");
        return props;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit companyF7 = (BasedataEdit)this.getControl(Q_COMPANY);
        companyF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit bankF7 = (BasedataEdit)this.getControl(Q_BANK);
        bankF7.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{CREDIT_CHART, BTN_REFRESH});
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propName;
        switch (propName = event.getProperty().getName()) {
            case "filter_company": {
                ListShowParameter showParameter = (ListShowParameter)event.getFormShowParameter();
                Long userPK = Long.valueOf(RequestContext.get().getUserId());
                String appId = this.getView().getFormShowParameter().getAppId();
                List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)userPK, (String)appId, (String)"cfm_creditlimit", (String)"47150e89000000ac");
                showParameter.setCustomParam("range", (Object)orgIdSet);
                break;
            }
            case "filter_bank": {
                Set<Long> banks = this.getBank();
                ListShowParameter parma = (ListShowParameter)event.getFormShowParameter();
                parma.getListFilterParameter().getQFilters().add(new QFilter("id", "in", banks));
            }
        }
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String appId = this.getView().getFormShowParameter().getAppId();
        List authorizedAccountLegalOrgId = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)Long.valueOf(RequestContext.get().getUserId()), (String)appId, (String)"cfm_creditlimit", (String)"47150e89000000ac");
        if (authorizedAccountLegalOrgId.size() > 0) {
            long orgId = RequestContext.get().getOrgId();
            if (authorizedAccountLegalOrgId.contains(orgId)) {
                this.getModel().setValue(Q_COMPANY, (Object)orgId);
            } else {
                this.getModel().setValue(Q_COMPANY, authorizedAccountLegalOrgId.get(0));
            }
        }
        this.defaultCurrency();
        this.defaultBank();
        this.updateCreditChart();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        super.propertyChanged(e);
        switch (key = e.getProperty().getName()) {
            case "filter_company": {
                this.defaultCurrency();
                this.updateCreditChart();
                this.defaultBank();
                break;
            }
            case "filter_currency": 
            case "filter_currencyunit": 
            case "filter_bank": 
            case "filter_credittype": {
                this.updateCreditChart();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (BTN_REFRESH.equals(source.getKey()) && this.updateCreditChart().booleanValue()) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5237\u65b0\u6210\u529f\u3002", (String)"CreditCardPlugin_10", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
        }
    }

    private Boolean updateCreditChart() {
        if (!this.verifyQuery().booleanValue()) {
            return Boolean.FALSE;
        }
        ArrayList<String> xDimensions = new ArrayList<String>();
        ArrayList<BigDecimal[]> charDataList = new ArrayList<BigDecimal[]>();
        Boolean isExitData = this.getCharData(xDimensions, charDataList);
        if (!isExitData.booleanValue()) {
            this.getDefaultData(xDimensions, charDataList);
        }
        Chart customchart = (Chart)this.getControl(CREDIT_CHART);
        customchart.clearData();
        customchart.setMargin(Position.top, "35px");
        customchart.setMargin(Position.left, "5%");
        customchart.setMargin(Position.bottom, "35px");
        customchart.setLegendAlign(XAlign.center, YAlign.bottom);
        customchart.setShowTooltip(true);
        this.setCreditchartXaxisTick(customchart, xDimensions);
        this.setCreditChartData(customchart, charDataList);
        return isExitData;
    }

    private Boolean getCharData(List<String> xDimensions, List<BigDecimal[]> charDataList) {
        BigDecimal useAmt;
        Long divideCount = this.getCurrencyUnit();
        QFilter companyFilter = this.getOrgFilter();
        QFilter bankFilter = this.getBankFilter();
        QFilter statusFilter = new QFilter("isclose", "=", (Object)"0").and("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("isframework", "=", (Object)"0");
        Object[] creditLimits = TmcDataServiceHelper.load((String)"cfm_creditlimit", (String)String.join((CharSequence)",", this.getSelectProps()), (QFilter[])new QFilter[]{statusFilter, companyFilter, bankFilter});
        if (EmptyUtil.isEmpty((Object[])creditLimits)) {
            return Boolean.FALSE;
        }
        DynamicObject toCurrency = (DynamicObject)this.getModel().getValue(Q_CURRENCY);
        int amtPrecision = toCurrency.getInt("amtprecision");
        Long targetCurrencyID = (Long)toCurrency.getPkValue();
        HashMap<String, BigDecimal> currencyRateMap = new HashMap<String, BigDecimal>(creditLimits.length);
        HashMap<Long, Pair<BigDecimal, BigDecimal>> amtMap = new HashMap<Long, Pair<BigDecimal, BigDecimal>>(creditLimits.length);
        for (Object creditLimit : creditLimits) {
            DynamicObject currency = creditLimit.getDynamicObject("currency");
            DynamicObject company = creditLimit.getDynamicObject("org");
            Long sourceCurrencyID = (Long)currency.getPkValue();
            BigDecimal rate = BigDecimal.ONE;
            if (sourceCurrencyID.compareTo(targetCurrencyID) != 0) {
                String key = String.valueOf(sourceCurrencyID) + targetCurrencyID;
                if (currencyRateMap.containsKey(key)) {
                    rate = (BigDecimal)currencyRateMap.get(key);
                } else {
                    try {
                        rate = RateHelper.getExchangeRate((Long)sourceCurrencyID, (Long)targetCurrencyID, (Long)((Long)company.getPkValue()), (Date)new Date());
                    }
                    catch (KDBizException e) {
                        logger.error((Throwable)e);
                        rate = null;
                    }
                    if (rate == null) {
                        this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"%1$s\u627e\u4e0d\u5230%2$s\u5151%3$s\u6c47\u7387", (String)"CreditCardPlugin_4", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), company.getString("name"), currency.getString("name"), toCurrency.getString("name")));
                        return Boolean.FALSE;
                    }
                    currencyRateMap.put(key, rate);
                }
            }
            Map<Long, BigDecimal> multEntryAmt = this.getMultEntryAmt((DynamicObject)creditLimit);
            Set<Long> creditTypes = this.getCreditTypes();
            Map<Long, Pair<BigDecimal, BigDecimal>> CreditLimitAmtMap = CreditCardPlugin.getEntryAvaAmtMap((DynamicObject)creditLimit, multEntryAmt, creditTypes);
            for (Map.Entry<Long, Pair<BigDecimal, BigDecimal>> entrySet : CreditLimitAmtMap.entrySet()) {
                Pair<BigDecimal, BigDecimal> amtPair = entrySet.getValue();
                BigDecimal avaAmt = ((BigDecimal)amtPair.getLeft()).multiply(rate).divide(new BigDecimal(divideCount), amtPrecision, RoundingMode.HALF_UP);
                useAmt = ((BigDecimal)amtPair.getRight()).multiply(rate).divide(new BigDecimal(divideCount), amtPrecision, RoundingMode.HALF_UP);
                Long key = entrySet.getKey();
                if (amtMap.containsKey(key)) {
                    amtMap.put(key, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)((BigDecimal)((Pair)amtMap.get(key)).getLeft()).add(avaAmt), (Object)((BigDecimal)((Pair)amtMap.get(key)).getRight()).add(useAmt)));
                    continue;
                }
                amtMap.put(entrySet.getKey(), (Pair<BigDecimal, BigDecimal>)Pair.of((Object)avaAmt, (Object)useAmt));
            }
        }
        int i = 0;
        Object[] typeIds = amtMap.keySet().toArray();
        Map<Long, String> creditTypeMap = this.getCreditTypeMap(typeIds);
        BigDecimal otherUseAmt = BigDecimal.ZERO;
        BigDecimal otherAvrAmt = BigDecimal.ZERO;
        Map<Long, BigDecimal> sortMap = this.sortAmount(amtMap);
        int arrLen = amtMap.size() > sortMap.size() ? sortMap.size() + 1 : sortMap.size();
        BigDecimal[] totalArr = new BigDecimal[arrLen];
        BigDecimal[] useArr = new BigDecimal[arrLen];
        for (Map.Entry entrySet : amtMap.entrySet()) {
            Long key = (Long)entrySet.getKey();
            BigDecimal leftVal = (BigDecimal)((Pair)entrySet.getValue()).getLeft();
            BigDecimal rightVal = (BigDecimal)((Pair)entrySet.getValue()).getRight();
            BigDecimal avrAmt = EmptyUtil.isEmpty((BigDecimal)leftVal) ? BigDecimal.ZERO : leftVal;
            BigDecimal bigDecimal = useAmt = EmptyUtil.isEmpty((BigDecimal)rightVal) ? BigDecimal.ZERO : rightVal;
            if (!sortMap.containsKey(key)) {
                otherAvrAmt = otherAvrAmt.add(avrAmt);
                otherUseAmt = otherUseAmt.add(useAmt);
                continue;
            }
            xDimensions.add(creditTypeMap.get(key));
            useArr[i] = useAmt;
            totalArr[i] = avrAmt;
            ++i;
        }
        if (otherAvrAmt.add(otherUseAmt).compareTo(BigDecimal.ZERO) > 0) {
            xDimensions.add(ResManager.loadKDString((String)"\u5176\u4ed6", (String)"CreditCardPlugin_11", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            useArr[i] = otherUseAmt;
            totalArr[i] = otherAvrAmt;
        }
        charDataList.add(totalArr);
        charDataList.add(useArr);
        return Boolean.TRUE;
    }

    private Set<Long> getCreditTypes() {
        HashSet<Long> creditTypes = new HashSet<Long>();
        DynamicObjectCollection creditTypeFilters = (DynamicObjectCollection)this.getModel().getValue(Q_CREDITTYPE);
        for (DynamicObject creditType : creditTypeFilters) {
            creditTypes.add(((DynamicObject)creditType.get("fbasedataid")).getLong("id"));
        }
        return creditTypes;
    }

    private Map<Long, BigDecimal> sortAmount(Map<Long, Pair<BigDecimal, BigDecimal>> amountMap) {
        HashMap<Long, BigDecimal> typeAmt = new HashMap<Long, BigDecimal>(amountMap.size());
        for (Map.Entry<Long, Pair<BigDecimal, BigDecimal>> map : amountMap.entrySet()) {
            typeAmt.put(map.getKey(), ((BigDecimal)map.getValue().getLeft()).add((BigDecimal)map.getValue().getRight()));
        }
        if (amountMap.size() <= 8) {
            return typeAmt;
        }
        Map sortDescAmt = typeAmt.entrySet().stream().sorted(Collections.reverseOrder(Map.Entry.comparingByValue())).collect(Collectors.toMap(x -> (Long)x.getKey(), x -> (BigDecimal)x.getValue(), (x1, x2) -> x2, LinkedHashMap::new));
        typeAmt.clear();
        int i = 0;
        for (Map.Entry amtMap : sortDescAmt.entrySet()) {
            if (i == 8) break;
            typeAmt.put((Long)amtMap.getKey(), (BigDecimal)amtMap.getValue());
            ++i;
        }
        return typeAmt;
    }

    private Map<Long, String> getCreditTypeMap(Object[] typeIds) {
        HashMap<Long, String> typeMaps = new HashMap<Long, String>(typeIds.length);
        Map typeMap = TmcDataServiceHelper.loadFromCache((Object[])typeIds, (String)"cfm_credittype");
        for (DynamicObject type : typeMap.values()) {
            typeMaps.put(type.getLong("id"), type.getString("name"));
        }
        return typeMaps;
    }

    public static Map<Long, Pair<BigDecimal, BigDecimal>> getEntryAvaAmtMap(DynamicObject creditLimit, Map<Long, BigDecimal> multAvaMap, Set<Long> creditTypes) {
        HashMap<Long, Pair<BigDecimal, BigDecimal>> amtMap = new HashMap<Long, Pair<BigDecimal, BigDecimal>>(16);
        DynamicObjectCollection entryTypes = creditLimit.getDynamicObjectCollection("entry_type");
        BigDecimal headAvaAmt = creditLimit.getBigDecimal("avaramt");
        for (DynamicObject entry : entryTypes) {
            BigDecimal avaAmt = entry.getBigDecimal("t_avaramt");
            BigDecimal useAmt = entry.getBigDecimal("t_useamt").add(entry.getBigDecimal("t_preamt"));
            DynamicObjectCollection colls = entry.getDynamicObjectCollection("t_credittype");
            boolean isUse = EmptyUtil.isNoEmpty((Object)entry.getPkValue()) && colls.size() == 1;
            colls.forEach(o -> {
                DynamicObject type = o.getDynamicObject("fbasedataid");
                if (EmptyUtil.isNoEmpty((DynamicObject)type) && (creditTypes.size() == 0 || creditTypes.contains(type.getLong("id")))) {
                    BigDecimal uAmt;
                    long typeId = type.getLong("id");
                    BigDecimal aAmt = avaAmt;
                    if (multAvaMap.containsKey(typeId)) {
                        aAmt = ((BigDecimal)multAvaMap.get(typeId)).min(avaAmt);
                    }
                    BigDecimal bigDecimal = uAmt = isUse ? useAmt : BigDecimal.ZERO;
                    if (amtMap.containsKey(typeId)) {
                        aAmt = ((BigDecimal)((Pair)amtMap.get(typeId)).getLeft()).min(avaAmt);
                        uAmt = ((BigDecimal)((Pair)amtMap.get(typeId)).getRight()).add(uAmt);
                    }
                    amtMap.put(typeId, Pair.of((Object)aAmt.min(headAvaAmt), (Object)uAmt));
                }
            });
        }
        return amtMap;
    }

    private Map<Long, BigDecimal> getMultEntryAmt(DynamicObject creditLimit) {
        DynamicObjectCollection multEntrys = creditLimit.getDynamicObjectCollection("entry_mult");
        HashMap<Long, BigDecimal> typeMap = new HashMap<Long, BigDecimal>(multEntrys.size());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)multEntrys)) {
            return typeMap;
        }
        for (DynamicObject multEntry : multEntrys) {
            DynamicObjectCollection types = multEntry.getDynamicObjectCollection("m_credittype");
            Set<Long> typeCollIds = CreditCardPlugin.getCollId(types);
            typeCollIds.forEach(o -> {
                BigDecimal avaAmt = multEntry.getBigDecimal("m_avaramt");
                if (typeMap.containsKey(o)) {
                    typeMap.put((Long)o, ((BigDecimal)typeMap.get(o)).min(avaAmt));
                } else {
                    typeMap.put((Long)o, avaAmt);
                }
            });
        }
        return typeMap;
    }

    public static Set<Long> getCollId(DynamicObjectCollection colls) {
        HashSet<Long> ids = new HashSet<Long>(colls.size());
        if (EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
            return ids;
        }
        colls.forEach(o -> ids.add(o.getDynamicObject("fbasedataid").getLong("id")));
        return ids;
    }

    private Axis setCreditchartXaxisTick(Chart customchart, List<String> xDimensions) {
        Axis xaxis = customchart.createXAxis(null, AxisType.category);
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        xaxis.setPropValue("axisTick", axisTick);
        xaxis.setCategorys(xDimensions);
        this.setLineColor(xaxis, "#666666");
        return xaxis;
    }

    private void setCreditChartData(Chart customchart, List<BigDecimal[]> charDataList) {
        Object[] dataSum = charDataList.get(0);
        Number[] useData = charDataList.get(1);
        Axis taskNumberAxis = customchart.createYAxis(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6", (String)"CreditCardPlugin_0", (String)"tmc-creditm-formplugin", (Object[])new Object[0]), AxisType.value);
        BarSeries seriesNormal = customchart.createBarSeries(ResManager.loadKDString((String)"\u53ef\u7528\u989d\u5ea6", (String)"CreditCardPlugin_2", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
        seriesNormal.setBarWidth("20%");
        seriesNormal.setColor("#00CCCC");
        seriesNormal.setData((Number[])dataSum);
        Label lab = new Label();
        lab.setShow(false);
        seriesNormal.setLabel(lab);
        BarSeries seriesOverdue = customchart.createBarSeries(ResManager.loadKDString((String)"\u5df2\u7528\u989d\u5ea6", (String)"CreditCardPlugin_3", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
        seriesOverdue.setBarWidth("20%");
        seriesOverdue.setColor("#098BFF");
        seriesOverdue.setData(useData);
        seriesOverdue.setLabel(lab);
        ArrayList<String> path = new ArrayList<String>();
        path.add("label");
        path.add("normal");
        path.add("formatter");
        seriesOverdue.addFuncPath(path);
        if (EmptyUtil.isNoEmpty((Object[])dataSum)) {
            BigDecimal maxData = this.getMaxAmt((BigDecimal[])dataSum);
            long maxTask = maxData.setScale(0, 4).longValue();
            int baseParam = EmptyUtil.isEmpty((Long)maxTask) ? 1 : this.getBaseParam(maxTask);
            long yMaxValue = maxTask != 0L && maxTask % (long)baseParam == 0L ? maxTask : (Math.floorDiv(maxTask, (long)baseParam) + 1L) * (long)baseParam;
            long interval = yMaxValue / 5L;
            taskNumberAxis.setMax((Number)yMaxValue);
            taskNumberAxis.setInterval((Number)(EmptyUtil.isEmpty((Long)interval) ? 1L : interval));
        }
        HashMap<String, Constable> axisTick = new HashMap<String, Constable>();
        axisTick.put("interval", Integer.valueOf(0));
        axisTick.put("show", Boolean.valueOf(false));
        taskNumberAxis.setPropValue("axisTick", axisTick);
        this.setLineColor(taskNumberAxis, "#666666");
        customchart.bindData(null);
    }

    private BigDecimal getMaxAmt(BigDecimal[] dataSum) {
        BigDecimal maxAmt = BigDecimal.ZERO;
        List sumDatas = Arrays.stream(dataSum).filter(o -> o != null).collect(Collectors.toList());
        if (EmptyUtil.isNoEmpty(sumDatas)) {
            Iterator ites = sumDatas.iterator();
            maxAmt = (BigDecimal)ites.next();
            while (ites.hasNext()) {
                BigDecimal amt = (BigDecimal)ites.next();
                if (amt == null || maxAmt.compareTo(amt) >= 0) continue;
                maxAmt = amt;
            }
        }
        return maxAmt;
    }

    private int getBaseParam(long maxTask) {
        int baseParam = 0;
        baseParam = maxTask < 10L ? (int)maxTask : (maxTask <= 100L ? 25 : (maxTask <= 500L ? 50 : (maxTask <= 1000L ? 100 : (maxTask <= 5000L ? 500 : (maxTask <= 10000L ? 1000 : (maxTask <= 50000L ? 5000 : (maxTask <= 100000L ? 10000 : 50000)))))));
        return baseParam;
    }

    private void getDefaultData(List<String> xDimensions, List<BigDecimal[]> charDataList) {
        xDimensions.add(" ");
        charDataList.add(new BigDecimal[]{BigDecimal.ZERO});
        charDataList.add(new BigDecimal[]{BigDecimal.ZERO});
        charDataList.add(new BigDecimal[]{BigDecimal.ZERO});
    }

    private void setLineColor(Axis axix, String color) {
        HashMap axisLineMap = new HashMap(1);
        HashMap<String, String> lineStyleMap = new HashMap<String, String>(1);
        lineStyleMap.put("color", color);
        axisLineMap.put("lineStyle", lineStyleMap);
        axix.setPropValue("axisLine", axisLineMap);
    }

    private Boolean verifyQuery() {
        DynamicObject companys = (DynamicObject)this.getModel().getValue(Q_COMPANY);
        if (EmptyUtil.isEmpty((DynamicObject)companys)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6388\u4fe1\u4e3b\u4f53\u3002", (String)"CreditCardPlugin_7", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        DynamicObject currency = (DynamicObject)this.getModel().getValue(Q_CURRENCY);
        if (EmptyUtil.isEmpty((DynamicObject)currency)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7edf\u8ba1\u5e01\u79cd\u3002", (String)"CreditCardPlugin_8", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String currencyUnit = (String)this.getModel().getValue(Q_CURRENCYUNIT);
        if (StringUtils.isBlank((CharSequence)currencyUnit)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d27\u5e01\u5355\u4f4d\u3002", (String)"CreditCardPlugin_9", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    private QFilter getOrgFilter() {
        DynamicObject company = (DynamicObject)this.getModel().getValue(Q_COMPANY);
        QFilter ofilter = null;
        if (company != null) {
            ofilter = new QFilter("org", "=", company.getPkValue());
        }
        return ofilter;
    }

    private QFilter getBankFilter() {
        ArrayList<Long> comIist = new ArrayList<Long>();
        DynamicObjectCollection banks = (DynamicObjectCollection)this.getModel().getValue(Q_BANK);
        for (DynamicObject company : banks) {
            comIist.add(((DynamicObject)company.get("fbasedataid")).getLong("id"));
        }
        QFilter ofilter = null;
        if (comIist.size() > 0) {
            ofilter = new QFilter("bank", "in", comIist);
        }
        return ofilter;
    }

    private Long getCurrencyUnit() {
        String currencyUnit = (String)this.getModel().getValue(Q_CURRENCYUNIT);
        Long divideCount = 1L;
        if ("Billion".equals(currencyUnit)) {
            divideCount = 100000000L;
        } else if ("TenThousand".equals(currencyUnit)) {
            divideCount = 10000L;
        } else if ("Million".equals(currencyUnit)) {
            divideCount = 1000000L;
        } else if ("Thousand".equals(currencyUnit)) {
            divideCount = 1000L;
        } else if ("Original".equals(currencyUnit)) {
            divideCount = 1L;
        }
        return divideCount;
    }

    private void defaultCurrency() {
        DynamicObject company = (DynamicObject)this.getModel().getValue(Q_COMPANY);
        if (EmptyUtil.isEmpty((DynamicObject)company)) {
            return;
        }
        DynamicObject currency = TmcBusinessBaseHelper.getBaseCurrency((long)company.getLong("id"));
        if (EmptyUtil.isNoEmpty((DynamicObject)currency)) {
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)Q_CURRENCY, (Object)currency.getPkValue());
            this.getView().updateView(Q_CURRENCY);
        }
    }

    private Set<Long> getBank() {
        Set<Long> bankIds = new HashSet<Long>(16);
        DynamicObject company = (DynamicObject)this.getModel().getValue(Q_COMPANY);
        if (EmptyUtil.isNoEmpty((DynamicObject)company)) {
            DynamicObjectCollection creditLimits = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"id,bank", (QFilter[])new QFilter[]{new QFilter("org", "=", company.getPkValue())});
            bankIds = creditLimits.stream().filter(t -> EmptyUtil.isNoEmpty((Object)t.get("bank"))).map(d -> d.getLong("bank")).collect(Collectors.toSet());
        }
        return bankIds;
    }

    private void defaultBank() {
        Set<Long> bankIds = this.getBank();
        this.getModel().setValue(Q_BANK, (Object)bankIds.toArray(new Object[bankIds.size()]));
    }
}

