/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.usecredit;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.tmc.creditm.common.helper.UseCreditHelper;
import kd.tmc.creditm.formplugin.resources.CreditmFormResourceEnum;
import kd.tmc.creditm.formplugin.usecredit.helper.UseCreditBatchHeper;
import kd.tmc.creditm.formplugin.usecredit.helper.UseCreditBean;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class UseCreditBatchEdit
extends AbstractTmcBillEdit {
    private static Map<String, DynamicObject> useConfigMap = new HashMap<String, DynamicObject>();
    private static Map<String, String> bankBizType = new HashMap<String, String>();
    private static Map<String, String> orgBizType = new HashMap<String, String>();
    private static Map<String, String> partBizType = new HashMap<String, String>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"businesscode"});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.loadConfigMap();
        this.getBizTypeComItems();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String propName;
        switch (propName = e.getProperty().getName()) {
            case "banktype": {
                this.bankTypeChange();
                break;
            }
            case "businesscode": {
                this.businessCodeChange();
                break;
            }
            case "bizbilltype": {
                this.bizTypeChange();
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "businesscode": {
                this.showBizBillList();
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "businesscode": {
                int idx = this.getModel().getEntryCurrentRowIndex("usecreditdetails");
                if (!EmptyUtil.isNoEmpty((Object)e.getValue()) || "other".equals(this.getModel().getValue("bizbilltype", idx))) break;
                e.setCancel(true);
                this.getModel().setValue("businesscode", (Object)"", idx);
                this.getView().updateView("businesscode", idx);
                this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditBatchEdit_3.loadKDString());
                break;
            }
            case "bizbilltype": {
                String entityName;
                int idx = this.getModel().getEntryCurrentRowIndex("usecreditdetails");
                String bankType = (String)this.getModel().getValue("banktype", idx);
                if ("other".equals(e.getValue()) || "cfm_creditlimit".equals(e.getValue())) {
                    return;
                }
                DynamicObject config = this.getConfig((String)e.getValue());
                if (orgBizType.size() == 0 || bankBizType.size() == 0 || partBizType.size() == 0) {
                    this.getBizTypeComItems();
                }
                String string = entityName = config != null ? config.getString("name") : "";
                if (CreditFinTypeEnum.ORG.getValue().equals(bankType) && !orgBizType.containsKey(e.getValue())) {
                    e.setCancel(true);
                    this.getView().updateView("bizbilltype", idx);
                    this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditBatchEdit_4.loadKDString(entityName));
                    return;
                }
                if (CreditFinTypeEnum.FINORG.getValue().equals(bankType) && !bankBizType.containsKey(e.getValue())) {
                    e.setCancel(true);
                    this.getView().updateView("bizbilltype", idx);
                    this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditBatchEdit_5.loadKDString(entityName));
                }
                if (!CreditFinTypeEnum.BIZPARTNER.getValue().equals(bankType) || partBizType.containsKey(e.getValue())) break;
                e.setCancel(true);
                this.getView().updateView("bizbilltype", idx);
                this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditBatchEdit_6.loadKDString(entityName));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnDatas;
        super.closedCallBack(evt);
        if ("showBizBillList".equals(evt.getActionId()) && EmptyUtil.isNoEmpty((Object)(returnDatas = (ListSelectedRowCollection)evt.getReturnData()))) {
            int currIdx = this.getModel().getEntryCurrentRowIndex("usecreditdetails");
            Object bizId = returnDatas.get(0).getPrimaryKeyValue();
            DynamicObject config = this.getConfig((String)this.getModel().getValue("bizbilltype"));
            if (EmptyUtil.isEmpty((DynamicObject)config)) {
                return;
            }
            IDataModel model = this.getModel();
            String bankType = (String)model.getValue("banktype", currIdx);
            DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("usecreditdetails");
            Set bizEntryIds = entryEntitys.parallelStream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("bizentryid"))).map(o -> o.getLong("bizentryid")).collect(Collectors.toSet());
            List<UseCreditBean> useCreditBeans = UseCreditBatchHeper.getUseCreditBeans(config, Long.parseLong(String.valueOf(bizId)));
            useCreditBeans = useCreditBeans.stream().filter(o -> EmptyUtil.isEmpty((Long)o.getBizEntryId()) || !bizEntryIds.contains(o.getBizEntryId())).collect(Collectors.toList());
            boolean isNeedNewRow = false;
            for (int i = 0; i < useCreditBeans.size(); ++i) {
                UseCreditBean bean = useCreditBeans.get(i);
                if (EmptyUtil.isNoEmpty((String)bean.getBankType()) && !bean.getBankType().equals(bankType)) continue;
                if (isNeedNewRow) {
                    currIdx = model.createNewEntryRow("usecreditdetails");
                }
                if (EmptyUtil.isNoEmpty((String)bean.getBankType())) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"banktype", (Object)bean.getBankType(), (int)currIdx);
                }
                if (EmptyUtil.isNoEmpty((String)bean.getBizBillType())) {
                    TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"bizbilltype", (Object)bean.getBizBillType(), (int)currIdx);
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"businesscode", (Object)bean.getBusinessCode(), (int)currIdx);
                model.setValue("bindid", (Object)bean.getBindId(), currIdx);
                model.setValue("currency", (Object)bean.getCurrencyId(), currIdx);
                model.setValue("businessamount", (Object)bean.getBusinessAmount(), currIdx);
                model.setValue("startdate", (Object)bean.getStartDate(), currIdx);
                model.setValue("expiredate", (Object)bean.getExpireDate(), currIdx);
                model.setValue("finorginfo", (Object)bean.getFinorgInfoId(), currIdx);
                model.setValue("credittype", (Object)bean.getCreditTypeId(), currIdx);
                model.setValue("creditproduct", (Object)bean.getCreditProduct(), currIdx);
                model.setValue("bizentryid", (Object)bean.getBizEntryId(), currIdx);
                this.getView().updateView("usecreditdetails", currIdx);
                isNeedNewRow = true;
            }
        }
    }

    private void businessCodeChange() {
        int idx = this.getModel().getEntryCurrentRowIndex("usecreditdetails");
        String businessCode = (String)this.getModel().getValue("businesscode", idx);
        String billType = (String)this.getModel().getValue("bizbilltype", idx);
        if (!"other".equals(billType) && EmptyUtil.isEmpty((String)businessCode)) {
            this.bizTypeChange();
        }
    }

    private void bankTypeChange() {
        int idx = this.getModel().getEntryCurrentRowIndex("usecreditdetails");
        this.getModel().setValue("bizbilltype", (Object)"other", idx);
        DynamicObject fundOrg = (DynamicObject)this.getModel().getValue("companydy");
        DynamicObject standardCurrency = TmcBusinessBaseHelper.getCasBaseCurrency((long)((Long)fundOrg.getPkValue()));
        this.getModel().setValue("currency", (Object)standardCurrency, idx);
        this.getModel().setValue("businesscode", (Object)"", idx);
    }

    private void bizTypeChange() {
        int idx = this.getModel().getEntryCurrentRowIndex("usecreditdetails");
        HashMap<String, Object> valMap = new HashMap<String, Object>();
        valMap.put("businesscode", "");
        valMap.put("finorginfo", null);
        valMap.put("credittype", null);
        valMap.put("creditproduct", "");
        valMap.put("remark", "");
        valMap.put("startdate", "");
        valMap.put("expiredate", "");
        valMap.put("currency", null);
        valMap.put("businessamount", 0);
        valMap.put("creditamount", 0);
        valMap.put("contractno", null);
        valMap.put("creditcurrency", null);
        valMap.put("creditrate", 0);
        valMap.put("discreditamount", 0);
        valMap.put("bindid", DB.genLongId((String)"t_cfm_use_credit"));
        valMap.put("bizentryid", 0);
        TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), valMap);
        this.lockEntry("other".equals(this.getModel().getValue("bizbilltype", idx)));
    }

    private void getBizTypeComItems() {
        ComboEdit comTypes = (ComboEdit)this.getView().getControl("bizbilltype");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        if (useConfigMap.size() > 0) {
            List filterConfigs = useConfigMap.entrySet().stream().collect(Collectors.toList());
            filterConfigs.sort(Comparator.comparing(o -> ((DynamicObject)o.getValue()).getInt("order")));
            for (Map.Entry config : filterConfigs) {
                if (EmptyUtil.isEmpty((DynamicObject)((DynamicObject)config.getValue()))) continue;
                ComboItem item = new ComboItem();
                item.setValue((String)config.getKey());
                item.setCaption(new LocaleString(((DynamicObject)config.getValue()).getString("name")));
                comboItems.add(item);
                String bankTypeComs = ((DynamicObject)config.getValue()).getString("banktypecoms");
                if (bankTypeComs.contains(CreditFinTypeEnum.ORG.getValue())) {
                    orgBizType.put((String)config.getKey(), ((DynamicObject)config.getValue()).getString("name"));
                }
                if (bankTypeComs.contains(CreditFinTypeEnum.FINORG.getValue())) {
                    bankBizType.put((String)config.getKey(), ((DynamicObject)config.getValue()).getString("name"));
                }
                if (!bankTypeComs.contains(CreditFinTypeEnum.BIZPARTNER.getValue())) continue;
                partBizType.put((String)config.getKey(), ((DynamicObject)config.getValue()).getString("name"));
            }
            comboItems.add(new ComboItem(new LocaleString(CreditmFormResourceEnum.UseCreditBatchEdit_0.loadKDString()), "other"));
            comTypes.setComboItems(comboItems);
            this.getModel().setValue("bizbilltype", (Object)"other");
        }
    }

    private String getBizType() {
        int idx = this.getModel().getEntryCurrentRowIndex("usecreditdetails");
        return String.valueOf(this.getModel().getValue("bizbilltype", idx));
    }

    private void showBizBillList() {
        QFilter customQfilter;
        QFilter selectedBillFilter;
        String bizBilltype = this.getBizType();
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("companydy"))) {
            this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditBatchEdit_2.loadKDString());
            return;
        }
        if ("other".equals(bizBilltype)) {
            this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditBatchEdit_1.loadKDString());
            return;
        }
        String formId = UseCreditBatchHeper.getFormId(bizBilltype);
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)formId, (boolean)false);
        QFilter bizFilter = this.getBizFilter(bizBilltype);
        String bankType = (String)this.getModel().getValue("banktype", this.getModel().getEntryCurrentRowIndex("usecreditdetails"));
        if ("cfm_creditlimit".equals(bizBilltype)) {
            bizFilter.and("banktype", "=", (Object)bankType);
        }
        if ((selectedBillFilter = this.getSelectedBillFilter()) != null) {
            bizFilter.and(selectedBillFilter);
        }
        if ((customQfilter = UseCreditBatchHeper.getCustomQfilter(bankType, bizBilltype)) != null) {
            bizFilter.and(customQfilter);
        }
        showListForm.getListFilterParameter().getQFilters().add(bizFilter);
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showBizBillList"));
        if ("cfm_creditlimit".equals(bizBilltype)) {
            showListForm.setFormId("bos_listf7");
        }
        this.getView().showForm((FormShowParameter)showListForm);
    }

    private QFilter getSelectedBillFilter() {
        int curIdx = this.getModel().getEntryCurrentRowIndex("usecreditdetails");
        String bizType = (String)this.getModel().getValue("bizbilltype", curIdx);
        DynamicObjectCollection entryEntitys = this.getModel().getEntryEntity("usecreditdetails");
        QFilter entryBizFilter = this.getEntryBizFilter(entryEntitys, bizType, curIdx);
        if (entryBizFilter != null) {
            return entryBizFilter;
        }
        Set bizIds = entryEntitys.parallelStream().filter(o -> bizType.equals(o.getString("bizbilltype")) && EmptyUtil.isNoEmpty((String)o.getString("businesscode")) && EmptyUtil.isNoEmpty((Long)o.getLong("bindid"))).map(o -> o.getLong("bindid")).collect(Collectors.toSet());
        Long currId = Long.valueOf((String)this.getModel().getValue("bindid", curIdx));
        if (EmptyUtil.isNoEmpty((Long)currId)) {
            bizIds.remove(currId);
        }
        if (EmptyUtil.isNoEmpty(bizIds)) {
            return new QFilter("id", "not in", bizIds);
        }
        return null;
    }

    private QFilter getEntryBizFilter(DynamicObjectCollection entryEntitys, String bizType, int curIdx) {
        if (EmptyUtil.isEmpty((String)bizType) || "other".equals(bizType)) {
            return null;
        }
        DynamicObject config = this.getConfig(bizType);
        if (EmptyUtil.isEmpty((DynamicObject)config)) {
            return null;
        }
        String creditEntry = config.getString("creditentry");
        if (EmptyUtil.isEmpty((String)creditEntry)) {
            return null;
        }
        Set bizEntryIds = entryEntitys.parallelStream().filter(o -> bizType.equals(o.getString("bizbilltype")) && EmptyUtil.isNoEmpty((Long)o.getLong("bizentryid"))).map(o -> o.getLong("bizentryid")).collect(Collectors.toSet());
        long currEntryId = (Long)this.getModel().getValue("bizentryid", curIdx);
        if (EmptyUtil.isNoEmpty((Long)currEntryId)) {
            bizEntryIds.remove(currEntryId);
        }
        if (EmptyUtil.isNoEmpty(bizEntryIds)) {
            return new QFilter(creditEntry, "not in", bizEntryIds);
        }
        return null;
    }

    private QFilter getBizFilter(String bizBilltype) {
        DynamicObject config = this.getConfig(bizBilltype);
        return UseCreditHelper.getBizQfilter((DynamicObject)config, (DynamicObject)((DynamicObject)this.getModel().getValue("companydy")));
    }

    private List<DynamicObject> getConfigArrs() {
        Map configMap = TmcDataServiceHelper.loadFromCache((String)"creditm_useconfig", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())});
        return configMap.values().stream().collect(Collectors.toList());
    }

    private DynamicObject getConfig(String bizBilltype) {
        if (useConfigMap.size() == 0) {
            this.loadConfigMap();
        }
        return useConfigMap.get(bizBilltype);
    }

    private void loadConfigMap() {
        List<DynamicObject> useConfigArrs = this.getConfigArrs();
        for (DynamicObject config : useConfigArrs) {
            String entityName = config.getString("biztypenum");
            if (EmptyUtil.isEmpty((String)entityName)) {
                entityName = config.getDynamicObject("biztype").getString("number");
            }
            useConfigMap.put(entityName, config);
        }
    }

    private void lockEntry(boolean isLock) {
        TmcViewInputHelper.registerMustInput((IFormView)this.getView(), (boolean)isLock, (String[])new String[]{"expiredate"});
    }
}

