/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.usecredit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.FieldEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.creditm.common.enums.UseCreditOperateTypeEnum;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.common.helper.UseCreditHelper;
import kd.tmc.creditm.formplugin.resources.CreditmFormResourceEnum;
import kd.tmc.creditm.formplugin.usecredit.helper.UseCreditBatchHeper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.edit.AbstractTmcBillEdit;

public class UseCreditBillEdit
extends AbstractTmcBillEdit
implements BeforeF7SelectListener {
    private static final String CLOSE_CALLBACK_KEY = "closeCallbackKey";
    private static Map<String, DynamicObject> useConfigMap = new HashMap<String, DynamicObject>();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit conEdit = (BasedataEdit)this.getView().getControl("contractno");
        conEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finEdit = (BasedataEdit)this.getView().getControl("finorginfo");
        finEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addClickListeners(new String[]{"businesscode"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initReleaseValue();
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Object changeType = this.getModel().getValue("changetype");
        if (UseCreditChangeTypeEnum.LOCK.getValue().equals(changeType)) {
            this.setCreditAmt();
            this.loadConfigMap();
            this.getBizTypeCombos();
        } else {
            FieldEdit creditAmount = (FieldEdit)this.getView().getControl("creditamount");
            creditAmount.setCaption(new LocaleString(CreditmFormResourceEnum.UseCreditBillEdit_0.loadKDString()));
        }
        this.lockByBillType();
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        if (Objects.equals(itemKey, "bar_new")) {
            this.afterNewPage();
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        switch (source.getKey()) {
            case "businesscode": {
                this.showBizBillList();
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "creditamount": 
            case "currency": 
            case "credittype": 
            case "org": 
            case "bizdate": {
                this.clearVal();
                break;
            }
            case "finorginfo": {
                this.clearVal();
                this.setEntryIdFromFinorg();
                break;
            }
            case "banktype": {
                this.getBizTypeCombos();
                this.getModel().setValue("bizbilltype", (Object)"other");
                break;
            }
            case "businesscode": {
                this.businessCodeProp();
                break;
            }
            case "bizbilltype": {
                this.bizBillTypeChange();
                this.getModel().setValue("businesscode", (Object)"");
                break;
            }
            case "businessamount": {
                this.businessAmount();
                break;
            }
            case "contractno": {
                this.contractnoProp();
            }
        }
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        String key;
        Control source = (Control)e.getSource();
        switch (key = source.getKey()) {
            case "businesscode": {
                if (!EmptyUtil.isNoEmpty((Object)e.getValue()) || "other".equals(this.getModel().getValue("bizbilltype"))) break;
                e.setCancel(true);
                this.getView().updateView("businesscode");
                this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditBatchEdit_3.loadKDString());
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "contractno": {
                this.creditConF7(evt);
                break;
            }
            case "finorginfo": {
                this.bankF7(evt);
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String actionId;
        super.closedCallBack(evt);
        switch (actionId = evt.getActionId()) {
            case "showBizBillList": {
                this.bizBusinessCodeCloseBack(evt);
                break;
            }
            case "closeCallbackKey": {
                this.creditNocloseBack(evt);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if (!args.getOperateKey().equals("refresh") && args.getOperationResult().isSuccess() && !"delete".equals(args.getOperateKey())) {
            this.getView().invokeOperation("refresh");
        }
    }

    public void initReleaseValue() {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Object operType = customParams.get("operateType");
        if (UseCreditOperateTypeEnum.RELEASE.getValue().equals(operType)) {
            DynamicObject creBill = UseCreditHelper.loadSingleUseCreditById((Long)((Long)customParams.get("useCreditId")));
            IDataModel model = this.getView().getModel();
            model.setValue("bindid", creBill.get("bindid"));
            model.setValue("rootid", creBill.getPkValue());
            model.setValue("org", creBill.get("org"));
            model.setValue("banktype", (Object)creBill.getString("banktype"));
            model.setValue("finorginfo", (Object)creBill.getDynamicObject("finorginfo"));
            model.setValue("credittype", (Object)creBill.getDynamicObject("credittype"));
            model.setValue("changetype", (Object)UseCreditChangeTypeEnum.RELEASE.getValue());
            BigDecimal creditAmt = creBill.getBigDecimal("businessamount").subtract(creBill.getBigDecimal("amountreleased"));
            model.setValue("releaseamount", (Object)creditAmt);
            model.setValue("creditproduct", creBill.get("creditproduct"));
            model.setValue("bizbilltype", creBill.get("bizbilltype"));
            model.setValue("businesscode", creBill.get("businesscode"));
            model.setValue("startdate", creBill.get("startdate"));
            model.setValue("expiredate", creBill.get("expiredate"));
            model.setValue("currency", (Object)creBill.getDynamicObject("currency"));
            model.setValue("businessamount", creBill.get("businessamount"));
            model.setValue("remark", creBill.get("remark"));
            model.setValue("description", creBill.get("description"));
            model.setValue("uniquecode", (Object)UUID.randomUUID().toString());
            DynamicObject creditLimit = creBill.getDynamicObject("contractno");
            DynamicObject realCreditLimit = CreditLimitHelper.getRealCreditLimit((DynamicObject)creditLimit);
            model.setValue("contractno", (Object)realCreditLimit);
            DynamicObjectCollection creditUses = CreditLimitHelper.queryCreditUses((Long)Long.parseLong(creBill.getString("bindid")), null, null, (String)"realamt,currency,creditlimit");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditUses) && realCreditLimit != null) {
                DynamicObject creditUse = creditUses.stream().filter(o -> o.getLong("creditlimit") == realCreditLimit.getLong("id")).findFirst().orElse(null);
                if (EmptyUtil.isEmpty((DynamicObject)creditUse)) {
                    return;
                }
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"creditcurrency", (Object)creditUse.get("currency"));
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"creditamount", (Object)creditUse.get("realamt"));
            }
        }
    }

    private void setCreditAmt() {
        Object bindId = this.getModel().getValue("bindid");
        DynamicObject contractNo = (DynamicObject)this.getModel().getValue("contractno");
        if (EmptyUtil.isEmpty((DynamicObject)contractNo)) {
            return;
        }
        DynamicObject realCreditLimit = CreditLimitHelper.getRealCreditLimit((DynamicObject)contractNo);
        long bizEntryId = (Long)this.getModel().getValue("bizentryid");
        DynamicObjectCollection creditUses = CreditLimitHelper.queryCreditUses((Long)Long.parseLong(String.valueOf(bindId)), null, (Long)(EmptyUtil.isNoEmpty((Long)bizEntryId) ? Long.valueOf(bizEntryId) : null), (String)"realamt,currency,creditlimit");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditUses) && realCreditLimit != null) {
            DynamicObject creditUse = creditUses.stream().filter(o -> o.getLong("creditlimit") == realCreditLimit.getLong("id")).findFirst().orElse(null);
            if (EmptyUtil.isEmpty((DynamicObject)creditUse)) {
                return;
            }
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"creditcurrency", (Object)creditUse.get("currency"));
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)this.getModel(), (String)"lockamount", (Object)creditUse.get("realamt"));
        }
    }

    private void bizBillTypeChange() {
        this.lockByBillType();
        IDataModel model = this.getModel();
        model.setValue("finorginfo", null);
        model.setValue("credittype", null);
        model.setValue("creditproduct", (Object)"");
        model.setValue("startdate", null);
        model.setValue("expiredate", null);
        model.setValue("currency", null);
        model.setValue("businessamount", (Object)BigDecimal.ZERO);
        model.setValue("creditamount", (Object)BigDecimal.ZERO);
        model.setValue("contractno", null);
        model.setValue("bizentryid", (Object)0);
        model.setValue("bindid", (Object)DB.genLongId((String)"t_cfm_use_credit"));
    }

    private void lockByBillType() {
        String bizBillType = (String)this.getModel().getValue("bizbilltype");
        this.getView().setEnable(Boolean.valueOf("other".equals(bizBillType)), new String[]{"finorginfo", "credittype", "creditproduct", "startdate", "expiredate", "currency", "businessamount"});
        if ("cfm_loanbill_bond".equals(bizBillType) || bizBillType.endsWith("#sl")) {
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"finorginfo"});
        }
    }

    private void showBizBillList() {
        QFilter customQfilter;
        String bizBilltype = (String)this.getModel().getValue("bizbilltype");
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue("org"))) {
            this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditBatchEdit_2.loadKDString());
            return;
        }
        if ("other".equals(bizBilltype)) {
            this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditBatchEdit_1.loadKDString());
            return;
        }
        String formId = UseCreditBatchHeper.getFormId(bizBilltype);
        ListShowParameter showListForm = ShowFormHelper.createShowListForm((String)formId, (boolean)false);
        QFilter filter = UseCreditHelper.getBizQfilter((DynamicObject)this.getConfig(bizBilltype), (DynamicObject)((DynamicObject)this.getModel().getValue("org")));
        String bankType = (String)this.getModel().getValue("banktype");
        if ("cfm_creditlimit".equals(bizBilltype)) {
            filter.and("banktype", "=", (Object)bankType);
            showListForm.setFormId("bos_listf7");
        }
        if ((customQfilter = UseCreditBatchHeper.getCustomQfilter(bankType, bizBilltype)) != null) {
            filter.and(customQfilter);
        }
        showListForm.getListFilterParameter().getQFilters().add(filter);
        showListForm.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "showBizBillList"));
        this.getView().showForm((FormShowParameter)showListForm);
    }

    private void creditNocloseBack(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        if (returnData instanceof String) {
            CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
            IDataModel model = this.getModel();
            Long creditLimitId = res.getCreditLimitId();
            DynamicObject creditLimitDynamicObject = this.getCreditLimitById(creditLimitId);
            model.setValue("creditamount", (Object)res.getRealBizAmt());
            model.setValue("contractno", (Object)creditLimitId);
            model.setValue("creditcurrency", creditLimitDynamicObject.get("currency"));
            model.setValue("lockamount", (Object)res.getExchangeAmt());
        }
    }

    private void bizBusinessCodeCloseBack(ClosedCallBackEvent evt) {
        ListSelectedRowCollection returnDatas = (ListSelectedRowCollection)evt.getReturnData();
        if (EmptyUtil.isNoEmpty((Object)returnDatas)) {
            String endProp;
            Object bizId = returnDatas.get(0).getPrimaryKeyValue();
            String bindId = (String)this.getModel().getValue("bindid");
            if (bindId != null && bindId.equals(String.valueOf(bizId))) {
                return;
            }
            DynamicObject config = this.getConfig((String)this.getModel().getValue("bizbilltype"));
            if (EmptyUtil.isEmpty((DynamicObject)config)) {
                return;
            }
            String creditEntry = config.getString("creditentry");
            Map selectProps = UseCreditHelper.getSelectProps((DynamicObject)config);
            DynamicObject bizBill = UseCreditHelper.getBizBill((DynamicObject)config, (Object)bizId);
            IDataModel model = this.getModel();
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)model, (String)"businesscode", (Object)bizBill.get((String)selectProps.get("billnoprop")));
            TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"bindid", (Object)bizBill.getPkValue());
            model.setValue("currency", bizBill.get((String)selectProps.get("currencyprop")));
            String startProp = (String)selectProps.get("startdateprop");
            if (EmptyUtil.isNoEmpty((String)startProp)) {
                model.setValue("startdate", bizBill.get(startProp));
            }
            if (EmptyUtil.isNoEmpty((String)(endProp = (String)selectProps.get("enddateprop")))) {
                model.setValue("expiredate", bizBill.get(endProp));
            }
            String creditorField = (String)selectProps.get("creditot");
            if (EmptyUtil.isNoEmpty((String)creditEntry)) {
                DynamicObjectCollection entrys = bizBill.getDynamicObjectCollection(creditEntry);
                if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
                    return;
                }
                String bankType = (String)this.getModel().getValue("banktype");
                Map<String, String> creditorTypeMap = UseCreditBatchHeper.creditorTypeMap();
                Set creditTypes = creditorTypeMap.entrySet().stream().filter(o -> ((String)o.getValue()).equals(bankType)).map(o -> (String)o.getKey()).collect(Collectors.toSet());
                String creditProp = ((String)selectProps.get("creditprop")).replace(creditEntry, "").replace(".", "");
                DynamicObject entry = entrys.stream().filter(o -> EmptyUtil.isEmpty((Object)o.get(creditProp))).findFirst().orElse(null);
                if ("cfm_loanbill_bond".equals(bizBill.getDynamicObjectType().getName())) {
                    entry = entrys.stream().filter(o -> creditTypes.contains(o.getString("e_investortype")) && EmptyUtil.isEmpty((Object)o.get(creditProp))).findFirst().orElse(null);
                }
                if (EmptyUtil.isEmpty((DynamicObject)entry)) {
                    return;
                }
                TmcViewInputHelper.setValWithoutDataChanged((IDataModel)model, (String)"bizentryid", (Object)entry.getPkValue());
                Map entryCreditAmount = UseCreditHelper.getEntryCreditAmount((DynamicObject)config, (DynamicObject)bizBill);
                Object finOrg = entry != null ? entry.get(creditorField.replace(creditEntry, "").replace(".", "")) : null;
                long finOrgId = 0L;
                if (finOrg != null) {
                    finOrgId = finOrg instanceof DynamicObject ? ((DynamicObject)finOrg).getLong("id") : ((Long)finOrg).longValue();
                }
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finorginfo", (Object)finOrgId);
                model.setValue("businessamount", (Object)(EmptyUtil.isNoEmpty((Long)finOrgId) ? entryCreditAmount.getOrDefault(finOrgId, BigDecimal.ZERO) : BigDecimal.ZERO));
            } else {
                TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"finorginfo", (Object)bizBill.get(creditorField));
                model.setValue("businessamount", (Object)UseCreditHelper.getCreditAmount((DynamicObject)config, (DynamicObject)bizBill));
            }
            String creditTypeProp = (String)selectProps.get("credittype");
            Object creditProduct = bizBill.get(creditTypeProp);
            if (EmptyUtil.isNoEmpty((Object)creditProduct)) {
                String fieldType = (String)selectProps.get("credittype_T");
                String fieldProp = (String)selectProps.get("credittype_P");
                if (UseCreditBatchHeper.isDynamicObject(fieldType) && EmptyUtil.isNoEmpty((String)fieldProp)) {
                    model.setValue("credittype", ((DynamicObject)creditProduct).get(fieldProp));
                    model.setValue("creditproduct", ((DynamicObject)creditProduct).get("name"));
                } else {
                    model.setValue("credittype", creditProduct);
                }
            }
        }
    }

    private void getBizTypeCombos() {
        ComboEdit comTypes = (ComboEdit)this.getView().getControl("bizbilltype");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>();
        if (useConfigMap.size() > 0) {
            List filterConfigs = useConfigMap.entrySet().stream().filter(o -> ((String)((DynamicObject)o.getValue()).get("banktypecoms")).contains((String)this.getModel().getValue("banktype"))).collect(Collectors.toList());
            filterConfigs.sort(Comparator.comparing(o -> ((DynamicObject)o.getValue()).getInt("order")));
            for (Map.Entry config : filterConfigs) {
                ComboItem item = new ComboItem();
                item.setValue((String)config.getKey());
                item.setCaption(new LocaleString(((DynamicObject)config.getValue()).getString("name")));
                comboItems.add(item);
            }
            comboItems.add(new ComboItem(new LocaleString(CreditmFormResourceEnum.UseCreditBatchEdit_0.loadKDString()), "other"));
            comTypes.setComboItems(comboItems);
        }
    }

    protected void afterNewPage() {
        DynamicObject currentPermOrg = TmcOrgDataHelper.getCurrentPermOrg((String)"creditm", (String)"cfm_use_credit_dynamic", (String)"47156aff000000ac");
        this.getModel().setValue("org", currentPermOrg.getPkValue());
        this.getModel().setValue("changetype", (Object)UseCreditChangeTypeEnum.LOCK.getValue());
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"releaseamount", "amountreleased"});
    }

    private void creditConF7(BeforeF7SelectEvent evt) {
        DynamicObject dataEntity = this.getModel().getDataEntity();
        String errorMessage = UseCreditHelper.checkRow((DynamicObject)this.getModel().getDataEntity());
        if (errorMessage.length() > 0) {
            this.getView().showErrorNotification(errorMessage);
            evt.setCancel(true);
            return;
        }
        if ("cfm_creditlimit".equals(dataEntity.getString("bizbilltype"))) {
            this.showCreditLimit(evt, dataEntity);
            return;
        }
        CreditLimitUseBean creditLimitUseBean = new CreditLimitUseBean();
        this.fillCreditLimitUseBean(creditLimitUseBean, dataEntity, evt);
    }

    private void showCreditLimit(BeforeF7SelectEvent evt, DynamicObject dataEntity) {
        DynamicObject creditType = dataEntity.getDynamicObject("credittype");
        DynamicObject org = (DynamicObject)this.getModel().getValue("org");
        String bankType = dataEntity.getString("banktype");
        DynamicObject bank = dataEntity.getDynamicObject("finorginfo");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        BigDecimal totalAmt = dataEntity.getBigDecimal("creditamount");
        QFilter frameFilter = CreditFrameworkHelper.getFrameLimitFilter((long)org.getLong("id"), (DynamicObject)bank, (String)bankType, (DynamicObject)creditType, (long)currency.getLong("id"), (BigDecimal)totalAmt);
        ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
        parameter.getListFilterParameter().getQFilters().add(frameFilter);
        parameter.setCaption(CreditmFormResourceEnum.UseCreditDynamicPlugin_2.loadKDString());
        parameter.setFormId("bos_listf7");
        parameter.setCustomParam("isframework", (Object)true);
        parameter.getCustomParams().put("totalamt", totalAmt);
        parameter.getCustomParams().put("org", org.getLong("id"));
        parameter.getCustomParams().put("credittype", creditType.getLong("id"));
    }

    private void bankF7(BeforeF7SelectEvent evt) {
        DynamicObject finOrg;
        String bankType = (String)this.getModel().getValue("banktype");
        if (EmptyUtil.isEmpty((String)bankType)) {
            return;
        }
        String bizBillType = (String)this.getModel().getValue("bizbilltype");
        String code = (String)this.getModel().getValue("businesscode");
        if (!"other".equals(bizBillType) && EmptyUtil.isEmpty((String)code)) {
            evt.setCancel(true);
            this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditBillEdit_1.loadKDString());
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter filter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()).and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (CreditFinTypeEnum.ORG.getValue().equals(bankType)) {
            showParameter.setCustomParam("orgFuncId", (Object)"08");
        }
        if ("cfm_loanbill_bond".equals(bizBillType) || bizBillType.endsWith("#sl")) {
            String bindId = (String)this.getModel().getValue("bindid");
            DynamicObject config = this.getConfig((String)this.getModel().getValue("bizbilltype"));
            String creditProp = config.getString("creditprop");
            String creditorId = this.getCreditorField(config);
            QFilter bizQfilter = UseCreditHelper.getBizQfilter((DynamicObject)config, (DynamicObject)((DynamicObject)this.getModel().getValue("org")));
            DynamicObjectCollection bills = QueryServiceHelper.query((String)"cfm_loanbill_bond", (String)(creditProp + "," + creditorId), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(bindId)).and(bizQfilter)});
            Set creditorIds = bills.stream().map(o -> o.getLong(creditorId)).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(creditorIds)) {
                filter.and(new QFilter("id", "in", creditorIds));
            }
        }
        if (EmptyUtil.isNoEmpty((DynamicObject)(finOrg = (DynamicObject)this.getModel().getValue("finorginfo")))) {
            showParameter.setSelectedRow(finOrg.getPkValue());
        }
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    private void fillCreditLimitUseBean(CreditLimitUseBean bean, DynamicObject row, BeforeF7SelectEvent evt) {
        bean.setPkId(Long.valueOf(row.getLong("bindid")));
        long bizEntryId = row.getLong("bizentryid");
        if (EmptyUtil.isNoEmpty((Long)bizEntryId)) {
            bean.setSourceBillEntryId(Long.valueOf(bizEntryId));
        }
        String entityName = "cfm_use_credit";
        boolean isPre = false;
        if (!"other".equals(row.getString("bizbilltype"))) {
            DynamicObject useConfig = UseCreditHelper.getUseConfig((String)row.getString("bizbilltype"));
            if (EmptyUtil.isEmpty((DynamicObject)useConfig)) {
                evt.setCancel(true);
                this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditDynamicPlugin_0.loadKDString());
                return;
            }
            entityName = useConfig.getDynamicObject("biztype").getString("number");
            isPre = useConfig.getBoolean("ispre");
        }
        bean.setEntityName(entityName);
        bean.setOrgId((Long)((DynamicObject)this.getModel().getValue("org")).getPkValue());
        bean.setFinOrgId((Long)row.getDynamicObject("finorginfo").getPkValue());
        Long currencyId = (Long)row.getDynamicObject("currency").getPkValue();
        bean.setCurrencyId(currencyId);
        DynamicObject creditType = row.getDynamicObject("credittype");
        Long creditTypeId = creditType != null ? (Long)row.getDynamicObject("credittype").getPkValue() : 0L;
        bean.setCreditTypeId(creditTypeId);
        bean.setCreditVariety(row.getString("creditproduct"));
        bean.setBizAmt(row.getBigDecimal("creditamount"));
        bean.setMaxAmt(row.getBigDecimal("businessamount"));
        bean.setRealAmt(row.getBigDecimal("discreditamount"));
        bean.setRealScale(row.getBigDecimal("creditrate"));
        bean.setStartDate(row.getDate("startdate"));
        bean.setEndDate(row.getDate("expiredate"));
        bean.setCreditRatio(row.getBigDecimal("creditamount").multiply(Constants.ONE_HUNDRED).divide(row.getBigDecimal("businessamount"), 8, RoundingMode.DOWN));
        bean.setPreOccupy(Boolean.valueOf(isPre));
        bean.setCreditFinType(row.getString("banktype"));
        DynamicObject credit = row.getDynamicObject("contractno");
        if (credit != null) {
            bean.setCreditLimitId(Long.valueOf(credit.getLong("id")));
        }
        FormShowParameter sp = evt.getFormShowParameter();
        sp.setCustomParam("KEY_F7PARAM", (Object)bean);
        sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_KEY));
    }

    private DynamicObject getCreditLimitById(Long creditLimitId) {
        return BusinessDataServiceHelper.loadSingle((Object)creditLimitId, (String)"cfm_creditlimit", (String)"id, currency.id, creditprop");
    }

    private void loadConfigMap() {
        DynamicObject[] useConfigArrs;
        for (DynamicObject config : useConfigArrs = this.getConfigArrs()) {
            String entityName = config.getString("biztypenum");
            if (EmptyUtil.isEmpty((String)entityName)) {
                entityName = config.getDynamicObject("biztype").getString("number");
            }
            useConfigMap.put(entityName, config);
        }
    }

    private DynamicObject[] getConfigArrs() {
        DynamicObjectCollection configs = QueryServiceHelper.query((String)"creditm_useconfig", (String)"id", (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())});
        return TmcDataServiceHelper.load((Object[])configs.parallelStream().map(o -> o.getLong("id")).toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"creditm_useconfig"));
    }

    private DynamicObject getConfig(String bizBilltype) {
        if (useConfigMap.size() == 0) {
            this.loadConfigMap();
        }
        return useConfigMap.get(bizBilltype);
    }

    private void clearVal() {
        Object changeType = this.getModel().getValue("changetype");
        if (UseCreditChangeTypeEnum.LOCK.getValue().equals(changeType)) {
            TmcViewInputHelper.clearValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String[])new String[]{"creditrate", "discreditamount"});
            this.getModel().setValue("contractno", null);
            this.getModel().setValue("creditcurrency", null);
        }
    }

    private String getCreditorField(DynamicObject config) {
        DynamicObjectCollection configEntrys = config.getDynamicObjectCollection("entryentity");
        DynamicObject configEntry = configEntrys.stream().filter(o -> "creditot".equals(o.getString("field"))).findFirst().orElse(null);
        String creditorId = configEntry != null ? configEntry.getString("fieldname") : "";
        return creditorId;
    }

    private void setEntryIdFromFinorg() {
        String bizType = (String)this.getModel().getValue("bizbilltype");
        DynamicObject config = this.getConfig(bizType);
        if (EmptyUtil.isEmpty((DynamicObject)config)) {
            return;
        }
        String creditEntry = config.getString("creditentry");
        if (EmptyUtil.isEmpty((String)creditEntry)) {
            return;
        }
        String bindId = (String)this.getModel().getValue("bindid");
        DynamicObject finOrg = (DynamicObject)this.getModel().getValue("finorginfo");
        if (EmptyUtil.isEmpty((DynamicObject)finOrg)) {
            this.getModel().setValue("bizentryid", (Object)0);
            return;
        }
        String amtProp = config.getString("amtprop");
        String creditorField = this.getCreditorField(config);
        String entityName = config.getDynamicObject("biztype").getString("number");
        DynamicObjectCollection bills = QueryServiceHelper.query((String)entityName, (String)(creditEntry + "," + amtProp), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)Long.parseLong(bindId)).and(creditorField, "=", finOrg.getPkValue())});
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)bills)) {
            DynamicObject bill = (DynamicObject)bills.get(0);
            this.getModel().setValue("bizentryid", (Object)bill.getLong(creditEntry));
            this.getModel().setValue("businessamount", (Object)bill.getBigDecimal(amtProp));
        }
    }

    private void businessAmount() {
        BigDecimal amount = (BigDecimal)this.getModel().getValue("businessamount");
        this.getModel().setValue("creditamount", (Object)amount);
    }

    private void businessCodeProp() {
        if ("other".equals(this.getModel().getValue("bizbilltype"))) {
            return;
        }
        this.bizBillTypeChange();
    }

    private void contractnoProp() {
        Object creditLimit = this.getModel().getValue("contractno");
        if (EmptyUtil.isNoEmpty((Object)creditLimit)) {
            this.getModel().setValue("creditcurrency", (Object)((DynamicObject)creditLimit).getDynamicObject("currency"));
            this.getModel().setValue("lockamount", this.getModel().getValue("creditamount"));
        }
    }
}

