/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.usecredit;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.AfterAddRowEventArgs;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.creditm.common.enums.UseCreditOperateTypeEnum;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.UseCreditHelper;
import kd.tmc.creditm.formplugin.resources.CreditmFormResourceEnum;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.helper.TmcOrgDataHelper;
import kd.tmc.fbp.common.helper.TmcViewInputHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UseCreditDynamicPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    private static Log logger = LogFactory.getLog(UseCreditDynamicPlugin.class);
    private static final String CLOSE_CALLBACK_KEY = "closeCallbackKey";
    private static final String SAVE = "save";
    private static final String COMPANY_DY = "companydy";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit bank = (BasedataEdit)this.getView().getControl("finorginfo");
        bank.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contractNofieldEdit = (BasedataEdit)this.getView().getControl("contractno");
        contractNofieldEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit contractNotileEdit = (BasedataEdit)this.getView().getControl("contractnotile");
        contractNotileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit finOrgInfoTileEdit = (BasedataEdit)this.getView().getControl("finorginfotile");
        finOrgInfoTileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit creditTypeTileEdit = (BasedataEdit)this.getView().getControl("credittypetile");
        creditTypeTileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit creditBusinessTypeTileEdit = (BasedataEdit)this.getView().getControl("creditbusinesstypetile");
        creditBusinessTypeTileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit currencyTileEdit = (BasedataEdit)this.getView().getControl("currencytile");
        currencyTileEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit company = (BasedataEdit)this.getView().getControl(COMPANY_DY);
        company.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        this.addItemClickListeners(new String[]{"toolbarap"});
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object operType = formShowParameter.getCustomParam("operateType");
        if (Objects.equals(UseCreditOperateTypeEnum.NEW.getValue(), operType)) {
            this.afterNewPage();
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"unsubmit", "audit", "unaudit"});
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name;
        switch (name = e.getProperty().getName()) {
            case "creditamount": 
            case "currency": 
            case "finorginfo": 
            case "credittype": 
            case "startdate": 
            case "expiredate": {
                int rowIdx = this.getModel().getEntryCurrentRowIndex("usecreditdetails");
                this.getModel().setValue("contractno", null, rowIdx);
                this.getModel().setValue("creditcurrency", null, rowIdx);
                this.getModel().setValue("creditrate", null, rowIdx);
                this.getModel().setValue("discreditamount", null, rowIdx);
                break;
            }
            case "companydy": 
            case "bizdate": {
                int entryRowCount = this.getModel().getEntryRowCount("usecreditdetails");
                for (int i = 0; i < entryRowCount; ++i) {
                    this.getModel().setValue("contractno", null, i);
                    this.getModel().setValue("creditcurrency", null, i);
                    this.getModel().setValue("creditrate", null, i);
                    this.getModel().setValue("discreditamount", null, i);
                    String bizBillType = (String)this.getModel().getValue("bizbilltype", i);
                    if ("other".equals(bizBillType)) continue;
                    this.getModel().setValue("businesscode", null, i);
                }
                break;
            }
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        DynamicObjectCollection dynamicObjectCollection;
        super.itemClick((ItemClickEvent)evt);
        String itemKey = evt.getItemKey();
        if ((Objects.equals(itemKey, SAVE) || Objects.equals(itemKey, "submit")) && (dynamicObjectCollection = this.getModel().getEntryEntity("usecreditdetails")).isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u5206\u5f55\u6570\u636e\u3002", (String)"UseCreditDynamicPlugin_1", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        super.itemClick(evt);
        String itemKey = evt.getItemKey();
        IDataModel model = this.getModel();
        DynamicObjectCollection dynamicObjectCollection = model.getEntryEntity("usecreditdetails");
        DynamicObject[] dynamicObjectArr = new DynamicObject[dynamicObjectCollection.size()];
        switch (itemKey) {
            case "submit": {
                this.fillDynamicObjectArr(dynamicObjectArr, dynamicObjectCollection);
                this.execOperate("submit", dynamicObjectArr);
                this.execDelete(dynamicObjectCollection);
                this.controlBotton(BillStatusEnum.SUBMIT.getValue());
                break;
            }
            case "save": {
                this.fillDynamicObjectArr(dynamicObjectArr, dynamicObjectCollection);
                this.execOperate(SAVE, dynamicObjectArr);
                this.execDelete(dynamicObjectCollection);
                break;
            }
            case "audit": {
                this.execOperate("audit");
                this.controlBotton(BillStatusEnum.AUDIT.getValue());
                break;
            }
            case "unaudit": {
                this.execOperate("unaudit");
                this.controlBotton(BillStatusEnum.SAVE.getValue());
                break;
            }
            case "unsubmit": {
                this.execOperate("unsubmit");
                this.controlBotton(BillStatusEnum.SAVE.getValue());
            }
        }
    }

    public void afterAddRow(AfterAddRowEventArgs e) {
        if (EmptyUtil.isNoEmpty((Object[])e.getRowDataEntities())) {
            IFormView view = this.getView();
            IDataModel model = view.getModel();
            int insertRow = e.getRowDataEntities()[0].getRowIndex();
            int curRowIdx = model.getEntryCurrentRowIndex("usecreditdetails");
            model.beginInit();
            model.setValue("changetype", (Object)UseCreditChangeTypeEnum.LOCK.getValue(), insertRow);
            String bizType = (String)model.getValue("bizbilltype", curRowIdx);
            if (this.getPageCache().get("copyentry") != null) {
                if (!"other".equals(bizType)) {
                    model.setValue("finorginfo", null, insertRow);
                    model.setValue("credittype", null, insertRow);
                    model.setValue("creditproduct", null, insertRow);
                    model.setValue("startdate", null, insertRow);
                    model.setValue("expiredate", null, insertRow);
                    model.setValue("businessamount", (Object)0, insertRow);
                    model.setValue("creditamount", (Object)0, insertRow);
                }
            } else {
                model.setValue("bizbilltype", (Object)"other", insertRow);
            }
            this.getPageCache().remove("copyentry");
            model.setValue("bindid", (Object)DB.genLongId((String)"t_cfm_use_credit"), insertRow);
            DynamicObject fundOrg = model.getDataEntity().getDynamicObject(COMPANY_DY);
            DynamicObject standardCurrency = TmcBusinessBaseHelper.getCasBaseCurrency((long)((Long)fundOrg.getPkValue()));
            model.setValue("currency", (Object)standardCurrency, insertRow);
            model.setValue("uniquecode", (Object)UUID.randomUUID().toString(), insertRow);
            model.endInit();
            view.updateView("usecreditdetails", insertRow);
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate op = (AbstractOperate)args.getSource();
        String key = op.getOperateKey();
        if ("copyentryrow".equals(key)) {
            this.getPageCache().put("copyentry", "1");
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key;
        switch (key = ((Control)evt.getSource()).getKey()) {
            case "contractno": 
            case "contractnotile": {
                this.contractChange(evt);
                break;
            }
            case "finorginfo": {
                this.bankF7(evt);
                break;
            }
            case "companydy": {
                this.companyF7(evt);
            }
        }
        List<String> multiSelectTileField = Arrays.asList("contractnotile", "finorginfotile", "credittypetile", "creditbusinesstypetile", "currencytile");
        if (multiSelectTileField.contains(key)) {
            ListShowParameter sp = (ListShowParameter)evt.getFormShowParameter();
            sp.setMultiSelect(false);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Objects.equals(actionId, CLOSE_CALLBACK_KEY) && (returnData = closedCallBackEvent.getReturnData()) instanceof String) {
            CreditLimitF7ResBean res = (CreditLimitF7ResBean)SerializationUtils.fromJsonString((String)((String)returnData), CreditLimitF7ResBean.class);
            IDataModel model = this.getModel();
            Long creditLimitId = res.getCreditLimitId();
            int rowIndex = this.getModel().getEntryCurrentRowIndex("usecreditdetails");
            this.getPageCache().put("creditamount", String.valueOf(res.getRealBizAmt()));
            this.getPageCache().put("creditrate", String.valueOf(res.getTransScale()));
            model.setValue("contractno", (Object)creditLimitId, rowIndex);
            TmcViewInputHelper.setValWithoutPropChgEvt((IFormView)this.getView(), (IDataModel)this.getModel(), (String)"creditamount", (Object)res.getRealBizAmt(), (int)rowIndex);
        }
    }

    private void companyF7(BeforeF7SelectEvent evt) {
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter qFilter = TmcOrgDataHelper.getAuthorizedBankOrgFilter((Long)RequestContext.get().getCurrUserId(), (String)"creditm", (String)"cfm_use_credit", (String)"47156aff000000ac");
        showParameter.getListFilterParameter().getQFilters().add(qFilter);
    }

    private void bankF7(BeforeF7SelectEvent evt) {
        String bankType = (String)this.getModel().getValue("banktype");
        if (EmptyUtil.isEmpty((String)bankType)) {
            return;
        }
        ListShowParameter showParameter = (ListShowParameter)evt.getFormShowParameter();
        QFilter filter = new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue()).and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        if (CreditFinTypeEnum.ORG.getValue().equals(bankType)) {
            showParameter.setCustomParam("orgFuncId", (Object)"08");
        }
        showParameter.getListFilterParameter().getQFilters().add(filter);
    }

    protected void afterNewPage() {
        String selectCompany = (String)this.getView().getFormShowParameter().getCustomParam("selectedFilterOrgs");
        List orgIdSet = TmcOrgDataHelper.getAuthorizedBankOrgId((Long)RequestContext.get().getCurrUserId(), (String)"creditm", (String)"cfm_use_credit", (String)"47156aff000000ac");
        if (selectCompany != null && !orgIdSet.contains(Long.parseLong(selectCompany)) || selectCompany == null) {
            selectCompany = String.valueOf(orgIdSet.get(0));
        }
        this.getModel().setValue(COMPANY_DY, (Object)Long.parseLong(selectCompany));
        this.getModel().setValue("groupid", (Object)UUID.randomUUID().toString());
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("usecreditdetails");
        DynamicObject fundOrg = this.getModel().getDataEntity().getDynamicObject(COMPANY_DY);
        DynamicObject standardCurrency = TmcBusinessBaseHelper.getCasBaseCurrency((long)((Long)fundOrg.getPkValue()));
        for (DynamicObject dynamicObject : entryEntity) {
            dynamicObject.set("changetype", (Object)UseCreditChangeTypeEnum.LOCK.getValue());
            dynamicObject.set("currency", (Object)standardCurrency);
            dynamicObject.set("bindid", (Object)DB.genLongId((String)"t_cfm_use_credit"));
            dynamicObject.set("uniquecode", (Object)UUID.randomUUID().toString());
        }
        this.getView().setVisible(Boolean.valueOf(false), new String[]{"releaseamount", "amountreleased"});
    }

    private void contractChange(BeforeF7SelectEvent evt) {
        if (EmptyUtil.isEmpty((Object)this.getModel().getValue(COMPANY_DY))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u8d44\u91d1\u7ec4\u7ec7\u3002", (String)"UseCreditDynamicPlugin_0", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
            evt.setCancel(true);
            return;
        }
        int rowIdx = evt.getRow();
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("usecreditdetails");
        DynamicObject entry = (DynamicObject)entryEntity.get(rowIdx);
        String errorMessage = UseCreditHelper.checkRow((DynamicObject)entry);
        if (errorMessage.length() > 0) {
            this.getView().showErrorNotification(errorMessage);
            evt.setCancel(true);
            return;
        }
        if ("cfm_creditlimit".equals(entry.getString("bizbilltype"))) {
            this.showCreditLimit(evt, entry);
            return;
        }
        this.fillCreditLimitUseBean(entry, evt);
    }

    private void showCreditLimit(BeforeF7SelectEvent evt, DynamicObject dataEntity) {
        DynamicObject creditType = dataEntity.getDynamicObject("credittype");
        DynamicObject org = (DynamicObject)this.getModel().getValue(COMPANY_DY);
        String bankType = dataEntity.getString("banktype");
        DynamicObject bank = dataEntity.getDynamicObject("finorginfo");
        DynamicObject currency = dataEntity.getDynamicObject("currency");
        BigDecimal totalAmt = dataEntity.getBigDecimal("creditamount");
        QFilter frameFilter = CreditFrameworkHelper.getFrameLimitFilter((long)org.getLong("id"), (DynamicObject)bank, (String)bankType, (DynamicObject)creditType, (long)currency.getLong("id"), (BigDecimal)totalAmt);
        ListShowParameter parameter = (ListShowParameter)evt.getFormShowParameter();
        parameter.getListFilterParameter().getQFilters().add(frameFilter);
        parameter.setCaption(CreditmFormResourceEnum.UseCreditDynamicPlugin_2.loadKDString());
        parameter.setFormId("bos_listf7");
        parameter.setCustomParam("isframework", (Object)true);
        parameter.getCustomParams().put("totalamt", totalAmt);
        parameter.getCustomParams().put("org", org.getLong("id"));
        parameter.getCustomParams().put("credittype", creditType.getLong("id"));
    }

    private void fillCreditLimitUseBean(DynamicObject row, BeforeF7SelectEvent evt) {
        CreditLimitUseBean creditLimitUseBean = new CreditLimitUseBean();
        creditLimitUseBean.setPkId(Long.valueOf(row.getLong("bindid")));
        String entityName = "cfm_use_credit";
        boolean isPre = false;
        if (!"other".equals(row.getString("bizbilltype"))) {
            DynamicObject useConfig = UseCreditHelper.getUseConfig((String)row.getString("bizbilltype"));
            if (EmptyUtil.isEmpty((DynamicObject)useConfig)) {
                evt.setCancel(true);
                this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditDynamicPlugin_0.loadKDString());
                return;
            }
            entityName = useConfig.getDynamicObject("biztype").getString("number");
            isPre = useConfig.getBoolean("ispre");
        }
        creditLimitUseBean.setEntityName(entityName);
        creditLimitUseBean.setOrgId((Long)((DynamicObject)this.getModel().getValue(COMPANY_DY)).getPkValue());
        creditLimitUseBean.setFinOrgId((Long)row.getDynamicObject("finorginfo").getPkValue());
        Long currencyId = (Long)row.getDynamicObject("currency").getPkValue();
        creditLimitUseBean.setCurrencyId(currencyId);
        DynamicObject creditType = row.getDynamicObject("credittype");
        creditLimitUseBean.setCreditTypeId(Long.valueOf(creditType != null ? creditType.getLong("id") : 0L));
        creditLimitUseBean.setCreditVariety(row.getString("businesscode"));
        creditLimitUseBean.setBizAmt(row.getBigDecimal("creditamount"));
        creditLimitUseBean.setMaxAmt(row.getBigDecimal("businessamount"));
        creditLimitUseBean.setStartDate(row.getDate("startdate"));
        creditLimitUseBean.setEndDate(row.getDate("expiredate"));
        creditLimitUseBean.setRealScale(row.getBigDecimal("creditrate"));
        creditLimitUseBean.setCreditRatio(row.getBigDecimal("creditamount").multiply(Constants.ONE_HUNDRED).divide(row.getBigDecimal("businessamount"), 8, 1));
        creditLimitUseBean.setPreOccupy(Boolean.valueOf(isPre));
        creditLimitUseBean.setCreditFinType(row.getString("banktype"));
        creditLimitUseBean.setCreditVariety(row.getString("creditproduct"));
        creditLimitUseBean.setSourceBillEntryId(Long.valueOf(row.getLong("bizentryid")));
        DynamicObject credit = row.getDynamicObject("contractno");
        if (credit != null) {
            creditLimitUseBean.setCreditLimitId(Long.valueOf(credit.getLong("id")));
        }
        FormShowParameter sp = evt.getFormShowParameter();
        sp.setCustomParam("KEY_F7PARAM", (Object)creditLimitUseBean);
        sp.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CLOSE_CALLBACK_KEY));
    }

    private void execDelete(DynamicObjectCollection colls) {
        if (colls == null || Objects.equals(((DynamicObject)colls.get(0)).getString("changetype"), UseCreditChangeTypeEnum.RELEASE.getValue())) {
            return;
        }
        String groupId = (String)this.getModel().getValue("groupid");
        DynamicObject[] creditGroupObjs = UseCreditHelper.loadUseCreditsByGroupId((String)groupId);
        Set currentSubmitBindIdSet = colls.stream().map(d -> d.get("bindid")).collect(Collectors.toSet());
        Set fromDbDynamicObjectSet = Arrays.stream(creditGroupObjs).collect(Collectors.toSet());
        fromDbDynamicObjectSet.removeIf(r -> currentSubmitBindIdSet.contains(((DynamicObject)r).get("bindid")));
        if (!fromDbDynamicObjectSet.isEmpty()) {
            TmcOperateServiceHelper.execOperate((String)"delete", (String)"cfm_use_credit", (Object[])fromDbDynamicObjectSet.stream().map(f -> ((DynamicObject)f).getPkValue()).distinct().toArray(Object[]::new), (OperateOption)this.getOperateOption());
        }
    }

    private void execOperate(String operationKey, DynamicObject[] creditUseArr) {
        try {
            TmcOperateServiceHelper.execOperate((String)operationKey, (String)"cfm_use_credit", (DynamicObject[])creditUseArr, (OperateOption)this.getOperateOption());
        }
        catch (Exception e) {
            logger.error(operationKey + "\u5f02\u5e38", (Throwable)e);
            throw e;
        }
    }

    private void execOperate(String operationKey) {
        DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("usecreditdetails");
        Object[] bindIds = new Object[dynamicObjectCollection.size()];
        for (int i = 0; i < bindIds.length; ++i) {
            DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(i);
            DynamicObject loadById = UseCreditHelper.loadSingleUseCreditByUniqueCode((String)dynamicObject.getString("uniquecode"));
            bindIds[i] = loadById.getPkValue();
        }
        TmcOperateServiceHelper.execOperate((String)operationKey, (String)"cfm_use_credit", (Object[])bindIds, (OperateOption)this.getOperateOption());
    }

    private void fillDynamicObjectArr(DynamicObject[] dynamicObjectArr, DynamicObjectCollection colls) {
        IDataModel model = this.getModel();
        for (int i = 0; i < colls.size(); ++i) {
            DynamicObject useCredit;
            DynamicObject entry = (DynamicObject)colls.get(i);
            DynamicObject loadByUniqueCode = UseCreditHelper.loadUseCreditByUniqueCode((String)((DynamicObject)colls.get(i)).getString("uniquecode"));
            DynamicObject dynamicObject = useCredit = loadByUniqueCode == null ? BusinessDataServiceHelper.newDynamicObject((String)"cfm_use_credit") : loadByUniqueCode;
            if (loadByUniqueCode == null) {
                useCredit.set("creator", (Object)RequestContext.get().getCurrUserId());
                useCredit.set("createtime", (Object)new Date());
            }
            useCredit.set("bindid", entry.get("bindid"));
            useCredit.set("bizentryid", entry.get("bizentryid"));
            useCredit.set("rootid", entry.get("rootid"));
            useCredit.set("billstatus", (Object)BillStatusEnum.SAVE.getValue());
            useCredit.set("org", model.getValue(COMPANY_DY));
            useCredit.set("groupid", model.getValue("groupid"));
            useCredit.set("uniquecode", entry.get("uniquecode"));
            useCredit.set("bizdate", model.getValue("bizdate"));
            useCredit.set("banktype", entry.get("banktype"));
            useCredit.set("finorginfo", entry.get("finorginfo"));
            useCredit.set("credittype", entry.get("credittype"));
            useCredit.set("changetype", entry.get("changetype"));
            useCredit.set("bizbilltype", entry.get("bizbilltype"));
            useCredit.set("businesscode", entry.get("businesscode"));
            useCredit.set("startdate", entry.get("startdate"));
            useCredit.set("expiredate", entry.get("expiredate"));
            useCredit.set("currency", entry.get("currency"));
            useCredit.set("businessamount", entry.get("businessamount"));
            useCredit.set("creditamount", entry.get("creditamount"));
            useCredit.set("contractno", entry.get("contractno"));
            DynamicObject creditLimit = entry.getDynamicObject("contractno");
            if (creditLimit != null) {
                useCredit.set("creditcurrency", (Object)creditLimit.getDynamicObject("currency"));
            }
            useCredit.set("creditrate", entry.get("creditrate"));
            useCredit.set("discreditamount", entry.get("discreditamount"));
            useCredit.set("registrant", model.getValue("registrant"));
            useCredit.set("creditbusinesstype", entry.get("creditbusinesstype"));
            useCredit.set("creditproduct", entry.get("creditproduct"));
            useCredit.set("remark", entry.get("remark"));
            useCredit.set("description", model.getValue("description"));
            useCredit.set("releaseamount", entry.get("releaseamount"));
            dynamicObjectArr[i] = useCredit;
        }
    }

    private OperateOption getOperateOption() {
        OperateOption option = OperateOption.create();
        option.setVariableValue("strictvalidation", String.valueOf(true));
        option.setVariableValue("isDynamicBillOp", String.valueOf(true));
        return option;
    }

    private void controlBotton(String billStatus) {
        if (BillStatusEnum.SUBMIT.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"submit", SAVE, "unaudit", "newentry", "deleteentry", "copyentryrow"});
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"unsubmit", "audit"});
            this.getView().setEnable(Boolean.valueOf(false), new String[]{"usecreditdetails", "fieldsetpanelap"});
        } else if (BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"unaudit"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"audit", "unsubmit"});
        } else if (BillStatusEnum.SAVE.getValue().equals(billStatus)) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{SAVE, "submit", "newentry", "deleteentry", "copyentryrow"});
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"unaudit", "unsubmit", "audit"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"usecreditdetails", "fieldsetpanelap"});
        }
    }
}

