/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.usecredit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.bill.BillOperationStatus;
import kd.bos.bill.BillShowParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.Distinctable;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.query.WithDistinctable;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.tmc.creditm.common.enums.UseCreditOperateTypeEnum;
import kd.tmc.creditm.formplugin.resources.CreditmFormResourceEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import kd.tmc.fbp.formplugin.list.AbstractTmcListPlugin;

public class UseCreditListPlugin
extends AbstractTmcListPlugin {
    private static final String REFRESH_LIST = "refresh_list";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"tblnew"});
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn commonFilterColumn : commonFilterColumns) {
            List defaultValues = commonFilterColumn.getDefaultValues();
            if (!commonFilterColumn.getFieldName().startsWith("org") || defaultValues == null || defaultValues.size() <= 0) continue;
            this.getPageCache().put("selectedFilterOrgs", defaultValues.get(0).toString());
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        Map filterValues = args.getSearchClickEvent().getFilterValues();
        if (filterValues.containsKey("customfilter")) {
            List customfilter = (List)filterValues.get("customfilter");
            for (Map filteritem : customfilter) {
                String fieldName = ((List)filteritem.get("FieldName")).get(0).toString();
                List item = (List)filteritem.get("Value");
                if (!fieldName.startsWith("org") || item.isEmpty() || "".equals(item.get(0))) continue;
                this.getPageCache().put("selectedFilterOrgs", item.get(0).toString());
            }
        }
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        CommonFilterColumn filterCol = (CommonFilterColumn)args.getSource();
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"finorginfo.")) {
            args.getQFilters().addAll(Arrays.asList(this.getFinOrgFilter()));
        }
        if (StringUtils.startsWith((CharSequence)filterCol.getFieldName(), (CharSequence)"creditbusinesstype.")) {
            args.getQFilters().addAll(Arrays.asList(this.getCreditBusinessTypeFilter()));
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if (evt.getOperationResult() == null || !evt.getOperationResult().isSuccess()) {
            return;
        }
        switch (operateKey) {
            case "newdata": {
                this.popUseCreditNewWin();
                break;
            }
            case "release": {
                this.openRelease();
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if (Objects.equals(actionId, REFRESH_LIST)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void openRelease() {
        Long selectedId = this.getSelectedId();
        if (EmptyUtil.isNoEmpty((Long)selectedId)) {
            DynamicObject useCreditBill = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"cfm_use_credit", (String)"bizbilltype,contractno,businessamount,creditamount,amountreleased");
            if (!"other".equals(useCreditBill.getString("bizbilltype"))) {
                this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditListPlugin_0.loadKDString());
                return;
            }
            if (useCreditBill.getBigDecimal("businessamount").subtract(useCreditBill.getBigDecimal("amountreleased")).compareTo(BigDecimal.ZERO) <= 0) {
                this.getView().showTipNotification(CreditmFormResourceEnum.UseCreditListPlugin_1.loadKDString());
                return;
            }
            BillShowParameter parameter = new BillShowParameter();
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setBillStatus(BillOperationStatus.ADDNEW);
            parameter.setFormId("cfm_use_credit");
            parameter.setCustomParam("operateType", (Object)UseCreditOperateTypeEnum.RELEASE.getValue());
            parameter.setCustomParam("useCreditId", (Object)useCreditBill.getLong("id"));
            parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REFRESH_LIST));
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private QFilter[] getCreditBusinessTypeFilter() {
        DataSet dataSet = ORM.create().queryDataSet("cfm_use_credit", "cfm_use_credit", "creditbusinesstype.id", new QFilter[0], "creditbusinesstype.id", -1, (Distinctable)WithDistinctable.get());
        ArrayList idList = new ArrayList();
        dataSet.forEach(o -> idList.add(o.get(0)));
        return new QFilter[]{new QFilter("id", "in", idList)};
    }

    private QFilter[] getFinOrgFilter() {
        DataSet dataSet = ORM.create().queryDataSet("cfm_use_credit", "cfm_use_credit", "finorginfo.id", new QFilter[0], "finorginfo.id", -1, (Distinctable)WithDistinctable.get());
        ArrayList idList = new ArrayList();
        dataSet.forEach(o -> idList.add(o.get(0)));
        return new QFilter[]{new QFilter("id", "in", idList)};
    }

    private void popUseCreditNewWin() {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("cfm_use_credit_dynamic");
        showParameter.setCustomParam("operateType", (Object)UseCreditOperateTypeEnum.NEW.getValue());
        showParameter.setCustomParam("selectedFilterOrgs", (Object)this.getPageCache().get("selectedFilterOrgs"));
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, REFRESH_LIST));
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm(showParameter);
    }
}

