/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.formplugin.usecredit.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.tmc.creditm.common.helper.UseCreditHelper;
import kd.tmc.creditm.formplugin.usecredit.helper.UseCreditBean;
import kd.tmc.fbp.common.enums.CreditorTypeEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UseCreditBatchHeper {
    public static Map<String, String> creditorTypeMap() {
        HashMap<String, String> creditTypeMap = new HashMap<String, String>();
        creditTypeMap.put(CreditorTypeEnum.BANK.getValue(), "bd_finorginfo");
        creditTypeMap.put(CreditorTypeEnum.FINORG.getValue(), "bd_finorginfo");
        creditTypeMap.put(CreditorTypeEnum.SETTLECENTER.getValue(), "bd_finorginfo");
        creditTypeMap.put(CreditorTypeEnum.INNERUNIT.getValue(), "bos_org");
        creditTypeMap.put(CreditorTypeEnum.CUSTOM.getValue(), "bd_bizpartner");
        return creditTypeMap;
    }

    public static QFilter getCustomQfilter(String finType, String billType) {
        List<String> finOrgTypes = Arrays.asList("cfm_loancontract_ic_l", "cfm_loanbill_e_l", "cim_invest_contract", "cim_invest_loanbill", "cfm_loan_apply", "cfm_loanbill_bond");
        if (!finOrgTypes.contains(billType) || EmptyUtil.isEmpty((String)finType)) {
            return null;
        }
        Map<String, String> stringStringMap = UseCreditBatchHeper.creditorTypeMap();
        List creditorTypes = stringStringMap.entrySet().stream().filter(o -> finType.equals(o.getValue())).map(o -> (String)o.getKey()).collect(Collectors.toList());
        if (creditorTypes.size() == 0) {
            return null;
        }
        if ("cfm_loanbill_bond".equals(billType)) {
            return new QFilter("investor_entry.e_investortype", "in", creditorTypes);
        }
        return new QFilter("creditortype", "in", creditorTypes);
    }

    public static List<UseCreditBean> getUseCreditBeans(DynamicObject config, long bizId) {
        ArrayList<UseCreditBean> beans = new ArrayList<UseCreditBean>();
        DynamicObject bizBill = UseCreditHelper.getBizBill((DynamicObject)config, (Object)bizId);
        Map selPropMap = UseCreditHelper.getSelectProps((DynamicObject)config);
        String entry = (String)selPropMap.get("creditentry");
        String billNo = bizBill.getString((String)selPropMap.get("billnoprop"));
        String id = bizBill.getString("id");
        DynamicObject currency = bizBill.getDynamicObject((String)selPropMap.get("currencyprop"));
        long currencyId = currency != null ? currency.getLong("id") : 0L;
        Date startDate = bizBill.getDate((String)selPropMap.get("startdateprop"));
        Date endDate = bizBill.getDate((String)selPropMap.get("enddateprop"));
        UseCreditBean bean = null;
        String creditTypeProp = (String)selPropMap.get("credittype");
        Object creditProduct = bizBill.get(creditTypeProp);
        long creditTypeId = 0L;
        String creditProductStr = "";
        if (EmptyUtil.isNoEmpty((Object)creditProduct)) {
            String fieldType = (String)selPropMap.get("credittype_T");
            String fieldProp = (String)selPropMap.get("credittype_P");
            if (UseCreditBatchHeper.isDynamicObject(fieldType) && EmptyUtil.isNoEmpty((String)fieldProp)) {
                creditTypeId = ((DynamicObject)creditProduct).getLong(fieldProp);
                creditProductStr = ((DynamicObject)creditProduct).getString("name");
            } else {
                creditTypeId = Long.parseLong(String.valueOf(creditProduct));
            }
        }
        String creditorType = (String)selPropMap.get("creditot_T");
        String creditorField = (String)selPropMap.get("creditot");
        if (EmptyUtil.isEmpty((String)entry)) {
            bean = new UseCreditBean(billNo, id, currencyId, startDate, endDate, creditTypeId, creditProductStr);
            BigDecimal creditAmount = UseCreditHelper.getCreditAmount((DynamicObject)config, (DynamicObject)bizBill);
            bean.setBusinessAmount(creditAmount);
            UseCreditBatchHeper.setCreditor(bean, bizBill, creditorField, creditorType);
            beans.add(bean);
        } else {
            DynamicObjectCollection entryColls = bizBill.getDynamicObjectCollection(entry);
            Set entryFields = selPropMap.values().stream().filter(o -> o.contains(entry)).collect(Collectors.toSet());
            Map<String, String> creditorTypeMap = UseCreditBatchHeper.creditorTypeMap();
            Map entryCreditAmount = UseCreditHelper.getEntryCreditAmount((DynamicObject)config, (DynamicObject)bizBill);
            for (DynamicObject entryColl : entryColls) {
                BigDecimal amount;
                String creditProp;
                if (EmptyUtil.isNoEmpty((Object)entryColl.get(creditProp = config.getString("creditprop").replace(entry, "").replace(".", "")))) continue;
                bean = new UseCreditBean(billNo, id, currencyId, startDate, endDate, creditTypeId, creditProductStr);
                bean.setBizBillType(config.getString("biztypenum"));
                if ("cfm_loanbill_bond".equals(bean.getBizBillType())) {
                    bean.setBankType(creditorTypeMap.get(entryColl.getString("e_investortype")));
                }
                if (entryFields.contains(creditorField)) {
                    String feild = creditorField.replace(entry, "").replace(".", "");
                    UseCreditBatchHeper.setCreditor(bean, entryColl, feild, creditorType);
                } else {
                    UseCreditBatchHeper.setCreditor(bean, bizBill, creditorField, creditorType);
                }
                if (EmptyUtil.isEmpty((Long)bean.getFinorgInfoId()) || (amount = entryCreditAmount.getOrDefault(bean.getFinorgInfoId(), BigDecimal.ZERO)).compareTo(BigDecimal.ZERO) == 0) continue;
                bean.setBusinessAmount(amount);
                bean.setBizEntryId(entryColl.getLong("id"));
                beans.add(bean);
            }
        }
        return beans;
    }

    private static void setCreditor(UseCreditBean bean, DynamicObject bizBill, String creditorField, String creditorType) {
        if (UseCreditBatchHeper.isDynamicObject(creditorType)) {
            bean.setFinorgInfoId(bizBill.getDynamicObject(creditorField).getLong("id"));
        } else {
            bean.setFinorgInfoId(bizBill.getLong(creditorField));
        }
    }

    public static String getFormId(String bizType) {
        if (bizType.contains("#")) {
            return bizType.substring(0, bizType.indexOf("#"));
        }
        return bizType;
    }

    public static boolean isDynamicObject(String fieldType) {
        return "DynamicObject".equals(fieldType);
    }
}

