/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.webapi.controller;

import java.io.Serializable;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.util.ExceptionUtils;
import kd.tmc.creditm.business.service.creditlimit.CreditLimitService;
import kd.tmc.creditm.webapi.helper.CreditmApiHelper;
import kd.tmc.creditm.webapi.model.CreditLimitInfoModel;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

@ApiController(value="creditm", desc="\u6388\u4fe1\u989d\u5ea6\u53d6\u6d88\u5360\u7528")
@ApiMapping(value="/cancelUse")
public class CreditmCancelUseController
implements Serializable {
    private static final Log logger = LogFactory.getLog(CreditmCancelUseController.class);

    @ApiPostMapping(value="/", desc="\u6388\u4fe1\u989d\u5ea6\u53d6\u6d88\u5360\u7528")
    public CustomApiResult<String> cancelUse(@ApiParam(value="\u6388\u4fe1\u989d\u5ea6\u53d6\u6d88\u5360\u7528\u53c2\u6570", required=true) @ApiParam(value="\u6388\u4fe1\u989d\u5ea6\u53d6\u6d88\u5360\u7528\u53c2\u6570", required=true) CreditLimitInfoModel param) {
        CustomApiResult result = CreditmApiHelper.getApiSuccessResult();
        try {
            String checkRes = this.checkParam(param);
            if (EmptyUtil.isNoEmpty((String)checkRes)) {
                result.setStatus(false);
                result.setMessage(checkRes);
                return result;
            }
            logger.info("credit canceluse api, billid:{}", (Object)param.getId());
            CreditLimitService creditService = new CreditLimitService();
            CreditLimitInfo resInfo = creditService.cancelCreditLimit(this.getLimitInfo(param));
            if (!resInfo.isSuccess()) {
                logger.info("canceluse error:{}", (Object)resInfo.getMessage());
                return CreditmApiHelper.getApiFailResult(resInfo.getMessage());
            }
            CreditmApiHelper.deleteCreditUse(param.getEntityName(), param.getId());
        }
        catch (Exception e) {
            result = CreditmApiHelper.getApiFailResult(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error((Throwable)e);
        }
        return result;
    }

    private String checkParam(CreditLimitInfoModel param) {
        StringBuilder str = new StringBuilder(128);
        if (EmptyUtil.isEmpty((Long)param.getId())) {
            str.append("id,");
        }
        if (EmptyUtil.isEmpty((String)param.getEntityName())) {
            str.append("entityName,");
        }
        if (str.length() > 0) {
            return ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CreditmConfirmUseController_0", (String)"tmc-creditm-webapi", (Object[])new Object[]{str.substring(0, str.length() - 1)});
        }
        return str.toString();
    }

    private CreditLimitInfo getLimitInfo(CreditLimitInfoModel param) {
        CreditLimitInfo info = new CreditLimitInfo();
        info.setId(param.getId());
        info.setEntityName(param.getEntityName());
        info.setPreOccupy(param.isPreOccupy());
        return info;
    }
}

