/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.webapi.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.constant.ApiErrorCode;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ExceptionUtils;
import kd.tmc.creditm.business.service.creditlimit.CreditLimitService;
import kd.tmc.creditm.webapi.helper.CreditmApiHelper;
import kd.tmc.creditm.webapi.model.CreditLimitUseModel;
import kd.tmc.creditm.webapi.resources.CreditmApiResourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitF7ResBean;
import kd.tmc.fbp.common.model.CreditLimitInfo;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.util.EmptyUtil;

@ApiController(value="creditm", desc="\u6388\u4fe1\u989d\u5ea6\u5360\u7528")
@ApiMapping(value="/confirmUse")
public class CreditmConfirmUseController
implements Serializable {
    private static final Log logger = LogFactory.getLog(CreditmConfirmUseController.class);

    @ApiPostMapping(value="/", desc="\u6388\u4fe1\u989d\u5ea6\u5360\u7528")
    public CustomApiResult<String> confirmUse(@ApiParam(value="\u6388\u4fe1\u989d\u5ea6\u5360\u7528\u53c2\u6570", required=true) @ApiParam(value="\u6388\u4fe1\u989d\u5ea6\u5360\u7528\u53c2\u6570", required=true) CreditLimitUseModel param) {
        CustomApiResult result = CreditmApiHelper.getApiSuccessResult();
        try {
            String checkRes = this.checkParam(param);
            if (EmptyUtil.isNoEmpty((String)checkRes)) {
                result.setStatus(false);
                result.setErrorCode(ApiErrorCode.HTTP_BAD_REQUEST.getStatusCode());
                result.setMessage(checkRes);
                return result;
            }
            logger.info("credit confirmuse api, billid:{}", (Object)param.getId());
            CreditLimitUseBean bean = this.getCreditLimitUseBean(param);
            CreditLimitService creditService = new CreditLimitService();
            CreditLimitF7ResBean res = creditService.autoUseCreditLimit(bean);
            if (!res.getSuccess().booleanValue()) {
                logger.info("autouse error:{}", (Object)res.getMsg());
                return CreditmApiHelper.getApiFailResult(res.getMsg());
            }
            CreditLimitInfo resInfo = creditService.confirmCreditLimit(this.getLimitInfo(param));
            if (!resInfo.isSuccess()) {
                logger.info("confirm error:{}", (Object)resInfo.getMessage());
                CreditmApiHelper.deleteCreditUse(param.getEntityName(), param.getId());
                return CreditmApiHelper.getApiFailResult(resInfo.getMessage());
            }
        }
        catch (Exception e) {
            result = CreditmApiHelper.getApiFailResult(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error((Throwable)e);
        }
        return result;
    }

    private String checkParam(CreditLimitUseModel param) {
        StringBuilder str = new StringBuilder(128);
        if (EmptyUtil.isEmpty((Long)param.getId())) {
            str.append("id,");
        }
        if (EmptyUtil.isEmpty((String)param.getSourceNo())) {
            str.append("sourceNo,");
        }
        if (EmptyUtil.isEmpty((String)param.getEntityName())) {
            str.append("entityName,");
        }
        if (EmptyUtil.isEmpty((Long)param.getOrgId())) {
            str.append("orgId,");
        }
        if (EmptyUtil.isEmpty((String)param.getCreditFinType())) {
            str.append("creditFinType,");
        }
        if (EmptyUtil.isEmpty((Long)param.getFinOrgId())) {
            str.append("finOrgId,");
        }
        if (EmptyUtil.isEmpty((Long)param.getCurrencyId())) {
            str.append("currencyId,");
        }
        if (EmptyUtil.isEmpty((Long)param.getCreditTypeId())) {
            str.append("creditTypeId,");
        }
        if (EmptyUtil.isEmpty((BigDecimal)param.getBizAmt())) {
            str.append("bizAmt,");
        }
        if (EmptyUtil.isEmpty((String)param.getCreditLimitNo())) {
            str.append("creditLimitNo,");
        }
        if (str.length() > 0) {
            return CreditmApiResourceEnum.CreditmConfirmUseController_0.loadKDString(str.substring(0, str.length() - 1));
        }
        if (EmptyUtil.isNoEmpty((String)param.getCreditFinType()) && !Arrays.asList("bd_finorginfo", "bos_org", "bd_bizpartner").contains(param.getCreditFinType())) {
            return CreditmApiResourceEnum.CreditmConfirmUseController_1.loadKDString();
        }
        boolean isExistOrg = TmcDataServiceHelper.exists((Object)param.getOrgId(), (String)"bos_org");
        if (!isExistOrg) {
            return CreditmApiResourceEnum.CreditmConfirmUseController_2.loadKDString();
        }
        boolean isExistFinOrg = TmcDataServiceHelper.exists((Object)param.getFinOrgId(), (String)param.getCreditFinType());
        if (!isExistFinOrg) {
            return CreditmApiResourceEnum.CreditmConfirmUseController_3.loadKDString();
        }
        boolean isExistCurr = TmcDataServiceHelper.exists((Object)param.getCurrencyId(), (String)"bd_currency");
        if (!isExistCurr) {
            return CreditmApiResourceEnum.CreditmConfirmUseController_4.loadKDString();
        }
        if (BigDecimal.ZERO.compareTo(param.getBizAmt()) > 0) {
            return CreditmApiResourceEnum.CreditmConfirmUseController_5.loadKDString();
        }
        if (BigDecimal.ZERO.compareTo(param.getCreditRatio()) > 0) {
            return CreditmApiResourceEnum.CreditmConfirmUseController_6.loadKDString();
        }
        boolean isCreditUse = TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)param.getId()), new QFilter("sourcetype", "=", (Object)param.getEntityName()), new QFilter("isrelease", "=", (Object)"0")});
        if (isCreditUse) {
            return CreditmApiResourceEnum.CreditmConfirmUseController_7.loadKDString(param.getEntityName(), param.getId());
        }
        return str.toString();
    }

    private CreditLimitInfo getLimitInfo(CreditLimitUseModel param) {
        CreditLimitInfo info = new CreditLimitInfo();
        info.setId(param.getId());
        info.setEntityName(param.getEntityName());
        info.setBillno(param.getSourceNo());
        info.setPreOccupy(param.isPreOccupy());
        info.setCreatetime(param.getBizDate());
        return info;
    }

    private CreditLimitUseBean getCreditLimitUseBean(CreditLimitUseModel param) {
        CreditLimitUseBean bean = new CreditLimitUseBean();
        bean.setPkId(param.getId());
        bean.setEntityName(param.getEntityName());
        bean.setOrgId(param.getOrgId());
        bean.setCreditFinType(param.getCreditFinType());
        bean.setFinOrgId(param.getFinOrgId());
        bean.setCurrencyId(param.getCurrencyId());
        bean.setCreditTypeId(param.getCreditTypeId());
        bean.setCreditVariety(param.getCreditVariety());
        bean.setBizAmt(param.getBizAmt());
        bean.setCreditRatio(param.getCreditRatio());
        bean.setStartDate(param.getStartDate());
        bean.setEndDate(param.getEndDate());
        bean.setPreOccupy(Boolean.valueOf(param.isPreOccupy()));
        bean.setCreditLimitNo(param.getCreditLimitNo());
        return bean;
    }
}

