/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.webapi.controller;

import java.io.Serializable;
import java.math.BigDecimal;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.util.ExceptionUtils;
import kd.tmc.creditm.business.service.creditlimit.CreditLimitService;
import kd.tmc.creditm.webapi.helper.CreditmApiHelper;
import kd.tmc.creditm.webapi.model.ReturnCreditLimitModel;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

@ApiController(value="creditm", desc="\u6388\u4fe1\u989d\u5ea6\u8fd4\u8fd8")
@ApiMapping(value="/returnUse")
public class CreditmReturnController
implements Serializable {
    private static final Log logger = LogFactory.getLog(CreditmReturnController.class);

    @ApiPostMapping(value="/", desc="\u6388\u4fe1\u989d\u5ea6\u53d6\u6d88\u5360\u7528")
    public CustomApiResult<String> returnUse(@ApiParam(value="\u6388\u4fe1\u989d\u5ea6\u8fd4\u8fd8\u53c2\u6570", required=true) @ApiParam(value="\u6388\u4fe1\u989d\u5ea6\u8fd4\u8fd8\u53c2\u6570", required=true) ReturnCreditLimitModel param) {
        CustomApiResult result = CreditmApiHelper.getApiSuccessResult();
        try {
            String checkRes = this.checkParam(param);
            if (EmptyUtil.isNoEmpty((String)checkRes)) {
                result.setStatus(false);
                result.setMessage(checkRes);
                return result;
            }
            logger.info("credit returnuse api, billid:{}", (Object)param.getBizBillId());
            CreditLimitService creditService = new CreditLimitService();
            ReturnCreditLimitInfo resInfo = creditService.returnCreditLimit(this.getReturnLimitInfo(param));
            if (!resInfo.isSuccess()) {
                logger.info("returnuse error:{}", (Object)resInfo.getMessage());
                return CreditmApiHelper.getApiFailResult(resInfo.getMessage());
            }
        }
        catch (Exception e) {
            result = CreditmApiHelper.getApiFailResult(ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            logger.error((Throwable)e);
        }
        return result;
    }

    private String checkParam(ReturnCreditLimitModel param) {
        StringBuilder str = new StringBuilder(128);
        if (EmptyUtil.isEmpty((Long)param.getId())) {
            str.append("id,");
        }
        if (EmptyUtil.isEmpty((String)param.getEntityName())) {
            str.append("entityName,");
        }
        if (EmptyUtil.isEmpty((String)param.getPreEntityName())) {
            str.append("preEntityName,");
        }
        if (EmptyUtil.isEmpty((Long)param.getBizBillId())) {
            str.append("bizBillId,");
        }
        if (EmptyUtil.isEmpty((BigDecimal)param.getReturnAmt())) {
            str.append("returnAmt,");
        }
        if (str.length() > 0) {
            return ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570%s\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"CreditmConfirmUseController_0", (String)"tmc-creditm-webapi", (Object[])new Object[]{str.substring(0, str.length() - 1)});
        }
        return str.toString();
    }

    private ReturnCreditLimitInfo getReturnLimitInfo(ReturnCreditLimitModel param) {
        ReturnCreditLimitInfo info = new ReturnCreditLimitInfo();
        info.setId(param.getId());
        info.setEntityName(param.getEntityName());
        info.setPreOccupy(param.isPreOccupy());
        info.setPreEntityName(param.getPreEntityName());
        info.setReturnBillId(param.getReturnBillId());
        info.setBizBillId(param.getBizBillId());
        info.setReturnTime(param.getReturnTime());
        info.setReturnAmt(param.getReturnAmt());
        info.setLast(param.isLast());
        return info;
    }
}

