/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.amount;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.amount.ICreditAmount;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class BondCreditAmount
implements ICreditAmount {
    @Override
    public BigDecimal getCreditAmount(DynamicObject bill) {
        return BigDecimal.ZERO;
    }

    @Override
    public Map<Long, BigDecimal> getEntryCreditAmount(DynamicObject bill) {
        HashMap<Long, BigDecimal> vestorAmountMap = new HashMap<Long, BigDecimal>();
        DynamicObject bondBill = TmcDataServiceHelper.loadSingle((Object)bill.getLong("id"), (String)"cfm_loanbill_bond", (String)"currency,drawamount,investor_entry.e_investamount,investor_entry.e_investorid");
        if (EmptyUtil.isEmpty((DynamicObject)bondBill)) {
            return vestorAmountMap;
        }
        int amtPrecision = bondBill.getDynamicObject("currency").getInt("amtprecision");
        BigDecimal drawAmount = bondBill.getBigDecimal("drawamount");
        DynamicObjectCollection entrys = bondBill.getDynamicObjectCollection("investor_entry");
        for (DynamicObject entry : entrys) {
            long investorId = entry.getLong("e_investorid");
            if (EmptyUtil.isEmpty((Long)investorId)) continue;
            vestorAmountMap.put(investorId, entry.getBigDecimal("e_investamount"));
        }
        DynamicObjectCollection repayBills = QueryServiceHelper.query((String)"cfm_repaymentbill", (String)"isbuyback,loans.e_repayamount repayamount,loans.buyback_entry.e_investorid investorid,loans.buyback_entry.e_buybackamt buybackamt", (QFilter[])new QFilter[]{new QFilter("loans.e_loanbill", "=", (Object)bill.getLong("id")).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)"yetconfirm")});
        List backRepays = repayBills.stream().filter(o -> o.getBoolean("isbuyback")).collect(Collectors.toList());
        BigDecimal backRepayAmount = BigDecimal.ZERO;
        for (DynamicObject backRepay : backRepays) {
            long investorId = backRepay.getLong("investorid");
            BigDecimal amount = vestorAmountMap.getOrDefault(investorId, BigDecimal.ZERO);
            backRepayAmount = backRepayAmount.add(backRepay.getBigDecimal("buybackamt"));
            BigDecimal buybackamt = amount.subtract(backRepay.getBigDecimal("buybackamt"));
            vestorAmountMap.put(investorId, buybackamt.compareTo(BigDecimal.ZERO) > 0 ? buybackamt : BigDecimal.ZERO);
        }
        drawAmount = drawAmount.subtract(backRepayAmount);
        List notBackRepays = repayBills.stream().filter(o -> !o.getBoolean("isbuyback")).collect(Collectors.toList());
        for (DynamicObject notBackRepay : notBackRepays) {
            BigDecimal repayAmount = notBackRepay.getBigDecimal("repayamount");
            Map<Long, BigDecimal> repayAmountMap = BondCreditAmount.repayAmountMap(vestorAmountMap, drawAmount, repayAmount, amtPrecision);
            BondCreditAmount.getRepayAmountMap(vestorAmountMap, repayAmountMap);
        }
        return vestorAmountMap;
    }

    private static Map<Long, BigDecimal> repayAmountMap(Map<Long, BigDecimal> vestorAmountMap, BigDecimal drawAmount, BigDecimal repayAmount, int amtPrecision) {
        HashMap<Long, BigDecimal> repayAmountMap = new HashMap<Long, BigDecimal>(vestorAmountMap.size());
        for (Map.Entry<Long, BigDecimal> vestorMap : vestorAmountMap.entrySet()) {
            repayAmountMap.put(vestorMap.getKey(), vestorMap.getValue().multiply(repayAmount).divide(drawAmount, amtPrecision, RoundingMode.HALF_UP));
        }
        return repayAmountMap;
    }

    private static void getRepayAmountMap(Map<Long, BigDecimal> vestorAmountMap, Map<Long, BigDecimal> repayAmountMap) {
        for (Map.Entry<Long, BigDecimal> entry : repayAmountMap.entrySet()) {
            if (!vestorAmountMap.containsKey(entry.getKey())) continue;
            BigDecimal amount = vestorAmountMap.getOrDefault(entry.getKey(), BigDecimal.ZERO);
            BigDecimal notDrawAmount = amount.subtract(entry.getValue());
            vestorAmountMap.put(entry.getKey(), notDrawAmount.compareTo(BigDecimal.ZERO) > 0 ? notDrawAmount : BigDecimal.ZERO);
        }
    }
}

