/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.amount;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.amount.ICreditAmount;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CfmLoanNotrepayAmount
implements ICreditAmount {
    @Override
    public BigDecimal getCreditAmount(DynamicObject bill) {
        return BigDecimal.ZERO;
    }

    @Override
    public Map<Long, BigDecimal> getEntryCreditAmount(DynamicObject bill) {
        Map<Long, BigDecimal> bankToAmountMap = new HashMap<Long, BigDecimal>();
        DynamicObjectCollection loanBillSls = QueryServiceHelper.query((String)"cfm_loanbill", (String)"banksyndicate_entry.id id,banksyndicate_entry.e_shareamount shareamount,banksyndicate_entry.e_bank bankid", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)bill.getLong("id")).and("banksyndicate_entry.e_bankcreditlimit", "=", (Object)0)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)loanBillSls)) {
            return bankToAmountMap;
        }
        bankToAmountMap = loanBillSls.stream().collect(Collectors.toMap(o -> o.getLong("bankid"), o -> o.getBigDecimal("shareamount"), (v1, v2) -> v2));
        DataSet repayDs = QueryServiceHelper.queryDataSet((String)"getEntryCreditAmountLoan", (String)"cfm_repaymentbill", (String)"slentryentity.s_bank bankid,slentryentity.s_repayamount repayamt", (QFilter[])new QFilter[]{new QFilter("slentryentity.s_loanbillno", "=", (Object)bill.getLong("id")).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("confirmstatus", "=", (Object)"yetconfirm")}, null).groupBy(new String[]{"bankid"}).sum("repayamt").finish();
        if (!repayDs.isEmpty()) {
            for (Row row : repayDs) {
                Long bankId = row.getLong("bankid");
                if (!bankToAmountMap.containsKey(bankId)) continue;
                bankToAmountMap.put(bankId, bankToAmountMap.getOrDefault(bankId, BigDecimal.ZERO).subtract(row.getBigDecimal("repayamt")));
            }
        }
        return bankToAmountMap;
    }
}

