/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.amount;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.amount.ICreditAmount;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;

public class LcLetteCreditAmount
implements ICreditAmount {
    @Override
    public BigDecimal getCreditAmount(DynamicObject bill) {
        BigDecimal amountUpper = bill.getBigDecimal("amountscaleupper");
        BigDecimal amount = bill.getBigDecimal("amount");
        DynamicObject currency = bill.getDynamicObject("currency");
        int amtprecision = currency.getInt("amtprecision");
        BigDecimal creditAmount = amount.multiply(BigDecimal.ONE.add(amountUpper.divide(Constants.ONE_HUNDRED, 11, RoundingMode.HALF_UP))).setScale(amtprecision, RoundingMode.HALF_UP);
        DynamicObjectCollection arrivalBills = QueryServiceHelper.query((String)"lc_arrival", (String)"doneamount", (QFilter[])new QFilter[]{new QFilter("lettercredit", "=", bill.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
        BigDecimal payAmount = arrivalBills.stream().map(o -> o.getBigDecimal("doneamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        return creditAmount.subtract(payAmount);
    }

    @Override
    public Map<Long, BigDecimal> getEntryCreditAmount(DynamicObject bill) {
        return null;
    }
}

