/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.common.resources.CreditmComResourceEnum;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.MutexServiceHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CreditFrameworkHelper {
    public static Set<Long> getCreditLimitIds(long frameWorkId) {
        HashSet<Long> limitIds = new HashSet<Long>();
        limitIds.add(frameWorkId);
        return CreditFrameworkHelper.getFrameWorkUse(limitIds, new HashSet<Long>(), true);
    }

    public static Set<Long> getFrameWorkUse(Set<Long> frameWorkIds, Set<Long> useIds, boolean isLookUp) {
        DynamicObjectCollection creditBills = QueryServiceHelper.query((String)"creditm_limit_framework", (String)"id,isframework,framework,sourcebillids.fbasedataid sid", (QFilter[])new QFilter[]{new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("framework", "in", frameWorkIds)});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)creditBills)) {
            return useIds;
        }
        useIds.addAll(creditBills.parallelStream().map(o -> o.getLong("id")).collect(Collectors.toSet()));
        useIds.removeAll(creditBills.parallelStream().filter(o -> !o.getBoolean("isframework")).map(o -> o.getLong("sid")).collect(Collectors.toSet()));
        frameWorkIds = creditBills.parallelStream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("framework"))).map(o -> o.getLong("id")).collect(Collectors.toSet());
        if (!isLookUp || EmptyUtil.isEmpty(frameWorkIds)) {
            return useIds;
        }
        return CreditFrameworkHelper.getFrameWorkUse(frameWorkIds, useIds, isLookUp);
    }

    public static BigDecimal getOrgTypeAmount(DynamicObject creditLimit, long orgId, long creditTypeId) {
        String shareType = creditLimit.getString("orgsharetype");
        BigDecimal amount = creditLimit.getBigDecimal("notallocationamt");
        DynamicObjectCollection entrys = creditLimit.getDynamicObjectCollection("entry_org");
        boolean isContain = false;
        for (Object entry : entrys) {
            DynamicObjectCollection vals = entry.getDynamicObjectCollection("o_org");
            Set<Long> collIds = CreditLimitHelper.getCollIds(vals);
            if (!collIds.contains(orgId) && (!OrgShareTypeEnum.DOWNSHARE.getValue().equals(shareType) || !CreditLimitHelper.isParentOrg((DynamicObject)entry, orgId))) continue;
            amount = amount.min(entry.getBigDecimal("o_notallocationamt"));
            isContain = true;
        }
        if (!isContain) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection entryTypes = creditLimit.getDynamicObjectCollection("entry_type");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryTypes)) {
            for (DynamicObject entry : entryTypes) {
                DynamicObjectCollection vals = entry.getDynamicObjectCollection("t_credittype");
                Set<Long> collIds = CreditLimitHelper.getCollIds(vals);
                if (!collIds.contains(creditTypeId)) continue;
                amount = amount.min(entry.getBigDecimal("t_notallocationamt"));
            }
        }
        boolean isMultCol = creditLimit.getBoolean("ismultcontrol");
        DynamicObjectCollection entryMults = creditLimit.getDynamicObjectCollection("entry_mult");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryMults)) {
            return amount;
        }
        isContain = false;
        for (DynamicObject entry : entryMults) {
            DynamicObjectCollection valOrgs = entry.getDynamicObjectCollection("m_org");
            DynamicObjectCollection valTypes = entry.getDynamicObjectCollection("m_credittype");
            Set<Long> collOrgIds = CreditLimitHelper.getCollIds(valOrgs);
            Set<Long> collTypeIds = CreditLimitHelper.getCollIds(valTypes);
            if (!collOrgIds.contains(orgId) || !collTypeIds.contains(creditTypeId)) continue;
            amount = amount.min(entry.getBigDecimal("m_notallocationamt"));
            isContain = true;
        }
        if (isMultCol && !isContain) {
            return BigDecimal.ZERO;
        }
        return amount;
    }

    public static DataSet getCreditLimitOrgtypeDs(Set<Long> limits) {
        DataSet limitDs = QueryServiceHelper.queryDataSet((String)"getCreditLimitOrgtypeDs", (String)"cfm_creditlimit", (String)"id,number,org horg,credittype htype,isframework,framework", (QFilter[])new QFilter[]{new QFilter("id", "in", limits)}, null);
        return limitDs;
    }

    public static Map<Long, Pair<BigDecimal, BigDecimal>> getEntryAmtMap(DataSet ds, String key) {
        HashMap<Long, Pair<BigDecimal, BigDecimal>> map = new HashMap<Long, Pair<BigDecimal, BigDecimal>>();
        ds = ds.groupBy(new String[]{key}).sum("amount").sum("preamount").finish();
        for (Row d : ds) {
            Long keyId = d.getLong(key);
            boolean isEmpty = EmptyUtil.isEmpty(map.get(keyId));
            Pair usePair = Pair.of((Object)(isEmpty ? BigDecimal.ZERO : (BigDecimal)((Pair)map.get(keyId)).getLeft()), (Object)(isEmpty ? BigDecimal.ZERO : (BigDecimal)((Pair)map.get(keyId)).getRight()));
            map.put(keyId, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)((BigDecimal)usePair.getLeft()).add(d.getBigDecimal("amount")), (Object)((BigDecimal)usePair.getRight()).add(d.getBigDecimal("preamount"))));
        }
        return map;
    }

    public static Map<String, Pair<BigDecimal, BigDecimal>> getEntryMultAmtMap(DataSet ds) {
        HashMap<String, Pair<BigDecimal, BigDecimal>> map = new HashMap<String, Pair<BigDecimal, BigDecimal>>();
        ds = ds.groupBy(new String[]{"org", "credittype"}).sum("amount").sum("preamount").finish();
        for (Row row : ds) {
            String key = row.getLong("org") + "#" + row.getLong("credittype");
            boolean isEmpty = EmptyUtil.isEmpty(map.get(key));
            Pair usePair = Pair.of((Object)(isEmpty ? BigDecimal.ZERO : (BigDecimal)((Pair)map.get(key)).getLeft()), (Object)(isEmpty ? BigDecimal.ZERO : (BigDecimal)((Pair)map.get(key)).getRight()));
            map.put(key, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)((BigDecimal)usePair.getLeft()).add(row.getBigDecimal("amount")), (Object)((BigDecimal)usePair.getRight()).add(row.getBigDecimal("preamount"))));
        }
        return map;
    }

    public static List<Long> getAllSubOrgs(List orgIds) {
        List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"08", (List)orgIds, (boolean)true);
        return subOrgIds;
    }

    public static Set<Long> getEntryOrgIds(DynamicObject frameWork) {
        HashSet<Long> orgIds = new HashSet<Long>();
        String shareType = frameWork.getString("orgsharetype");
        DynamicObjectCollection entryOrgs = frameWork.getDynamicObjectCollection("entry_org");
        for (DynamicObject entryOrg : entryOrgs) {
            DynamicObjectCollection orgs = entryOrg.getDynamicObjectCollection("o_org");
            Set<Long> collIds = CreditLimitHelper.getCollIds(orgs);
            if (collIds.size() == 0) continue;
            if (OrgShareTypeEnum.APPOINTSHARE.getValue().equals(shareType)) {
                orgIds.addAll(collIds);
                continue;
            }
            List<Long> subOrgIds = CreditFrameworkHelper.getAllSubOrgs(new ArrayList<Long>(collIds));
            orgIds.addAll(subOrgIds);
        }
        return orgIds;
    }

    public static Set<Long> getEntryTypeIds(DynamicObject frameWork) {
        DynamicObjectCollection entryTypes = frameWork.getDynamicObjectCollection("entry_type");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryTypes)) {
            return null;
        }
        HashSet<Long> typeIds = new HashSet<Long>();
        for (DynamicObject entryType : entryTypes) {
            DynamicObjectCollection creditColls = entryType.getDynamicObjectCollection("t_credittype");
            typeIds.addAll(CreditLimitHelper.getCollIds(creditColls));
        }
        return typeIds;
    }

    public static void creditWriteBackFrame(Long frameWorkId, Long orgId, Long creditTypeId, BigDecimal amount) {
        if (EmptyUtil.isEmpty((BigDecimal)amount)) {
            return;
        }
        boolean isSucess = MutexServiceHelper.request((String)String.valueOf(frameWorkId), (String)"creditm_limit_framework", (String)"updateFrame");
        if (!isSucess) {
            DynamicObject frameWork = TmcDataServiceHelper.loadSingleFromCache((Object)frameWorkId, (String)"cfm_creditlimit", (String)"number");
            throw new KDBizException(CreditmComResourceEnum.CreditFrameworkHelper_0.loadKDString(frameWork.getString("number")));
        }
        try {
            DynamicObject[] frameWorks = TmcDataServiceHelper.load((String)"creditm_limit_framework", (String)"totalamt,notallocationamt,ismergesrc,orgsharetype,entry_org.o_org,entry_org.o_totalamt,entry_org.o_singleamt,entry_org.o_notallocationamt,entry_type.t_credittype,entry_type.t_totalamt,entry_type.t_singleamt,entry_type.t_notallocationamt,entry_mult.m_org,entry_mult.m_credittype,entry_mult.m_totalamt,entry_mult.m_notallocationamt", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)frameWorkId)});
            ArrayList<DynamicObject> updateFrames = new ArrayList<DynamicObject>(frameWorks.length);
            ArrayList<Object[]> paramList = new ArrayList<Object[]>(frameWorks.length);
            for (DynamicObject frameWork : frameWorks) {
                frameWork = CreditFrameworkHelper.getRealCreditLimitFrame(frameWork);
                BigDecimal notAllcalAmt = frameWork.getBigDecimal("notallocationamt");
                BigDecimal resAmount = CreditFrameworkHelper.getResAmount(notAllcalAmt, amount);
                paramList.add(new Object[]{notAllcalAmt, notAllcalAmt, frameWork.getLong("id")});
                frameWork.set("notallocationamt", (Object)resAmount);
                boolean isDownShare = OrgShareTypeEnum.DOWNSHARE.getValue().equals(frameWork.getString("orgsharetype"));
                DynamicObjectCollection orgEntrys = frameWork.getDynamicObjectCollection("entry_org");
                if (isDownShare) {
                    for (DynamicObject orgEntry : orgEntrys) {
                        DynamicObjectCollection orgs = orgEntry.getDynamicObjectCollection("o_org");
                        if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)orgs) || !CreditLimitHelper.isParentOrg(orgEntry, orgId)) continue;
                        orgEntry.set("o_notallocationamt", (Object)CreditFrameworkHelper.getResAmount(orgEntry.getBigDecimal("o_notallocationamt"), amount));
                    }
                } else {
                    orgEntrys.stream().filter(o -> CreditLimitHelper.getCollIds(o.getDynamicObjectCollection("o_org")).contains(orgId)).forEach(t -> t.set("o_notallocationamt", (Object)CreditFrameworkHelper.getResAmount(t.getBigDecimal("o_notallocationamt"), amount)));
                }
                DynamicObjectCollection typeEntrys = frameWork.getDynamicObjectCollection("entry_type");
                typeEntrys.stream().filter(o -> CreditLimitHelper.getCollIds(o.getDynamicObjectCollection("t_credittype")).contains(creditTypeId)).forEach(t -> t.set("t_notallocationamt", (Object)CreditFrameworkHelper.getResAmount(t.getBigDecimal("t_notallocationamt"), amount)));
                DynamicObjectCollection multEntrys = frameWork.getDynamicObjectCollection("entry_mult");
                multEntrys.stream().filter(o -> CreditLimitHelper.getCollIds(o.getDynamicObjectCollection("m_org")).contains(orgId) && CreditLimitHelper.getCollIds(o.getDynamicObjectCollection("m_credittype")).contains(creditTypeId)).forEach(t -> t.set("m_notallocationamt", (Object)CreditFrameworkHelper.getResAmount(t.getBigDecimal("m_notallocationamt"), amount)));
                updateFrames.add(frameWork);
            }
            int[] updateCount = DB.executeBatch((DBRoute)new DBRoute(DBRouteConst.TMC.getRouteKey()), (String)"update t_cfm_creditlimit_e set fnotallocationamt=? where fnotallocationamt=? and fid=?", paramList);
            if (paramList.size() != Arrays.stream(updateCount).sum()) {
                throw new KDBizException(CreditmComResourceEnum.CreditFrameworkHelper_2.loadKDString());
            }
            SaveServiceHelper.save((DynamicObject[])updateFrames.toArray(new DynamicObject[0]));
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            MutexServiceHelper.release((String)String.valueOf(frameWorkId), (String)"creditm_limit_framework", (String)"updateFrame");
        }
    }

    private static BigDecimal getResAmount(BigDecimal totalAmount, BigDecimal amount) {
        BigDecimal resAmount = totalAmount.subtract(amount);
        return BigDecimal.ZERO.compareTo(resAmount) > 0 ? BigDecimal.ZERO : resAmount;
    }

    public static QFilter getFrameLimitFilter(long orgId, DynamicObject bank, String bankType, DynamicObject creditType, long currencyId, BigDecimal totalAmt) {
        QFilter filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("isclose", "=", (Object)"0").and("isframework", "=", (Object)"1").and("currency", "=", (Object)currencyId);
        filter.and(CreditLimitHelper.getBankFilter(bank, bankType));
        filter.and("notallocationamt", ">=", (Object)totalAmt);
        filter.and(QFilter.isNull((String)"entry_type").or(new QFilter("entry_type.t_credittype.fbasedataid", "in", (Object)creditType.getLong("id"))));
        QFilter orgFilter = new QFilter("orgsharetype", "=", (Object)OrgShareTypeEnum.APPOINTSHARE.getValue()).and(new QFilter("entry_org.o_org.fbasedataid", "=", (Object)orgId));
        QFilter downFilter = new QFilter("orgsharetype", "=", (Object)OrgShareTypeEnum.DOWNSHARE.getValue());
        Object[] frameWorks = TmcDataServiceHelper.load((String)"creditm_limit_framework", (String)"id,orgsharetype,ismultcontrol,entry_org.o_org,entry_mult.m_org,entry_mult.m_credittype", (QFilter[])new QFilter[]{filter, orgFilter.or(downFilter)});
        Set filterBillIds = Arrays.stream(frameWorks).map(o -> o.getLong("id")).collect(Collectors.toSet());
        QFilter frameFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
        if (EmptyUtil.isNoEmpty((Object[])frameWorks)) {
            List<DynamicObject> downShareBills = Arrays.stream(frameWorks).filter(o -> OrgShareTypeEnum.DOWNSHARE.getValue().equals(o.getString("orgsharetype"))).collect(Collectors.toList());
            Set<Long> billNoIds = CreditFrameworkHelper.getDownShareBillNotIds(downShareBills, orgId);
            filterBillIds.removeAll(billNoIds);
            List<DynamicObject> multConBills = Arrays.stream(frameWorks).filter(o -> o.getBoolean("ismultcontrol")).collect(Collectors.toList());
            Set<Long> multConBillNotIds = CreditFrameworkHelper.getMultConBillNotIds(multConBills, orgId, creditType.getLong("id"));
            filterBillIds.removeAll(multConBillNotIds);
        }
        if (filterBillIds.size() > 0) {
            frameFilter = new QFilter("id", "in", filterBillIds);
        }
        return frameFilter;
    }

    private static Set<Long> getMultConBillNotIds(List<DynamicObject> multConBills, long orgId, long typeId) {
        HashSet<Long> multConNotIds = new HashSet<Long>();
        for (DynamicObject multConBill : multConBills) {
            if (!multConBill.getBoolean("ismultcontrol")) continue;
            DynamicObjectCollection multEntrys = multConBill.getDynamicObjectCollection("entry_mult");
            boolean isContain = false;
            for (DynamicObject multEntry : multEntrys) {
                Set<Long> orgIds = CreditLimitHelper.getCollIds(multEntry.getDynamicObjectCollection("m_org"));
                Set<Long> typeIds = CreditLimitHelper.getCollIds(multEntry.getDynamicObjectCollection("m_credittype"));
                isContain = orgIds.contains(orgId) && typeIds.contains(typeId);
                if (!isContain) continue;
                break;
            }
            if (isContain) continue;
            multConNotIds.add(multConBill.getLong("id"));
        }
        return multConNotIds;
    }

    private static Set<Long> getDownShareBillNotIds(List<DynamicObject> downShareBills, long orgId) {
        HashSet<Long> downShareNotIds = new HashSet<Long>();
        for (DynamicObject downShareBill : downShareBills) {
            DynamicObject entryOrg;
            String orgShareType = downShareBill.getString("orgsharetype");
            if (!OrgShareTypeEnum.DOWNSHARE.getValue().equals(orgShareType)) continue;
            DynamicObjectCollection entryOrgs = downShareBill.getDynamicObjectCollection("entry_org");
            boolean isParentOrg = false;
            Iterator iterator = entryOrgs.iterator();
            while (iterator.hasNext() && !(isParentOrg = CreditLimitHelper.isParentOrg(entryOrg = (DynamicObject)iterator.next(), orgId))) {
            }
            if (isParentOrg) continue;
            downShareNotIds.add(downShareBill.getLong("id"));
        }
        return downShareNotIds;
    }

    public static QFilter getFrameTypeFilter(DynamicObject frameWork, DynamicObject org) {
        QFilter filter = new QFilter("iscomprehensive", "=", (Object)"0").and(new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and(new QFilter("enable", "=", (Object)"1")));
        if (EmptyUtil.isEmpty((DynamicObject)frameWork) || EmptyUtil.isEmpty((DynamicObject)org)) {
            return filter;
        }
        boolean isMultCon = frameWork.getBoolean("ismultcontrol");
        if (isMultCon) {
            HashSet<Long> collIds = new HashSet<Long>();
            DynamicObjectCollection multEntrys = frameWork.getDynamicObjectCollection("entry_mult");
            for (DynamicObject multEntry : multEntrys) {
                DynamicObjectCollection types = multEntry.getDynamicObjectCollection("m_credittype");
                DynamicObjectCollection orgs = multEntry.getDynamicObjectCollection("m_org");
                Set<Long> typeIds = CreditLimitHelper.getCollIds(types);
                Set<Long> orgIdsIds = CreditLimitHelper.getCollIds(orgs);
                if (!orgIdsIds.contains(org.getLong("id"))) continue;
                collIds.addAll(typeIds);
            }
            if (EmptyUtil.isEmpty(collIds)) {
                return QFilter.of((String)"1!=1", (Object[])new Object[0]);
            }
            return filter.and(new QFilter("id", "in", collIds));
        }
        Set<Long> entryTypeIds = CreditFrameworkHelper.getEntryTypeIds(frameWork);
        if (EmptyUtil.isNoEmpty(entryTypeIds)) {
            filter.and(new QFilter("id", "in", entryTypeIds));
        }
        return filter;
    }

    public static DynamicObject getRealCreditLimitFrame(DynamicObject frameBill) {
        if (frameBill.getBoolean("ismergesrc")) {
            DynamicObject targetCredit = CreditFrameworkHelper.getMergeTargetCredit(frameBill);
            return CreditFrameworkHelper.getRealCreditLimitFrame(targetCredit);
        }
        return frameBill;
    }

    public static DynamicObject getMergeTargetCredit(DynamicObject srcCredit) {
        QFilter idFilter = new QFilter("sourcebillids.fbasedataid", "=", srcCredit.getPkValue());
        DynamicObject frame = TmcDataServiceHelper.loadSingle((String)"creditm_limit_framework", (String)"id", (QFilter[])new QFilter[]{idFilter});
        if (frame == null) {
            throw new KDBizException(CreditmComResourceEnum.CreditFrameworkHelper_1.loadKDString(srcCredit.getString("number")));
        }
        frame = TmcDataServiceHelper.loadSingle((Object)frame.getPkValue(), (String)"creditm_limit_framework");
        return frame;
    }

    public static BigDecimal getSrcCreditLimitAmount(DynamicObject limit) {
        BigDecimal srcTotalAmt = BigDecimal.ZERO;
        if ("creditm_apply".equals(limit.getDynamicObjectType().getName())) {
            if (CreditmApplyTypeEnum.isChange(limit.getString("applytype"))) {
                return limit.getDynamicObject("creditlimit").getBigDecimal("totalamt");
            }
            return srcTotalAmt;
        }
        if (limit.getBoolean("ismergenew")) {
            DynamicObjectCollection sourcebills = limit.getDynamicObjectCollection("sourcebillids");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)sourcebills)) {
                return srcTotalAmt;
            }
            DynamicObject parentLimit = QueryServiceHelper.queryOne((String)"cfm_creditlimit", (String)"totalamt,framework", (QFilter[])new QFilter[]{new QFilter("id", "in", sourcebills.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet()))});
            if (parentLimit != null && EmptyUtil.isNoEmpty((Long)parentLimit.getLong("framework"))) {
                return parentLimit.getBigDecimal("totalamt");
            }
        }
        return srcTotalAmt;
    }
}

