/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.helper;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.common.resources.CreditmComResourceEnum;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditFrameworkRerunHelper {
    public static String rerunNotallocationAmount(DynamicObject frameWork) {
        Set<Long> frameWorkIds = Stream.of(Long.valueOf(frameWork.getLong("id"))).collect(Collectors.toSet());
        DynamicObjectCollection sourceBillIds = frameWork.getDynamicObjectCollection("sourcebillids");
        Set<Long> frameSrcIds = new HashSet<Long>();
        if (frameWork.getBoolean("ismergenew")) {
            frameSrcIds = sourceBillIds.parallelStream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
        }
        Set<Long> mergeSrcbillIds = CreditFrameworkRerunHelper.getMergeSrcbillIds(frameWorkIds, frameSrcIds);
        DynamicObjectCollection useFrames = QueryServiceHelper.query((String)"creditm_limit_framework", (String)"id,org,credittype,totalamt,ismergenew,sourcebillids.fbasedataid sid", (QFilter[])new QFilter[]{new QFilter("framework", "in", mergeSrcbillIds), new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue())});
        Set sids = useFrames.parallelStream().filter(o -> o.getBoolean("ismergenew")).map(o -> o.getLong("sid")).collect(Collectors.toSet());
        useFrames.removeAll((Collection)useFrames.parallelStream().filter(u -> sids.contains(u.getLong("id"))).collect(Collectors.toSet()));
        BigDecimal headAmount = useFrames.stream().map(o -> o.getBigDecimal("totalamt")).reduce(BigDecimal.ZERO, BigDecimal::add);
        frameWork.set("notallocationamt", (Object)frameWork.getBigDecimal("totalamt").subtract(headAmount));
        Map<String, BigDecimal> orgTypeAmountMap = useFrames.parallelStream().collect(Collectors.toMap(o -> o.getString("org") + "#" + o.getString("credittype"), t -> t.getBigDecimal("totalamt"), (v1, v2) -> v1.add((BigDecimal)v2)));
        Map<Long, BigDecimal> orgAmountMap = useFrames.parallelStream().collect(Collectors.toMap(o -> o.getLong("org"), t -> t.getBigDecimal("totalamt"), (v1, v2) -> v1.add((BigDecimal)v2)));
        Map<Long, BigDecimal> typeAmountMap = useFrames.parallelStream().collect(Collectors.toMap(o -> o.getLong("credittype"), t -> t.getBigDecimal("totalamt"), (v1, v2) -> v1.add((BigDecimal)v2)));
        String orgRes = CreditFrameworkRerunHelper.updateOrgEntryLocationAmt(frameWork, orgAmountMap);
        if (EmptyUtil.isNoEmpty((String)orgRes)) {
            return orgRes;
        }
        String typeRes = CreditFrameworkRerunHelper.updateTypeEntryLocationAmt(frameWork, typeAmountMap);
        if (EmptyUtil.isNoEmpty((String)typeRes)) {
            return typeRes;
        }
        String multRes = CreditFrameworkRerunHelper.updateMultEntryLocationAmt(frameWork, orgTypeAmountMap);
        if (EmptyUtil.isNoEmpty((String)multRes)) {
            return multRes;
        }
        return "";
    }

    private static String updateOrgEntryLocationAmt(DynamicObject frameWork, Map<Long, BigDecimal> orgAmountMap) {
        DynamicObjectCollection orgEntrys = frameWork.getDynamicObjectCollection("entry_org");
        for (DynamicObject orgEntry : orgEntrys) {
            BigDecimal entryTotalAmt = orgEntry.getBigDecimal("o_totalamt").add(orgEntry.getBigDecimal("o_singleamt"));
            orgEntry.set("o_notallocationamt", (Object)entryTotalAmt);
        }
        for (Map.Entry<Long, BigDecimal> amountMap : orgAmountMap.entrySet()) {
            int i = 1;
            for (DynamicObject orgEntry : orgEntrys) {
                Set<Long> orgIds = CreditLimitHelper.getCollIds(orgEntry.getDynamicObjectCollection("o_org"));
                if (orgIds.contains(amountMap.getKey())) {
                    BigDecimal notLocationAmt = orgEntry.getBigDecimal("o_notallocationamt");
                    BigDecimal notLtAmt = notLocationAmt.subtract(amountMap.getValue());
                    if (BigDecimal.ZERO.compareTo(notLtAmt) > 0) {
                        BigDecimal entryTotalAmt = orgEntry.getBigDecimal("o_totalamt").add(orgEntry.getBigDecimal("o_singleamt"));
                        return CreditmComResourceEnum.CreditFrameworkRerunHelper_0.loadKDString(i, entryTotalAmt.subtract(notLtAmt));
                    }
                    orgEntry.set("o_notallocationamt", (Object)notLtAmt);
                }
                ++i;
            }
        }
        return "";
    }

    private static String updateTypeEntryLocationAmt(DynamicObject frameWork, Map<Long, BigDecimal> typeAmountMap) {
        DynamicObjectCollection typeEntrys = frameWork.getDynamicObjectCollection("entry_type");
        for (DynamicObject typeEntry : typeEntrys) {
            BigDecimal entryTotalAmt = typeEntry.getBigDecimal("t_totalamt").add(typeEntry.getBigDecimal("t_singleamt"));
            typeEntry.set("t_notallocationamt", (Object)entryTotalAmt);
        }
        for (Map.Entry<Long, BigDecimal> amountMap : typeAmountMap.entrySet()) {
            int i = 1;
            for (DynamicObject typeEntry : typeEntrys) {
                Set<Long> orgIds = CreditLimitHelper.getCollIds(typeEntry.getDynamicObjectCollection("t_credittype"));
                if (orgIds.contains(amountMap.getKey())) {
                    BigDecimal notLocationAmt = typeEntry.getBigDecimal("t_notallocationamt");
                    BigDecimal notLtAmt = notLocationAmt.subtract(amountMap.getValue());
                    if (BigDecimal.ZERO.compareTo(notLtAmt) > 0) {
                        BigDecimal entryTotalAmt = typeEntry.getBigDecimal("t_totalamt").add(typeEntry.getBigDecimal("t_singleamt"));
                        return CreditmComResourceEnum.CreditFrameworkRerunHelper_1.loadKDString(i, entryTotalAmt.subtract(notLtAmt));
                    }
                    typeEntry.set("t_notallocationamt", (Object)notLtAmt);
                }
                ++i;
            }
        }
        return "";
    }

    private static String updateMultEntryLocationAmt(DynamicObject frameWork, Map<String, BigDecimal> orgTypeAmountMap) {
        DynamicObjectCollection multEntrys = frameWork.getDynamicObjectCollection("entry_mult");
        for (DynamicObject multEntry : multEntrys) {
            BigDecimal entryTotalAmt = multEntry.getBigDecimal("m_totalamt");
            multEntry.set("m_notallocationamt", (Object)entryTotalAmt);
        }
        for (Map.Entry<String, BigDecimal> orgTypeMap : orgTypeAmountMap.entrySet()) {
            int i = 1;
            for (DynamicObject multEntry : multEntrys) {
                Set<Long> orgIds = CreditLimitHelper.getCollIds(multEntry.getDynamicObjectCollection("m_org"));
                Set<Long> typeIds = CreditLimitHelper.getCollIds(multEntry.getDynamicObjectCollection("m_credittype"));
                String[] split = orgTypeMap.getKey().split("#");
                if (split == null || split.length != 2) continue;
                if (orgIds.contains(Long.parseLong(split[0])) && typeIds.contains(Long.parseLong(split[1]))) {
                    BigDecimal notLocationAmt = multEntry.getBigDecimal("m_notallocationamt");
                    BigDecimal notLtAmt = notLocationAmt.subtract(orgTypeMap.getValue());
                    if (BigDecimal.ZERO.compareTo(notLtAmt) > 0) {
                        BigDecimal entryTotalAmt = multEntry.getBigDecimal("m_totalamt");
                        return CreditmComResourceEnum.CreditFrameworkRerunHelper_2.loadKDString(i, entryTotalAmt.subtract(notLtAmt));
                    }
                    multEntry.set("m_notallocationamt", (Object)notLtAmt);
                }
                ++i;
            }
        }
        return "";
    }

    public static Set<Long> getMergeSrcbillIds(Set<Long> frameWorkIds, Set<Long> frameSrcIds) {
        if (EmptyUtil.isNoEmpty(frameSrcIds)) {
            DynamicObjectCollection frameBills = QueryServiceHelper.query((String)"creditm_limit_framework", (String)"ismergenew,sourcebillids.fbasedataid sourcebillids", (QFilter[])new QFilter[]{new QFilter("id", "in", frameSrcIds)});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)frameBills)) {
                return frameWorkIds;
            }
            frameWorkIds.addAll(frameSrcIds);
            frameSrcIds = frameBills.parallelStream().filter(o -> o.getBoolean("ismergenew")).map(o -> o.getLong("sourcebillids")).collect(Collectors.toSet());
            if (EmptyUtil.isEmpty(frameSrcIds)) {
                return frameWorkIds;
            }
            CreditFrameworkRerunHelper.getMergeSrcbillIds(frameWorkIds, frameSrcIds);
        }
        return frameWorkIds;
    }
}

