/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.helper;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.constant.DBRouteConst;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitAmtHelper {
    public static void dealOrgEntryAmt(DynamicObject creditLimit, Long orgId, boolean isPre, BigDecimal amt) {
        if (EmptyUtil.isEmpty((BigDecimal)amt)) {
            return;
        }
        String orgShareType = creditLimit.getString("orgsharetype");
        boolean isGroup = creditLimit.getBoolean("isgrouplimit");
        DynamicObjectCollection orgEntrys = creditLimit.getDynamicObjectCollection("entry_org");
        if (EmptyUtil.isEmpty((Long)orgId) || orgEntrys == null || orgEntrys.size() == 0 || EmptyUtil.isEmpty((BigDecimal)amt)) {
            return;
        }
        if (OrgShareTypeEnum.DOWNSHARE.getValue().equals(orgShareType) || !isGroup) {
            for (DynamicObject orgEntry : orgEntrys) {
                if (!CreditLimitHelper.isParentOrg(orgEntry, orgId)) continue;
                String prop = isPre ? "o_preamt" : "o_useamt";
                orgEntry.set(prop, (Object)CreditLimitAmtHelper.getAmountLessZero(orgEntry.getBigDecimal(prop).add(amt)));
                orgEntry.set("o_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(orgEntry.getBigDecimal("o_totalamt"), orgEntry.getBigDecimal("o_useamt"), orgEntry.getBigDecimal("o_preamt")));
            }
        } else {
            String prop = isPre ? "o_preamt" : "o_useamt";
            Set orgs = orgEntrys.stream().filter(o -> EmptyUtil.isEmpty((Long)o.getLong("pid"))).collect(Collectors.toSet());
            for (DynamicObject orgEntry : orgs) {
                Set<Long> collIds = CreditLimitHelper.getCollIds(orgEntry.getDynamicObjectCollection("o_org"));
                if (!collIds.contains(orgId)) continue;
                orgEntry.set(prop, (Object)CreditLimitAmtHelper.getAmountLessZero(orgEntry.getBigDecimal(prop).add(amt)));
                orgEntry.set("o_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(orgEntry.getBigDecimal("o_totalamt"), orgEntry.getBigDecimal("o_useamt"), orgEntry.getBigDecimal("o_preamt")));
                break;
            }
            Set detailEntrys = orgEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("pid"))).collect(Collectors.toSet());
            for (DynamicObject orgEntry : detailEntrys) {
                DynamicObject org = CreditLimitHelper.getDynFormMultiple(orgEntry, "o_org");
                if (org == null || org.getLong("id") != orgId.longValue()) continue;
                orgEntry.set(prop, (Object)CreditLimitAmtHelper.getAmountLessZero(orgEntry.getBigDecimal(prop).add(amt)));
                orgEntry.set("o_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(orgEntry.getBigDecimal("o_singleamt"), orgEntry.getBigDecimal("o_useamt"), orgEntry.getBigDecimal("o_preamt")));
                break;
            }
        }
    }

    public static void dealTypeEntryAmt(DynamicObject creditLimit, Long typeId, boolean isPre, BigDecimal amt) {
        block5: {
            DynamicObjectCollection entryTypes;
            block4: {
                if (EmptyUtil.isEmpty((BigDecimal)amt)) {
                    return;
                }
                DynamicObject creditType = creditLimit.getDynamicObject("credittype");
                entryTypes = creditLimit.getDynamicObjectCollection("entry_type");
                if (EmptyUtil.isEmpty((Long)typeId) || EmptyUtil.isEmpty((DynamicObjectCollection)entryTypes) || EmptyUtil.isEmpty((BigDecimal)amt)) {
                    return;
                }
                if (creditType.getBoolean("iscomprehensive") || entryTypes.size() <= 0) break block4;
                DynamicObject typeEntry = (DynamicObject)entryTypes.get(0);
                DynamicObject entryCreditType = CreditLimitHelper.getDynFormMultiple(typeEntry, "t_credittype");
                if (entryCreditType == null || entryCreditType.getLong("id") != typeId.longValue()) break block5;
                String prop = isPre ? "t_preamt" : "t_useamt";
                typeEntry.set(prop, (Object)CreditLimitAmtHelper.getAmountLessZero(typeEntry.getBigDecimal(prop).add(amt)));
                typeEntry.set("t_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(typeEntry.getBigDecimal("t_totalamt"), typeEntry.getBigDecimal("t_useamt"), typeEntry.getBigDecimal("t_preamt")));
                break block5;
            }
            String prop = isPre ? "t_preamt" : "t_useamt";
            Set types = entryTypes.stream().filter(o -> EmptyUtil.isEmpty((Long)o.getLong("pid"))).collect(Collectors.toSet());
            for (DynamicObject typeEntry : types) {
                Set<Long> collIds = CreditLimitHelper.getCollIds(typeEntry.getDynamicObjectCollection("t_credittype"));
                if (!collIds.contains(typeId)) continue;
                typeEntry.set(prop, (Object)CreditLimitAmtHelper.getAmountLessZero(typeEntry.getBigDecimal(prop).add(amt)));
                typeEntry.set("t_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(typeEntry.getBigDecimal("t_totalamt"), typeEntry.getBigDecimal("t_useamt"), typeEntry.getBigDecimal("t_preamt")));
                break;
            }
            Set deltailTypes = entryTypes.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("pid"))).collect(Collectors.toSet());
            for (DynamicObject typeEntry : deltailTypes) {
                DynamicObject type = CreditLimitHelper.getDynFormMultiple(typeEntry, "t_credittype");
                if (type == null || type.getLong("id") != typeId.longValue()) continue;
                typeEntry.set(prop, (Object)CreditLimitAmtHelper.getAmountLessZero(typeEntry.getBigDecimal(prop).add(amt)));
                typeEntry.set("t_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(typeEntry.getBigDecimal("t_singleamt"), typeEntry.getBigDecimal("t_useamt"), typeEntry.getBigDecimal("t_preamt")));
                break;
            }
        }
    }

    public static void dealMultEntryAmt(DynamicObject creditLimit, Long typeId, Long orgId, boolean isPre, BigDecimal amt) {
        if (EmptyUtil.isEmpty((BigDecimal)amt)) {
            return;
        }
        DynamicObjectCollection multEntrys = creditLimit.getDynamicObjectCollection("entry_mult");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)multEntrys) || EmptyUtil.isEmpty((Long)orgId) || EmptyUtil.isEmpty((Long)typeId) || EmptyUtil.isEmpty((BigDecimal)amt)) {
            return;
        }
        for (DynamicObject multEntry : multEntrys) {
            DynamicObjectCollection types = multEntry.getDynamicObjectCollection("m_credittype");
            DynamicObjectCollection orgs = multEntry.getDynamicObjectCollection("m_org");
            Set<Long> typeCollIds = CreditLimitHelper.getCollIds(types);
            boolean isParentOrgColl = CreditLimitHelper.isParentOrgColl(orgs, orgId, creditLimit.getString("orgsharetype"));
            if (!typeCollIds.contains(typeId) || !isParentOrgColl) continue;
            String prop = isPre ? "m_preamt" : "m_useamt";
            multEntry.set(prop, (Object)CreditLimitAmtHelper.getAmountLessZero(multEntry.getBigDecimal(prop).add(amt)));
            multEntry.set("m_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(multEntry.getBigDecimal("m_totalamt"), multEntry.getBigDecimal("m_useamt"), multEntry.getBigDecimal("m_preamt")));
        }
    }

    public static void dealHeadAmt(DynamicObject creditLimit, boolean isPre, BigDecimal amt) {
        if (amt.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        String prop = isPre ? "preuseamt" : "useamt";
        BigDecimal amount = creditLimit.getBigDecimal(prop).add(amt);
        BigDecimal totalAmt = creditLimit.getBigDecimal("totalamt");
        amount = totalAmt.compareTo(amount) > 0 ? amount : totalAmt;
        creditLimit.set(prop, (Object)amount);
        BigDecimal avarAmt = CreditLimitAmtHelper.getAvarAmt(creditLimit.getBigDecimal("totalamt"), creditLimit.getBigDecimal("useamt"), creditLimit.getBigDecimal("preuseamt"));
        creditLimit.set("avaramt", (Object)(totalAmt.compareTo(avarAmt) > 0 ? avarAmt : totalAmt));
        creditLimit.set(prop, (Object)CreditLimitAmtHelper.getAmountLessZero(amount));
    }

    public static BigDecimal getAvarAmt(BigDecimal totalAmt, BigDecimal useAmt, BigDecimal preAmt) {
        BigDecimal avarAmt = totalAmt.subtract(useAmt).subtract(preAmt);
        BigDecimal resAmout = CreditLimitAmtHelper.getAmountLessZero(avarAmt);
        return resAmout.compareTo(totalAmt) > 0 ? totalAmt : resAmout;
    }

    public static BigDecimal getAmountLessZero(BigDecimal amount) {
        return BigDecimal.ZERO.compareTo(amount) > 0 ? BigDecimal.ZERO : amount;
    }

    public static void batchUpdateHeadAmt(List<Object[]> paramList, List<Object[]> paramListUse) {
        if (paramList.size() == 0) {
            return;
        }
        StringBuilder sqlStr = new StringBuilder("update t_cfm_creditlimit set ");
        sqlStr.append(" favaramt=?").append(" where fid=?").append(" and favaramt=?");
        int[] resultArr = DB.executeBatch((DBRoute)new DBRoute(DBRouteConst.TMC.getRouteKey()), (String)sqlStr.toString(), paramList);
        int count = Arrays.stream(resultArr).sum();
        if (paramList.size() != count) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5173\u8054\u7684\u6388\u4fe1\u989d\u5ea6\u5355\u53ef\u7528\u989d\u5ea6\u5df2\u4fee\u6539\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"CreditLimitHelper_22", (String)"tmc-creditm-common", (Object[])new Object[0]));
        }
        if (paramListUse != null && paramListUse.size() != 0) {
            StringBuilder sqlUseStr = new StringBuilder("update t_cfm_credituse set ");
            sqlUseStr.append(" freturnamt=?").append(" where fid=?").append(" and freturnamt=? and frealamt=?");
            resultArr = DB.executeBatch((DBRoute)new DBRoute(DBRouteConst.TMC.getRouteKey()), (String)sqlUseStr.toString(), paramListUse);
            count = Arrays.stream(resultArr).sum();
            if (paramListUse.size() != count) {
                throw new KDBizException(ResManager.loadKDString((String)"\u5173\u8054\u7684\u6388\u4fe1\u989d\u5ea6\u5355\u5360\u7528\u5355\u6b63\u5728\u66f4\u65b0\u4e2d\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"CreditLimitHelper_23", (String)"tmc-creditm-common", (Object[])new Object[0]));
            }
        }
    }

    public static DataSet getCreditUseDs(Set<Long> creditLimitId, Set<Long> baseIds, String selField) {
        QFilter filter = new QFilter("creditlimit", "in", creditLimitId).and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())).and(new QFilter("realamt", ">", (Object)BigDecimal.ZERO));
        if (EmptyUtil.isNoEmpty(baseIds)) {
            filter = filter.and(new QFilter(selField, "in", baseIds));
        }
        DataSet creditUseDataSet = QueryServiceHelper.queryDataSet((String)"creditUse", (String)"cfm_credituse", (String)"id,case when amount>0 then amount-returnamt else amount end as amount,case when preamount>0 then preamount-returnamt else preamount end as preamount,creditlimit,credittype,org", (QFilter[])new QFilter[]{filter}, (String)selField);
        return creditUseDataSet;
    }
}

