/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicCollectionProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.creditm.common.enums.CreditShareTypeEnum;
import kd.tmc.creditm.common.enums.GuaranteeWayEnum;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitAmtHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.enums.CreditFinTypeEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.CreditLimitUseBean;
import kd.tmc.fbp.common.model.guaranteeuse.GuaranteeUseBean;
import kd.tmc.fbp.common.model.interest.ReturnCreditLimitInfo;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CreditLimitHelper {
    public static final Set<String> getSelectProps() {
        HashSet<String> props = new HashSet<String>();
        props.add("org");
        props.add("orgsharetype");
        props.add("credittype");
        props.add("avaramt");
        props.add("entry_org.o_org");
        props.add("entry_org.o_totalamt");
        props.add("entry_type.t_credittype");
        props.add("entry_type.t_totalamt");
        props.add("entry_mult.m_credittype");
        props.add("entry_mult.m_org");
        return props;
    }

    public static QFilter getCreditLimitFilter(CreditLimitUseBean useBean) {
        QFilter filter = new QFilter("status", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("isclose", "=", (Object)"0").and("isframework", "=", (Object)"0").and(new QFilter("orgsharetype", "=", (Object)OrgShareTypeEnum.DOWNSHARE.getValue()).or(new QFilter("orgsharetype", "=", (Object)OrgShareTypeEnum.APPOINTSHARE.getValue()).and(new QFilter("entry_org.o_org.fbasedataid.id", "=", (Object)useBean.getOrgId()))));
        filter.and(CreditLimitHelper.bankFilter(useBean));
        Object[] creditLimits = TmcDataServiceHelper.load((String)"cfm_creditlimit", (String)String.join((CharSequence)",", CreditLimitHelper.getSelectProps()), (QFilter[])new QFilter[]{filter});
        HashSet<Long> ids = new HashSet<Long>(creditLimits.length);
        if (EmptyUtil.isNoEmpty((Object[])creditLimits)) {
            Set creditIds = Arrays.stream(creditLimits).filter(o -> o.getBigDecimal("avaramt").compareTo(BigDecimal.ZERO) == 0).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
            if (EmptyUtil.isNoEmpty(creditIds)) {
                DynamicObjectCollection creditUsesPre;
                DynamicObjectCollection creditUses = CreditLimitHelper.getCredituseBill(useBean.getPkId(), useBean.getEntityName());
                creditIds = creditUses.stream().map(o -> o.get("creditlimit")).collect(Collectors.toSet());
                if (EmptyUtil.isNoEmpty((Long)useBean.getSourceBillId()) && EmptyUtil.isNoEmpty((String)useBean.getSourceType()) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(creditUsesPre = CreditLimitHelper.getCredituseBill(useBean.getSourceBillId(), useBean.getSourceType())))) {
                    creditIds.addAll(creditUsesPre.stream().map(o -> o.get("creditlimit")).collect(Collectors.toSet()));
                }
            }
            for (Object creditLimit : creditLimits) {
                if (creditLimit.getBigDecimal("avaramt").compareTo(BigDecimal.ZERO) == 0 && !creditIds.contains(creditLimit.getPkValue()) || !CreditLimitHelper.checkCreditType((DynamicObject)creditLimit, useBean.getCreditTypeId())) continue;
                if (OrgShareTypeEnum.APPOINTSHARE.getValue().equals(creditLimit.getString("orgsharetype"))) {
                    ids.add(creditLimit.getLong("id"));
                    continue;
                }
                Long creditLimitId = CreditLimitHelper.checkCreditLimitOrg((DynamicObject)creditLimit, useBean.getOrgId());
                if (!EmptyUtil.isNoEmpty((Long)creditLimitId)) continue;
                ids.add(creditLimit.getLong("id"));
            }
        }
        return new QFilter("id", "in", ids);
    }

    private static DynamicObjectCollection getCredituseBill(Long souId, String souType) {
        DynamicObjectCollection creditUses = QueryServiceHelper.query((String)"cfm_credituse", (String)"id,creditlimit", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)souId), new QFilter("sourcetype", "=", (Object)souType), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("realamt", ">", (Object)0)});
        return creditUses;
    }

    private static QFilter bankFilter(CreditLimitUseBean useBean) {
        if (EmptyUtil.isEmpty((String)useBean.getCreditFinType())) {
            useBean.setCreditFinType(CreditFinTypeEnum.FINORG.getValue());
        }
        Long finOrgId = useBean.getFinOrgId();
        QFilter filter = new QFilter("bank", "=", (Object)finOrgId);
        boolean isFinOrg = CreditFinTypeEnum.FINORG.getValue().equals(useBean.getCreditFinType());
        if (!isFinOrg) {
            return filter;
        }
        DynamicObject finOrg = TmcDataServiceHelper.loadSingle((Object)finOrgId, (String)"bd_finorginfo");
        boolean isBank = "0".equals(finOrg.getDynamicObject("finorgtype").get("type"));
        if (isBank) {
            Object bankCateId = CreditLimitHelper.getBankCateIdByFinOrgId(finOrgId);
            filter = new QFilter("bank.bank_cate", "=", bankCateId);
        }
        return filter;
    }

    private static boolean checkCreditType(DynamicObject creditLimit, Long typeId) {
        DynamicObjectCollection entryTypes = creditLimit.getDynamicObjectCollection("entry_type");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryTypes)) {
            return true;
        }
        if (EmptyUtil.isEmpty((Long)typeId)) {
            return false;
        }
        for (DynamicObject entryType : entryTypes) {
            DynamicObject type = CreditLimitHelper.getDynFormMultiple(entryType, "t_credittype");
            if (type == null || !typeId.equals(type.getLong("id"))) continue;
            return true;
        }
        return false;
    }

    private static Long checkCreditLimitOrg(DynamicObject creditLimit, Long orgId) {
        DynamicObjectCollection entryOrgs = creditLimit.getDynamicObjectCollection("entry_org");
        for (DynamicObject entryOrg : entryOrgs) {
            if (!CreditLimitHelper.isParentOrg(entryOrg, orgId)) continue;
            return creditLimit.getLong("id");
        }
        return null;
    }

    public static void fillCanUseCreditLimitAmt(CreditLimitUseBean useBean, List<DynamicObject> creditLimitList) {
        DynamicObject[] creditLimitArr = TmcDataServiceHelper.load((Object[])creditLimitList.stream().map(DataEntityBase::getPkValue).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_creditlimit"));
        Map<String, BigDecimal> preAmountMap = CreditLimitHelper.getPreAmountByCreditType(useBean);
        for (DynamicObject creditLimit : creditLimitArr) {
            BigDecimal avaAmt = CreditLimitHelper.getCanUseCreditLimitAmt(useBean, creditLimit, preAmountMap);
            creditLimitList.stream().filter(o -> o.getPkValue().equals(creditLimit.getPkValue())).findFirst().ifPresent(srcCreditLimit -> srcCreditLimit.set("curravaamt", (Object)avaAmt));
        }
    }

    public static Map<String, BigDecimal> getPreAmountByCreditType(CreditLimitUseBean useBean) {
        Map<String, BigDecimal> sourceMap = new HashMap<String, BigDecimal>();
        Long compId = useBean.getOrgId();
        Long sourceBillId = useBean.getSourceBillId();
        String sourceType = useBean.getSourceType();
        if (EmptyUtil.isNoEmpty((Long)sourceBillId) && EmptyUtil.isNoEmpty((String)sourceType)) {
            sourceMap = CreditLimitHelper.getPreAmountByBill(compId, sourceBillId, sourceType);
        }
        if (EmptyUtil.isNoEmpty((Long)useBean.getPkId()) && EmptyUtil.isNoEmpty((String)useBean.getEntityName())) {
            Map<String, BigDecimal> billMap = CreditLimitHelper.getPreAmountByBill(compId, useBean.getPkId(), useBean.getEntityName());
            for (Map.Entry<String, BigDecimal> map : billMap.entrySet()) {
                sourceMap.put(map.getKey(), sourceMap.getOrDefault(map.getKey(), BigDecimal.ZERO).add(map.getValue()));
            }
        }
        return sourceMap;
    }

    public static Map<String, BigDecimal> getPreAmountByBill(Long compId, Long sourceBillId, String sourceType) {
        HashMap<String, BigDecimal> preUseMap = new HashMap<String, BigDecimal>();
        if (EmptyUtil.isNoEmpty((Long)sourceBillId) && EmptyUtil.isNoEmpty((String)sourceType)) {
            DynamicObjectCollection creditPreUse = QueryServiceHelper.query((String)"cfm_credituse", (String)"id,preamount,realamt,credittype,creditlimit", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)sourceBillId), new QFilter("sourcetype", "=", (Object)sourceType), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("org", "=", (Object)compId), new QFilter("realamt", ">", (Object)0)});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)creditPreUse)) {
                return preUseMap;
            }
            for (DynamicObject use : creditPreUse) {
                long creditType = use.getLong("credittype");
                String key = compId + use.getString("creditlimit") + (EmptyUtil.isNoEmpty((Long)creditType) ? String.valueOf(creditType) : "");
                preUseMap.put(key, preUseMap.getOrDefault(key, BigDecimal.ZERO).add(use.getBigDecimal("realamt")));
            }
        }
        return preUseMap;
    }

    public static BigDecimal getCanUseCreditLimitAmt(CreditLimitUseBean useBean, DynamicObject creditLimit, Map<String, BigDecimal> preAmountMap) {
        Long creditTypeId = useBean.getCreditTypeId();
        Long compId = useBean.getOrgId();
        return CreditLimitHelper.getCreditLimitAvarAmt(creditLimit, creditTypeId, compId, preAmountMap);
    }

    public static BigDecimal getCreditLimitAvarAmt(DynamicObject creditLimit, Long creditTypeId, Long compId, Map<String, BigDecimal> preAmountMap) {
        BigDecimal avarAmt = creditLimit.getBigDecimal("avaramt");
        BigDecimal orgEntryAmt = CreditLimitHelper.getOrgEntryAmt(creditLimit, compId);
        BigDecimal typeEntryAmt = CreditLimitHelper.getTypeEntryAmt(creditLimit, creditTypeId);
        BigDecimal multEntryAmt = CreditLimitHelper.getMultEntryAmt(creditLimit, compId, creditTypeId);
        String key = compId + creditLimit.getString("id") + (EmptyUtil.isEmpty((Long)creditTypeId) ? "" : creditTypeId);
        BigDecimal preAmount = preAmountMap == null ? BigDecimal.ZERO : preAmountMap.get(key);
        BigDecimal actAmt = avarAmt.min(orgEntryAmt);
        if (typeEntryAmt != null) {
            actAmt = actAmt.min(typeEntryAmt);
        }
        if (multEntryAmt != null) {
            actAmt = actAmt.min(multEntryAmt);
        }
        if (preAmount != null) {
            actAmt = actAmt.add(preAmount);
        }
        return actAmt;
    }

    private static BigDecimal getOrgEntryAmt(DynamicObject creditLimit, Long orgId) {
        String orgShareType = creditLimit.getString("orgsharetype");
        boolean isGroup = creditLimit.getBoolean("isgrouplimit");
        BigDecimal avaAmt = BigDecimal.ZERO;
        DynamicObjectCollection orgEntrys = creditLimit.getDynamicObjectCollection("entry_org");
        if (EmptyUtil.isEmpty((Long)orgId) || orgEntrys == null || orgEntrys.size() == 0) {
            return avaAmt;
        }
        if (OrgShareTypeEnum.DOWNSHARE.getValue().equals(orgShareType) || !isGroup) {
            boolean isParent = false;
            for (DynamicObject orgEntry : orgEntrys) {
                if (!CreditLimitHelper.isParentOrg(orgEntry, orgId)) continue;
                BigDecimal avaAmtTemp = orgEntry.getBigDecimal("o_avaramt");
                avaAmt = !isParent || avaAmt.compareTo(avaAmtTemp) > 0 ? avaAmtTemp : avaAmt;
                isParent = true;
            }
        } else {
            Map<String, BigDecimal> entryOrgAvaAmtMap = CreditLimitHelper.getEntryAvaAmtMap(orgEntrys, "o_avaramt", "o_org");
            avaAmt = entryOrgAvaAmtMap.getOrDefault(String.valueOf(orgId), BigDecimal.ZERO);
        }
        return avaAmt;
    }

    public static boolean isParentOrg(DynamicObject orgEntry, Long orgId) {
        DynamicObject org = CreditLimitHelper.getDynFormMultiple(orgEntry, "o_org");
        return org != null && CreditLimitHelper.isCheckParentOrg(org.getLong("id"), orgId);
    }

    public static boolean isCheckParentOrg(long parentOrgId, long orgId) {
        return parentOrgId == orgId || OrgUnitServiceHelper.isParentOrg((String)"08", (long)parentOrgId, (long)orgId);
    }

    public static boolean isParentOrgColl(DynamicObjectCollection orgColl, Long orgId, String orgshareType) {
        if (OrgShareTypeEnum.APPOINTSHARE.getValue().equals(orgshareType)) {
            Set<Long> orgCollIds = CreditLimitHelper.getCollIds(orgColl);
            return orgCollIds.contains(orgId);
        }
        for (DynamicObject org : orgColl) {
            DynamicObject multOrg = org.getDynamicObject("fbasedataid");
            boolean isParentOrg = multOrg != null && CreditLimitHelper.isCheckParentOrg(multOrg.getLong("id"), orgId);
            if (!isParentOrg) continue;
            return isParentOrg;
        }
        return false;
    }

    public static Set<Long> getAllOrgIds(DynamicObjectCollection orgColl, boolean isDownShare) {
        if (!isDownShare) {
            return CreditLimitHelper.getCollIds(orgColl);
        }
        HashSet<Long> orgIds = new HashSet<Long>();
        for (DynamicObject org : orgColl) {
            DynamicObject baseOrg = org.getDynamicObject("fbasedataid");
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"08", Collections.singletonList(baseOrg.getLong("id")), (boolean)true);
            orgIds.addAll(subOrgIds.parallelStream().collect(Collectors.toSet()));
        }
        return orgIds;
    }

    private static BigDecimal getTypeEntryAmt(DynamicObject creditLimit, Long typeId) {
        DynamicObject creditType = creditLimit.getDynamicObject("credittype");
        DynamicObjectCollection entryTypes = creditLimit.getDynamicObjectCollection("entry_type");
        BigDecimal avaAmt = BigDecimal.ZERO;
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryTypes)) {
            return null;
        }
        if (EmptyUtil.isEmpty((Long)typeId)) {
            return BigDecimal.ZERO;
        }
        if (!creditType.getBoolean("iscomprehensive") && entryTypes.size() > 0) {
            DynamicObject entryCreditType = CreditLimitHelper.getDynFormMultiple((DynamicObject)entryTypes.get(0), "t_credittype");
            if (entryCreditType != null && entryCreditType.getLong("id") == typeId.longValue()) {
                return ((DynamicObject)entryTypes.get(0)).getBigDecimal("t_avaramt");
            }
        } else {
            Map<String, BigDecimal> entryTypeAvaAmtMap = CreditLimitHelper.getEntryAvaAmtMap(entryTypes, "t_avaramt", "t_credittype");
            avaAmt = entryTypeAvaAmtMap.get(String.valueOf(typeId));
        }
        return avaAmt;
    }

    private static BigDecimal getMultEntryAmt(DynamicObject creditLimit, Long orgId, Long typeId) {
        DynamicObjectCollection multEntrys = creditLimit.getDynamicObjectCollection("entry_mult");
        boolean isMultControl = creditLimit.getBoolean("ismultcontrol");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)multEntrys) || EmptyUtil.isEmpty((Long)orgId) || EmptyUtil.isEmpty((Long)typeId)) {
            return isMultControl ? BigDecimal.ZERO : null;
        }
        ArrayList<BigDecimal> multAmt = new ArrayList<BigDecimal>(multEntrys.size());
        for (DynamicObject multEntry : multEntrys) {
            DynamicObjectCollection types = multEntry.getDynamicObjectCollection("m_credittype");
            DynamicObjectCollection orgs = multEntry.getDynamicObjectCollection("m_org");
            Set<Long> typeCollIds = CreditLimitHelper.getCollIds(types);
            boolean isParentOrgColl = CreditLimitHelper.isParentOrgColl(orgs, orgId, creditLimit.getString("orgsharetype"));
            if (!typeCollIds.contains(typeId) || !isParentOrgColl) continue;
            multAmt.add(multEntry.getBigDecimal("m_avaramt"));
        }
        if (multAmt.size() > 0) {
            return multAmt.stream().min(BigDecimal::compareTo).orElse(BigDecimal.ZERO);
        }
        return isMultControl ? BigDecimal.ZERO : null;
    }

    public static Map<String, BigDecimal> getEntryAvaAmtMap(DynamicObjectCollection entrys, String amtField, String baseField) {
        HashMap<String, BigDecimal> amtMap = new HashMap<String, BigDecimal>(16);
        for (DynamicObject entry : entrys) {
            BigDecimal avaAmt = entry.getBigDecimal(amtField);
            DynamicObjectCollection colls = entry.getDynamicObjectCollection(baseField);
            colls.stream().forEach(o -> {
                DynamicObject org = o.getDynamicObject("fbasedataid");
                String orgId = org.getString("id");
                if (amtMap.containsKey(orgId)) {
                    amtMap.put(orgId, ((BigDecimal)amtMap.get(orgId)).min(avaAmt));
                } else {
                    amtMap.put(orgId, avaAmt);
                }
            });
        }
        return amtMap;
    }

    public static Map<Long, BigDecimal> getParentAmtMap(DynamicObjectCollection entrys, String field) {
        HashMap<Long, BigDecimal> amtMap = new HashMap<Long, BigDecimal>(16);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            return amtMap;
        }
        entrys.stream().filter(o -> EmptyUtil.isEmpty((Long)o.getLong("pid"))).forEach(e -> {
            BigDecimal totalAmt = e.getBigDecimal(field);
            amtMap.put(e.getLong("id"), totalAmt);
        });
        return amtMap;
    }

    public static DynamicObject[] getMergeSrcCredit(DynamicObject mergedCredit) {
        QFilter idFilter = new QFilter("id", "in", (Object)mergedCredit.getDynamicObjectCollection("sourcebillids").stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).toArray());
        DynamicObjectCollection creditLimitArr = QueryServiceHelper.query((String)"cfm_creditlimit", (String)"id", (QFilter[])new QFilter[]{idFilter});
        if (EmptyUtil.isEmpty((DynamicObjectCollection)creditLimitArr)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6%s\u5355\u65e0\u6cd5\u627e\u5230\u6e90\u5355", (String)"CreditLimitHelper_0", (String)"tmc-creditm-common", (Object[])new Object[0]), mergedCredit.getString("number")));
        }
        return TmcDataServiceHelper.load((Object[])creditLimitArr.stream().map(d -> d.get("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_creditlimit"));
    }

    public static DynamicObject getRealCreditLimit(DynamicObject creditLimit) {
        if (creditLimit.getBoolean("ismergesrc")) {
            DynamicObject targetCredit = CreditLimitHelper.getMergeTargetCredit(creditLimit);
            return CreditLimitHelper.getRealCreditLimit(targetCredit);
        }
        return creditLimit;
    }

    public static DynamicObject getMergeTargetCredit(DynamicObject srcCredit) {
        QFilter idFilter = new QFilter("sourcebillids.fbasedataid", "=", srcCredit.getPkValue());
        DynamicObject creditLimit = TmcDataServiceHelper.loadSingle((String)"cfm_creditlimit", (String)"id", (QFilter[])new QFilter[]{idFilter});
        if (creditLimit == null) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6%s\u5355\u65e0\u6cd5\u627e\u5230\u4e0b\u6e38\u5355\u636e", (String)"CreditLimitHelper_1", (String)"tmc-creditm-common", (Object[])new Object[0]), srcCredit.getString("number")));
        }
        creditLimit = TmcDataServiceHelper.loadSingle((Object)creditLimit.getPkValue(), (String)"cfm_creditlimit");
        return creditLimit;
    }

    public static boolean isCreditUsed(DynamicObject data) {
        return TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", data.getPkValue()), new QFilter("iscopy", "=", (Object)Character.valueOf('0')), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
    }

    public static List<DynamicObject> getPrevCreditUseRec(String entityName, Object pkId, Object creditLimitId) {
        ArrayList<DynamicObject> useRecList = new ArrayList<DynamicObject>();
        QFilter sourceTypeFilter = new QFilter("sourcetype", "=", (Object)entityName);
        QFilter sourceIdFilter = new QFilter("sourcebillid", "=", pkId);
        QFilter creditLimitIdFilter = new QFilter("creditlimit", "=", creditLimitId);
        DynamicObjectCollection creditUseArr = QueryServiceHelper.query((String)"cfm_credituse", (String)"id,billstatus", (QFilter[])new QFilter[]{sourceTypeFilter, sourceIdFilter, creditLimitIdFilter}, (String)"createtime desc", (int)1);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditUseArr)) {
            useRecList.addAll(Arrays.asList(TmcDataServiceHelper.load((Object[])new Object[]{((DynamicObject)creditUseArr.get(0)).get("id")}, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_credituse"))));
        }
        return useRecList;
    }

    public static List<Map<String, Object>> autoFillCreditLimitType(DynamicObject creditLimit, CreditLimitUseBean useBean, BigDecimal rate, BigDecimal realBizAmt) {
        BigDecimal creditRatio;
        Map<String, BigDecimal> preAmountMap;
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(16);
        Long compId = useBean.getOrgId();
        Long creditTypeId = useBean.getCreditTypeId();
        BigDecimal avarAmt = creditLimit.getBigDecimal("avaramt");
        BigDecimal orgEntryAmt = CreditLimitHelper.getOrgEntryAmt(creditLimit, compId);
        BigDecimal typeEntryAmt = CreditLimitHelper.getTypeEntryAmt(creditLimit, creditTypeId);
        BigDecimal multEntryAmt = CreditLimitHelper.getMultEntryAmt(creditLimit, compId, creditTypeId);
        String shareType = CreditShareTypeEnum.ORG.getName();
        avarAmt = avarAmt.min(orgEntryAmt);
        if (typeEntryAmt != null && avarAmt.compareTo(typeEntryAmt) > 0) {
            shareType = CreditShareTypeEnum.TYPE.getName();
            avarAmt = typeEntryAmt;
        }
        if (multEntryAmt != null && avarAmt.compareTo(multEntryAmt) > 0) {
            shareType = CreditShareTypeEnum.MULT.getName();
            avarAmt = multEntryAmt;
        }
        if ((preAmountMap = CreditLimitHelper.getPreAmountByCreditType(useBean)) != null) {
            String key = compId + creditLimit.getString("id") + creditTypeId;
            BigDecimal preAmt = preAmountMap.get(key);
            avarAmt = avarAmt.add(preAmt != null ? preAmt : BigDecimal.ZERO);
        }
        if (EmptyUtil.isEmpty((BigDecimal)(creditRatio = useBean.getCreditRatio()))) {
            creditRatio = Constants.ONE_HUNDRED;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("et_credittype", creditTypeId);
        data.put("et_ctrltype", shareType);
        data.put("et_avaamt", avarAmt);
        data.put("amount", useBean.getBizAmt().multiply(creditRatio).divide(Constants.ONE_HUNDRED));
        data.put("creditratio", useBean.getCreditRatio());
        data.put("exchangerate", rate);
        BigDecimal realAmt = realBizAmt.multiply(rate).setScale(CreditLimitHelper.getAmtPrecision(creditLimit.getDynamicObject("currency")), RoundingMode.DOWN);
        data.put("et_useamt", realAmt);
        dataList.add(data);
        return dataList;
    }

    public static int getAmtPrecision(DynamicObject currency) {
        if (currency == null) {
            return 0;
        }
        int amtprecision = currency.getInt("amtprecision");
        return amtprecision;
    }

    public static void checkCreditLimitStatus(String creditLimitNum, DynamicObject creditLimit, boolean isMerge) {
        Object billStatus = creditLimit.get("status");
        if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            String msg = ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%s]\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"CreditLimitHelper_11", (String)"tmc-creditm-common", (Object[])new Object[]{creditLimit.getString("number")});
            if (isMerge) {
                msg = String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%1$s]\u5df2\u8fdb\u884c\u7eed\u6388\u4fe1\uff0c\u65b0\u6388\u4fe1\u989d\u5ea6\u5355[%2$s]\u975e\u5df2\u5ba1\u6838\u72b6\u6001\u3002", (String)"CreditLimitHelper_12", (String)"tmc-creditm-common", (Object[])new Object[0]), creditLimitNum, creditLimit.getString("number"));
            }
            throw new KDBizException(msg);
        }
        boolean isClose = creditLimit.getBoolean("isclose");
        if (isClose) {
            String closeMsg = ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%s]\u5df2\u5173\u95ed\u3002", (String)"CreditLimitHelper_13", (String)"tmc-creditm-common", (Object[])new Object[]{creditLimit.getString("number")});
            if (isMerge) {
                closeMsg = String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355[%1$s]\u5df2\u8fdb\u884c\u7eed\u6388\u4fe1\uff0c\u65b0\u6388\u4fe1\u989d\u5ea6\u5355[%2$s]\u5df2\u5173\u95ed\u3002", (String)"CreditLimitHelper_14", (String)"tmc-creditm-common", (Object[])new Object[0]), creditLimitNum, creditLimit.getString("number"));
            }
            throw new KDBizException(closeMsg);
        }
    }

    public static String checkStatus(DynamicObject creditLimit) {
        boolean isClose;
        StringBuilder str = new StringBuilder();
        Object billStatus = creditLimit.get("status");
        if (!BillStatusEnum.AUDIT.getValue().equals(billStatus)) {
            str.append(ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"CreditLimitHelper_18", (String)"tmc-creditm-common", (Object[])new Object[0])).append("\u3001");
        }
        if (isClose = creditLimit.getBoolean("isclose")) {
            str.append(ResManager.loadKDString((String)"\u672a\u5173\u95ed", (String)"CreditLimitHelper_19", (String)"tmc-creditm-common", (Object[])new Object[0])).append("\u3001");
        }
        return EmptyUtil.isEmpty((CharSequence)str) ? "" : str.substring(0, str.length() - 1);
    }

    public static void checkCreditLimitLegal(CreditLimitUseBean useBean, DynamicObject creditLimit) {
        String msg = CreditLimitHelper.checkStatus(creditLimit);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5360\u7528\u5931\u8d25\uff0c\u53ea\u80fd\u5360\u7528%s\u7684\u6388\u4fe1\u989d\u5ea6\u3002", (String)"CreditLimitHelper_9", (String)"tmc-creditm-common", (Object[])new Object[]{msg}));
        }
        Long finOrgId = useBean.getFinOrgId();
        boolean isFinorg = CreditFinTypeEnum.FINORG.getValue().equals(useBean.getCreditFinType());
        DynamicObject bank = creditLimit.getDynamicObject("bank");
        if (isFinorg) {
            DynamicObject finOrg = TmcDataServiceHelper.loadSingle((Object)finOrgId, (String)"bd_finorginfo", (String)"id,finorgtype,org");
            boolean isBank = "0".equals(finOrg.getDynamicObject("finorgtype").get("type"));
            if (isBank) {
                Object creditLimitBankCateId;
                Object useBankCateId = CreditLimitHelper.getBankCateIdByFinOrgId(useBean.getFinOrgId());
                if (!useBankCateId.equals(creditLimitBankCateId = CreditLimitHelper.getBankCateIdByFinOrgId((Long)bank.getPkValue()))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5360\u7528\u5931\u8d25\uff0c\u6388\u4fe1\u673a\u6784\u5bf9\u5e94\u7684\u94f6\u884c\u7c7b\u522b\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5", (String)"CreditLimitHelper_7", (String)"tmc-creditm-common", (Object[])new Object[0]));
                }
            } else if (!bank.getPkValue().equals(finOrgId)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5360\u7528\u5931\u8d25\uff0c\u6388\u4fe1\u673a\u6784\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5", (String)"CreditLimitHelper_17", (String)"tmc-creditm-common", (Object[])new Object[0]));
            }
        } else if (!bank.getPkValue().equals(finOrgId)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5360\u7528\u5931\u8d25\uff0c\u6388\u4fe1\u673a\u6784\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5", (String)"CreditLimitHelper_17", (String)"tmc-creditm-common", (Object[])new Object[0]));
        }
    }

    private static Object getBankCateIdByFinOrgId(Long finOrgId) {
        DynamicObject finOrg = TmcDataServiceHelper.loadSingle((Object)finOrgId, (String)"bd_finorginfo", (String)"id,bank_cate");
        DynamicObject bankCate = finOrg.getDynamicObject("bank_cate");
        Object bankCateId = bankCate != null ? bankCate.getPkValue() : Long.valueOf(0L);
        return bankCateId;
    }

    public static void mergedCreditSubmit(DynamicObject mergedCredit) {
        boolean isMergeSrcClose = mergedCredit.getBoolean("ismergesrcclose");
        if (isMergeSrcClose) {
            return;
        }
        Object[] srcCreditArr = CreditLimitHelper.getMergeSrcCredit(mergedCredit);
        if (EmptyUtil.isEmpty((Object[])srcCreditArr)) {
            return;
        }
        Object[] srcBillIds = Arrays.stream(srcCreditArr).map(DataEntityBase::getPkValue).toArray();
        QFilter creditUseIdFilter = new QFilter("creditlimit", "in", (Object)srcBillIds);
        DynamicObjectCollection creditUseColl = QueryServiceHelper.query((String)"cfm_credituse", (String)"id", (QFilter[])new QFilter[]{creditUseIdFilter});
        Map<Object, Object> creditUseMap = new HashMap();
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)creditUseColl)) {
            Object[] creditUseIdArr = creditUseColl.stream().map(d -> d.get("id")).toArray();
            creditUseMap = Stream.of(TmcDataServiceHelper.load((Object[])creditUseIdArr, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_credituse"))).collect(Collectors.groupingBy(o -> o.getDynamicObject("creditlimit").getPkValue()));
        }
        ArrayList newUseList = new ArrayList();
        for (Object srcCredit : srcCreditArr) {
            srcCredit.set("isclose", (Object)"1");
            srcCredit.set("ismergesrc", (Object)"1");
            srcCredit.set("closedate", (Object)DateUtils.getCurrentDate());
            srcCredit.set("closeuser", (Object)RequestContext.get().getCurrUserId());
            List srcUseList = (List)creditUseMap.get(srcCredit.getPkValue());
            if (srcUseList == null) continue;
            newUseList.addAll(srcUseList.stream().map(o -> {
                DynamicObject newUseObj = TmcDataServiceHelper.clone((DynamicObject)o);
                newUseObj.set("id", (Object)DB.genLongId((String)newUseObj.getDataEntityType().getAlias()));
                newUseObj.set("creditlimit", (Object)mergedCredit);
                newUseObj.set("iscopy", (Object)1);
                return newUseObj;
            }).collect(Collectors.toList()));
        }
        TmcDataServiceHelper.save((DynamicObject[])srcCreditArr);
        if (newUseList.size() > 0) {
            TmcDataServiceHelper.save((DynamicObject[])newUseList.toArray(new DynamicObject[0]));
        }
        mergedCredit.set("ismergesrcclose", (Object)1);
    }

    public static DynamicObject getDynFormMultiple(DynamicObject obj, String field) {
        DynamicObjectCollection dyns = obj.getDynamicObjectCollection(field);
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dyns)) {
            return ((DynamicObject)dyns.get(0)).getDynamicObject("fbasedataid");
        }
        return null;
    }

    public static void handleCreditLimtByType(DynamicObject creditLimit, DynamicObject creditUse, BigDecimal amount, boolean isPre) {
        long orgId = creditUse.getDynamicObject("org").getLong("id");
        DynamicObject creditType = creditUse.getDynamicObject("credittype");
        long creditTypeId = creditType != null ? creditType.getLong("id") : 0L;
        CreditLimitAmtHelper.dealOrgEntryAmt(creditLimit, orgId, isPre, amount);
        CreditLimitAmtHelper.dealTypeEntryAmt(creditLimit, creditTypeId, isPre, amount);
        CreditLimitAmtHelper.dealMultEntryAmt(creditLimit, creditTypeId, orgId, isPre, amount);
        CreditLimitAmtHelper.dealHeadAmt(creditLimit, isPre, amount);
    }

    public static Long checkBillHasReturn(Map<Long, ReturnCreditLimitInfo> returnInfoMap, Long creditLimitId, Set<Object> creditUseIds) {
        QFilter creditLimitUseFilter;
        Long bizBillId = 0L;
        HashSet<Long> returnIds = new HashSet<Long>(returnInfoMap.size());
        for (Map.Entry<Long, ReturnCreditLimitInfo> infos : returnInfoMap.entrySet()) {
            ReturnCreditLimitInfo param = infos.getValue();
            Long returnId = EmptyUtil.isEmpty((Long)param.getReturnBillId()) ? param.getBizBillId() : param.getReturnBillId();
            bizBillId = EmptyUtil.isEmpty((Long)param.getBizBillId()) ? returnId : param.getBizBillId();
            returnIds.add(returnId);
        }
        QFilter creditLimitFilter = new QFilter("creditlimit", "=", (Object)creditLimitId);
        QFilter returnIdFilter = new QFilter("returnentry.e_returnid", "in", returnIds).and(new QFilter("returnentry.e_bizbillid", "in", (Object)bizBillId));
        boolean isHas = TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])new QFilter[]{creditLimitFilter, returnIdFilter, creditLimitUseFilter = new QFilter("id", "in", creditUseIds)});
        if (isHas) {
            return bizBillId;
        }
        return 0L;
    }

    public static Pair<BigDecimal, BigDecimal> getMultAmt(Long creditLimitId, Set<Long> orgIds, Set<Long> typeIds) {
        if (EmptyUtil.isEmpty(orgIds) || EmptyUtil.isEmpty(typeIds)) {
            return Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO);
        }
        DataSet creditUseDataSet = QueryServiceHelper.queryDataSet((String)"creditUse", (String)"cfm_credituse", (String)"id,case when amount>0 then amount-returnamt else amount end as amount,case when preamount>0 then preamount-returnamt else preamount end as preamount,creditlimit,credittype", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", (Object)creditLimitId), new QFilter("org", "in", orgIds), new QFilter("credittype", "in", typeIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("realamt", ">", (Object)BigDecimal.ZERO)}, (String)"credittype").groupBy(new String[]{"creditlimit"}).sum("amount").sum("preamount").finish();
        if (creditUseDataSet != null && creditUseDataSet.hasNext()) {
            Row creditUse = creditUseDataSet.next();
            return Pair.of((Object)creditUse.getBigDecimal("amount"), (Object)creditUse.getBigDecimal("preamount"));
        }
        return Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO);
    }

    public static Map<Long, Pair<BigDecimal, BigDecimal>> getCreditTypeAmt(Long creditLimitId, Set<Long> typeIds, String selField) {
        HashSet<Long> creditIds = new HashSet<Long>(1);
        creditIds.add(creditLimitId);
        Map<Long, Pair<BigDecimal, BigDecimal>> creditUseMap = CreditLimitHelper.getEntryShareAmt(creditIds, typeIds, selField);
        return creditUseMap;
    }

    public static Map<Long, Pair<BigDecimal, BigDecimal>> getEntryShareAmt(Set<Long> creditLimitId, Set<Long> baseIds, String selField) {
        HashMap<Long, Pair<BigDecimal, BigDecimal>> creditUseMap = new HashMap<Long, Pair<BigDecimal, BigDecimal>>();
        DataSet creditUseDs = CreditLimitAmtHelper.getCreditUseDs(creditLimitId, baseIds, selField);
        DataSet creditUseDataSet = creditUseDs.groupBy(new String[]{selField}).sum("amount").sum("preamount").finish();
        for (Row row : creditUseDataSet) {
            creditUseMap.put(row.getLong(selField), (Pair<BigDecimal, BigDecimal>)Pair.of((Object)row.getBigDecimal("amount"), (Object)row.getBigDecimal("preamount")));
        }
        return creditUseMap;
    }

    public static DynamicObject getCreditTypeById(long id) {
        Map typeMap = TmcDataServiceHelper.loadFromCache((Object[])new Object[]{id}, (String)"cfm_credittype");
        return (DynamicObject)typeMap.get(id);
    }

    public static String getMultCollectName(DynamicObjectCollection colls) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
            return "";
        }
        HashSet names = new HashSet(16);
        colls.forEach(o -> {
            if (o.getDynamicObject("fbasedataid") != null) {
                names.add(o.getDynamicObject("fbasedataid").getString("name"));
            }
        });
        String join = String.join((CharSequence)",", names);
        if (EmptyUtil.isNoEmpty((String)join) && join.length() > 2000) {
            join = join.substring(0, 1997) + "...";
        }
        return join;
    }

    public static Map<Long, String> getMultFromDyn(DynamicObjectCollection colls) {
        HashMap<Long, String> baseMap = new HashMap<Long, String>(16);
        colls.forEach(o -> {
            DynamicObject baseDyn = o.getDynamicObject("fbasedataid");
            baseMap.put(baseDyn.getLong("id"), baseDyn.getString("name"));
        });
        return baseMap;
    }

    public static String getMultCollectIdOrName(DynamicObjectCollection colls, boolean isId) {
        if (EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
            return null;
        }
        return ((DynamicObject)colls.get(0)).getDynamicObject("fbasedataid").getString(isId ? "id" : "name");
    }

    public static Set<Long> getCollIds(DynamicObjectCollection colls) {
        HashSet<Long> ids = new HashSet<Long>(16);
        if (EmptyUtil.isEmpty((DynamicObjectCollection)colls)) {
            return ids;
        }
        colls.forEach(o -> {
            if (o.getDynamicObject("fbasedataid") != null) {
                ids.add(o.getDynamicObject("fbasedataid").getLong("id"));
            }
        });
        return ids;
    }

    public static Set<Long> getBaseIds(IDataModel model, String entry, String baseField) {
        int entryRowCount = model.getEntryRowCount(entry);
        HashSet<Long> ids = new HashSet<Long>(entryRowCount);
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject entryRowEntity = model.getEntryRowEntity(entry, i);
            if (EmptyUtil.isNoEmpty((Long)entryRowEntity.getLong("pid"))) continue;
            DynamicObjectCollection colls = (DynamicObjectCollection)model.getValue(baseField, i);
            Set<Long> collIds = CreditLimitHelper.getCollIds(colls);
            ids.addAll(collIds);
        }
        return ids;
    }

    public static Long checkExist(Set<Object> sets, Set<Long> setBases) {
        if (EmptyUtil.isEmpty(sets) || EmptyUtil.isEmpty(setBases)) {
            return null;
        }
        HashSet setIds = new HashSet();
        sets.forEach(s -> setIds.add(Long.parseLong(String.valueOf(s))));
        for (Long setBase : setBases) {
            if (setIds.contains(setBase)) continue;
            return setBase;
        }
        return null;
    }

    public static void setCreditTypeParentAmt(IDataModel model, IFormView view, Set<Long> pids) {
        if (pids.size() == 0) {
            return;
        }
        int entryRowCount = model.getEntryRowCount("entry_type");
        int parentIdx = 0;
        Long tempPid = 0L;
        BigDecimal useAmt = BigDecimal.ZERO;
        BigDecimal preAmt = BigDecimal.ZERO;
        for (int i = 0; i < entryRowCount; ++i) {
            DynamicObject rowEntity = model.getEntryRowEntity("entry_type", i);
            long pid = rowEntity.getLong("pid");
            if (EmptyUtil.isEmpty((Long)pid)) {
                if (EmptyUtil.isNoEmpty((Long)tempPid) && useAmt.add(preAmt).compareTo(BigDecimal.ZERO) > 0) {
                    model.setValue("t_useamt", (Object)useAmt, parentIdx);
                    model.setValue("t_preamt", (Object)preAmt, parentIdx);
                    model.setValue("t_avaramt", (Object)((BigDecimal)model.getValue("t_totalamt", parentIdx)).subtract(useAmt).subtract(preAmt), parentIdx);
                }
                parentIdx = i;
                useAmt = BigDecimal.ZERO;
                preAmt = BigDecimal.ZERO;
                continue;
            }
            tempPid = rowEntity.getLong("pid");
            if (!pids.contains(tempPid)) {
                tempPid = 0L;
                continue;
            }
            useAmt = useAmt.add((BigDecimal)model.getValue("t_useamt", i));
            preAmt = preAmt.add((BigDecimal)model.getValue("t_preamt", i));
        }
        if (EmptyUtil.isNoEmpty((Long)tempPid) && useAmt.add(preAmt).compareTo(BigDecimal.ZERO) > 0) {
            model.setValue("t_useamt", (Object)useAmt, parentIdx);
            model.setValue("t_preamt", (Object)preAmt, parentIdx);
            model.setValue("t_avaramt", (Object)((BigDecimal)model.getValue("t_totalamt", parentIdx)).subtract(useAmt).subtract(preAmt), parentIdx);
            view.updateView("t_avaramt", parentIdx);
        }
    }

    public static String getMsg(Boolean isPre) {
        String msg = ResManager.loadKDString((String)"\u5360\u7528", (String)"CreditLimitHelper_15", (String)"tmc-creditm-common", (Object[])new Object[0]);
        if (isPre != null && isPre.booleanValue()) {
            msg = ResManager.loadKDString((String)"\u9884\u5360", (String)"CreditLimitHelper_16", (String)"tmc-creditm-common", (Object[])new Object[0]);
        }
        return msg;
    }

    public static Set<Long> getMultiPorpIds(DynamicObjectCollection colls, String prop) {
        HashSet<Long> setIds = new HashSet<Long>(colls.size());
        for (DynamicObject coll : colls) {
            DynamicObjectCollection propColls = coll.getDynamicObjectCollection(prop);
            Set propCollSet = propColls.stream().map(o -> o.getDynamicObject("fbasedataid").getLong("id")).collect(Collectors.toSet());
            setIds.addAll(propCollSet);
        }
        return setIds;
    }

    public static void createTreePid(DynamicObject targetBill, String entry, String totalField, String tableName) {
        DynamicObjectCollection detailEntrys = targetBill.getDynamicObjectCollection(entry);
        long count = detailEntrys.stream().filter(o -> o.getBigDecimal(totalField).compareTo(BigDecimal.ZERO) > 0).count();
        if (EmptyUtil.isEmpty((Long)count)) {
            targetBill.getDynamicObjectCollection(entry).clear();
        }
        long[] ids = DBServiceHelper.genLongIds((String)tableName, (int)((int)count));
        int i = 0;
        Long entryId = 0L;
        for (DynamicObject detailEntry : detailEntrys) {
            BigDecimal totalAmt = detailEntry.getBigDecimal(totalField);
            if (totalAmt.compareTo(BigDecimal.ZERO) > 0 && i < ids.length) {
                entryId = ids[i];
                detailEntry.set("id", (Object)entryId);
                ++i;
                continue;
            }
            detailEntry.set("pid", (Object)entryId);
        }
    }

    public static DynamicObjectCollection generateMultiPropValue(DynamicObject entity, String propName, DynamicObject ... objs) {
        DynamicCollectionProperty currencyProp = (DynamicCollectionProperty)entity.getDynamicObjectType().getProperty(propName);
        DynamicObjectCollection collection = new DynamicObjectCollection(currencyProp.getDynamicCollectionItemPropertyType(), (Object)entity);
        for (DynamicObject obj : objs) {
            DynamicObject newObj = new DynamicObject(currencyProp.getDynamicCollectionItemPropertyType());
            newObj.set("fbasedataid", (Object)obj);
            newObj.set("fbasedataid_id", obj.getPkValue());
            collection.add((Object)newObj);
        }
        return collection;
    }

    public static List<Pair<DynamicObject, List<DynamicObject>>> checkRepeatCreditUses(List<Pair<DynamicObject, List<DynamicObject>>> creditUsePairs) {
        List<Object> creditUseList = new ArrayList();
        for (Pair<DynamicObject, List<DynamicObject>> creditUsePair : creditUsePairs) {
            creditUseList.addAll((Collection)creditUsePair.getRight());
        }
        DynamicObject[] creditLimitArr = TmcDataServiceHelper.load((Object[])creditUsePairs.stream().map(o -> ((DynamicObject)o.getLeft()).getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"cfm_creditlimit"));
        Map<Long, DynamicObject> creditLimitMap = Arrays.stream(creditLimitArr).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        creditUseList = creditUseList.stream().sorted(Comparator.comparing(o -> o.getDate("modifytime"), Comparator.reverseOrder())).collect(Collectors.toList());
        Iterator<Object> useIters = creditUseList.iterator();
        HashMap<Long, Date> useDateMap = new HashMap<Long, Date>(creditUseList.size());
        while (useIters.hasNext()) {
            DynamicObject creditUse = (DynamicObject)useIters.next();
            long sentryId = creditUse.getLong("sourcebillentryid");
            Date createTime = (Date)useDateMap.get(sentryId);
            if (createTime != null && createTime.compareTo(creditUse.getDate("modifytime")) > 0) {
                useIters.remove();
                continue;
            }
            useDateMap.put(sentryId, creditUse.getDate("modifytime"));
        }
        Map<Long, List<DynamicObject>> creditUseMap = creditUseList.stream().collect(Collectors.groupingBy(o -> o.getDynamicObject("creditlimit").getLong("id")));
        ArrayList<Pair<DynamicObject, List<DynamicObject>>> newPairLists = new ArrayList<Pair<DynamicObject, List<DynamicObject>>>(creditUseMap.size());
        for (Map.Entry<Long, List<DynamicObject>> creditUse : creditUseMap.entrySet()) {
            newPairLists.add((Pair<DynamicObject, List<DynamicObject>>)Pair.of((Object)creditLimitMap.get(creditUse.getKey()), creditUse.getValue()));
        }
        return newPairLists;
    }

    public static QFilter getFilter(String entityName, Long pkId) {
        return new QFilter("sourcebillid", "=", (Object)pkId).and(new QFilter("sourcetype", "=", (Object)entityName));
    }

    public static String checkCreditLimitAmt(DynamicObject creditLimit) {
        BigDecimal amt = creditLimit.getBigDecimal("totalamt");
        BigDecimal avarAmt = creditLimit.getBigDecimal("avaramt");
        BigDecimal useAmt = creditLimit.getBigDecimal("useamt");
        BigDecimal preUseAmt = creditLimit.getBigDecimal("preuseamt");
        if (avarAmt.compareTo(BigDecimal.ZERO) < 0 || useAmt.compareTo(BigDecimal.ZERO) < 0 || preUseAmt.compareTo(BigDecimal.ZERO) < 0 || avarAmt.compareTo(amt) > 0) {
            DynamicObject currency = creditLimit.getDynamicObject("currency");
            int amtPrecision = CreditLimitHelper.getAmtPrecision(currency);
            return String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5355%1$s\u5904\u7406\u7ed3\u679c\u5f02\u5e38\uff1a\u603b\u6388\u4fe1\u989d\u5ea6%2$s\uff0c\u5df2\u7528\u989d\u5ea6%3$s\uff0c\u9884\u5360\u989d\u5ea6%4$s\uff0c\u53ef\u7528\u989d\u5ea6%5$s\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u3002", (String)"CreditLimitService_22", (String)"tmc-creditm-common", (Object[])new Object[0]), creditLimit.getString("number"), amt.setScale(amtPrecision, RoundingMode.HALF_UP), useAmt.setScale(amtPrecision, RoundingMode.HALF_UP), preUseAmt.setScale(amtPrecision, RoundingMode.HALF_UP), avarAmt.setScale(amtPrecision, RoundingMode.HALF_UP));
        }
        return "";
    }

    public static String checkCreditUseTotal(List<Long> creditlimitIds) {
        DataSet creditUseDs = QueryServiceHelper.queryDataSet((String)"checkCreditUseTotal", (String)"cfm_credituse", (String)"creditlimit,case when amount>0 then amount-returnamt else 0 end amount,case when preamount>0 then preamount-returnamt else 0 end preamount", (QFilter[])new QFilter[]{new QFilter("creditlimit", "in", creditlimitIds), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())}, null);
        DataSet totalUseDs = creditUseDs.groupBy(new String[]{"creditlimit"}).sum("amount").sum("preamount").finish();
        DataSet creditLimitDs = QueryServiceHelper.queryDataSet((String)"getCreditlimit", (String)"cfm_creditlimit", (String)"id,number,useamt,preuseamt", (QFilter[])new QFilter[]{new QFilter("id", "in", creditlimitIds)}, null);
        DataSet joinDs = creditLimitDs.leftJoin(totalUseDs).on("id", "creditlimit").select(new String[]{"id", "number", "useamt", "preuseamt", "case when amount is null then 0 else amount end amount", "case when preamount is null then 0 else preamount end preamount"}).finish();
        for (Row ds : joinDs) {
            if (ds.getBigDecimal("useamt").compareTo(ds.getBigDecimal("amount")) == 0 && ds.getBigDecimal("preuseamt").compareTo(ds.getBigDecimal("preamount")) == 0) continue;
            return String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u989d\u5ea6\u5360\u7528\u5355%1$s\u7684\u5360\u7528\u660e\u7ec6\u6c47\u603b\u5360\u7528\u989d\u5ea6\u4e3a%2$s\uff0c\u9884\u5360\u989d\u5ea6%3$s\uff0c\u548c\u6388\u4fe1\u989d\u5ea6\u5355\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5", (String)"CreditLimitHelper_20", (String)"tmc-creditm-common", (Object[])new Object[0]), ds.getString("number"), ds.getBigDecimal("amount"), ds.getBigDecimal("preamount"));
        }
        return "";
    }

    public static void saveGuaranteeUse(DynamicObject[] bills) {
        ArrayList<GuaranteeUseBean> gUseList = new ArrayList<GuaranteeUseBean>(bills.length);
        ArrayList<Long> deleteBizIds = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            Long billId = bill.getLong("id");
            DynamicObjectCollection gContractDC = bill.getDynamicObjectCollection("entry_gcontract");
            if (EmptyUtil.isEmpty((DynamicObjectCollection)gContractDC)) {
                deleteBizIds.add(billId);
                continue;
            }
            String srcBillType = bill.getDataEntityType().getName();
            String billNo = bill.getString("number");
            DynamicObject cParty = bill.getDynamicObject("bank");
            DynamicObject bizOrg = bill.getDynamicObject("org");
            DynamicObject bizCurrency = bill.getDynamicObject("currency");
            Date startDate = bill.getDate("startdate");
            Date endDate = bill.getDate("enddate");
            BigDecimal bizAmount = bill.getBigDecimal("totalamt");
            for (DynamicObject gc : gContractDC) {
                GuaranteeUseBean gUse = new GuaranteeUseBean();
                gUse.setSrcBillId(billId);
                gUse.setSrcBillType(srcBillType);
                gUse.setSrcBillNo(billNo);
                gUse.setgContractId(Long.valueOf(gc.getDynamicObject("gcontract").getLong("id")));
                gUse.setComment(gc.getString("gcomment"));
                gUse.setBizAmount(bizAmount);
                gUse.setgAmount(gc.getBigDecimal("gamount"));
                gUse.setgRatio(gc.getBigDecimal("gratio"));
                gUse.setExchrate(gc.getBigDecimal("gexchrate"));
                gUse.setDebtOrgId(Long.valueOf(bizOrg == null ? 0L : bizOrg.getLong("id")));
                gUse.setDebtOrgText(bizOrg == null ? "" : bizOrg.getString("name"));
                gUse.setDebtCurrencyId(Long.valueOf(bizCurrency == null ? 0L : bizCurrency.getLong("id")));
                gUse.setCparty(cParty == null ? "" : cParty.getString("name"));
                gUse.setDebtStartDate(startDate);
                gUse.setDebtEndDate(endDate);
                gUseList.add(gUse);
            }
        }
        GuaranteeUseHelper.deleteGuaranteeUse(deleteBizIds);
        GuaranteeUseHelper.saveGuaranteeUse(gUseList);
    }

    public static boolean checkGuaType(String guaType) {
        if (EmptyUtil.isEmpty((String)guaType)) {
            return false;
        }
        List<String> guarTypes = Arrays.asList(guaType.split(","));
        return guarTypes.contains(GuaranteeWayEnum.ENSURE.getValue()) || guarTypes.contains(GuaranteeWayEnum.MORTGAGE.getValue()) || guarTypes.contains(GuaranteeWayEnum.PLEDGE.getValue());
    }

    public static boolean checkGuaType(List<String> guaType, List<String> gmGuaType) {
        if (EmptyUtil.isEmpty(guaType) || EmptyUtil.isEmpty(gmGuaType)) {
            return false;
        }
        for (String type : guaType) {
            if (EmptyUtil.isEmpty((String)type) || !gmGuaType.contains(type)) continue;
            return true;
        }
        return false;
    }

    public static DynamicObject getCreditUseBill(Long billId, String billType, Long entryId) {
        Object[] creditUses;
        entryId = EmptyUtil.isEmpty((Long)entryId) ? billId : entryId;
        QFilter filter = new QFilter("sourcebillid", "=", (Object)billId).and("sourcebillentryid", "=", (Object)entryId).and("isrelease", "=", (Object)"0");
        if (EmptyUtil.isNoEmpty((String)billType)) {
            filter.and("sourcetype", "=", (Object)billType);
        }
        return EmptyUtil.isNoEmpty((Object[])(creditUses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"id,credittype,org,currency,amount,preamount,returnamt,creditlimit,realamt,bizcreditamount,creditrate,creditratio", (QFilter[])new QFilter[]{filter}, (String)"createtime desc", (int)1))) ? creditUses[0] : null;
    }

    public static String checkBean(CreditLimitUseBean useBean) {
        StringBuilder str = new StringBuilder();
        if (EmptyUtil.isEmpty((Long)useBean.getOrgId())) {
            str.append("org").append(",");
        }
        if (EmptyUtil.isEmpty((Long)useBean.getCurrencyId())) {
            str.append("currency").append(",");
        }
        if (EmptyUtil.isEmpty((BigDecimal)useBean.getBizAmt())) {
            str.append("bizamt").append(",");
        }
        return EmptyUtil.isEmpty((CharSequence)str) ? str.toString() : str.substring(0, str.length() - 1);
    }

    public static void creditPartUse(CreditLimitUseBean useBean, BigDecimal avaAmt, BigDecimal rate, DynamicObject currency) {
        BigDecimal realAmt = avaAmt.divide(rate, currency.getInt("amtprecision"), RoundingMode.HALF_DOWN);
        BigDecimal bizAmt = useBean.getBizAmt();
        BigDecimal ratio = realAmt.divide(bizAmt, 8, RoundingMode.HALF_DOWN);
        useBean.setCreditRatio(ratio.multiply(Constants.ONE_HUNDRED));
    }

    public static DynamicObjectCollection queryCreditUses(Long billId, String billType, Long entryId, String selectFields) {
        QFilter filter = new QFilter("sourcebillid", "=", (Object)billId);
        if (EmptyUtil.isNoEmpty((String)billType)) {
            filter.and(new QFilter("sourcetype", "=", (Object)billType));
        }
        if (EmptyUtil.isNoEmpty((Long)entryId)) {
            filter.and(new QFilter("sourcebillentryid", "=", (Object)entryId));
        }
        filter.and(new QFilter("isrelease", "=", (Object)"0")).and(new QFilter("creditlimit.isclose", "=", (Object)"0"));
        if (EmptyUtil.isEmpty((String)selectFields)) {
            selectFields = "creditlimit,currency,amount,preamount,returnamt,realamt,sourcebillid,sourcebillentryid";
        }
        return QueryServiceHelper.query((String)"cfm_credituse", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    public static void delOldCreditUse(List<DynamicObject> creditUses) {
        HashSet<Long> useIds = new HashSet<Long>();
        for (DynamicObject creditUse : creditUses) {
            long sourceBillId = creditUse.getLong("sourcebillid");
            long sourceBillEntryId = creditUse.getLong("sourcebillentryid");
            DynamicObjectCollection bills = QueryServiceHelper.query((String)"cfm_credituse", (String)"id", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)sourceBillId), new QFilter("sourcebillentryid", "=", (Object)sourceBillEntryId), new QFilter("id", "!=", creditUse.getPkValue()), new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue())});
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)bills)) continue;
            useIds.add(creditUse.getLong("id"));
        }
        if (!useIds.isEmpty()) {
            DeleteServiceHelper.delete((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("id", "in", useIds)});
        }
    }

    public static Pair<BigDecimal, BigDecimal> getSumAmt(Map<Long, Pair<BigDecimal, BigDecimal>> detailAmtMap, Set<Long> collIds) {
        BigDecimal preAmt = BigDecimal.ZERO;
        BigDecimal useAmt = BigDecimal.ZERO;
        for (Long collId : collIds) {
            Pair<BigDecimal, BigDecimal> amtPair = detailAmtMap.getOrDefault(collId, (Pair<BigDecimal, BigDecimal>)Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
            preAmt = preAmt.add((BigDecimal)amtPair.getLeft());
            useAmt = useAmt.add((BigDecimal)amtPair.getRight());
        }
        return Pair.of((Object)preAmt, (Object)useAmt);
    }

    public static QFilter getBankFilter(DynamicObject bank, String bankType) {
        DynamicObject bankCate;
        DynamicObjectCollection fins;
        QFilter filter = new QFilter("banktype", "=", (Object)bankType);
        if (CreditFinTypeEnum.FINORG.getValue().equals(bankType) && EmptyUtil.isNoEmpty((DynamicObject)(bank = TmcDataServiceHelper.loadSingleFromCache((Object)bank.getPkValue(), (String)"bd_finorginfo", (String)"finorgtype,bank_cate"))) && bank.getDynamicObject("finorgtype") != null && "0".equals(bank.getDynamicObject("finorgtype").getString("type")) && bank.getDynamicObject("bank_cate") != null && EmptyUtil.isNoEmpty((DynamicObjectCollection)(fins = QueryServiceHelper.query((String)"bd_finorginfo", (String)"id", (QFilter[])new QFilter[]{new QFilter("bank_cate", "=", (bankCate = bank.getDynamicObject("bank_cate")).getPkValue())})))) {
            Set ids = fins.parallelStream().map(o -> o.getLong("id")).collect(Collectors.toSet());
            return new QFilter("bank", "in", ids);
        }
        return filter.and(new QFilter("bank", "=", bank.getPkValue()));
    }
}

