/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.helper;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DBServiceHelper;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitImportHelper {
    public static void setData(Map<String, Object> rowdata) {
        boolean isGroupLimit;
        Object createOrg = rowdata.get("createorg");
        if (createOrg == null || EmptyUtil.isEmpty((Object)createOrg)) {
            rowdata.put("createorg", rowdata.get("org"));
        }
        if (!(isGroupLimit = rowdata.containsKey("isgrouplimit"))) {
            rowdata.put("isgrouplimit", Boolean.FALSE);
        }
        BigDecimal totalamt = BigDecimal.ZERO;
        try {
            totalamt = BigDecimal.valueOf(Double.parseDouble((String)rowdata.get("totalamt")));
        }
        catch (NumberFormatException e) {
            CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u603b\u6388\u4fe1\u989d\u5ea6\u975e\u6cd5", (String)"CreditLimitBatchImportPlugin_13", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        JSONArray gcontractEntries = (JSONArray)rowdata.get("entry_gcontract");
        if (gcontractEntries != null && gcontractEntries.size() > 0) {
            for (Object gcontractEntry : gcontractEntries) {
                JSONObject gcontractEntryJson = (JSONObject)gcontractEntry;
                BigDecimal gratio = BigDecimal.ZERO;
                try {
                    gratio = gcontractEntryJson.getBigDecimal("gratio");
                }
                catch (NumberFormatException e) {
                    CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u62c5\u4fdd\u6bd4\u4f8b\u975e\u6cd5", (String)"CreditLimitBatchImportPlugin_12", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
                }
                if (EmptyUtil.isEmpty((BigDecimal)gratio)) {
                    CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u62c5\u4fdd\u6bd4\u4f8b\u4e0d\u80fd\u4e3a\u7a7a", (String)"CreditLimitBatchImportPlugin_11", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
                    continue;
                }
                gcontractEntryJson.put("gamount", (Object)totalamt.multiply(gratio).divide(new BigDecimal(100), 6, RoundingMode.HALF_UP));
            }
        }
    }

    public static void verifyData(Map<String, Object> rowdata) {
        CreditLimitImportHelper.verifyHeadData(rowdata);
        CreditLimitImportHelper.VerifyEntryOrg(rowdata);
        CreditLimitImportHelper.VerifyEntryType(rowdata);
    }

    private static void verifyHeadData(Map<String, Object> rowdata) {
        JSONObject creditType = (JSONObject)rowdata.get("credittype");
        if (creditType == null) {
            CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b\u4e0d\u80fd\u4e3a\u7a7a", (String)"CreditLimitBatchImportPlugin_14", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
    }

    private static void VerifyEntryType(Map<String, Object> rowdata) {
        boolean isComprehensive;
        JSONObject creditType = (JSONObject)rowdata.get("credittype");
        if (creditType == null) {
            return;
        }
        String creditTypenum = creditType.getString("number");
        DynamicObject credittypeDo = TmcDataServiceHelper.loadSingleFromCache((String)"cfm_credittype", (String)"iscomprehensive", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)creditTypenum)});
        if (credittypeDo == null) {
            CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b\u3010%s\u3011\u4e0d\u5b58\u5728", (String)"CreditLimitBatchImportPlugin_1", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), creditTypenum);
        }
        if (!(isComprehensive = credittypeDo.getBoolean("iscomprehensive"))) {
            JSONArray typeEntries = (JSONArray)rowdata.get("entry_type");
            int size = typeEntries.size();
            if (size == 0) {
                CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b\u4e3a\u4e13\u9879\u6388\u4fe1\u65f6\uff0c\u7c7b\u522b\u5171\u4eab\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (String)"CreditLimitBatchImportPlugin_7", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
            } else if (size > 1) {
                CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b\u4e3a\u4e13\u9879\u6388\u4fe1\u65f6\uff0c\u7c7b\u522b\u5171\u4eab\u5206\u5f55\u4e0d\u80fd\u6709\u591a\u6761", (String)"CreditLimitBatchImportPlugin_8", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
            } else {
                String typeNumber = typeEntries.getJSONObject(0).getJSONObject("t_credittype").getString("number");
                if (typeNumber.contains(",")) {
                    CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b\u4e3a\u4e13\u9879\u6388\u4fe1\u65f6\uff0c\u7c7b\u522b\u5171\u4eab\u5206\u5f55\u7684\u6388\u4fe1\u7c7b\u522b\u53ea\u80fd\u5355\u9009", (String)"CreditLimitBatchImportPlugin_9", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
                }
                if (!StringUtils.equals((CharSequence)creditTypenum, (CharSequence)typeNumber)) {
                    CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b\u4e3a\u4e13\u9879\u6388\u4fe1\u65f6\uff0c\u7c7b\u522b\u5171\u4eab\u5206\u5f55\u7684\u6388\u4fe1\u7c7b\u522b\u5fc5\u987b\u548c\u6388\u4fe1\u7c7b\u522b\u4e00\u81f4", (String)"CreditLimitBatchImportPlugin_10", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
                }
            }
        }
    }

    private static void VerifyEntryOrg(Map<String, Object> rowdata) {
        boolean isGroupLimit = (Boolean)rowdata.get("isgrouplimit");
        String orgShareType = (String)rowdata.get("orgsharetype");
        boolean isGroupAndDownShare = isGroupLimit && OrgShareTypeEnum.DOWNSHARE.getValue().equals(orgShareType);
        JSONArray orgEntries = (JSONArray)rowdata.get("entry_org");
        if (orgEntries == null || orgEntries.size() == 0) {
            CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5171\u4eab\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (String)"CreditLimitBatchImportPlugin_2", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
        }
        if (!isGroupLimit) {
            String orgNumber;
            if (orgEntries.size() > 1) {
                CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u975e\u96c6\u56e2\u6388\u4fe1\uff0c\u53ea\u80fd\u6dfb\u52a0\u4e00\u6761\u7ec4\u7ec7\u5171\u4eab\u8bb0\u5f55", (String)"CreditLimitBatchImportPlugin_5", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
            }
            JSONObject orgEntry = (JSONObject)orgEntries.get(0);
            JSONObject oorg = orgEntry.getJSONObject("o_org");
            JSONObject org = (JSONObject)rowdata.get("org");
            String oOrgNumber = oorg.getString("number");
            if (!StringUtils.equals((CharSequence)oOrgNumber, (CharSequence)(orgNumber = org.getString("number")))) {
                CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u975e\u96c6\u56e2\u6388\u4fe1,\u7ec4\u7ec7\u5171\u4eab\u8bb0\u5f55\u7684\u8d44\u91d1\u7ec4\u7ec7\u5fc5\u987b\u548c\u6388\u4fe1\u4e3b\u4f53\u76f8\u540c", (String)"CreditLimitBatchImportPlugin_6", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
            }
        }
        if (isGroupAndDownShare) {
            for (Object orgEntryObj : orgEntries) {
                JSONObject orgEntry = (JSONObject)orgEntryObj;
                JSONObject oorg = orgEntry.getJSONObject("o_org");
                String oOrgNumber = oorg.getString("number");
                if (!oOrgNumber.contains(",")) continue;
                CreditLimitImportHelper.throwException(ResManager.loadKDString((String)"\u96c6\u56e2\u6388\u4fe1\u5e76\u4e14\u7ec4\u7ec7\u5171\u4eab\u65b9\u5f0f\u4e3a\u5411\u4e0b\u5171\u4eab\u65f6,\u7ec4\u7ec7\u5171\u4eab\u8bb0\u5f55\u7684\u8d44\u91d1\u7ec4\u7ec7\u53ea\u80fd\u5355\u9009", (String)"CreditLimitBatchImportPlugin_4", (String)"tmc-creditm-opplugin", (Object[])new Object[0]), new Object[0]);
            }
        }
    }

    private static void buildTree(JSONArray entrys, String field) {
        HashMap<String, Long> map = new HashMap<String, Long>(16);
        for (Object entry : entrys) {
            JSONObject jsonObject = (JSONObject)entry;
            JSONObject fieldValue = jsonObject.getJSONObject(field);
            String number = fieldValue.getString("number");
            String[] split = number.split(",");
            if (split.length > 1) {
                long globalId = DBServiceHelper.genGlobalLongId();
                Long id = jsonObject.getLong("id");
                if (EmptyUtil.isEmpty((Long)id)) {
                    id = globalId;
                }
                jsonObject.put("id", (Object)id);
                for (String s : split) {
                    map.put(s, id);
                }
                continue;
            }
            Long aLong = (Long)map.get(split[0]);
            jsonObject.put("pid", (Object)(EmptyUtil.isEmpty((Long)aLong) ? Long.valueOf(0L) : aLong));
            long globalId = DBServiceHelper.genGlobalLongId();
            Long id = jsonObject.getLong("id");
            if (EmptyUtil.isEmpty((Long)id)) {
                id = globalId;
            }
            jsonObject.put("id", (Object)id);
        }
    }

    public static void buildTree(Map<String, Object> rowdata) {
        DynamicObject credittypeDo;
        boolean isComprehensive;
        String orgShareType = (String)rowdata.get("orgsharetype");
        JSONObject credittype = (JSONObject)rowdata.get("credittype");
        boolean isDownShare = OrgShareTypeEnum.DOWNSHARE.getValue().equals(orgShareType);
        JSONArray orgEntrys = (JSONArray)rowdata.get("entry_org");
        JSONArray typeEntrys = (JSONArray)rowdata.get("entry_type");
        if (!isDownShare) {
            CreditLimitImportHelper.buildTree(orgEntrys, "o_org");
        }
        if (isComprehensive = (credittypeDo = TmcDataServiceHelper.loadSingleFromCache((String)"cfm_credittype", (String)"iscomprehensive", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)credittype.getString("number"))})).getBoolean("iscomprehensive")) {
            CreditLimitImportHelper.buildTree(typeEntrys, "t_credittype");
        }
    }

    public static void throwException(String format, Object ... args) {
        String exMsg = String.format(format, args);
        throw new KDBizException(exMsg);
    }
}

