/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitAmtHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CreditLimitUpdateAmtHelper {
    public static BigDecimal getReturnAmt(DynamicObject creditLimit, BigDecimal rate, int amtPrecision) {
        DynamicObjectCollection entrys = creditLimit.getDynamicObjectCollection("returnentry");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entrys)) {
            return BigDecimal.ZERO;
        }
        for (DynamicObject entry : entrys) {
            BigDecimal bizAmt = entry.getBigDecimal("e_bizamount");
            BigDecimal amount = entry.getBigDecimal("e_amount");
            if (bizAmt.compareTo(BigDecimal.ZERO) == 0) {
                bizAmt = amount;
                entry.set("e_bizamount", (Object)amount);
            }
            entry.set("e_amount", (Object)bizAmt.multiply(rate).setScale(amtPrecision, RoundingMode.HALF_UP));
        }
        return entrys.stream().map(o -> o.getBigDecimal("e_amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
    }

    public static List<Pair<Long, Long>> getOrgType(Long creditLimitId) {
        ArrayList<Pair<Long, Long>> orgTypes = new ArrayList<Pair<Long, Long>>(16);
        DataSet creditUseDataSet = QueryServiceHelper.queryDataSet((String)"creditUse", (String)"cfm_credituse", (String)"id,org,amount,preamount,creditlimit,credittype", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", (Object)creditLimitId), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())}, (String)"credittype").groupBy(new String[]{"org", "credittype"}).finish();
        while (creditUseDataSet.hasNext()) {
            Row creditUse = creditUseDataSet.next();
            orgTypes.add((Pair<Long, Long>)Pair.of((Object)creditUse.getLong("org"), (Object)creditUse.getLong("credittype")));
        }
        return orgTypes;
    }

    public static void dealOrgEntryAmt(DynamicObject creditLimit, Map<Long, Pair<BigDecimal, BigDecimal>> orgMap) {
        String orgShareType = creditLimit.getString("orgsharetype");
        boolean isGroup = creditLimit.getBoolean("isgrouplimit");
        DynamicObjectCollection orgEntrys = creditLimit.getDynamicObjectCollection("entry_org");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)orgEntrys)) {
            return;
        }
        if (OrgShareTypeEnum.DOWNSHARE.getValue().equals(orgShareType) || !isGroup) {
            for (DynamicObject orgEntry : orgEntrys) {
                BigDecimal useAmt = BigDecimal.ZERO;
                BigDecimal preUseAmt = BigDecimal.ZERO;
                for (Map.Entry<Long, Pair<BigDecimal, BigDecimal>> entry : orgMap.entrySet()) {
                    Long orgMapKey = entry.getKey();
                    if (!CreditLimitHelper.isParentOrg(orgEntry, orgMapKey)) continue;
                    useAmt = useAmt.add((BigDecimal)entry.getValue().getLeft());
                    preUseAmt = preUseAmt.add((BigDecimal)entry.getValue().getRight());
                }
                orgEntry.set("o_useamt", (Object)useAmt);
                orgEntry.set("o_preamt", (Object)preUseAmt);
                BigDecimal avarAmt = CreditLimitAmtHelper.getAvarAmt(orgEntry.getBigDecimal("o_totalamt"), useAmt, preUseAmt);
                orgEntry.set("o_avaramt", (Object)avarAmt);
            }
        } else {
            HashMap<Long, Pair> pidMap = new HashMap<Long, Pair>(orgEntrys.size());
            Set detailEntrys = orgEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("pid"))).collect(Collectors.toSet());
            for (DynamicObject orgEntry : detailEntrys) {
                DynamicObject org = CreditLimitHelper.getDynFormMultiple(orgEntry, "o_org");
                Long pid = orgEntry.getLong("pid");
                BigDecimal useAmt = BigDecimal.ZERO;
                BigDecimal preUseAmt = BigDecimal.ZERO;
                if (org != null && orgMap.containsKey(org.getLong("id"))) {
                    useAmt = (BigDecimal)orgMap.get(org.getLong("id")).getLeft();
                    preUseAmt = (BigDecimal)orgMap.get(org.getLong("id")).getRight();
                }
                orgEntry.set("o_useamt", (Object)useAmt);
                orgEntry.set("o_preamt", (Object)preUseAmt);
                orgEntry.set("o_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(orgEntry.getBigDecimal("o_singleamt"), useAmt, preUseAmt));
                Pair amtMap = pidMap.getOrDefault(pid, Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
                pidMap.put(pid, Pair.of((Object)((BigDecimal)amtMap.getLeft()).add(useAmt), (Object)((BigDecimal)amtMap.getRight()).add(preUseAmt)));
            }
            Set orgs = orgEntrys.stream().filter(o -> EmptyUtil.isEmpty((Long)o.getLong("pid"))).collect(Collectors.toSet());
            for (DynamicObject orgEntry : orgs) {
                long orgEntryId = orgEntry.getLong("id");
                Set orgColls = orgEntry.getDynamicObjectCollection("o_org").stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                if (EmptyUtil.isNoEmpty((Long)orgEntryId) && pidMap.containsKey(orgEntryId)) {
                    orgEntry.set("o_useamt", ((Pair)pidMap.get(orgEntryId)).getLeft());
                    orgEntry.set("o_preamt", ((Pair)pidMap.get(orgEntryId)).getRight());
                    orgEntry.set("o_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(orgEntry.getBigDecimal("o_totalamt"), orgEntry.getBigDecimal("o_useamt"), orgEntry.getBigDecimal("o_preamt")));
                    continue;
                }
                if (orgColls.size() != 1 || pidMap.containsKey(orgEntryId)) continue;
                Object orgId = orgColls.iterator().next();
                orgEntry.set("o_useamt", orgMap.containsKey(orgId) ? orgMap.get(orgId).getLeft() : BigDecimal.ZERO);
                orgEntry.set("o_preamt", orgMap.containsKey(orgId) ? orgMap.get(orgId).getRight() : BigDecimal.ZERO);
                orgEntry.set("o_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(orgEntry.getBigDecimal("o_totalamt"), orgEntry.getBigDecimal("o_useamt"), orgEntry.getBigDecimal("o_preamt")));
            }
        }
    }

    public static void dealTypeEntryAmt(DynamicObject creditLimit, Map<Long, Pair<BigDecimal, BigDecimal>> typeMap) {
        DynamicObject creditType = creditLimit.getDynamicObject("credittype");
        DynamicObjectCollection entryTypes = creditLimit.getDynamicObjectCollection("entry_type");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryTypes)) {
            return;
        }
        if (!creditType.getBoolean("iscomprehensive") && entryTypes.size() > 0) {
            DynamicObject typeEntry = (DynamicObject)entryTypes.get(0);
            DynamicObject entryCreditType = CreditLimitHelper.getDynFormMultiple(typeEntry, "t_credittype");
            if (entryCreditType != null && typeMap.containsKey(entryCreditType.getLong("id"))) {
                typeEntry.set("t_useamt", typeMap.get(entryCreditType.getLong("id")).getLeft());
                typeEntry.set("t_preamt", typeMap.get(entryCreditType.getLong("id")).getRight());
            }
            typeEntry.set("t_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(typeEntry.getBigDecimal("t_totalamt"), typeEntry.getBigDecimal("t_useamt"), typeEntry.getBigDecimal("t_preamt")));
        } else {
            HashMap<Long, Pair> pidMap = new HashMap<Long, Pair>(entryTypes.size());
            for (DynamicObject typeEntry : entryTypes) {
                if (EmptyUtil.isEmpty((Long)typeEntry.getLong("pid"))) continue;
                DynamicObject type = CreditLimitHelper.getDynFormMultiple(typeEntry, "t_credittype");
                Long pid = typeEntry.getLong("pid");
                BigDecimal uamt = BigDecimal.ZERO;
                BigDecimal pamt = BigDecimal.ZERO;
                if (type != null && typeMap.containsKey(type.getLong("id"))) {
                    uamt = (BigDecimal)typeMap.get(type.getLong("id")).getLeft();
                    pamt = (BigDecimal)typeMap.get(type.getLong("id")).getRight();
                }
                typeEntry.set("t_useamt", (Object)uamt);
                typeEntry.set("t_preamt", (Object)pamt);
                typeEntry.set("t_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(typeEntry.getBigDecimal("t_singleamt"), uamt, pamt));
                Pair amtMap = pidMap.getOrDefault(pid, Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
                pidMap.put(pid, Pair.of((Object)((BigDecimal)amtMap.getLeft()).add(uamt), (Object)((BigDecimal)amtMap.getRight()).add(pamt)));
            }
            Set types = entryTypes.stream().filter(o -> EmptyUtil.isEmpty((Long)o.getLong("pid"))).collect(Collectors.toSet());
            for (DynamicObject typeEntry : types) {
                long typeEntryId = typeEntry.getLong("id");
                Set typeColls = typeEntry.getDynamicObjectCollection("t_credittype").stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                BigDecimal uamt = BigDecimal.ZERO;
                BigDecimal pamt = BigDecimal.ZERO;
                if (EmptyUtil.isNoEmpty((Long)typeEntryId) && pidMap.containsKey(typeEntryId)) {
                    uamt = (BigDecimal)((Pair)pidMap.get(typeEntryId)).getLeft();
                    pamt = (BigDecimal)((Pair)pidMap.get(typeEntryId)).getRight();
                } else if (typeColls.size() == 1 && !pidMap.containsKey(typeEntryId)) {
                    Object orgId = typeColls.iterator().next();
                    uamt = typeMap.containsKey(orgId) ? (BigDecimal)typeMap.get(orgId).getLeft() : BigDecimal.ZERO;
                    pamt = typeMap.containsKey(orgId) ? (BigDecimal)typeMap.get(orgId).getRight() : BigDecimal.ZERO;
                }
                typeEntry.set("t_useamt", (Object)uamt);
                typeEntry.set("t_preamt", (Object)pamt);
                typeEntry.set("t_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(typeEntry.getBigDecimal("t_totalamt"), uamt, pamt));
            }
        }
    }

    public static void dealMultEntryAmt(DynamicObject creditLimit, Map<String, Pair<BigDecimal, BigDecimal>> orgTypeMap) {
        DynamicObjectCollection multEntrys = creditLimit.getDynamicObjectCollection("entry_mult");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)multEntrys)) {
            return;
        }
        for (DynamicObject multEntry : multEntrys) {
            DynamicObjectCollection types = multEntry.getDynamicObjectCollection("m_credittype");
            DynamicObjectCollection orgs = multEntry.getDynamicObjectCollection("m_org");
            Set<Long> typeCollIds = CreditLimitHelper.getCollIds(types);
            BigDecimal useAmt = BigDecimal.ZERO;
            BigDecimal preAmt = BigDecimal.ZERO;
            for (Map.Entry<String, Pair<BigDecimal, BigDecimal>> entry : orgTypeMap.entrySet()) {
                String orgTypes = entry.getKey();
                int idx = orgTypes.indexOf("#");
                String orgId = orgTypes.substring(0, idx);
                String typeId = orgTypes.substring(idx + 1);
                boolean isParentOrgColl = CreditLimitHelper.isParentOrgColl(orgs, Long.parseLong(orgId), creditLimit.getString("orgsharetype"));
                if (!typeCollIds.contains(Long.parseLong(typeId)) || !isParentOrgColl) continue;
                useAmt = useAmt.add((BigDecimal)entry.getValue().getLeft());
                preAmt = preAmt.add((BigDecimal)entry.getValue().getRight());
            }
            multEntry.set("m_useamt", (Object)useAmt);
            multEntry.set("m_preamt", (Object)preAmt);
            multEntry.set("m_avaramt", (Object)CreditLimitAmtHelper.getAvarAmt(multEntry.getBigDecimal("m_totalamt"), multEntry.getBigDecimal("m_useamt"), multEntry.getBigDecimal("m_preamt")));
        }
    }

    public static void dealHeadAmt(DynamicObject creditLimit, BigDecimal useAmt, BigDecimal preAmt) {
        creditLimit.set("useamt", (Object)useAmt);
        creditLimit.set("preuseamt", (Object)preAmt);
        BigDecimal avarAmt = CreditLimitAmtHelper.getAvarAmt(creditLimit.getBigDecimal("totalamt"), creditLimit.getBigDecimal("useamt"), creditLimit.getBigDecimal("preuseamt"));
        creditLimit.set("avaramt", (Object)avarAmt);
    }
}

