/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.common.resources.CreditmComResourceEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.DateUtils;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditmValidateFrameHelper {
    public static List<String> checkLimitFrame(DynamicObject limit, DynamicObject frameWork) {
        BigDecimal orgTypeAmount;
        String checkCreditType;
        Date endDate;
        ArrayList<String> checkMsg = new ArrayList<String>();
        frameWork = CreditFrameworkHelper.getRealCreditLimitFrame(frameWork);
        BigDecimal srcCreditLimitAmount = CreditFrameworkHelper.getSrcCreditLimitAmount(limit);
        BigDecimal totalAmt = limit.getBigDecimal("totalamt");
        DynamicObject org = limit.getDynamicObject("org");
        DynamicObject creditType = limit.getDynamicObject("credittype");
        DynamicObject currency = limit.getDynamicObject("currency");
        Date startDate = limit.getDate("startdate");
        if (!EmptyUtil.isAnyoneEmpty((Object[])new Object[]{startDate, endDate = limit.getDate("enddate")}) && DateUtils.getDataFormat((Date)startDate, (boolean)true).compareTo(DateUtils.getDataFormat((Date)frameWork.getDate("startdate"), (boolean)true)) < 0) {
            checkMsg.add(CreditmComResourceEnum.CreditmValidateFrameHelper_2.loadKDString(DateUtils.formatString((Date)frameWork.getDate("startdate"), (String)"yyyy-MM-dd")));
        }
        String creditProp = frameWork.getString("creditprop");
        if (CreditPropEnum.FIX.getValue().equals(creditProp) && !CreditPropEnum.FIX.getValue().equals(limit.getString("creditprop"))) {
            checkMsg.add(CreditmComResourceEnum.CreditmValidateFrameHelper_4.loadKDString(DateUtils.formatString((Date)frameWork.getDate("enddate"), (String)"yyyy-MM-dd")));
        }
        if (frameWork.getDynamicObject("currency").getLong("id") != limit.getDynamicObject("currency").getLong("id")) {
            checkMsg.add(CreditmComResourceEnum.CreditmValidateFrameHelper_7.loadKDString());
        }
        if (EmptyUtil.isNoEmpty((String)(checkCreditType = CreditmValidateFrameHelper.checkCreditType(limit, frameWork)))) {
            checkMsg.add(checkCreditType);
        }
        Set<Long> orgIds = CreditFrameworkHelper.getEntryOrgIds(frameWork);
        if (("creditm_apply".equals(limit.getDynamicObjectType().getName()) && CreditmApplyTypeEnum.isAdd(limit.getString("applytype")) || "cfm_creditlimit".equals(limit.getDynamicObjectType().getName())) && !orgIds.contains(org.getLong("id"))) {
            checkMsg.add(CreditmComResourceEnum.CreditmValidateFrameHelper_1.loadKDString(org.getString("name")));
        }
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        if (org.getLong("id") != rootOrgId) {
            orgIds = CreditFrameworkHelper.getEntryOrgIds(limit);
            boolean isParentOrg = true;
            for (Long orgId : orgIds) {
                if (orgId.longValue() != org.getLong("id") && !(isParentOrg = OrgUnitServiceHelper.isParentOrg((String)"08", (long)org.getLong("id"), (long)orgId))) break;
            }
            if (!isParentOrg) {
                checkMsg.add(CreditmComResourceEnum.CreditmValidateFrameHelper_8.loadKDString(org.getString("name")));
            }
        }
        if (srcCreditLimitAmount.compareTo(totalAmt) > 0) {
            return checkMsg;
        }
        if ((totalAmt = totalAmt.subtract(srcCreditLimitAmount)).compareTo(orgTypeAmount = CreditFrameworkHelper.getOrgTypeAmount(frameWork, org.getLong("id"), creditType.getLong("id"))) > 0) {
            int amtPrecision = CreditLimitHelper.getAmtPrecision(currency);
            checkMsg.add(CreditmComResourceEnum.CreditmValidateFrameHelper_0.loadKDString(org.getString("name"), creditType.getString("name"), orgTypeAmount.add(srcCreditLimitAmount).setScale(amtPrecision)));
        }
        return checkMsg;
    }

    private static String checkCreditType(DynamicObject dataEntity, DynamicObject frameWork) {
        DynamicObject creditType = dataEntity.getDynamicObject("credittype");
        Set<Long> entryTypeIds = CreditFrameworkHelper.getEntryTypeIds(frameWork);
        if (creditType.getBoolean("iscomprehensive")) {
            DynamicObject frameCreditType = frameWork.getDynamicObject("credittype");
            if (!(frameCreditType = TmcDataServiceHelper.loadSingleFromCache((Object)frameCreditType.getPkValue(), (String)"cfm_credittype", (String)"iscomprehensive")).getBoolean("iscomprehensive") || EmptyUtil.isNoEmpty(entryTypeIds)) {
                return CreditmComResourceEnum.CreditmValidateFrameHelper_6.loadKDString(creditType.getString("name"));
            }
        }
        if (entryTypeIds != null && !entryTypeIds.contains(creditType.getLong("id"))) {
            return CreditmComResourceEnum.CreditmValidateFrameHelper_5.loadKDString(creditType.getString("name"));
        }
        return null;
    }
}

