/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.helper;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.tmc.fbp.common.helper.MarketDataServiceHelper;
import kd.tmc.fbp.common.helper.TmcBusinessBaseHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.model.ForexQuoteInfo;
import kd.tmc.fbp.common.util.EmptyUtil;

public class RateHelper {
    public static BigDecimal getExchangeRate(Long sourceCurrencyId, Long targetCurrencyId, Long orgId, Date date) {
        if (sourceCurrencyId == null || targetCurrencyId == null || orgId == null) {
            return null;
        }
        if (sourceCurrencyId != null && sourceCurrencyId.equals(targetCurrencyId)) {
            return BigDecimal.ONE;
        }
        return TmcBusinessBaseHelper.getExchangeRateNew((long)sourceCurrencyId, (long)targetCurrencyId, (long)orgId, (Date)date);
    }

    @Deprecated
    public static Long getExchageTableId(Long orgId) {
        return TmcBusinessBaseHelper.getExchageTableId((Long)orgId);
    }

    public static BigDecimal getMdTate(DynamicObject forexQuote, DynamicObject sourceCurrency, DynamicObject targetCurrency, Long orgId, Date date) {
        if (sourceCurrency.getLong("id") == targetCurrency.getLong("id")) {
            return BigDecimal.ONE;
        }
        BigDecimal rate = null;
        if (forexQuote == null) {
            return RateHelper.getExchangeRate(sourceCurrency.getLong("id"), targetCurrency.getLong("id"), orgId, date);
        }
        String cuPair = sourceCurrency.getString("number") + "/" + targetCurrency.getString("number");
        ForexQuoteInfo forexQuoteInfo = MarketDataServiceHelper.getForexQuoteInfo((Long)((Long)forexQuote.getPkValue()), (String)cuPair, null, null);
        rate = forexQuoteInfo.getMiddleprice();
        if (!cuPair.equals(forexQuoteInfo.getFxquote())) {
            rate = BigDecimal.ONE.divide(rate, 19, 4);
        }
        if (EmptyUtil.isEmpty((BigDecimal)rate)) {
            rate = RateHelper.getExchangeRate(sourceCurrency.getLong("id"), targetCurrency.getLong("id"), orgId, date);
        }
        return rate;
    }

    public static DynamicObject getCurrency(Long bizCurrency) {
        return TmcDataServiceHelper.loadSingleFromCache((Object)bizCurrency, (String)"bd_currency");
    }
}

