/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.common.helper;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.tmc.creditm.common.amount.ICreditAmount;
import kd.tmc.creditm.common.enums.UseCreditChangeTypeEnum;
import kd.tmc.fbp.common.enums.BaseEnableEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class UseCreditHelper {
    private static final Log logger = LogFactory.getLog(UseCreditHelper.class);

    public static String getSelectProperties() {
        return String.join((CharSequence)",", "id", "description", "finorginfo", "credittype", "changetype", "remark", "creditprop", "lockamount", "creditbusinesstype", "creditproduct", "businesscode", "expiredate", "startdate", "currency", "creditamount", "businessamount", "contractno", "creditrate", "releaseamount", "bindid", "discreditamount", "amountreleased", "creditcurrency", "org", "curcyamountreleased", "bizentryid", "billstatus", "billno", "rootid", "businesscode", "bizdate", "registrant", "groupid", "uniquecode", "bizbilltype");
    }

    public static DynamicObject loadSingleUseCreditById(Long useCreditId) {
        return BusinessDataServiceHelper.loadSingle((Object)useCreditId, (String)"cfm_use_credit", (String)UseCreditHelper.getSelectProperties());
    }

    public static DynamicObject loadSingleUseCreditByUniqueCode(String uniqueCode) {
        return BusinessDataServiceHelper.loadSingle((String)"cfm_use_credit", (String)UseCreditHelper.getSelectProperties(), (QFilter[])new QFilter("uniquecode", "=", (Object)uniqueCode).toArray());
    }

    public static DynamicObject loadUseCreditByUniqueCode(String uniqueCode) {
        return BusinessDataServiceHelper.loadSingle((String)"cfm_use_credit", (QFilter[])new QFilter("uniquecode", "=", (Object)uniqueCode).toArray());
    }

    public static DynamicObject[] loadUseCreditsByGroupId(String groupId) {
        return BusinessDataServiceHelper.load((String)EntityMetadataCache.getDataEntityType((String)"cfm_use_credit").getName(), (String)UseCreditHelper.getSelectProperties(), (QFilter[])new QFilter("groupid", "=", (Object)groupId).toArray());
    }

    public static DynamicObject getUseConfig(String bizTypeNum) {
        return TmcDataServiceHelper.loadSingleFromCache((String)"creditm_useconfig", (QFilter[])new QFilter[]{new QFilter("biztypenum", "=", (Object)bizTypeNum), new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())});
    }

    public static DynamicObject getUseConfigFromType(String bizType) {
        return TmcDataServiceHelper.loadSingleFromCache((String)"creditm_useconfig", (QFilter[])new QFilter[]{new QFilter("biztype.number", "=", (Object)bizType), new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())});
    }

    public static QFilter getBizQfilter(DynamicObject config, DynamicObject org) {
        if (EmptyUtil.isAnyoneEmpty((Object[])new Object[]{config, org})) {
            return QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        String filterCon = config.getString("filtercon_tag");
        if (EmptyUtil.isEmpty((String)filterCon)) {
            return QFilter.of((String)"1!=1", (Object[])new Object[0]);
        }
        DynamicObjectCollection entitys = config.getDynamicObjectCollection("entryentity");
        DynamicObject entry = entitys.stream().filter(o -> "org".equals(o.getString("field"))).findFirst().get();
        String orgProp = entry.getString("fieldname");
        DynamicObject bizType = config.getDynamicObject("biztype");
        FilterCondition condition = (FilterCondition)SerializationUtils.fromJsonString((String)filterCon, FilterCondition.class);
        MainEntityType dataType = EntityMetadataCache.getDataEntityType((String)bizType.getString("number"));
        QFilter filter = UseCreditHelper.getFilter(dataType, condition);
        return filter.and(new QFilter(orgProp, "=", org.getPkValue()));
    }

    public static QFilter getFilter(MainEntityType dataType, FilterCondition condition) {
        FilterBuilder fb = new FilterBuilder(dataType, condition, true);
        fb.buildFilter(true);
        return fb.getQFilter();
    }

    public static DynamicObject getBizBill(DynamicObject config, Object bizId) {
        DynamicObject bizType = config.getDynamicObject("biztype");
        Map<String, String> selectProps = UseCreditHelper.getSelectProps(config);
        ArrayList<String> fields = new ArrayList<String>();
        fields.addAll(Arrays.asList(selectProps.get("billnoprop"), selectProps.get("currencyprop"), selectProps.get("creditprop"), selectProps.get("amtprop"), selectProps.get("startdateprop"), selectProps.get("enddateprop"), selectProps.get("creditot"), selectProps.get("credittype")));
        if ("cfm_loanbill_bond".equals(config.getString("biztypenum"))) {
            fields.add(selectProps.get("creditentry") + "." + "e_investortype");
        }
        String sels = fields.stream().collect(Collectors.joining(","));
        DynamicObject bizBill = TmcDataServiceHelper.loadSingle((Object)bizId, (String)bizType.getString("number"), (String)sels);
        return bizBill;
    }

    public static Map<String, String> getSelectProps(DynamicObject config) {
        HashMap<String, String> propMap = new HashMap<String, String>();
        propMap.put("billnoprop", config.getString("billnoprop"));
        propMap.put("creditprop", config.getString("creditprop"));
        propMap.put("creditentry", config.getString("creditentry"));
        propMap.put("amtprop", config.getString("amtprop"));
        propMap.put("currencyprop", config.getString("currencyprop"));
        propMap.put("startdateprop", config.getString("startdateprop"));
        propMap.put("enddateprop", config.getString("enddateprop"));
        DynamicObjectCollection entitys = config.getDynamicObjectCollection("entryentity");
        for (DynamicObject entity : entitys) {
            propMap.put(entity.getString("field"), entity.getString("fieldname"));
            propMap.put(entity.getString("field") + "_T", entity.getString("fieldtype"));
            propMap.put(entity.getString("field") + "_P", entity.getString("fieldprop"));
        }
        return propMap;
    }

    public static BigDecimal getCreditAmount(DynamicObject config, DynamicObject bizBill) {
        String amtProp = config.getString("amtprop");
        String amtPlugin = config.getString("amountplugin");
        if (EmptyUtil.isEmpty((String)amtPlugin)) {
            return bizBill.getBigDecimal(amtProp);
        }
        ICreditAmount service = null;
        try {
            service = (ICreditAmount)Class.forName(amtPlugin).newInstance();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return BigDecimal.ZERO;
        }
        return service.getCreditAmount(bizBill);
    }

    public static Map<Long, BigDecimal> getEntryCreditAmount(DynamicObject config, DynamicObject bizBill) {
        HashMap<Long, BigDecimal> repayAmountMap = new HashMap<Long, BigDecimal>();
        String amtPlugin = config.getString("amountplugin");
        if (EmptyUtil.isEmpty((String)amtPlugin)) {
            return repayAmountMap;
        }
        ICreditAmount service = null;
        try {
            service = (ICreditAmount)Class.forName(amtPlugin).newInstance();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            return repayAmountMap;
        }
        return service.getEntryCreditAmount(bizBill);
    }

    public static String checkRow(DynamicObject row) {
        StringBuilder errorMessage = new StringBuilder();
        if (EmptyUtil.isEmpty((DynamicObject)row.getDynamicObject("finorginfo"))) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u91d1\u878d\u673a\u6784\u3002", (String)"UseCreditCheckUtil_0", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((BigDecimal)row.getBigDecimal("creditamount"))) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5360\u7528\u6388\u4fe1\u91d1\u989d\u3002", (String)"UseCreditCheckUtil_2", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
        }
        if ("other".equals(row.getString("bizbilltype")) && EmptyUtil.isEmpty((Object)row.getDate("expiredate"))) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5230\u671f\u65e5\u671f\u3002", (String)"UseCreditCheckUtil_3", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
        }
        if (EmptyUtil.isEmpty((DynamicObject)row.getDynamicObject("currency"))) {
            errorMessage.append(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u5e01\u79cd\u3002", (String)"UseCreditCheckUtil_4", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
        }
        if (row.getBigDecimal("creditamount").compareTo(row.getBigDecimal("businessamount")) > 0) {
            errorMessage.append(ResManager.loadKDString((String)"\u5360\u7528\u6388\u4fe1\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u4e1a\u52a1\u91d1\u989d\u3002", (String)"UseCreditCheckUtil_5", (String)"tmc-creditm-formplugin", (Object[])new Object[0]));
        }
        return errorMessage.toString();
    }

    public static boolean checkCodeExist(String businessCode, String uniqueCode) {
        QFilter qFilter = new QFilter("businesscode", "=", (Object)businessCode).and(new QFilter("changetype", "=", (Object)UseCreditChangeTypeEnum.LOCK.getValue())).and(new QFilter("uniquecode", "!=", (Object)uniqueCode)).and(new QFilter("bizbilltype", "=", (Object)"other"));
        return TmcDataServiceHelper.exists((String)"cfm_use_credit", (QFilter[])qFilter.toArray());
    }

    public static boolean checkbillisLegal(DynamicObject org, String bizBillType, Long billId, long bizEntryId) {
        if ("other".equals(bizBillType)) {
            return true;
        }
        DynamicObject config = TmcDataServiceHelper.loadSingleFromCache((String)"creditm_useconfig", (QFilter[])new QFilter[]{new QFilter("biztypenum", "=", (Object)bizBillType), new QFilter("enable", "=", (Object)BaseEnableEnum.ENABLE.getValue())});
        if (EmptyUtil.isEmpty((DynamicObject)config)) {
            return false;
        }
        QFilter bizQfilter = UseCreditHelper.getBizQfilter(config, org);
        DynamicObject bizType = config.getDynamicObject("biztype");
        String creditProp = config.getString("creditprop");
        String creditEntry = config.getString("creditentry");
        bizQfilter.and(new QFilter("id", "=", (Object)billId));
        if (EmptyUtil.isEmpty((String)creditEntry)) {
            bizQfilter.and(new QFilter(creditProp, "=", (Object)0));
        } else {
            bizQfilter.and(new QFilter(creditProp, "=", (Object)0)).and(creditEntry, "=", (Object)bizEntryId);
        }
        return TmcDataServiceHelper.exists((String)bizType.getString("number"), (QFilter[])new QFilter[]{bizQfilter});
    }

    public static Map<Long, BigDecimal> getCreditAmtMap(Set<Long> creditBindIds) {
        DynamicObjectCollection creditUseBills = QueryServiceHelper.query((String)"cfm_use_credit", (String)"id,creditamount,businessamount,amountreleased", (QFilter[])new QFilter[]{new QFilter("changetype", "=", (Object)UseCreditChangeTypeEnum.LOCK.getValue()), new QFilter("id", "in", creditBindIds)});
        Map<Long, BigDecimal> creditAmtMap = creditUseBills.parallelStream().collect(Collectors.toMap(e -> e.getLong("id"), o -> o.getBigDecimal("businessamount").subtract(o.getBigDecimal("amountreleased"))));
        return creditAmtMap;
    }
}

