/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.common.constant.Constants;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditlimitHelper {
    public static boolean isExistBillCredituse(long creditLimitId, long sourceBillId, long sourceBillEntryId, String billStatus) {
        DynamicObjectCollection entrys;
        BigDecimal returnAmount;
        DynamicObject creditUse = TmcDataServiceHelper.loadSingle((String)"cfm_credituse", (String)"creditlimit,realamt,returnentry.e_amount", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "=", (Object)sourceBillId).and("creditlimit", "=", (Object)creditLimitId).and("sourcebillentryid", "=", (Object)sourceBillEntryId).and("billstatus", "=", (Object)billStatus).and("isrelease", "=", (Object)"0")});
        if (EmptyUtil.isEmpty((DynamicObject)creditUse)) {
            return false;
        }
        BigDecimal realAmt = creditUse.getBigDecimal("realamt");
        if (EmptyUtil.isEmpty((BigDecimal)realAmt)) {
            return false;
        }
        DynamicObject creditLimit = creditUse.getDynamicObject("creditlimit");
        return creditLimit == null || CreditPropEnum.isCircle((String)creditLimit.getString("creditprop")) || (returnAmount = (entrys = creditUse.getDynamicObjectCollection("returnentry")).stream().map(o -> o.getBigDecimal("e_amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)).compareTo(realAmt) < 0;
    }

    public static DynamicObject getCreditLimitBill(long limitId, String entity, String fields) {
        if (EmptyUtil.isNoEmpty((String)fields)) {
            return TmcDataServiceHelper.loadSingle((Object)limitId, (String)entity, (String)fields);
        }
        return TmcDataServiceHelper.loadSingle((Object)limitId, (String)entity);
    }

    public static String checkExistOrgAndType(DynamicObject data, Set<Long> limitIds) {
        DataSet limitDs = QueryServiceHelper.queryDataSet((String)"checkMergeEntry", (String)"cfm_credituse", (String)"org,credittype", (QFilter[])new QFilter[]{new QFilter("creditlimit", "in", limitIds).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("isrelease", "=", (Object)"0")}, null);
        if (limitDs.isEmpty()) {
            return "";
        }
        DataSet orgDs = limitDs.copy().groupBy(new String[]{"org"}).finish();
        DataSet creditTypeDs = limitDs.filter("credittype!=0").groupBy(new String[]{"credittype"}).finish();
        DynamicObjectCollection orgEntrys = data.getDynamicObjectCollection("entry_org");
        Set collOrgIds = CreditLimitHelper.getMultiPorpIds((DynamicObjectCollection)orgEntrys, (String)"o_org");
        HashSet<Long> valIds = new HashSet<Long>();
        for (Row orglimit : orgDs) {
            Long orgId = orglimit.getLong("org");
            boolean isCon = CreditlimitHelper.checkMultOrg(collOrgIds, orgId, data.getString("orgsharetype"));
            if (isCon) continue;
            valIds.add(orglimit.getLong("org"));
        }
        if (valIds.size() > 0) {
            Map orgMap = TmcDataServiceHelper.loadFromCache((String)"bos_org", (String)"name", (QFilter[])new QFilter[]{new QFilter("id", "in", valIds)});
            String orgName = orgMap.values().stream().map(o -> o.getString("name")).collect(Collectors.joining("\u3001"));
            return CreditmBusResourceEnum.CreditLimitSubmitValidator_29.loadKDString(orgName);
        }
        DynamicObjectCollection typeEntrys = data.getDynamicObjectCollection("entry_type");
        Set collTypes = CreditLimitHelper.getMultiPorpIds((DynamicObjectCollection)typeEntrys, (String)"t_credittype");
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)typeEntrys)) {
            valIds.clear();
            for (Row creditTypelimit : creditTypeDs) {
                if (collTypes.contains(creditTypelimit.getLong("credittype"))) continue;
                valIds.add(creditTypelimit.getLong("credittype"));
            }
            if (valIds.size() > 0) {
                Map creditTypeIds = TmcDataServiceHelper.loadFromCache((String)"cfm_credittype", (String)"id,name", (QFilter[])new QFilter[]{new QFilter("id", "in", valIds), new QFilter("iscomprehensive", "=", (Object)false)});
                if (EmptyUtil.isEmpty((Object)creditTypeIds) || creditTypeIds.size() == 0) {
                    return "";
                }
                String typeNames = creditTypeIds.values().stream().filter(o -> valIds.contains(o.getLong("id"))).map(o -> o.getString("name")).collect(Collectors.joining(","));
                return CreditmBusResourceEnum.CreditLimitSubmitValidator_30.loadKDString(typeNames);
            }
        }
        return "";
    }

    public static String checkOrgType(Set<String> orgTypeIds, Set<Long> collOrgIds, Set<Long> collTypeIds, DynamicObject entry, String orgShareType) {
        StringBuilder str = new StringBuilder(128);
        DynamicObjectCollection mOrgs = entry.getDynamicObjectCollection("m_org");
        Set collMorgIds = CreditLimitHelper.getCollIds((DynamicObjectCollection)mOrgs);
        DynamicObjectCollection mTypes = entry.getDynamicObjectCollection("m_credittype");
        Set collMtypeIds = CreditLimitHelper.getCollIds((DynamicObjectCollection)mTypes);
        ArrayList orgLists = new ArrayList(collMorgIds);
        ArrayList typeLists = new ArrayList(collMtypeIds);
        Collections.sort(orgLists);
        Collections.sort(typeLists);
        List orgs = orgLists.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        List types = typeLists.stream().map(o -> String.valueOf(o)).collect(Collectors.toList());
        String key = String.join((CharSequence)"", orgs) + String.join((CharSequence)"", types);
        if (orgTypeIds.contains(key)) {
            str.append(CreditmBusResourceEnum.CreditLimitSubmitValidator_10.loadKDString());
        } else {
            orgTypeIds.add(key);
        }
        for (DynamicObject mOrg : mOrgs) {
            String orgId = mOrg.getDynamicObject("fbasedataid").getString("id");
            String orgName = mOrg.getDynamicObject("fbasedataid").getString("name");
            if (CreditlimitHelper.checkMultOrg(collOrgIds, Long.parseLong(orgId), orgShareType)) continue;
            str.append(CreditmBusResourceEnum.CreditLimitSubmitValidator_8.loadKDString(orgName));
        }
        for (DynamicObject mType : mTypes) {
            String typeId = mType.getDynamicObject("fbasedataid").getString("id");
            String name = mType.getDynamicObject("fbasedataid").getString("name");
            if (collTypeIds.size() <= 0 || collTypeIds.contains(Long.parseLong(typeId))) continue;
            str.append(CreditmBusResourceEnum.CreditLimitSubmitValidator_9.loadKDString(name));
        }
        return str.toString();
    }

    public static boolean checkMultOrg(Set<Long> collOrgIds, Long orgId, String orgShareType) {
        if (collOrgIds.contains(orgId)) {
            return true;
        }
        boolean downShare = OrgShareTypeEnum.DOWNSHARE.getValue().equals(orgShareType);
        if (downShare) {
            for (Long collOrgId : collOrgIds) {
                boolean isParentOrg = OrgUnitServiceHelper.isParentOrg((String)"08", (long)collOrgId, (long)orgId);
                if (!isParentOrg) continue;
                return isParentOrg;
            }
        }
        return false;
    }

    public static void setMultEntryVal(DynamicObject applyEntry, DynamicObject entry, String multField) {
        DynamicObjectCollection orgs = entry.getDynamicObjectCollection(multField);
        DynamicObjectCollection applyOrgs = applyEntry.getDynamicObjectCollection(multField);
        for (DynamicObject applyOrg : applyOrgs) {
            DynamicObject row = orgs.addNew();
            row.set("fbasedataid_id", applyOrg.get("fbasedataid_id"));
        }
    }

    public static BigDecimal getCreditRatioBySuretyAppend(DynamicObject useRec, boolean isPre, String returnBizType) {
        BigDecimal creditRatio = useRec.getBigDecimal("creditratio");
        if (isPre || !"fbd_surety_append".equals(returnBizType)) {
            return creditRatio;
        }
        if (EmptyUtil.isEmpty((BigDecimal)creditRatio)) {
            creditRatio = Constants.ONE_HUNDRED;
        }
        BigDecimal bizAmount = useRec.getBigDecimal("bizamount");
        DynamicObject bizCurrency = useRec.getDynamicObject("bizcurrency");
        if (EmptyUtil.isEmpty((BigDecimal)bizAmount)) {
            bizAmount = useRec.getBigDecimal("bizcreditamount").multiply(Constants.ONE_HUNDRED).divide(useRec.getBigDecimal("creditratio"), 12, 4);
            useRec.set("bizamount", (Object)bizAmount.setScale(CreditLimitHelper.getAmtPrecision((DynamicObject)bizCurrency), RoundingMode.HALF_UP));
        }
        DynamicObjectCollection entrys = useRec.getDynamicObjectCollection("returnentry");
        for (DynamicObject entry : entrys) {
            if (EmptyUtil.isNoEmpty((BigDecimal)entry.getBigDecimal("e_bizreturnamt"))) continue;
            entry.set("e_bizreturnamt", (Object)entry.getBigDecimal("e_bizamount").multiply(Constants.ONE_HUNDRED).divide(creditRatio, CreditLimitHelper.getAmtPrecision((DynamicObject)bizCurrency), RoundingMode.HALF_UP));
        }
        BigDecimal returnTotalAmt = entrys.stream().filter(o -> !"fbd_surety_append".equals(o.getString("e_billtype"))).map(o -> o.getBigDecimal("e_bizreturnamt")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        if (bizAmount.compareTo(returnTotalAmt) == 0) {
            throw new KDBizException(CreditmBusResourceEnum.CreditlimitHelper_0.loadKDString());
        }
        BigDecimal realAmt = useRec.getBigDecimal("realamt");
        BigDecimal bizNotReturnAmt = bizAmount.subtract(returnTotalAmt);
        BigDecimal rate = useRec.getBigDecimal("creditrate");
        if (EmptyUtil.isEmpty((BigDecimal)rate)) {
            rate = BigDecimal.ONE;
        }
        return realAmt.multiply(Constants.ONE_HUNDRED).divide(bizNotReturnAmt.multiply(rate), 8, RoundingMode.DOWN);
    }
}

