/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.apply;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.tmc.creditm.business.helper.CreditlimitApplyHelper;
import kd.tmc.creditm.business.helper.CreditlimitHelper;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditmApplyAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("contractno");
        sel.add("creditlimit");
        sel.add("applytype");
        sel.add("isframework");
        sel.add("totalamt");
        sel.add("startdate");
        sel.add("enddate");
        sel.add("guartype");
        sel.add("credittype");
        sel.add("isgrouplimit");
        sel.add("orgsharetype");
        sel.add("o_org");
        sel.add("o_totalamt");
        sel.add("o_singleamt");
        sel.add("t_credittype");
        sel.add("t_totalamt");
        sel.add("t_singleamt");
        sel.add("m_org");
        sel.add("m_credittype");
        sel.add("m_totalamt");
        sel.add("entry_org.pid");
        sel.add("entry_type.pid");
        return sel;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> limits = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject data : dataEntities) {
            DynamicObject limit = data.getDynamicObject("creditlimit");
            if (EmptyUtil.isEmpty((DynamicObject)limit)) continue;
            String applyType = data.getString("applytype");
            boolean isFrameWork = data.getBoolean("isframework");
            limit = CreditlimitHelper.getCreditLimitBill(limit.getLong("id"), isFrameWork ? "creditm_limit_framework" : "cfm_creditlimit", "");
            CreditlimitApplyHelper.saveHistoryVersion(data, limit);
            if (!CreditmApplyTypeEnum.isApplyTypes((String)applyType)) continue;
            this.creditmApplyJoin(data, limit);
            this.creditmApplyRenewal(data, limit);
            this.creditmApplyAdjust(data, limit);
            CreditlimitApplyHelper.creditmApplyChange(data, limit, applyType);
            limits.add(limit);
        }
        CreditlimitApplyHelper.updateLimits(limits);
    }

    private void creditmApplyAdjust(DynamicObject data, DynamicObject limit) {
        if (!CreditmApplyTypeEnum.isAdjust((String)data.getString("applytype"))) {
            return;
        }
        DynamicObjectCollection applyEntryOrgs = data.getDynamicObjectCollection("entry_org");
        DynamicObject org = data.getDynamicObject("org");
        BigDecimal amt = BigDecimal.ZERO;
        if (applyEntryOrgs.size() == 1) {
            amt = ((DynamicObject)applyEntryOrgs.get(0)).getBigDecimal("o_totalamt");
        } else {
            for (DynamicObject applyEntryOrg : applyEntryOrgs) {
                DynamicObjectCollection orgs = applyEntryOrg.getDynamicObjectCollection("o_org");
                BigDecimal oTotalAmt = applyEntryOrg.getBigDecimal("o_totalamt");
                Set orgIds = orgs.stream().map(o -> o.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
                if (oTotalAmt.compareTo(BigDecimal.ZERO) != 0 || orgIds == null || orgIds.size() != 1 || !orgIds.contains(org.getPkValue())) continue;
                amt = ((DynamicObject)applyEntryOrgs.get(1)).getBigDecimal("o_singleamt");
            }
        }
        boolean isFrameWork = data.getBoolean("isframework");
        boolean isOrgCredituse = TmcDataServiceHelper.exists((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", limit.getPkValue()).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()).and("org", "=", org.getPkValue())});
        this.dealOrgEntry(limit, org, isOrgCredituse, isFrameWork, amt);
        this.dealMultEntry(limit, org, isOrgCredituse, amt);
    }

    private void dealOrgEntry(DynamicObject limit, DynamicObject org, boolean isOrgCredituse, boolean isFrameWork, BigDecimal amt) {
        DynamicObjectCollection orgEntrys = limit.getDynamicObjectCollection("entry_org");
        Iterator orgItes = orgEntrys.iterator();
        while (orgItes.hasNext()) {
            String field;
            DynamicObject orgEntry = (DynamicObject)orgItes.next();
            Set<Object> orgIds = this.getOrgIds(orgEntry);
            if (!orgIds.contains(org.getPkValue()) || orgIds.size() > 1) continue;
            boolean isDetailEntry = EmptyUtil.isNoEmpty((Integer)orgEntry.getInt("pid"));
            if (BigDecimal.ZERO.compareTo(amt) == 0 && !isOrgCredituse && !isDetailEntry && orgIds.size() == 1 && orgEntrys.size() > 0) {
                orgItes.remove();
                continue;
            }
            String string = field = isDetailEntry ? "o_singleamt" : "o_totalamt";
            if (isFrameWork) {
                BigDecimal hasLocatAmt = orgEntry.getBigDecimal("o_singleamt").subtract(orgEntry.getBigDecimal("o_notallocationamt"));
                BigDecimal notAmt = amt.subtract(hasLocatAmt);
                orgEntry.set("o_notallocationamt", (Object)(BigDecimal.ZERO.compareTo(notAmt) > 0 ? BigDecimal.ZERO : notAmt));
            }
            BigDecimal useAmt = orgEntry.getBigDecimal("o_useamt").add(orgEntry.getBigDecimal("o_preamt"));
            orgEntry.set(field, (Object)amt);
            BigDecimal avaAmt = amt.subtract(useAmt);
            orgEntry.set("o_avaramt", (Object)(avaAmt.compareTo(BigDecimal.ZERO) > 0 ? avaAmt : BigDecimal.ZERO));
        }
    }

    private void dealMultEntry(DynamicObject limit, DynamicObject org, boolean isOrgCredituse, BigDecimal amt) {
        if (isOrgCredituse || amt.compareTo(BigDecimal.ZERO) != 0) {
            return;
        }
        DynamicObjectCollection multEntrys = limit.getDynamicObjectCollection("entry_mult");
        Iterator multItes = multEntrys.iterator();
        while (multItes.hasNext()) {
            DynamicObject multEntry = (DynamicObject)multItes.next();
            DynamicObjectCollection orgColls = multEntry.getDynamicObjectCollection("m_org");
            Set orgIds = CreditLimitHelper.getCollIds((DynamicObjectCollection)orgColls);
            if (orgIds.size() == 1 && orgIds.contains(org.getLong("id"))) {
                multItes.remove();
                continue;
            }
            orgColls.removeIf(o -> o.getDynamicObject("fbasedataid") != null && o.getDynamicObject("fbasedataid").getLong("id") == org.getLong("id"));
        }
    }

    private Set<Object> getOrgIds(DynamicObject orgEntry) {
        return orgEntry.getDynamicObjectCollection("o_org").stream().map(e -> e.getDynamicObject("fbasedataid").getPkValue()).collect(Collectors.toSet());
    }

    private void creditmApplyRenewal(DynamicObject data, DynamicObject limit) {
        if (!CreditmApplyTypeEnum.isRenewal((String)data.getString("applytype"))) {
            return;
        }
        Date renewalDate = data.getDate("renewalenddate");
        limit.set("enddate", (Object)renewalDate);
    }

    private void creditmApplyJoin(DynamicObject data, DynamicObject limit) {
        if (!CreditmApplyTypeEnum.isJoin((String)data.getString("applytype"))) {
            return;
        }
        DynamicObjectCollection entryOrgs = data.getDynamicObjectCollection("entry_org");
        if (EmptyUtil.isEmpty((DynamicObjectCollection)entryOrgs)) {
            return;
        }
        DynamicObject entry = (DynamicObject)entryOrgs.get(0);
        BigDecimal singleAmt = entry.getBigDecimal("o_totalamt");
        DynamicObject org = ((DynamicObject)entry.getDynamicObjectCollection("o_org").get(0)).getDynamicObject("fbasedataid");
        boolean isFrameWork = data.getBoolean("isframework");
        boolean isDownShare = OrgShareTypeEnum.DOWNSHARE.getValue().equals(limit.getString("orgsharetype"));
        DynamicObjectCollection limitOrgs = limit.getDynamicObjectCollection("entry_org");
        int seq = 0;
        DynamicObject entrySeq = limitOrgs.stream().sorted((x, y) -> y.getInt("seq") - x.getInt("seq")).findFirst().orElse(null);
        if (entrySeq != null) {
            seq = entrySeq.getInt("seq") + 1;
        }
        BigDecimal useAmt = BigDecimal.ZERO;
        BigDecimal preAmt = BigDecimal.ZERO;
        if (isDownShare) {
            List subOrgIds = OrgUnitServiceHelper.getAllSubordinateOrgs((String)"08", Collections.singletonList(org.getLong("id")), (boolean)true);
            Map creditOrgAmt = CreditLimitHelper.getCreditTypeAmt((Long)limit.getLong("id"), subOrgIds.parallelStream().collect(Collectors.toSet()), (String)"org");
            useAmt = creditOrgAmt.values().stream().map(o -> (BigDecimal)o.getLeft()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            preAmt = creditOrgAmt.values().stream().map(o -> (BigDecimal)o.getRight()).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
        }
        DynamicObject newEntry = limitOrgs.addNew();
        newEntry.set("seq", (Object)seq);
        newEntry.set("o_totalamt", (Object)singleAmt);
        newEntry.set("o_avaramt", (Object)singleAmt);
        if (isFrameWork) {
            newEntry.set("o_notallocationamt", (Object)singleAmt);
        }
        newEntry.set("o_useamt", (Object)useAmt);
        newEntry.set("o_preamt", (Object)preAmt);
        BigDecimal avaAmt = singleAmt.subtract(useAmt).subtract(preAmt);
        newEntry.set("o_avaramt", (Object)(BigDecimal.ZERO.compareTo(avaAmt) > 0 ? BigDecimal.ZERO : avaAmt));
        newEntry.set("o_org", (Object)CreditLimitHelper.generateMultiPropValue((DynamicObject)newEntry, (String)"o_org", (DynamicObject[])new DynamicObject[]{org}));
    }
}

