/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.apply;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.tmc.creditm.business.helper.CreditlimitApplyHelper;
import kd.tmc.creditm.business.helper.CreditlimitHelper;
import kd.tmc.creditm.common.enums.CreditmApplyTypeEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.BillChangeHistoryHelper;

public class CreditmApplyUnAuditService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("applytype");
        sel.add("creditlimit");
        sel.add("isframework");
        return sel;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> limits = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            String applyType = dataEntity.getString("applytype");
            if (CreditmApplyTypeEnum.isAdd((String)applyType) || !CreditmApplyTypeEnum.isApplyTypes((String)applyType)) continue;
            DynamicObject limit = dataEntity.getDynamicObject("creditlimit");
            DynamicObject lastLimitVersion = BillChangeHistoryHelper.genDelChangeHistory((Long)limit.getLong("id"), (String)"cfm_creditlimit");
            boolean isRenewal = CreditmApplyTypeEnum.isRenewal((String)applyType);
            limit = CreditlimitHelper.getCreditLimitBill(limit.getLong("id"), dataEntity.getBoolean("isframework") ? "creditm_limit_framework" : "cfm_creditlimit", isRenewal ? "id,enddate" : "");
            if (isRenewal) {
                limit.set("enddate", (Object)lastLimitVersion.getDate("enddate"));
                limits.add(limit);
                continue;
            }
            if (CreditmApplyTypeEnum.isAdjust((String)applyType) || CreditmApplyTypeEnum.isJoin((String)applyType)) {
                CreditlimitApplyHelper.entryOrgChange(lastLimitVersion, limit, true);
                limits.add(limit);
                continue;
            }
            CreditlimitApplyHelper.creditmApplyChange(lastLimitVersion, limit, applyType);
            limits.add(limit);
        }
        CreditlimitApplyHelper.updateLimits(limits);
    }
}

