/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.creditlimit;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.helper.SuretyHelper;
import kd.tmc.fbp.common.helper.TmcBotpHelper;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitDeleteService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("ismergenew");
        selector.add("sourcebillids");
        selector.add("closedate");
        selector.add("closeuser");
        selector.add("entry_gcontract");
        selector.add("entry_surety");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        HashSet applyIds = new HashSet();
        for (DynamicObject dataEntity : dataEntities) {
            Object[] creditApplyBillIds;
            DynamicObjectCollection sourceBills;
            DeleteServiceHelper.delete((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", dataEntity.getPkValue())});
            boolean isMerge = dataEntity.getBoolean("ismergenew");
            if (isMerge) {
                this.deleteMergeCredit(dataEntity);
            }
            if (!"creditm_limit_framework".equals(dataEntity.getDynamicObjectType().getName()) || EmptyUtil.isEmpty((DynamicObjectCollection)(sourceBills = dataEntity.getDynamicObjectCollection("sourcebillids"))) || !EmptyUtil.isNoEmpty((Object[])(creditApplyBillIds = TmcBotpHelper.getSourceBillIds((String)"cfm_creditlimit", (Object)dataEntity.getLong("id"), (String)"creditm_apply")))) continue;
            Collections.addAll(applyIds, creditApplyBillIds);
        }
        if (applyIds.size() > 0) {
            DynamicObject[] applyBills;
            for (DynamicObject applyBill : applyBills = TmcDataServiceHelper.load((String)"creditm_apply", (String)"ishascreditlimit", (QFilter[])new QFilter[]{new QFilter("id", "in", applyIds)})) {
                applyBill.set("ishascreditlimit", (Object)"0");
            }
            SaveServiceHelper.update((DynamicObject[])applyBills);
        }
        GuaranteeUseHelper.deleteGuaranteeUse((DynamicObject[])dataEntities);
        SuretyHelper.cancelSuretiesLink((DynamicObject[])dataEntities);
    }

    private void deleteMergeCredit(DynamicObject mergedCredit) {
        DynamicObject[] srcCreditArr;
        for (DynamicObject srcCredit : srcCreditArr = CreditLimitHelper.getMergeSrcCredit((DynamicObject)mergedCredit)) {
            srcCredit.set("ismergesrc", (Object)0);
            srcCredit.set("isclose", (Object)"0");
            srcCredit.set("closedate", null);
            srcCredit.set("closeuser", (Object)0);
        }
        TmcDataServiceHelper.save((DynamicObject[])srcCreditArr);
    }
}

