/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.creditlimit;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.creditm.common.helper.CreditLimitBusinessHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitSaveService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("name");
        selector.add("number");
        selector.add("avaramt");
        selector.add("totalamt");
        selector.add("useamt");
        selector.add("ismergesrcclose");
        selector.add("creditltmsh_entry");
        selector.add("creditlmttype_entry");
        selector.add("e_avaramt");
        selector.add("e_totalamt");
        selector.add("et_avaramt");
        selector.add("et_totalamt");
        selector.add("sourcebillids");
        selector.add("issurety");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            boolean isMergeNew = dataEntity.getBoolean("ismergenew");
            if (isMergeNew) {
                CreditLimitHelper.mergedCreditSubmit((DynamicObject)dataEntity);
            }
            CreditLimitBusinessHelper.updateAmount((DynamicObject)dataEntity);
            CreditLimitSaveService.setIsSurety(dataEntity);
            CreditLimitHelper.saveGuaranteeUse((DynamicObject[])dataEntities);
        }
        if (this.getOperationVariable().containsKey("op_from_isc")) {
            this.handleFromIsc(dataEntities);
        }
    }

    private static void setIsSurety(DynamicObject dataEntity) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dataEntity.getDynamicObjectCollection("entry_surety"))) {
            dataEntity.set("issurety", (Object)true);
        } else {
            dataEntity.set("issurety", (Object)false);
        }
    }

    private void handleFromIsc(DynamicObject[] dataEntities) {
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
        for (DynamicObject dataEntity : dataEntities) {
            if (!BillStatusEnum.AUDIT.getValue().equals(dataEntity.getString("status"))) continue;
            datas.add(dataEntity);
        }
        if (EmptyUtil.isNoEmpty(datas)) {
            GuaranteeUseHelper.confirmGuaranteeUse((DynamicObject[])datas.toArray(new DynamicObject[0]));
        }
    }
}

