/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.creditlimit;

import java.util.Arrays;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.tmc.creditm.common.helper.CreditLimitBusinessHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("totalamt");
        selector.add("preuseamt");
        selector.add("entry_org");
        selector.add("o_avaramt");
        selector.add("o_totalamt");
        selector.add("o_singleamt");
        selector.add("o_preamt");
        selector.add("o_useamt");
        selector.add("entry_type");
        selector.add("t_avaramt");
        selector.add("t_totalamt");
        selector.add("t_singleamt");
        selector.add("t_useamt");
        selector.add("t_preamt");
        selector.add("entry_mult");
        selector.add("m_avaramt");
        selector.add("m_totalamt");
        selector.add("m_useamt");
        selector.add("m_preamt");
        selector.add("name");
        selector.add("ismergenew");
        selector.add("entry_surety");
        selector.add("issurety");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            boolean fromEdit;
            CreditLimitBusinessHelper.updateAmount((DynamicObject)dataEntity);
            dataEntity.set("name", dataEntity.get("number"));
            boolean isMergeNew = dataEntity.getBoolean("ismergenew");
            if (isMergeNew) {
                CreditLimitHelper.mergedCreditSubmit((DynamicObject)dataEntity);
            }
            if (fromEdit = this.getOperationVariable().containsKey("op_from_edit_form")) {
                CreditLimitHelper.saveGuaranteeUse((DynamicObject[])dataEntities);
            }
            CreditLimitSubmitService.setIsSurety(dataEntity);
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        Object[] mergeLimitIds = (Long[])Arrays.stream(dataEntities).filter(o -> o.getBoolean("ismergenew")).map(o -> o.getLong("id")).toArray(Long[]::new);
        if (EmptyUtil.isNoEmpty((Object[])mergeLimitIds)) {
            TmcOperateServiceHelper.execOperate((String)"credituseamtupdate", (String)"cfm_creditlimit", (Object[])mergeLimitIds, (OperateOption)OperateOption.create());
        }
    }

    private static void setIsSurety(DynamicObject dataEntity) {
        if (EmptyUtil.isNoEmpty((DynamicObjectCollection)dataEntity.getDynamicObjectCollection("entry_surety"))) {
            dataEntity.set("issurety", (Object)true);
        } else {
            dataEntity.set("issurety", (Object)false);
        }
    }
}

