/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.creditlimit;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.creditm.common.enums.OrgShareTypeEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CreditLimitTypeAmtService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (final DynamicObject data : dataEntities) {
            DynamicObjectCollection multEntry;
            if (!data.getBoolean("ismergenew") && !data.getBoolean("ischanging")) continue;
            DynamicObjectCollection entryTypes = data.getDynamicObjectCollection("entry_type");
            if (EmptyUtil.isNoEmpty((DynamicObjectCollection)entryTypes)) {
                Set creditIds = null;
                if (data.getBoolean("ismergenew")) {
                    DynamicObjectCollection sourceBillIds = data.getDynamicObjectCollection("sourcebillids");
                    creditIds = CreditLimitHelper.getCollIds((DynamicObjectCollection)sourceBillIds);
                }
                if (data.getBoolean("ischanging")) {
                    creditIds = new HashSet<Long>(){
                        {
                            this.add(data.getLong("id"));
                        }
                    };
                }
                if (creditIds == null || creditIds.size() == 0) {
                    return;
                }
                Set creditTypeIds = entryTypes.stream().map(o -> Long.parseLong(CreditLimitHelper.getMultCollectIdOrName((DynamicObjectCollection)o.getDynamicObjectCollection("t_credittype"), (boolean)true))).collect(Collectors.toSet());
                Map creditTypeAmtMap = CreditLimitHelper.getCreditTypeAmt((Long)((Long)creditIds.iterator().next()), creditTypeIds, (String)"credittype");
                this.setCreditTypeAmt(data, creditTypeAmtMap);
            }
            if (!EmptyUtil.isNoEmpty((DynamicObjectCollection)(multEntry = data.getDynamicObjectCollection("entry_mult")))) continue;
            boolean isDownShare = OrgShareTypeEnum.DOWNSHARE.getValue().equals(data.getString("orgsharetype"));
            for (DynamicObject entry : multEntry) {
                DynamicObjectCollection orgColl = entry.getDynamicObjectCollection("m_org");
                DynamicObjectCollection typeColl = entry.getDynamicObjectCollection("m_credittype");
                Set allOrgIds = CreditLimitHelper.getAllOrgIds((DynamicObjectCollection)orgColl, (boolean)isDownShare);
                Pair creditMultAmtPair = CreditLimitHelper.getMultAmt((Long)data.getLong("id"), (Set)allOrgIds, (Set)CreditLimitHelper.getCollIds((DynamicObjectCollection)typeColl));
                entry.set("m_useamt", creditMultAmtPair.getLeft());
                entry.set("m_preamt", creditMultAmtPair.getRight());
                entry.set("m_avaramt", (Object)entry.getBigDecimal("m_totalamt").subtract((BigDecimal)creditMultAmtPair.getRight()).subtract((BigDecimal)creditMultAmtPair.getLeft()));
            }
        }
    }

    public void setCreditTypeAmt(DynamicObject data, Map<Long, Pair<BigDecimal, BigDecimal>> creditTypeAmtMap) {
        DynamicObject currency = data.getDynamicObject("currency");
        int amtPrecision = CreditLimitHelper.getAmtPrecision((DynamicObject)currency);
        DynamicObjectCollection typeEntrys = data.getDynamicObjectCollection("entry_type");
        Set<Long> pids = typeEntrys.stream().filter(o -> EmptyUtil.isNoEmpty((Long)o.getLong("pid"))).map(p -> p.getLong("pid")).collect(Collectors.toSet());
        for (DynamicObject typeEntry : typeEntrys) {
            long pid = typeEntry.getLong("pid");
            DynamicObjectCollection types = typeEntry.getDynamicObjectCollection("t_credittype");
            if (pids.contains(pid)) continue;
            String typeId = CreditLimitHelper.getMultCollectIdOrName((DynamicObjectCollection)types, (boolean)true);
            String typeName = CreditLimitHelper.getMultCollectIdOrName((DynamicObjectCollection)types, (boolean)false);
            if (!creditTypeAmtMap.containsKey(Long.parseLong(typeId))) continue;
            Pair<BigDecimal, BigDecimal> pairMap = creditTypeAmtMap.get(Long.parseLong(typeId));
            BigDecimal avaAmt = typeEntry.getBigDecimal("t_singleamt");
            if (EmptyUtil.isEmpty((Long)pid)) {
                avaAmt = typeEntry.getBigDecimal("t_totalamt");
            }
            if ((avaAmt = avaAmt.subtract((BigDecimal)pairMap.getRight()).subtract((BigDecimal)pairMap.getLeft())).compareTo(BigDecimal.ZERO) < 0) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b[%1$s]\u5df2\u7528\u989d\u5ea6+\u9884\u5360\u989d\u5ea6\u4e3a%2$s\uff0c\u5927\u4e8e\u5355\u9879\u9650\u989d%3$s", (String)"CreditLimitTypeAmtService_0", (String)"tmc-creditm-business", (Object[])new Object[0]), typeName, ((BigDecimal)pairMap.getLeft()).setScale(amtPrecision).add(((BigDecimal)pairMap.getRight()).setScale(amtPrecision)), typeEntry.getBigDecimal("t_singleamt").setScale(amtPrecision)));
            }
            typeEntry.set("t_useamt", pairMap.getLeft());
            typeEntry.set("t_preamt", pairMap.getRight());
            typeEntry.set("t_avaramt", (Object)avaAmt);
            pids.add(typeEntry.getLong("pid"));
        }
        String msg = CreditLimitTypeAmtService.setCreditTypeParentAmt(data, pids, amtPrecision);
        if (EmptyUtil.isNoEmpty((String)msg)) {
            throw new KDBizException(msg);
        }
    }

    public static String setCreditTypeParentAmt(DynamicObject data, Set<Long> pids, int amtPrecision) {
        DynamicObjectCollection typeEntrys = data.getDynamicObjectCollection("entry_type");
        if (pids.size() == 0 || EmptyUtil.isEmpty((DynamicObjectCollection)typeEntrys)) {
            return "";
        }
        HashMap<Long, Pair> parentMapAmt = new HashMap<Long, Pair>();
        BigDecimal useAmt = BigDecimal.ZERO;
        BigDecimal preAmt = BigDecimal.ZERO;
        for (DynamicObject typeEntry : typeEntrys) {
            long pid = typeEntry.getLong("pid");
            if (EmptyUtil.isEmpty((Long)pid) && pids.contains(typeEntry.getLong("id"))) {
                useAmt = BigDecimal.ZERO;
                preAmt = BigDecimal.ZERO;
                continue;
            }
            if (!pids.contains(typeEntry.getLong("pid"))) continue;
            useAmt = useAmt.add(typeEntry.getBigDecimal("t_useamt"));
            preAmt = preAmt.add(typeEntry.getBigDecimal("t_preamt"));
            parentMapAmt.put(pid, Pair.of((Object)useAmt, (Object)preAmt));
        }
        Set types = typeEntrys.stream().filter(o -> EmptyUtil.isEmpty((Long)o.getLong("pid"))).collect(Collectors.toSet());
        for (DynamicObject type : types) {
            String typeName = CreditLimitHelper.getMultCollectName((DynamicObjectCollection)type.getDynamicObjectCollection("t_credittype"));
            long pid = type.getLong("id");
            Pair amtPair = (Pair)parentMapAmt.get(pid);
            if (amtPair == null) continue;
            BigDecimal avaAmt = type.getBigDecimal("t_totalamt").subtract((BigDecimal)amtPair.getLeft()).subtract((BigDecimal)amtPair.getRight());
            if (avaAmt.compareTo(BigDecimal.ZERO) < 0) {
                return String.format(ResManager.loadKDString((String)"\u6388\u4fe1\u7c7b\u522b[%1$s]\u5df2\u7528\u989d\u5ea6+\u9884\u5360\u989d\u5ea6\u4e3a%2$s\uff0c\u5927\u4e8e\u5206\u914d\u989d\u5ea6%3$s", (String)"CreditLimitTypeAmtService_1", (String)"tmc-creditm-business", (Object[])new Object[0]), typeName, ((BigDecimal)amtPair.getLeft()).setScale(amtPrecision).add(((BigDecimal)amtPair.getRight()).setScale(amtPrecision)), type.getBigDecimal("t_totalamt").setScale(amtPrecision));
            }
            type.set("t_useamt", amtPair.getLeft());
            type.set("t_preamt", amtPair.getRight());
            type.set("t_avaramt", (Object)avaAmt);
        }
        return "";
    }
}

