/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.creditlimit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.tmc.creditm.common.helper.CreditFrameworkHelper;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.GuaranteeUseHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitUnAuditService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        Set limitIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toSet());
        DeleteServiceHelper.delete((String)"cfm_credituse", (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.SAVE.getValue()), new QFilter("creditlimit", "in", limitIds)});
        ArrayList<DynamicObject> datas = new ArrayList<DynamicObject>();
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject frameWork;
            String guaType = dataEntity.getString("guartype");
            if (CreditLimitHelper.checkGuaType((String)guaType)) {
                datas.add(dataEntity);
            }
            if (!EmptyUtil.isNoEmpty((DynamicObject)(frameWork = dataEntity.getDynamicObject("framework")))) continue;
            BigDecimal srcCreditLimitAmount = CreditFrameworkHelper.getSrcCreditLimitAmount((DynamicObject)dataEntity);
            CreditFrameworkHelper.creditWriteBackFrame((Long)frameWork.getLong("id"), (Long)dataEntity.getDynamicObject("org").getLong("id"), (Long)dataEntity.getDynamicObject("credittype").getLong("id"), (BigDecimal)dataEntity.getBigDecimal("totalamt").subtract(srcCreditLimitAmount).negate());
        }
        if (EmptyUtil.isNoEmpty(datas)) {
            GuaranteeUseHelper.cancelGuaranteeUse((DynamicObject[])datas.toArray(new DynamicObject[0]));
        }
    }
}

