/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.creditlimit;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.common.helper.CreditLimitHelper;
import kd.tmc.creditm.common.helper.CreditLimitUpdateAmtHelper;
import kd.tmc.creditm.common.helper.RateHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CreditLimitUpdateByRateService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("forexquote");
        selector.add("orgsharetype");
        selector.add("isgrouplimit");
        selector.add("credittype");
        selector.add("useamt");
        selector.add("preuseamt");
        selector.add("avaramt");
        selector.add("creditprop");
        selector.add("totalamt");
        selector.add("entry_org");
        selector.add("entry_org.pid");
        selector.add("o_avaramt");
        selector.add("o_org");
        selector.add("o_totalamt");
        selector.add("o_singleamt");
        selector.add("o_useamt");
        selector.add("o_preamt");
        selector.add("entry_type");
        selector.add("entry_type.pid");
        selector.add("t_credittype");
        selector.add("t_avaramt");
        selector.add("t_totalamt");
        selector.add("t_singleamt");
        selector.add("t_useamt");
        selector.add("t_preamt");
        selector.add("entry_mult");
        selector.add("entry_mult.pid");
        selector.add("m_org");
        selector.add("m_credittype");
        selector.add("m_avaramt");
        selector.add("m_totalamt");
        selector.add("m_useamt");
        selector.add("m_preamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> creditLists = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject creditLimit;
            if (dataEntity.getBoolean("isclose") || (creditLimit = CreditLimitUpdateByRateService.updateCreditLimit(dataEntity)) == null) continue;
            creditLists.add(creditLimit);
        }
        if (creditLists.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])creditLists.toArray(new DynamicObject[0]));
        }
    }

    public static DynamicObject updateCreditLimit(DynamicObject creditLimit) {
        boolean isCircle = CreditPropEnum.CIRCLE.getValue().equals(creditLimit.getString("creditprop"));
        Long creditLimitId = creditLimit.getLong("id");
        List orgTypes = CreditLimitUpdateAmtHelper.getOrgType((Long)creditLimit.getLong("id"));
        HashMap<Long, Pair> orgMap = new HashMap<Long, Pair>();
        HashMap<Long, Pair> typeMap = new HashMap<Long, Pair>();
        HashMap<String, Pair> orgTypeMap = new HashMap<String, Pair>();
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        BigDecimal useAmtTotal = BigDecimal.ZERO;
        BigDecimal preAmtTotal = BigDecimal.ZERO;
        ArrayList<Object> creditUses = new ArrayList<Object>(orgTypes.size());
        for (Pair orgType : orgTypes) {
            Long typeId;
            Long orgId = (Long)orgType.getLeft();
            Object[] credituses = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"id,currency,bizcurrency,credittype,org,creditrate,bizcreditamount,amount,realamt,preamount,returnamt,returnentry.e_bizamount,returnentry.e_amount", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", (Object)creditLimitId), new QFilter("org", "=", (Object)orgId), new QFilter("credittype", "=", (Object)(typeId = (Long)orgType.getRight())), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
            if (EmptyUtil.isEmpty((Object[])credituses)) continue;
            for (Object creditus : credituses) {
                BigDecimal returnAmont;
                BigDecimal bigDecimal = returnAmont = isCircle ? creditus.getBigDecimal("returnamt") : BigDecimal.ZERO;
                if (creditus.getDynamicObject("currency") != null && creditus.getDynamicObject("bizcurrency") != null && creditus.getDynamicObject("currency").getLong("id") != creditus.getDynamicObject("bizcurrency").getLong("id")) {
                    BigDecimal rate = BigDecimal.ONE;
                    String key = creditus.getDynamicObject("bizcurrency").getString("id") + creditus.getDynamicObject("currency").getString("id") + creditus.getDynamicObject("org").getString("id");
                    if (rateMap.containsKey(key)) {
                        rate = (BigDecimal)rateMap.get(key);
                    } else {
                        rate = RateHelper.getMdTate((DynamicObject)creditLimit.getDynamicObject("forexquote"), (DynamicObject)creditus.getDynamicObject("bizcurrency"), (DynamicObject)creditus.getDynamicObject("currency"), (Long)creditus.getDynamicObject("org").getLong("id"), (Date)new Date());
                        rateMap.put(key, rate);
                    }
                    if (rate != null && creditus.getBigDecimal("creditrate").compareTo(rate) != 0) {
                        int amtPrecision = CreditLimitHelper.getAmtPrecision((DynamicObject)creditus.getDynamicObject("currency"));
                        BigDecimal amount = creditus.getBigDecimal("bizcreditamount").multiply(rate).setScale(amtPrecision, RoundingMode.HALF_UP);
                        if (creditus.getBigDecimal("amount").compareTo(BigDecimal.ZERO) != 0) {
                            creditus.set("amount", (Object)amount);
                        } else {
                            creditus.set("preamount", (Object)amount);
                        }
                        creditus.set("creditrate", (Object)rate);
                        returnAmont = CreditLimitUpdateAmtHelper.getReturnAmt((DynamicObject)creditus, (BigDecimal)rate, (int)amtPrecision);
                        creditus.set("returnamt", (Object)(returnAmont == null ? BigDecimal.ZERO : returnAmont));
                        creditus.set("creditrate", (Object)rate);
                        BigDecimal useAmount = creditus.getBigDecimal("amount").add(creditus.getBigDecimal("preamount"));
                        if (isCircle) {
                            useAmount = useAmount.subtract(creditus.getBigDecimal("returnamt"));
                        }
                        creditus.set("realamt", (Object)useAmount);
                        creditUses.add(creditus);
                    }
                }
                BigDecimal useAmt = creditus.getBigDecimal("amount");
                BigDecimal preAmt = creditus.getBigDecimal("preamount");
                if (useAmt != null && useAmt.compareTo(BigDecimal.ZERO) > 0) {
                    useAmt = useAmt.subtract(returnAmont == null ? BigDecimal.ZERO : returnAmont);
                } else {
                    preAmt = preAmt.subtract(returnAmont == null ? BigDecimal.ZERO : returnAmont);
                }
                useAmtTotal = useAmtTotal.add(useAmt == null ? BigDecimal.ZERO : useAmt);
                preAmtTotal = preAmtTotal.add(preAmt == null ? BigDecimal.ZERO : preAmt);
                Pair orgAmts = orgMap.getOrDefault(orgId, Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
                useAmt = useAmt == null ? BigDecimal.ZERO : useAmt;
                preAmt = preAmt == null ? BigDecimal.ZERO : preAmt;
                orgMap.put(orgId, Pair.of((Object)((BigDecimal)orgAmts.getLeft()).add(useAmt), (Object)((BigDecimal)orgAmts.getRight()).add(preAmt)));
                Pair typeAmts = typeMap.getOrDefault(typeId, Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
                typeMap.put(typeId, Pair.of((Object)((BigDecimal)typeAmts.getLeft()).add(useAmt), (Object)((BigDecimal)typeAmts.getRight()).add(preAmt)));
                String orgTypeKey = String.valueOf(orgId) + "#" + String.valueOf(typeId);
                Pair orgTypeAmts = orgTypeMap.getOrDefault(orgTypeKey, Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
                orgTypeMap.put(orgTypeKey, Pair.of((Object)((BigDecimal)orgTypeAmts.getLeft()).add(useAmt), (Object)((BigDecimal)orgTypeAmts.getRight()).add(preAmt)));
            }
        }
        if (creditUses.size() > 0) {
            CreditLimitUpdateAmtHelper.dealOrgEntryAmt((DynamicObject)creditLimit, orgMap);
            CreditLimitUpdateAmtHelper.dealTypeEntryAmt((DynamicObject)creditLimit, typeMap);
            CreditLimitUpdateAmtHelper.dealMultEntryAmt((DynamicObject)creditLimit, orgTypeMap);
            CreditLimitUpdateAmtHelper.dealHeadAmt((DynamicObject)creditLimit, (BigDecimal)useAmtTotal, (BigDecimal)preAmtTotal);
            SaveServiceHelper.save((DynamicObject[])creditUses.toArray(new DynamicObject[0]));
            return creditLimit;
        }
        return null;
    }
}

