/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.creditlimit;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.creditm.common.helper.CreditLimitUpdateAmtHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.enums.BillStatusEnum;
import kd.tmc.fbp.common.helper.TmcDataServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;
import org.apache.commons.lang3.tuple.Pair;

public class CreditLimitUseAmtUpdateService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List selector = super.getSelector();
        selector.add("id");
        selector.add("forexquote");
        selector.add("orgsharetype");
        selector.add("isgrouplimit");
        selector.add("credittype");
        selector.add("useamt");
        selector.add("preuseamt");
        selector.add("avaramt");
        selector.add("creditprop");
        selector.add("totalamt");
        selector.add("entry_org");
        selector.add("entry_org.pid");
        selector.add("o_avaramt");
        selector.add("o_org");
        selector.add("o_totalamt");
        selector.add("o_singleamt");
        selector.add("o_useamt");
        selector.add("o_preamt");
        selector.add("entry_type");
        selector.add("entry_type.pid");
        selector.add("t_credittype");
        selector.add("t_avaramt");
        selector.add("t_totalamt");
        selector.add("t_singleamt");
        selector.add("t_useamt");
        selector.add("t_preamt");
        selector.add("entry_mult");
        selector.add("entry_mult.pid");
        selector.add("m_org");
        selector.add("m_credittype");
        selector.add("m_avaramt");
        selector.add("m_totalamt");
        selector.add("m_useamt");
        selector.add("m_preamt");
        return selector;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        ArrayList<DynamicObject> creditLists = new ArrayList<DynamicObject>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            List<DynamicObject> updateCreditUse = this.getUpdateCreditUse(dataEntity.getLong("id"));
            creditLists.addAll(updateCreditUse);
        }
        if (creditLists.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])creditLists.toArray(new DynamicObject[0]));
            creditLists.clear();
        }
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject creditLimit = CreditLimitUseAmtUpdateService.reCalCreditLimitAmt(dataEntity);
            if (creditLimit == null) continue;
            creditLists.add(creditLimit);
        }
        if (creditLists.size() > 0) {
            SaveServiceHelper.save((DynamicObject[])creditLists.toArray(new DynamicObject[0]));
        }
    }

    private List<DynamicObject> getUpdateCreditUse(long creditLimitId) {
        DynamicObject[] creditUseArrs;
        ArrayList<DynamicObject> creditUses = new ArrayList<DynamicObject>();
        for (DynamicObject creditUseArr : creditUseArrs = TmcDataServiceHelper.load((String)"cfm_credituse", (String)"amount,preamount,returnamt,realamt", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", (Object)creditLimitId).and("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())})) {
            BigDecimal realAmount;
            boolean needUpdate = false;
            BigDecimal amount = creditUseArr.getBigDecimal("amount");
            BigDecimal preAmount = creditUseArr.getBigDecimal("preamount");
            BigDecimal returnAmt = creditUseArr.getBigDecimal("returnamt");
            BigDecimal realAmt = creditUseArr.getBigDecimal("realamt");
            if (amount.compareTo(BigDecimal.ZERO) > 0 && preAmount.compareTo(BigDecimal.ZERO) > 0) {
                creditUseArr.set("preamount", (Object)BigDecimal.ZERO);
                needUpdate = true;
            }
            if (realAmt.compareTo(realAmount = amount.add(preAmount).subtract(returnAmt)) != 0) {
                needUpdate = true;
            }
            if (!needUpdate) continue;
            creditUseArr.set("realamt", (Object)creditUseArr.getBigDecimal("amount").add(creditUseArr.getBigDecimal("preamount")).subtract(creditUseArr.getBigDecimal("returnamt")));
            creditUses.add(creditUseArr);
        }
        return creditUses;
    }

    public static DynamicObject reCalCreditLimitAmt(DynamicObject creditLimit) {
        boolean isCircle = CreditPropEnum.CIRCLE.getValue().equals(creditLimit.getString("creditprop"));
        Long creditLimitId = creditLimit.getLong("id");
        List orgTypes = CreditLimitUpdateAmtHelper.getOrgType((Long)creditLimit.getLong("id"));
        HashMap<Long, Pair> orgMap = new HashMap<Long, Pair>();
        HashMap<Long, Pair> typeMap = new HashMap<Long, Pair>();
        HashMap<String, Pair> orgTypeMap = new HashMap<String, Pair>();
        BigDecimal useAmtTotal = BigDecimal.ZERO;
        BigDecimal preAmtTotal = BigDecimal.ZERO;
        for (Pair orgType : orgTypes) {
            Long typeId;
            Long orgId = (Long)orgType.getLeft();
            DynamicObjectCollection credituses = QueryServiceHelper.query((String)"cfm_credituse", (String)"id,currency,bizcurrency,credittype,org,creditrate,bizcreditamount,amount,realamt,preamount,returnamt", (QFilter[])new QFilter[]{new QFilter("creditlimit", "=", (Object)creditLimitId), new QFilter("org", "=", (Object)orgId), new QFilter("credittype", "=", (Object)(typeId = (Long)orgType.getRight())), new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue())});
            if (EmptyUtil.isEmpty((DynamicObjectCollection)credituses)) continue;
            for (DynamicObject creditus : credituses) {
                BigDecimal returnAmont = isCircle ? creditus.getBigDecimal("returnamt") : BigDecimal.ZERO;
                BigDecimal useAmt = creditus.getBigDecimal("amount");
                BigDecimal preAmt = creditus.getBigDecimal("preamount");
                if (useAmt != null && useAmt.compareTo(BigDecimal.ZERO) > 0) {
                    useAmt = useAmt.subtract(returnAmont == null ? BigDecimal.ZERO : returnAmont);
                } else {
                    preAmt = isCircle ? preAmt.subtract(returnAmont == null ? BigDecimal.ZERO : returnAmont) : creditus.getBigDecimal("realamt");
                }
                useAmtTotal = useAmtTotal.add(useAmt == null ? BigDecimal.ZERO : useAmt);
                preAmtTotal = preAmtTotal.add(preAmt == null ? BigDecimal.ZERO : preAmt);
                Pair orgAmts = orgMap.getOrDefault(orgId, Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
                useAmt = useAmt == null ? BigDecimal.ZERO : useAmt;
                preAmt = preAmt == null ? BigDecimal.ZERO : preAmt;
                orgMap.put(orgId, Pair.of((Object)((BigDecimal)orgAmts.getLeft()).add(useAmt), (Object)((BigDecimal)orgAmts.getRight()).add(preAmt)));
                Pair typeAmts = typeMap.getOrDefault(typeId, Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
                typeMap.put(typeId, Pair.of((Object)((BigDecimal)typeAmts.getLeft()).add(useAmt), (Object)((BigDecimal)typeAmts.getRight()).add(preAmt)));
                String orgTypeKey = String.valueOf(orgId) + "#" + String.valueOf(typeId);
                Pair orgTypeAmts = orgTypeMap.getOrDefault(orgTypeKey, Pair.of((Object)BigDecimal.ZERO, (Object)BigDecimal.ZERO));
                orgTypeMap.put(orgTypeKey, Pair.of((Object)((BigDecimal)orgTypeAmts.getLeft()).add(useAmt), (Object)((BigDecimal)orgTypeAmts.getRight()).add(preAmt)));
            }
        }
        CreditLimitUpdateAmtHelper.dealOrgEntryAmt((DynamicObject)creditLimit, orgMap);
        CreditLimitUpdateAmtHelper.dealTypeEntryAmt((DynamicObject)creditLimit, typeMap);
        CreditLimitUpdateAmtHelper.dealMultEntryAmt((DynamicObject)creditLimit, orgTypeMap);
        CreditLimitUpdateAmtHelper.dealHeadAmt((DynamicObject)creditLimit, (BigDecimal)useAmtTotal, (BigDecimal)preAmtTotal);
        return creditLimit;
    }
}

