/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.credituse;

import java.math.BigDecimal;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.creditm.business.resources.CreditmBusResourceEnum;
import kd.tmc.creditm.common.enums.CreditPropEnum;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.helper.TmcOperateServiceHelper;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CredituseUpdateLimitService
extends AbstractTmcBizOppService {
    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObjectCollection entrys;
            DynamicObject limit = dataEntity.getDynamicObject("creditlimit");
            String creditProp = limit.getString("creditprop");
            if (CreditPropEnum.CIRCLE.getValue().equals(creditProp) && EmptyUtil.isNoEmpty((DynamicObjectCollection)(entrys = dataEntity.getDynamicObjectCollection("returnentry")))) {
                BigDecimal returnAmt = entrys.parallelStream().map(o -> o.getBigDecimal("e_amount")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
                dataEntity.set("returnamt", (Object)returnAmt);
            }
            dataEntity.set("realamt", (Object)dataEntity.getBigDecimal("amount").add(dataEntity.getBigDecimal("preamount").subtract(dataEntity.getBigDecimal("returnamt"))));
        }
    }

    public void afterProcess(DynamicObject[] dataEntities) throws KDException {
        super.afterProcess(dataEntities);
        for (DynamicObject dataEntity : dataEntities) {
            DynamicObject limit = dataEntity.getDynamicObject("creditlimit");
            OperationResult result = TmcOperateServiceHelper.execOperate((String)"credituseamtupdate", (String)"cfm_creditlimit", (Object[])new Object[]{limit.getPkValue()}, (OperateOption)OperateOption.create());
            if (result != null && result.isSuccess()) continue;
            throw new KDBizException(CreditmBusResourceEnum.CredituseUpdateLimitService_0.loadKDString(result != null ? result.getMessage() : ""));
        }
    }
}

