/*
 * Decompiled with CFR 0.152.
 */
package kd.tmc.creditm.business.opservice.framework;

import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.tmc.creditm.common.helper.CreditFrameworkRerunHelper;
import kd.tmc.fbp.business.opservice.AbstractTmcBizOppService;
import kd.tmc.fbp.common.util.EmptyUtil;

public class CreditLimitFrameworkSubmitService
extends AbstractTmcBizOppService {
    public List<String> getSelector() {
        List sel = super.getSelector();
        sel.add("isframework");
        sel.add("ismergenew");
        sel.add("sourcebillids");
        sel.add("totalamt");
        sel.add("notallocationamt");
        sel.add("entry_org");
        sel.add("o_org");
        sel.add("o_totalamt");
        sel.add("o_singleamt");
        sel.add("o_notallocationamt");
        sel.add("entry_type");
        sel.add("t_credittype");
        sel.add("t_singleamt");
        sel.add("t_totalamt");
        sel.add("t_notallocationamt");
        sel.add("entry_mult");
        sel.add("m_org");
        sel.add("m_credittype");
        sel.add("m_totalamt");
        sel.add("m_notallocationamt");
        return sel;
    }

    public void process(DynamicObject[] dataEntities) throws KDException {
        for (DynamicObject dataEntity : dataEntities) {
            boolean isFrameWork = dataEntity.getBoolean("isframework");
            if (!isFrameWork || !"creditm_limit_framework".equals(dataEntity.getDynamicObjectType().getName())) continue;
            if (dataEntity.getBoolean("ismergenew")) {
                String res = CreditFrameworkRerunHelper.rerunNotallocationAmount((DynamicObject)dataEntity);
                if (!EmptyUtil.isNoEmpty((String)res)) continue;
                throw new KDBizException(res);
            }
            dataEntity.set("notallocationamt", (Object)dataEntity.getBigDecimal("totalamt"));
            this.setDefaultAllocationAmt(dataEntity, "entry_org", "o_totalamt", "o_singleamt", "o_notallocationamt");
            this.setDefaultAllocationAmt(dataEntity, "entry_type", "t_totalamt", "t_singleamt", "t_notallocationamt");
            this.setDefaultAllocationAmt(dataEntity, "entry_mult", "m_totalamt", "m_singleamt", "m_notallocationamt");
        }
    }

    private void setDefaultAllocationAmt(DynamicObject dataEntity, String entry, String totalField, String singleField, String alcaField) {
        DynamicObjectCollection orgEntrys = dataEntity.getDynamicObjectCollection(entry);
        for (DynamicObject orgEntry : orgEntrys) {
            BigDecimal oTotalAmt = orgEntry.getBigDecimal(totalField);
            if ("entry_mult".equals(entry)) {
                orgEntry.set(alcaField, (Object)oTotalAmt);
                continue;
            }
            orgEntry.set(alcaField, (Object)(EmptyUtil.isEmpty((BigDecimal)oTotalAmt) ? orgEntry.getBigDecimal(singleField) : oTotalAmt));
        }
    }
}

